/*
 * Decompiled with CFR 0.152.
 */
package begosrs.barbarianassault.menuentryswapper;

import begosrs.barbarianassault.BaMinigameConfig;
import begosrs.barbarianassault.BaMinigamePlugin;
import begosrs.barbarianassault.Role;
import begosrs.barbarianassault.Wave;
import begosrs.barbarianassault.menuentryswapper.Hide;
import begosrs.barbarianassault.menuentryswapper.Swap;
import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.LinkedHashMultimap;
import com.google.common.collect.Multimap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.function.Predicate;
import java.util.function.Supplier;
import javax.inject.Inject;
import net.runelite.api.Client;
import net.runelite.api.GameState;
import net.runelite.api.MenuAction;
import net.runelite.api.MenuEntry;
import net.runelite.client.util.Text;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MenuEntrySwapper {
    private static final Logger log = LoggerFactory.getLogger(MenuEntrySwapper.class);
    private final BaMinigameConfig config;
    private final Client client;
    private final BaMinigamePlugin plugin;
    private final Multimap<String, Swap> swaps;
    private final Set<Hide> hides;
    private final ArrayListMultimap<String, Integer> optionIndexes;

    @Inject
    MenuEntrySwapper(BaMinigameConfig config, Client client, BaMinigamePlugin plugin) {
        this.config = config;
        this.client = client;
        this.plugin = plugin;
        this.swaps = LinkedHashMultimap.create();
        this.hides = new HashSet<Hide>();
        this.optionIndexes = ArrayListMultimap.create();
    }

    private static <T extends Comparable<? super T>> void sortedInsert(List<T> list, T value) {
        int idx = Collections.binarySearch(list, value);
        list.add(idx < 0 ? -idx - 1 : idx, value);
    }

    public void enableSwaps() {
        this.addSwap("talk-to", "get-rewards", this.config::swapGetRewards);
        this.addSwap("climb-down", "quick-start", this.config::swapQuickStart);
        this.addSwap("look-in", "empty", this.config::swapCollectionBag);
        this.addSwap("use", "tell-defensive", "collector horn", this.config::swapCollectorHorn);
        this.addSwap("use", "destroy", "red egg", this.config::swapDestroyEggs);
        this.addSwap("use", "destroy", "green egg", this.config::swapDestroyEggs);
        this.addSwap("use", "destroy", "blue egg", this.config::swapDestroyEggs);
        this.addSwap("drink-from", "take-from", this.config::swapHealerSpring);
        this.addHide("attack", "penance", () -> this.shouldHideAttOptions(Role.COLLECTOR));
        this.addHide("attack", "queen spawn", () -> this.shouldHideAttOptions(Role.COLLECTOR));
        this.addHide("attack", "penance", () -> this.shouldHideAttOptions(Role.DEFENDER));
        this.addHide("attack", "queen spawn", () -> this.shouldHideAttOptions(Role.DEFENDER));
        this.addHide("attack", "penance", () -> this.shouldHideAttOptions(Role.HEALER));
        this.addHide("attack", "queen spawn", () -> this.shouldHideAttOptions(Role.HEALER));
    }

    private boolean shouldHideAttOptions(Role role) {
        if (this.plugin.getInGameBit() != 1) {
            return false;
        }
        Wave wave = this.plugin.getWave();
        Role currentRole = null;
        if (wave != null) {
            currentRole = wave.getRole();
        }
        if (currentRole == null || !Objects.equals((Object)currentRole, (Object)role)) {
            return false;
        }
        switch (role) {
            case COLLECTOR: {
                return this.config.hideAttackOptionsCollector();
            }
            case DEFENDER: {
                return this.config.hideAttackOptionsDefender();
            }
            case HEALER: {
                return this.config.hideAttackOptionsHealer();
            }
        }
        return false;
    }

    public void disableSwaps() {
        this.swaps.clear();
    }

    public void performSwaps() {
        if (this.client.getGameState() != GameState.LOGGED_IN || this.client.isMenuOpen()) {
            return;
        }
        MenuEntry[] menuEntries = this.client.getMenuEntries();
        int idx = 0;
        this.optionIndexes.clear();
        for (MenuEntry entry : menuEntries) {
            String option = Text.removeTags((String)entry.getOption()).toLowerCase();
            this.optionIndexes.put((Object)option, (Object)idx++);
        }
        idx = 0;
        for (MenuEntry entry : menuEntries) {
            this.swapMenuEntry(idx++, entry);
        }
        MenuEntry[] filteredEntries = this.filterHidden(this.client.getMenuEntries());
        if (filteredEntries.length != menuEntries.length) {
            this.client.setMenuEntries(filteredEntries);
        }
    }

    private MenuEntry[] filterHidden(MenuEntry[] menuEntries) {
        ArrayList<MenuEntry> filtered = new ArrayList<MenuEntry>();
        for (MenuEntry entry : menuEntries) {
            String option = Text.standardize((String)entry.getOption());
            String target = Text.standardize((String)entry.getTarget());
            boolean shouldAdd = this.hides.stream().noneMatch(h -> h.getEnabled().get() != false && h.getOptionPredicate().test(option) && h.getTargetPredicate().test(target));
            if (!shouldAdd) continue;
            filtered.add(entry);
        }
        return filtered.toArray(new MenuEntry[0]);
    }

    private void swapMenuEntry(int index, MenuEntry menuEntry) {
        Swap swap;
        String option = Text.removeTags((String)menuEntry.getOption()).toLowerCase();
        String target = Text.removeTags((String)menuEntry.getTarget()).toLowerCase();
        Collection swaps = this.swaps.get((Object)option);
        Iterator iterator = swaps.iterator();
        while (!(!iterator.hasNext() || (swap = (Swap)iterator.next()).getTargetPredicate().test(target) && swap.getEnabled().get().booleanValue() && this.performSwap(swap.getSwappedOption(), target, index, swap.isStrict()))) {
        }
    }

    private void addSwap(String option, String swappedOption, Supplier<Boolean> enabled) {
        this.addSwap(option, (String s) -> true, swappedOption, enabled);
    }

    private void addSwap(String option, String swappedOption, String target, Supplier<Boolean> enabled) {
        this.addSwap(option, (String s) -> Objects.equals(s, target), swappedOption, enabled);
    }

    private void addSwap(String option, Predicate<String> targetPredicate, String swappedOption, Supplier<Boolean> enabled) {
        this.swaps.put((Object)option, (Object)new Swap(s -> true, targetPredicate, swappedOption, enabled, true));
    }

    private void addHide(String option, String targetContains, Supplier<Boolean> enabled) {
        this.hides.add(new Hide(s -> Objects.equals(s, option), s -> s.contains(targetContains), enabled, true));
    }

    private boolean performSwap(String option, String target, int index, boolean strict) {
        MenuEntry[] menuEntries = this.client.getMenuEntries();
        int optionIdx = this.findIndex(menuEntries, index, option, target, strict);
        if (optionIdx >= 0) {
            this.performSwap(this.optionIndexes, menuEntries, optionIdx, index);
            return true;
        }
        return false;
    }

    private void performSwap(ArrayListMultimap<String, Integer> optionIndexes, MenuEntry[] entries, int index1, int index2) {
        MenuEntry entry2;
        MenuEntry entry1 = entries[index1];
        entries[index1] = entry2 = entries[index2];
        entries[index2] = entry1;
        if (entry1.isItemOp() && entry1.getType() == MenuAction.CC_OP_LOW_PRIORITY) {
            entry1.setType(MenuAction.CC_OP);
        }
        if (entry2.isItemOp() && entry2.getType() == MenuAction.CC_OP_LOW_PRIORITY) {
            entry2.setType(MenuAction.CC_OP);
        }
        this.client.setMenuEntries(entries);
        String option1 = Text.removeTags((String)entry1.getOption()).toLowerCase();
        String option2 = Text.removeTags((String)entry2.getOption()).toLowerCase();
        List list1 = optionIndexes.get((Object)option1);
        List list2 = optionIndexes.get((Object)option2);
        list1.remove((Object)index1);
        list2.remove((Object)index2);
        MenuEntrySwapper.sortedInsert(list1, index2);
        MenuEntrySwapper.sortedInsert(list2, index1);
    }

    private int findIndex(MenuEntry[] entries, int limit, String option, String target, boolean strict) {
        if (strict) {
            List indexes = this.optionIndexes.get((Object)option);
            for (int i = indexes.size() - 1; i >= 0; --i) {
                int idx = (Integer)indexes.get(i);
                MenuEntry entry = entries[idx];
                String entryTarget = Text.removeTags((String)entry.getTarget()).toLowerCase();
                if (idx >= limit || target != null && !entryTarget.equals(target)) continue;
                return idx;
            }
        } else {
            for (int i = limit - 1; i >= 0; --i) {
                MenuEntry entry = entries[i];
                String entryOption = Text.removeTags((String)entry.getOption()).toLowerCase();
                String entryTarget = Text.removeTags((String)entry.getTarget()).toLowerCase();
                if (!entryOption.contains(option.toLowerCase()) || !entryTarget.equals(target)) continue;
                return i;
            }
        }
        return -1;
    }
}

