/*
 * Decompiled with CFR 0.152.
 */
package begosrs.barbarianassault.inventory;

import begosrs.barbarianassault.BaMinigameConfig;
import begosrs.barbarianassault.BaMinigamePlugin;
import begosrs.barbarianassault.Role;
import begosrs.barbarianassault.inventory.InventoryHighlightMode;
import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.image.BufferedImage;
import javax.inject.Inject;
import javax.inject.Singleton;
import net.runelite.api.ItemComposition;
import net.runelite.api.widgets.WidgetItem;
import net.runelite.client.game.ItemManager;
import net.runelite.client.ui.overlay.WidgetItemOverlay;
import net.runelite.client.util.AsyncBufferedImage;

@Singleton
public class InventoryOverlay
extends WidgetItemOverlay {
    private final ItemManager itemManager;
    private final BaMinigamePlugin plugin;
    private final BaMinigameConfig config;

    @Inject
    private InventoryOverlay(ItemManager itemManager, BaMinigamePlugin plugin, BaMinigameConfig config) {
        this.itemManager = itemManager;
        this.plugin = plugin;
        this.config = config;
        this.showOnInventory();
        this.showOnEquipment();
    }

    public void renderItemOverlay(Graphics2D graphics, int itemId, WidgetItem itemWidget) {
        Role role = this.plugin.getRole();
        if (role == null) {
            return;
        }
        int listenItemId = this.plugin.getLastListenItemId();
        if (listenItemId != itemId) {
            return;
        }
        Color color = this.plugin.getColorForInventoryItemId(itemId);
        switch (role) {
            case ATTACKER: {
                if (!this.config.highlightArrows()) break;
                this.highlightItem(graphics, itemId, itemWidget, color);
                break;
            }
            case DEFENDER: {
                if (!this.config.highlightBait()) break;
                this.highlightItem(graphics, itemId, itemWidget, color);
                break;
            }
            case HEALER: {
                if (!this.config.highlightPoison()) break;
                this.highlightItem(graphics, itemId, itemWidget, color);
            }
        }
    }

    private void highlightItem(Graphics2D graphics, int itemId, WidgetItem itemWidget, Color color) {
        Rectangle bounds = itemWidget.getCanvasBounds();
        InventoryHighlightMode inventoryHighlightMode = this.config.inventoryHighlightMode();
        if (inventoryHighlightMode == InventoryHighlightMode.OVERLAY) {
            ItemComposition item = this.itemManager.getItemComposition(itemId);
            AsyncBufferedImage image = this.itemManager.getImage(itemId, itemWidget.getQuantity(), item.isStackable());
            BufferedImage overlayedImage = this.overlay((BufferedImage)image, color);
            graphics.drawImage((Image)overlayedImage, (int)bounds.getX(), (int)bounds.getY(), null);
        } else if (inventoryHighlightMode == InventoryHighlightMode.OUTLINE) {
            BufferedImage outline = this.itemManager.getItemOutline(itemId, itemWidget.getQuantity(), color);
            graphics.drawImage((Image)outline, (int)bounds.getX(), (int)bounds.getY(), null);
        }
    }

    private BufferedImage overlay(BufferedImage image, Color color) {
        int w = image.getWidth();
        int h = image.getHeight();
        BufferedImage overlayed = new BufferedImage(w, h, 2);
        Graphics2D g = overlayed.createGraphics();
        g.drawImage((Image)image, 0, 0, null);
        g.setComposite(AlphaComposite.SrcAtop);
        g.setColor(color);
        g.fillRect(0, 0, w, h);
        g.dispose();
        return overlayed;
    }
}

