/*
 * Decompiled with CFR 0.152.
 */
package begosrs.barbarianassault.hoppers;

import begosrs.barbarianassault.BaMinigameConfig;
import begosrs.barbarianassault.BaMinigamePlugin;
import begosrs.barbarianassault.hoppers.CollectorEgg;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.util.HashMap;
import java.util.Map;
import javax.inject.Inject;
import javax.inject.Singleton;
import net.runelite.api.Client;
import net.runelite.api.GameObject;
import net.runelite.api.Perspective;
import net.runelite.api.Player;
import net.runelite.api.Point;
import net.runelite.api.coords.LocalPoint;
import net.runelite.api.coords.WorldPoint;
import net.runelite.client.plugins.Plugin;
import net.runelite.client.ui.overlay.Overlay;
import net.runelite.client.ui.overlay.OverlayLayer;
import net.runelite.client.ui.overlay.OverlayPosition;
import net.runelite.client.ui.overlay.components.TextComponent;
import net.runelite.client.util.QuantityFormatter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
public class HoppersOverlay
extends Overlay {
    private static final Logger log = LoggerFactory.getLogger(HoppersOverlay.class);
    private static final int STRING_GAP = 15;
    private static final int Z_OFFSET = 100;
    private static final int MAXIMUM_DISTANCE = 20;
    private final Client client;
    private final BaMinigamePlugin plugin;
    private final BaMinigameConfig config;
    private final TextComponent textComponent;
    private final Map<WorldPoint, Integer> offsetMap;

    @Inject
    private HoppersOverlay(Client client, BaMinigamePlugin plugin, BaMinigameConfig config) {
        super((Plugin)plugin);
        this.setPosition(OverlayPosition.DYNAMIC);
        this.setLayer(OverlayLayer.ABOVE_SCENE);
        this.client = client;
        this.plugin = plugin;
        this.config = config;
        this.textComponent = new TextComponent();
        this.offsetMap = new HashMap<WorldPoint, Integer>();
    }

    public Dimension render(Graphics2D graphics) {
        if (!this.config.showEggsOnHopper() || this.plugin.getInGameBit() != 1) {
            return null;
        }
        Player player = this.client.getLocalPlayer();
        if (player == null) {
            return null;
        }
        this.offsetMap.clear();
        for (GameObject hopper : this.plugin.getHoppers()) {
            LocalPoint localPoint;
            WorldPoint hopperPoint = hopper.getWorldLocation();
            if (hopperPoint.distanceTo(player.getWorldLocation()) >= 20 || (localPoint = LocalPoint.fromWorld((Client)this.client, (WorldPoint)hopperPoint)) == null) continue;
            for (Map.Entry<CollectorEgg, Integer> eggCount : this.plugin.getCannonEggs().entrySet()) {
                CollectorEgg collectorEgg = eggCount.getKey();
                int count = eggCount.getValue();
                String message = String.format("%s %s", QuantityFormatter.quantityToStackSize((long)count), collectorEgg.getName());
                Point textPoint = Perspective.getCanvasTextLocation((Client)this.client, (Graphics2D)graphics, (LocalPoint)localPoint, (String)message, (int)100);
                if (textPoint == null) continue;
                int offset = this.offsetMap.compute(hopper.getWorldLocation(), (k, v) -> v != null ? v + 1 : 0);
                int textX = textPoint.getX();
                int textY = textPoint.getY() - 15 * offset;
                this.textComponent.setText(message);
                this.textComponent.setColor(collectorEgg.getColor());
                this.textComponent.setPosition(new java.awt.Point(textX, textY));
                this.textComponent.render(graphics);
            }
        }
        return null;
    }
}

