/*
 * Decompiled with CFR 0.152.
 */
package begosrs.barbarianassault.groundmarkers;

import begosrs.barbarianassault.BaMinigameConfig;
import begosrs.barbarianassault.BaMinigamePlugin;
import begosrs.barbarianassault.Role;
import begosrs.barbarianassault.Wave;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.Polygon;
import java.awt.Shape;
import java.awt.Stroke;
import java.util.List;
import javax.inject.Inject;
import net.runelite.api.Client;
import net.runelite.api.GroundObject;
import net.runelite.api.Perspective;
import net.runelite.api.Player;
import net.runelite.api.coords.LocalPoint;
import net.runelite.api.coords.WorldPoint;
import net.runelite.client.ui.overlay.Overlay;
import net.runelite.client.ui.overlay.OverlayLayer;
import net.runelite.client.ui.overlay.OverlayPosition;
import net.runelite.client.ui.overlay.OverlayPriority;
import net.runelite.client.ui.overlay.OverlayUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BrokenTrapsOverlay
extends Overlay {
    private static final Logger log = LoggerFactory.getLogger(BrokenTrapsOverlay.class);
    private static final int MAX_DRAW_DISTANCE = 32;
    private final Client client;
    private final BaMinigameConfig config;
    private final BaMinigamePlugin plugin;

    @Inject
    private BrokenTrapsOverlay(Client client, BaMinigameConfig config, BaMinigamePlugin plugin) {
        this.client = client;
        this.config = config;
        this.plugin = plugin;
        this.setPosition(OverlayPosition.DYNAMIC);
        this.setPriority(OverlayPriority.LOW);
        this.setLayer(OverlayLayer.ABOVE_SCENE);
    }

    public Dimension render(Graphics2D graphics) {
        if (!this.config.highlightBrokenTraps()) {
            return null;
        }
        if (this.plugin.getRole() != Role.DEFENDER) {
            return null;
        }
        Wave wave = this.plugin.getWave();
        if (wave == null || wave.isComplete()) {
            return null;
        }
        List<GroundObject> traps = this.plugin.getBrokenTraps();
        if (traps.isEmpty()) {
            return null;
        }
        Player player = this.client.getLocalPlayer();
        if (player == null) {
            return null;
        }
        Color color = this.config.highlightBrokenTrapsColor();
        int opacity = this.config.highlightBrokenTrapsOpacity();
        BasicStroke stroke = new BasicStroke((float)this.config.highlightBrokenTrapsBorderWidth());
        for (GroundObject trap : traps) {
            Polygon poly;
            LocalPoint lp;
            WorldPoint playerLocation;
            WorldPoint worldPoint = trap.getWorldLocation();
            if (worldPoint.distanceTo(playerLocation = player.getWorldLocation()) >= 32 || (lp = LocalPoint.fromWorld((Client)this.client, (WorldPoint)worldPoint)) == null || (poly = Perspective.getCanvasTilePoly((Client)this.client, (LocalPoint)lp)) == null) continue;
            OverlayUtil.renderPolygon((Graphics2D)graphics, (Shape)poly, (Color)color, (Color)new Color(0, 0, 0, opacity), (Stroke)stroke);
        }
        return null;
    }
}

