/*
 * Decompiled with CFR 0.152.
 */
package begosrs.barbarianassault.grounditems;

import begosrs.barbarianassault.BaMinigameConfig;
import begosrs.barbarianassault.BaMinigamePlugin;
import begosrs.barbarianassault.Role;
import begosrs.barbarianassault.grounditems.GroundEggsMode;
import begosrs.barbarianassault.grounditems.GroundItem;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.Polygon;
import java.awt.Shape;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Predicate;
import javax.inject.Inject;
import javax.inject.Singleton;
import net.runelite.api.Client;
import net.runelite.api.Perspective;
import net.runelite.api.Player;
import net.runelite.api.Point;
import net.runelite.api.coords.LocalPoint;
import net.runelite.api.coords.WorldPoint;
import net.runelite.client.plugins.Plugin;
import net.runelite.client.ui.overlay.OverlayLayer;
import net.runelite.client.ui.overlay.OverlayPanel;
import net.runelite.client.ui.overlay.OverlayPosition;
import net.runelite.client.ui.overlay.OverlayUtil;
import net.runelite.client.ui.overlay.components.TextComponent;
import net.runelite.client.util.QuantityFormatter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
public class GroundItemsOverlay
extends OverlayPanel {
    private static final Logger log = LoggerFactory.getLogger(GroundItemsOverlay.class);
    private static final int MAX_DISTANCE = 2500;
    private static final int OFFSET_Z = 20;
    private static final int MAX_QUANTITY = 65535;
    private static final int STRING_GAP = 15;
    private final StringBuilder itemStringBuilder = new StringBuilder();
    private final TextComponent textComponent = new TextComponent();
    private final Map<WorldPoint, Integer> offsetMap = new HashMap<WorldPoint, Integer>();
    private final Client client;
    private final BaMinigamePlugin plugin;
    private final BaMinigameConfig config;

    @Inject
    public GroundItemsOverlay(Client client, BaMinigamePlugin plugin, BaMinigameConfig config) {
        super((Plugin)plugin);
        this.setPosition(OverlayPosition.DYNAMIC);
        this.setLayer(OverlayLayer.ABOVE_SCENE);
        this.client = client;
        this.plugin = plugin;
        this.config = config;
    }

    public Dimension render(Graphics2D graphics) {
        if (!this.config.showGroundItemHighlights()) {
            return null;
        }
        Role role = this.plugin.getRole();
        if (role == null) {
            return null;
        }
        switch (role) {
            case COLLECTOR: {
                this.renderEggs(graphics);
                break;
            }
            case DEFENDER: {
                if (this.config.highlightGroundBait()) {
                    this.renderBait(graphics);
                }
                if (!this.config.highlightGroundLogsHammer()) break;
                this.renderLogsHammer(graphics);
            }
        }
        return null;
    }

    private void renderEggs(Graphics2D graphics) {
        Collection<GroundItem> eggsList = this.plugin.getGroundEggs().values();
        String calledEgg = this.plugin.getLastListen();
        GroundEggsMode groundEggsMode = this.config.highlightGroundEggsMode();
        Predicate<GroundItem> filter = item -> groundEggsMode == GroundEggsMode.ALL || groundEggsMode == GroundEggsMode.CALLED && (item.getId() == 10534 || calledEgg != null && calledEgg.startsWith(item.getName()));
        this.renderGroundItems(graphics, eggsList, filter);
    }

    private void renderBait(Graphics2D graphics) {
        Collection<GroundItem> bait = this.plugin.getGroundBait().values();
        this.renderGroundItems(graphics, bait);
    }

    private void renderLogsHammer(Graphics2D graphics) {
        Collection<GroundItem> logsHammer = this.plugin.getGroundLogsHammer().values();
        this.renderGroundItems(graphics, logsHammer);
    }

    private void renderGroundItems(Graphics2D graphics, Collection<GroundItem> itemsList) {
        this.renderGroundItems(graphics, itemsList, null);
    }

    private void renderGroundItems(Graphics2D graphics, Collection<GroundItem> itemsList, Predicate<GroundItem> filter) {
        Player player = this.client.getLocalPlayer();
        if (player == null) {
            return;
        }
        this.offsetMap.clear();
        LocalPoint localLocation = player.getLocalLocation();
        for (GroundItem item : itemsList) {
            Polygon poly;
            if (filter != null && !filter.test(item)) {
                log.debug("item {} failed the filter test", (Object)item.getName());
                continue;
            }
            LocalPoint groundPoint = LocalPoint.fromWorld((Client)this.client, (WorldPoint)item.getLocation());
            if (groundPoint == null || localLocation.distanceTo(groundPoint) > 2500) continue;
            Color color = this.plugin.getColorForGroundItemId(item.getId());
            if (this.config.highlightGroundTiles() && (poly = Perspective.getCanvasTilePoly((Client)this.client, (LocalPoint)groundPoint)) != null) {
                OverlayUtil.renderPolygon((Graphics2D)graphics, (Shape)poly, (Color)color);
            }
            this.itemStringBuilder.append(item.getName());
            if (item.getQuantity() > 1) {
                if (item.getQuantity() >= 65535) {
                    this.itemStringBuilder.append(" (Lots!)");
                } else {
                    this.itemStringBuilder.append(" (").append(QuantityFormatter.quantityToStackSize((long)item.getQuantity())).append(")");
                }
            }
            String itemString = this.itemStringBuilder.toString();
            this.itemStringBuilder.setLength(0);
            Point textPoint = Perspective.getCanvasTextLocation((Client)this.client, (Graphics2D)graphics, (LocalPoint)groundPoint, (String)itemString, (int)(item.getHeight() + 20));
            if (textPoint == null) continue;
            int offset = this.offsetMap.compute(item.getLocation(), (k, v) -> v != null ? v + 1 : 0);
            int textX = textPoint.getX();
            int textY = textPoint.getY() - 15 * offset;
            this.textComponent.setText(itemString);
            this.textComponent.setColor(color);
            this.textComponent.setPosition(new java.awt.Point(textX, textY));
            this.textComponent.render(graphics);
        }
    }
}

