/*
 * Decompiled with CFR 0.152.
 */
package begosrs.barbarianassault;

import begosrs.barbarianassault.BaMinigamePlugin;
import begosrs.barbarianassault.Role;
import begosrs.barbarianassault.api.widgets.BaWidgetInfo;
import begosrs.barbarianassault.timer.TimeUnits;
import begosrs.barbarianassault.timer.Timer;
import java.awt.Color;
import javax.annotation.Nullable;
import net.runelite.api.Client;
import net.runelite.api.widgets.Widget;
import net.runelite.client.chat.ChatMessageBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Wave {
    private static final Logger log = LoggerFactory.getLogger(Wave.class);
    static final int AMOUNT_EGGS_COLLECTED_INDEX = 2;
    static final int AMOUNT_HP_REPLENISHED_INDEX = 3;
    private static final String[] SUMMARY_DESCRIPTIONS = new String[]{"Wrong att.", "Runners passed", "Eggs", "Heal", "Wrong pois."};
    private static final BaWidgetInfo[] AMOUNTS_WIDGETS = new BaWidgetInfo[]{BaWidgetInfo.BA_FAILED_ATTACKS, BaWidgetInfo.BA_RUNNERS_PASSED, BaWidgetInfo.BA_EGGS_COLLECTED, BaWidgetInfo.BA_HITPOINTS_REPLENISHED, BaWidgetInfo.BA_WRONG_POISON_PACKS};
    private static final int FAILED_ATTACKS_INDEX = 0;
    private static final BaWidgetInfo[] ATTACKER_POINTS_WIDGETS = new BaWidgetInfo[]{BaWidgetInfo.BA_FAILED_ATTACKS_POINTS, BaWidgetInfo.BA_RANGERS_KILLED, BaWidgetInfo.BA_FIGHTERS_KILLED};
    private static final int RUNNERS_PASSED_INDEX = 0;
    private static final BaWidgetInfo[] DEFENDER_POINTS_WIDGETS = new BaWidgetInfo[]{BaWidgetInfo.BA_RUNNERS_PASSED_POINTS, BaWidgetInfo.BA_RUNNERS_KILLED};
    private static final int EGGS_COLLECTED_INDEX = 0;
    private static final BaWidgetInfo[] COLLECTOR_POINTS_WIDGETS = new BaWidgetInfo[]{BaWidgetInfo.BA_EGGS_COLLECTED_POINTS};
    private static final int HITPOINTS_REPLENISHED_INDEX = 0;
    private static final int WRONG_POISON_PACKS_INDEX = 1;
    private static final BaWidgetInfo[] HEALER_POINTS_WIDGETS = new BaWidgetInfo[]{BaWidgetInfo.BA_HITPOINTS_REPLENISHED_POINTS, BaWidgetInfo.BA_WRONG_POISON_PACKS_POINTS, BaWidgetInfo.BA_HEALERS_KILLED};
    private static final int MAXIMUM_COLLECTED_EGGS = 60;
    private static final int MAXIMUM_HP_HEALED = 504;
    private final Client client;
    private final int number;
    @Nullable
    private final Timer timer;
    private final int[] rolesPoints;
    private final int[] amounts;
    private final int[] points;
    private final Role[] playerRoles;
    @Nullable
    private Role role;
    private int wrongEggsCount;
    private int eggsCount;
    private int hpHealed;
    private boolean fightersKilled;
    private boolean rangersKilled;
    private boolean healersKilled;
    private boolean runnersKilled;
    private boolean ended;

    Wave(Client client, int number) {
        this(client, number, new Role[5], null);
    }

    Wave(Client client, int number, Role[] playerRoles, Timer timer) {
        this.client = client;
        this.number = number;
        this.timer = timer;
        this.rolesPoints = new int[4];
        this.amounts = new int[5];
        this.points = new int[5];
        this.playerRoles = playerRoles;
    }

    public int getTimeUntilCallChange() {
        return 30 - this.getSecondsElapsed(true, TimeUnits.SECONDS) % 30;
    }

    public float getTimeElapsed(boolean delayTicks, TimeUnits units) {
        return (float)this.getSecondsElapsed(delayTicks, units) + (float)this.getMillisOfSecondElapsed(delayTicks, units) / 1000.0f;
    }

    public int getCollectedEggsCount() {
        if (this.ended) {
            return Math.max(0, this.amounts[2]);
        }
        return Math.min(this.eggsCount - this.wrongEggsCount, 60);
    }

    public int getHpHealed() {
        if (this.ended) {
            return Math.max(0, this.amounts[3]);
        }
        return Math.min(this.hpHealed, 504);
    }

    void setAmounts() {
        for (int i = 0; i < AMOUNTS_WIDGETS.length; ++i) {
            int amountsCount;
            this.amounts[i] = amountsCount = this.getBaWidgetValue(AMOUNTS_WIDGETS[i]);
        }
    }

    void setPoints(boolean roundEnded) {
        if (roundEnded) {
            int i = 0;
            while (i < this.rolesPoints.length) {
                int n = i++;
                this.rolesPoints[n] = this.rolesPoints[n] + 80;
            }
        } else {
            int points;
            this.points[0] = this.getBaWidgetValue(ATTACKER_POINTS_WIDGETS[0]);
            this.points[1] = this.getBaWidgetValue(DEFENDER_POINTS_WIDGETS[0]);
            this.points[2] = this.getBaWidgetValue(COLLECTOR_POINTS_WIDGETS[0]);
            this.points[3] = this.getBaWidgetValue(HEALER_POINTS_WIDGETS[0]);
            this.points[4] = this.getBaWidgetValue(HEALER_POINTS_WIDGETS[1]);
            int basePoints = this.getBaWidgetValue(BaWidgetInfo.BA_BASE_POINTS);
            for (Role role : Role.values()) {
                int n = role.ordinal();
                this.rolesPoints[n] = this.rolesPoints[n] + Math.max(0, basePoints);
            }
            for (Enum enum_ : ATTACKER_POINTS_WIDGETS) {
                points = this.getBaWidgetValue((BaWidgetInfo)enum_);
                int n = Role.ATTACKER.ordinal();
                this.rolesPoints[n] = this.rolesPoints[n] + Math.max(0, points);
            }
            for (Enum enum_ : DEFENDER_POINTS_WIDGETS) {
                points = this.getBaWidgetValue((BaWidgetInfo)enum_);
                int n = Role.DEFENDER.ordinal();
                this.rolesPoints[n] = this.rolesPoints[n] + Math.max(0, points);
            }
            for (Enum enum_ : COLLECTOR_POINTS_WIDGETS) {
                points = this.getBaWidgetValue((BaWidgetInfo)enum_);
                int n = Role.COLLECTOR.ordinal();
                this.rolesPoints[n] = this.rolesPoints[n] + Math.max(0, points);
            }
            for (Enum enum_ : HEALER_POINTS_WIDGETS) {
                points = this.getBaWidgetValue((BaWidgetInfo)enum_);
                int n = Role.HEALER.ordinal();
                this.rolesPoints[n] = this.rolesPoints[n] + Math.max(0, points);
            }
        }
        this.ended = true;
    }

    ChatMessageBuilder getWavePoints(boolean colorful, boolean bonus) {
        ChatMessageBuilder message = new ChatMessageBuilder();
        for (int i = 0; i < Role.values().length; ++i) {
            if (i != 0) {
                message.append(" / ");
            }
            Role role = Role.values()[i];
            String roleName = role.getName();
            Color roleColor = role.getColor();
            int pts = Math.max(0, this.rolesPoints[i]);
            if (bonus) {
                pts = (int)((double)pts * 1.1);
            }
            String points = String.valueOf(pts);
            message.append(roleName + ": ");
            if (colorful) {
                message.append(roleColor, points);
                continue;
            }
            message.append(points);
        }
        return message;
    }

    ChatMessageBuilder getWaveSummary(boolean colorful) {
        ChatMessageBuilder message = new ChatMessageBuilder();
        for (int i = 0; i < SUMMARY_DESCRIPTIONS.length; ++i) {
            if (i != 0) {
                message.append(" / ");
            }
            message.append(SUMMARY_DESCRIPTIONS[i]).append(": ").append(String.valueOf(this.amounts[i]));
            int pointsCount = this.points[i];
            if (pointsCount == 0) continue;
            message.append(" (");
            if (colorful) {
                Color color = pointsCount < 0 ? BaMinigamePlugin.RED : BaMinigamePlugin.DARK_GREEN;
                message.append(color, (pointsCount > 0 ? "+" : "") + pointsCount);
            } else {
                message.append((pointsCount > 0 ? "+" : "") + pointsCount);
            }
            message.append(")");
        }
        return message;
    }

    private int getSecondsElapsed(boolean delayTicks, TimeUnits units) {
        if (units == TimeUnits.TICKS) {
            return this.getTicksInMillis(delayTicks) / 1000;
        }
        return this.timer == null ? 0 : (int)this.timer.getWaveTime().getSeconds();
    }

    private int getMillisOfSecondElapsed(boolean delayTicks, TimeUnits units) {
        if (units == TimeUnits.TICKS) {
            return this.getTicksInMillis(delayTicks) % 1000;
        }
        return this.timer == null ? 0 : this.timer.getWaveTime().getNano() / 1000000;
    }

    private int getTicksInMillis(boolean delayed) {
        return this.timer == null ? 0 : this.timer.getCurrentWaveTick(delayed) * 600;
    }

    private int getBaWidgetValue(BaWidgetInfo baWidgetInfo) {
        Widget widget = this.client.getWidget(baWidgetInfo.getGroupId(), baWidgetInfo.getChildId());
        return widget == null ? 0 : Integer.parseInt(widget.getText());
    }

    public boolean isComplete() {
        return (this.role == Role.ATTACKER || this.role == Role.COLLECTOR) && this.fightersKilled && this.rangersKilled || this.role == Role.DEFENDER && this.runnersKilled || this.role == Role.HEALER && this.healersKilled;
    }

    public int getNumber() {
        return this.number;
    }

    @Nullable
    public Timer getTimer() {
        return this.timer;
    }

    public int[] getRolesPoints() {
        return this.rolesPoints;
    }

    public int[] getAmounts() {
        return this.amounts;
    }

    public int[] getPoints() {
        return this.points;
    }

    public Role[] getPlayerRoles() {
        return this.playerRoles;
    }

    @Nullable
    public Role getRole() {
        return this.role;
    }

    public void setRole(@Nullable Role role) {
        this.role = role;
    }

    public int getWrongEggsCount() {
        return this.wrongEggsCount;
    }

    public void setWrongEggsCount(int wrongEggsCount) {
        this.wrongEggsCount = wrongEggsCount;
    }

    public int getEggsCount() {
        return this.eggsCount;
    }

    public void setEggsCount(int eggsCount) {
        this.eggsCount = eggsCount;
    }

    public void setHpHealed(int hpHealed) {
        this.hpHealed = hpHealed;
    }

    public void setFightersKilled(boolean fightersKilled) {
        this.fightersKilled = fightersKilled;
    }

    public void setRangersKilled(boolean rangersKilled) {
        this.rangersKilled = rangersKilled;
    }

    public void setHealersKilled(boolean healersKilled) {
        this.healersKilled = healersKilled;
    }

    public void setRunnersKilled(boolean runnersKilled) {
        this.runnersKilled = runnersKilled;
    }
}

