/*
 * Decompiled with CFR 0.152.
 */
package begosrs.barbarianassault;

import begosrs.barbarianassault.Role;
import begosrs.barbarianassault.Wave;
import begosrs.barbarianassault.points.RolePointsTrackingMode;
import java.util.EnumMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;

public class Session {
    private final List<Wave> waves = new LinkedList<Wave>();
    private final Map<Role, Integer> rolePoints = new EnumMap<Role, Integer>(Role.class);

    public void addWave(Wave wave, RolePointsTrackingMode trackingMode) {
        int[] points = wave.getRolesPoints();
        Role[] playerRoles = wave.getPlayerRoles();
        Role myRole = wave.getRole();
        for (Role role : Role.values()) {
            boolean isPlayerTracking;
            int playerRoleIndex;
            switch (trackingMode) {
                case PLAYER_ONE: {
                    playerRoleIndex = 0;
                    break;
                }
                case PLAYER_TWO: {
                    playerRoleIndex = 1;
                    break;
                }
                case PLAYER_THREE: {
                    playerRoleIndex = 2;
                    break;
                }
                case PLAYER_FOUR: {
                    playerRoleIndex = 3;
                    break;
                }
                case PLAYER_FIVE: {
                    playerRoleIndex = 4;
                    break;
                }
                default: {
                    playerRoleIndex = -1;
                }
            }
            boolean bl = isPlayerTracking = playerRoleIndex >= 0 && playerRoles[playerRoleIndex] != null;
            if (trackingMode == RolePointsTrackingMode.ALL || trackingMode == RolePointsTrackingMode.MINE && myRole == role || trackingMode == RolePointsTrackingMode.ATTACKER && Role.ATTACKER == role || trackingMode == RolePointsTrackingMode.DEFENDER && Role.DEFENDER == role || trackingMode == RolePointsTrackingMode.HEALER && Role.HEALER == role || trackingMode == RolePointsTrackingMode.COLLECTOR && Role.COLLECTOR == role || isPlayerTracking && playerRoles[playerRoleIndex] == role) {
                this.rolePoints.merge(role, points[role.ordinal()], Integer::sum);
            }
            if (wave.getNumber() != 10 || (trackingMode != RolePointsTrackingMode.MINE || role == myRole) && (!isPlayerTracking || playerRoles[playerRoleIndex] == role)) continue;
            this.rolePoints.merge(role, 5, Integer::sum);
        }
        this.waves.add(wave);
    }

    public void reset() {
        this.waves.clear();
        this.rolePoints.clear();
    }

    public int getRolePoints(Role role) {
        return this.rolePoints.getOrDefault((Object)role, 0);
    }

    public void resetRolePoints() {
        for (Role role : Role.values()) {
            this.rolePoints.put(role, 0);
        }
    }

    public List<Wave> getWaves() {
        return this.waves;
    }

    public Map<Role, Integer> getRolePoints() {
        return this.rolePoints;
    }
}

