/*
 * Decompiled with CFR 0.152.
 */
package begosrs.barbarianassault;

import begosrs.barbarianassault.BaMinigamePlugin;
import begosrs.barbarianassault.Role;
import begosrs.barbarianassault.Wave;
import begosrs.barbarianassault.points.RolePointsTrackingMode;
import begosrs.barbarianassault.timer.Timer;
import java.awt.Color;
import java.util.ArrayList;
import java.util.List;
import net.runelite.client.chat.ChatMessageBuilder;

public class Round {
    static final int STARTING_WAVE = 1;
    public static final int ENDING_WAVE = 10;
    private static final String[] SUMMARY_DESCRIPTIONS = new String[]{"Wrong att.", "Runners passed", "Eggs", "Heal", "Wrong pois."};
    private final int startingWave;
    private final Timer timer;
    private final List<Wave> waves;
    private final int[] rolesPoints;
    private final int[] summaryAmounts;
    private final int[] summaryPoints;

    Round(int startingWave, Timer timer) {
        this.startingWave = startingWave;
        this.timer = timer;
        this.waves = new ArrayList<Wave>();
        this.rolesPoints = new int[4];
        this.summaryPoints = new int[5];
        this.summaryAmounts = new int[5];
    }

    void addWave(Wave wave, RolePointsTrackingMode trackingMode) {
        int[] waveRolesPoints = wave.getRolesPoints();
        Role[] playerRoles = wave.getPlayerRoles();
        Role myRole = wave.getRole();
        for (int i = 0; i < this.rolesPoints.length; ++i) {
            boolean isPlayerTracking;
            int playerRoleIndex;
            switch (trackingMode) {
                case PLAYER_ONE: {
                    playerRoleIndex = 0;
                    break;
                }
                case PLAYER_TWO: {
                    playerRoleIndex = 1;
                    break;
                }
                case PLAYER_THREE: {
                    playerRoleIndex = 2;
                    break;
                }
                case PLAYER_FOUR: {
                    playerRoleIndex = 3;
                    break;
                }
                case PLAYER_FIVE: {
                    playerRoleIndex = 4;
                    break;
                }
                default: {
                    playerRoleIndex = -1;
                }
            }
            boolean bl = isPlayerTracking = playerRoleIndex >= 0 && playerRoles[playerRoleIndex] != null;
            if (trackingMode == RolePointsTrackingMode.ALL || trackingMode == RolePointsTrackingMode.MINE && myRole != null && myRole.ordinal() == i || trackingMode == RolePointsTrackingMode.ATTACKER && Role.ATTACKER.ordinal() == i || trackingMode == RolePointsTrackingMode.DEFENDER && Role.DEFENDER.ordinal() == i || trackingMode == RolePointsTrackingMode.HEALER && Role.HEALER.ordinal() == i || trackingMode == RolePointsTrackingMode.COLLECTOR && Role.COLLECTOR.ordinal() == i || isPlayerTracking && playerRoles[playerRoleIndex].ordinal() == i) {
                int n = i;
                this.rolesPoints[n] = this.rolesPoints[n] + waveRolesPoints[i];
            }
            if (wave.getNumber() != 10 || (trackingMode != RolePointsTrackingMode.MINE || myRole == null || myRole.ordinal() == i) && (!isPlayerTracking || playerRoles[playerRoleIndex].ordinal() == i)) continue;
            int n = i;
            this.rolesPoints[n] = this.rolesPoints[n] + 5;
        }
        int[] waveAmounts = wave.getAmounts();
        for (int i = 0; i < this.summaryAmounts.length; ++i) {
            int n = i;
            this.summaryAmounts[n] = this.summaryAmounts[n] + waveAmounts[i];
        }
        int[] wavePoints = wave.getPoints();
        for (int i = 0; i < this.summaryPoints.length; ++i) {
            int n = i;
            this.summaryPoints[n] = this.summaryPoints[n] + wavePoints[i];
        }
        this.waves.add(wave);
    }

    public int getCollectedEggsCount(int currentWaveCollectedEggs) {
        return currentWaveCollectedEggs + this.waves.stream().map(Wave::getCollectedEggsCount).reduce(0, Integer::sum);
    }

    public int getHpHealed(int currentWaveHpHealed) {
        return currentWaveHpHealed + this.waves.stream().map(Wave::getHpHealed).reduce(0, Integer::sum);
    }

    int getNumberOfWaves() {
        return this.waves.size();
    }

    boolean isComplete() {
        return this.startingWave - 1 + this.getNumberOfWaves() == 10;
    }

    ChatMessageBuilder getRoundPointsMessage(boolean colorful, boolean bonus) {
        ChatMessageBuilder message = new ChatMessageBuilder();
        for (int i = 0; i < Role.values().length; ++i) {
            if (i != 0) {
                message.append(" / ");
            }
            Role role = Role.values()[i];
            String roleName = role.getName();
            Color roleColor = role.getColor();
            int pts = Math.max(0, this.rolesPoints[i]);
            if (bonus) {
                pts = (int)((double)pts * 1.1);
            }
            String points = String.valueOf(pts);
            message.append(roleName + ": ");
            if (colorful) {
                message.append(roleColor, points);
                continue;
            }
            message.append(points);
        }
        return message;
    }

    ChatMessageBuilder getRoundSummaryMessage(boolean colorful) {
        ChatMessageBuilder message = new ChatMessageBuilder();
        for (int i = 0; i < SUMMARY_DESCRIPTIONS.length; ++i) {
            if (i != 0) {
                message.append(" / ");
            }
            message.append(SUMMARY_DESCRIPTIONS[i]).append(": ").append(String.valueOf(this.summaryAmounts[i]));
            int pointsCount = this.summaryPoints[i];
            if (pointsCount == 0) continue;
            message.append(" (");
            if (colorful) {
                Color color = pointsCount < 0 ? BaMinigamePlugin.RED : BaMinigamePlugin.DARK_GREEN;
                message.append(color, (pointsCount > 0 ? "+" : "") + pointsCount);
            } else {
                message.append((pointsCount > 0 ? "+" : "") + pointsCount);
            }
            message.append(")");
        }
        return message;
    }

    public int getRolePoints(Role role) {
        return this.rolesPoints[role.ordinal()];
    }

    public void resetRolePoints() {
        for (int i = 0; i < Role.values().length; ++i) {
            this.rolesPoints[i] = 0;
        }
    }

    public int getStartingWave() {
        return this.startingWave;
    }

    public Timer getTimer() {
        return this.timer;
    }

    public List<Wave> getWaves() {
        return this.waves;
    }
}

