/*
 * Decompiled with CFR 0.152.
 */
package begosrs.barbarianassault;

import begosrs.barbarianassault.BaMinigamePlugin;
import begosrs.barbarianassault.api.BaVarbits;
import begosrs.barbarianassault.api.widgets.BaWidgetInfo;
import com.google.common.collect.ImmutableMap;
import java.awt.Color;
import net.runelite.api.Client;
import net.runelite.api.widgets.Widget;

public enum Role {
    ATTACKER("Attacker", BaMinigamePlugin.RED, BaWidgetInfo.BA_ATTACKER_WAVE_INFO, BaWidgetInfo.BA_ATTACKER_WAVE_TEXT, BaWidgetInfo.BA_ATTACKER_WAVE_SPRITE, BaWidgetInfo.BA_ATTACKER_LISTEN_TOP_TEXT, BaWidgetInfo.BA_HORN_OF_GLORY_COLLECTOR_LISTEN_TEXT, BaWidgetInfo.BA_ATTACKER_CALL_TEXT, BaWidgetInfo.BA_ATTACKER_CALL_FLASH, BaWidgetInfo.BA_HORN_OF_GLORY_COLLECTOR_LISTEN_TEXT, BaWidgetInfo.BA_ATTACKER_ROLE_TEXT, BaWidgetInfo.BA_ATTACKER_ROLE_SPRITE, 770, "Collector", BaVarbits.BA_ATTACKER_ROLE_BASE_POINTS, BaVarbits.BA_ATTACKER_ROLE_MULTIPLIER, 768, 20561),
    DEFENDER("Defender", BaMinigamePlugin.LIGHT_BLUE, BaWidgetInfo.BA_DEFENDER_WAVE_INFO, BaWidgetInfo.BA_DEFENDER_WAVE_TEXT, BaWidgetInfo.BA_DEFENDER_WAVE_SPRITE, BaWidgetInfo.BA_DEFENDER_LISTEN_TEXT, BaWidgetInfo.BA_HORN_OF_GLORY_HEALER_LISTEN_TEXT, BaWidgetInfo.BA_DEFENDER_CALL_TEXT, BaWidgetInfo.BA_DEFENDER_CALL_FLASH, BaWidgetInfo.BA_HORN_OF_GLORY_HEALER_LISTEN_TEXT, BaWidgetInfo.BA_DEFENDER_ROLE_TEXT, BaWidgetInfo.BA_DEFENDER_ROLE_SPRITE, 771, "Healer", BaVarbits.BA_DEFENDER_ROLE_BASE_POINTS, BaVarbits.BA_DEFENDER_ROLE_MULTIPLIER, 769, 20566),
    COLLECTOR("Collector", Color.YELLOW, BaWidgetInfo.BA_COLLECTOR_WAVE_INFO, BaWidgetInfo.BA_COLLECTOR_WAVE_TEXT, BaWidgetInfo.BA_COLLECTOR_WAVE_SPRITE, BaWidgetInfo.BA_COLLECTOR_LISTEN_TEXT, BaWidgetInfo.BA_HORN_OF_GLORY_ATTACKER_LISTEN_TEXT, BaWidgetInfo.BA_COLLECTOR_CALL_TEXT, BaWidgetInfo.BA_COLLECTOR_CALL_FLASH, BaWidgetInfo.BA_HORN_OF_GLORY_ATTACKER_LISTEN_TEXT, BaWidgetInfo.BA_COLLECTOR_ROLE_TEXT, BaWidgetInfo.BA_COLLECTOR_ROLE_SPRITE, 768, "Attacker", BaVarbits.BA_COLLECTOR_ROLE_BASE_POINTS, BaVarbits.BA_COLLECTOR_ROLE_MULTIPLIER, 770, 20563),
    HEALER("Healer", BaMinigamePlugin.DARK_GREEN, BaWidgetInfo.BA_HEALER_WAVE_INFO, BaWidgetInfo.BA_HEALER_WAVE_TEXT, BaWidgetInfo.BA_HEALER_WAVE_SPRITE, BaWidgetInfo.BA_HEALER_LISTEN_TEXT, BaWidgetInfo.BA_HORN_OF_GLORY_DEFENDER_LISTEN_TEXT, BaWidgetInfo.BA_HEALER_CALL_TEXT, BaWidgetInfo.BA_HEALER_CALL_FLASH, BaWidgetInfo.BA_HORN_OF_GLORY_DEFENDER_LISTEN_TEXT, BaWidgetInfo.BA_HEALER_ROLE_TEXT, BaWidgetInfo.BA_HEALER_ROLE_SPRITE, 769, "Defender", BaVarbits.BA_HEALER_ROLE_POINTS, BaVarbits.BA_HEALER_ROLE_MULTIPLIER, 771, 20569);

    private static final ImmutableMap<String, String> GLORY_CALLS;
    private static final ImmutableMap<String, Integer> ITEMS;
    private final String name;
    private final Color color;
    private final BaWidgetInfo waveInfo;
    private final BaWidgetInfo waveText;
    private final BaWidgetInfo waveSprite;
    private final BaWidgetInfo listen;
    private final BaWidgetInfo hornOfGloryListen;
    private final BaWidgetInfo call;
    private final BaWidgetInfo callFlash;
    private final BaWidgetInfo hornOfGloryCall;
    private final BaWidgetInfo roleText;
    private final BaWidgetInfo roleSprite;
    private final int partnerHornSpriteId;
    private final String partnerRoleName;
    private final BaVarbits basePointsVarBit;
    private final BaVarbits pointsMultiplierVarBit;
    private final int hornSpriteId;
    private final int roleModelId;

    public String toString() {
        return this.name();
    }

    int getListenItemId(Client client) {
        String listen = this.getListenText(client);
        return (Integer)ITEMS.getOrDefault((Object)listen, (Object)-1);
    }

    String getListenText(Client client) {
        String listen = this.getWidgetText(client, this.hornOfGloryListen, this.listen);
        if (this == ATTACKER) {
            if ("Controlled/".equals(listen)) {
                listen = "Controlled/Bullet/Wind";
            } else if ("Accurate/".equals(listen)) {
                listen = "Accurate/Field/Water";
            } else if ("Aggressive/".equals(listen)) {
                listen = "Aggressive/Blunt/Earth";
            } else if ("Defensive/".equals(listen)) {
                listen = "Defensive/Barbed/Fire";
            }
        }
        return listen;
    }

    String getCallText(Client client) {
        return this.getWidgetText(client, this.hornOfGloryCall, this.call);
    }

    private String getWidgetText(Client client, BaWidgetInfo hornOfGlory, BaWidgetInfo baWidgetInfo) {
        Widget widget = client.getWidget(hornOfGlory.getGroupId(), hornOfGlory.getChildId());
        if (widget != null) {
            return (String)GLORY_CALLS.get((Object)widget.getText());
        }
        widget = client.getWidget(baWidgetInfo.getGroupId(), baWidgetInfo.getChildId());
        if (widget != null) {
            return widget.getText();
        }
        return null;
    }

    public int getPoints(Client client) {
        int constant = 512;
        int multiplier = client.getVarbitValue(this.pointsMultiplierVarBit.getId());
        return client.getVarbitValue(this.basePointsVarBit.getId()) + 512 * multiplier;
    }

    private Role(String name, Color color, BaWidgetInfo waveInfo, BaWidgetInfo waveText, BaWidgetInfo waveSprite, BaWidgetInfo listen, BaWidgetInfo hornOfGloryListen, BaWidgetInfo call, BaWidgetInfo callFlash, BaWidgetInfo hornOfGloryCall, BaWidgetInfo roleText, BaWidgetInfo roleSprite, int partnerHornSpriteId, String partnerRoleName, BaVarbits basePointsVarBit, BaVarbits pointsMultiplierVarBit, int hornSpriteId, int roleModelId) {
        this.name = name;
        this.color = color;
        this.waveInfo = waveInfo;
        this.waveText = waveText;
        this.waveSprite = waveSprite;
        this.listen = listen;
        this.hornOfGloryListen = hornOfGloryListen;
        this.call = call;
        this.callFlash = callFlash;
        this.hornOfGloryCall = hornOfGloryCall;
        this.roleText = roleText;
        this.roleSprite = roleSprite;
        this.partnerHornSpriteId = partnerHornSpriteId;
        this.partnerRoleName = partnerRoleName;
        this.basePointsVarBit = basePointsVarBit;
        this.pointsMultiplierVarBit = pointsMultiplierVarBit;
        this.hornSpriteId = hornSpriteId;
        this.roleModelId = roleModelId;
    }

    public String getName() {
        return this.name;
    }

    public Color getColor() {
        return this.color;
    }

    public BaWidgetInfo getWaveInfo() {
        return this.waveInfo;
    }

    public BaWidgetInfo getWaveText() {
        return this.waveText;
    }

    public BaWidgetInfo getWaveSprite() {
        return this.waveSprite;
    }

    public BaWidgetInfo getListen() {
        return this.listen;
    }

    public BaWidgetInfo getHornOfGloryListen() {
        return this.hornOfGloryListen;
    }

    public BaWidgetInfo getCall() {
        return this.call;
    }

    public BaWidgetInfo getCallFlash() {
        return this.callFlash;
    }

    public BaWidgetInfo getHornOfGloryCall() {
        return this.hornOfGloryCall;
    }

    public BaWidgetInfo getRoleText() {
        return this.roleText;
    }

    public BaWidgetInfo getRoleSprite() {
        return this.roleSprite;
    }

    public int getPartnerHornSpriteId() {
        return this.partnerHornSpriteId;
    }

    public String getPartnerRoleName() {
        return this.partnerRoleName;
    }

    public BaVarbits getBasePointsVarBit() {
        return this.basePointsVarBit;
    }

    public BaVarbits getPointsMultiplierVarBit() {
        return this.pointsMultiplierVarBit;
    }

    public int getHornSpriteId() {
        return this.hornSpriteId;
    }

    public int getRoleModelId() {
        return this.roleModelId;
    }

    static {
        GLORY_CALLS = ImmutableMap.builder().put((Object)"Controlled/Bullet/Wind", (Object)"Controlled/Bullet/Wind").put((Object)"Accurate/Field/Water", (Object)"Accurate/Field/Water").put((Object)"Aggressive/Blunt/Earth", (Object)"Aggressive/Blunt/Earth").put((Object)"Defensive/Barbed/Fire", (Object)"Defensive/Barbed/Fire").put((Object)"Tofu", (Object)"Tofu").put((Object)"Crackers", (Object)"Crackers").put((Object)"Worms", (Object)"Worms").put((Object)"Poison worms", (Object)"Pois. Worms").put((Object)"Poison tofu", (Object)"Pois. Tofu").put((Object)"Poison meat", (Object)"Pois. Meat").put((Object)"Red egg", (Object)"Red egg").put((Object)"Green egg", (Object)"Green egg").put((Object)"Blue egg", (Object)"Blue egg").build();
        ITEMS = ImmutableMap.builder().put((Object)"Tofu", (Object)10514).put((Object)"Crackers", (Object)10513).put((Object)"Worms", (Object)10515).put((Object)"Poison Worms", (Object)10540).put((Object)"Pois. Worms", (Object)10540).put((Object)"Poison Tofu", (Object)10539).put((Object)"Pois. Tofu", (Object)10539).put((Object)"Poison Meat", (Object)10541).put((Object)"Pois. Meat", (Object)10541).put((Object)"Controlled/Bullet/Wind", (Object)22227).put((Object)"Accurate/Field/Water", (Object)22228).put((Object)"Aggressive/Blunt/Earth", (Object)22229).put((Object)"Defensive/Barbed/Fire", (Object)22230).put((Object)"Red eggs", (Object)10532).put((Object)"Green eggs", (Object)10531).put((Object)"Blue eggs", (Object)10533).build();
    }
}

