/*
 * Decompiled with CFR 0.152.
 */
package begosrs.barbarianassault;

import begosrs.barbarianassault.BaMinigameConfig;
import begosrs.barbarianassault.BaMinigameInputListener;
import begosrs.barbarianassault.Role;
import begosrs.barbarianassault.Round;
import begosrs.barbarianassault.Session;
import begosrs.barbarianassault.Wave;
import begosrs.barbarianassault.api.widgets.BaWidgetInfo;
import begosrs.barbarianassault.attackstyle.AttackStyle;
import begosrs.barbarianassault.attackstyle.AttackStyleWidget;
import begosrs.barbarianassault.attackstyle.WeaponType;
import begosrs.barbarianassault.deathtimes.DeathTimeInfoBox;
import begosrs.barbarianassault.deathtimes.DeathTimesMode;
import begosrs.barbarianassault.grounditems.GroundItem;
import begosrs.barbarianassault.grounditems.GroundItemsOverlay;
import begosrs.barbarianassault.grounditems.MenuHighlightMode;
import begosrs.barbarianassault.groundmarkers.BrokenTrapsOverlay;
import begosrs.barbarianassault.hoppers.CollectorEgg;
import begosrs.barbarianassault.hoppers.HoppersOverlay;
import begosrs.barbarianassault.inventory.InventoryOverlay;
import begosrs.barbarianassault.menuentryswapper.MenuEntrySwapper;
import begosrs.barbarianassault.points.DisplayPointsLocationMode;
import begosrs.barbarianassault.points.DisplayPointsMode;
import begosrs.barbarianassault.points.KandarinDiaryBonusMode;
import begosrs.barbarianassault.points.PointsCounterMode;
import begosrs.barbarianassault.points.PointsMode;
import begosrs.barbarianassault.points.RewardsBreakdownMode;
import begosrs.barbarianassault.points.RolePointsInfoBox;
import begosrs.barbarianassault.points.RolePointsOverlay;
import begosrs.barbarianassault.points.RolePointsTrackingMode;
import begosrs.barbarianassault.teamhealthbar.TeamHealthBarOverlay;
import begosrs.barbarianassault.ticktimer.RunnerTickTimer;
import begosrs.barbarianassault.ticktimer.RunnerTickTimerOverlay;
import begosrs.barbarianassault.timer.DurationMode;
import begosrs.barbarianassault.timer.TimeUnits;
import begosrs.barbarianassault.timer.Timer;
import begosrs.barbarianassault.waveinfo.WaveInfoOverlay;
import com.google.inject.Provides;
import java.awt.Color;
import java.awt.image.BufferedImage;
import java.time.Duration;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import javax.inject.Inject;
import net.runelite.api.ChatMessageType;
import net.runelite.api.Client;
import net.runelite.api.GameObject;
import net.runelite.api.GameState;
import net.runelite.api.GroundObject;
import net.runelite.api.InventoryID;
import net.runelite.api.Item;
import net.runelite.api.ItemComposition;
import net.runelite.api.ItemContainer;
import net.runelite.api.MenuAction;
import net.runelite.api.MenuEntry;
import net.runelite.api.MessageNode;
import net.runelite.api.Player;
import net.runelite.api.Tile;
import net.runelite.api.TileItem;
import net.runelite.api.coords.WorldPoint;
import net.runelite.api.events.ChatMessage;
import net.runelite.api.events.ClientTick;
import net.runelite.api.events.GameObjectDespawned;
import net.runelite.api.events.GameObjectSpawned;
import net.runelite.api.events.GameTick;
import net.runelite.api.events.GroundObjectDespawned;
import net.runelite.api.events.GroundObjectSpawned;
import net.runelite.api.events.ItemContainerChanged;
import net.runelite.api.events.ItemDespawned;
import net.runelite.api.events.ItemSpawned;
import net.runelite.api.events.MenuEntryAdded;
import net.runelite.api.events.ScriptPostFired;
import net.runelite.api.events.VarbitChanged;
import net.runelite.api.events.WidgetClosed;
import net.runelite.api.events.WidgetLoaded;
import net.runelite.api.widgets.Widget;
import net.runelite.client.callback.ClientThread;
import net.runelite.client.chat.ChatColorType;
import net.runelite.client.chat.ChatMessageBuilder;
import net.runelite.client.chat.ChatMessageManager;
import net.runelite.client.chat.QueuedMessage;
import net.runelite.client.config.ConfigManager;
import net.runelite.client.eventbus.Subscribe;
import net.runelite.client.events.ConfigChanged;
import net.runelite.client.game.ItemManager;
import net.runelite.client.input.KeyListener;
import net.runelite.client.input.KeyManager;
import net.runelite.client.plugins.Plugin;
import net.runelite.client.plugins.PluginDescriptor;
import net.runelite.client.ui.overlay.Overlay;
import net.runelite.client.ui.overlay.OverlayManager;
import net.runelite.client.ui.overlay.infobox.InfoBox;
import net.runelite.client.ui.overlay.infobox.InfoBoxManager;
import net.runelite.client.util.ColorUtil;
import net.runelite.client.util.ImageUtil;
import net.runelite.client.util.Text;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@PluginDescriptor(name="Ba Minigame", description="Includes many features to enhance the barbarian assault minigame gameplay experience", tags={"overlay", "b.a.", "barbarian assault", "minigame", "attacker", "defender", "collector", "healer", "plugin hub"})
public class BaMinigamePlugin
extends Plugin {
    private static final Logger log = LoggerFactory.getLogger(BaMinigamePlugin.class);
    public static final Color RED = new Color(228, 18, 31);
    public static final Color DARK_GREEN = new Color(0, 153, 0);
    public static final Color LIGHT_BLUE = new Color(60, 124, 240);
    public static final Color LIGHT_RED = new Color(255, 35, 35);
    public static final Color FIGHTER_DEATH_COLOR = new Color(255, 48, 69);
    public static final Color HEALER_DEATH_COLOR = new Color(34, 150, 40);
    public static final Color RUNNER_DEATH_COLOR = new Color(51, 102, 255);
    public static final Color DEFAULT_FLASH_COLOR = new Color(255, 255, 255, 126);
    public static final int DEFAULT_ATTACK_STYLE_COLOR = 16750623;
    public static final int WAVE_CHECKMARK_ICON_WIDTH = 13;
    private static final int BA_WAVE_NUM_INDEX = 2;
    private static final String END_ROUND_REWARD_NEEDLE_TEXT = "<br>5";
    private static final int MENU_THIRD_OPTION = MenuAction.GROUND_ITEM_THIRD_OPTION.getId();
    private static final String BA_MINIGAME_CONFIG_GROUP = "baMinigame";
    private static final String GROUND_ITEMS_CONFIG_GROUP = "grounditems";
    private static final String GROUND_ITEMS_CONFIG_HIGHLIGHTED_ITENS = "highlightedItems";
    private static final String GROUND_ITEMS_CONFIG_HIDDEN_ITENS = "hiddenItems";
    private static final String[] GROUND_ITEMS_HIDDEN_LIST = new String[]{"Green egg", "Red egg", "Blue egg", "Hammer", "Logs", "Yellow egg", "Crackers", "Tofu", "Worms"};
    private static final String BARBARIAN_ASSAULT_CONFIG_GROUP = "barbarianAssault";
    private static final String[] BARBARIAN_ASSAULT_CONFIGS = new String[]{"showTimer", "showHealerBars", "waveTimes"};
    private static final int BA_UNDERGROUND_REGION_ID = 10322;
    private static final int BA_TILE_START_X = 2522;
    private static final int BA_TILE_END_X = 2538;
    private static final int BA_TILE_START_Y = 3560;
    private static final int BA_TILE_END_Y = 3579;
    private static final int WAVE_ICON_WIDTH = 17;
    private static final BaWidgetInfo[] TEAM_PLAYERS_ROLES_WIDGETS = new BaWidgetInfo[]{BaWidgetInfo.BA_TEAM_PLAYER1_ROLE, BaWidgetInfo.BA_TEAM_PLAYER2_ROLE, BaWidgetInfo.BA_TEAM_PLAYER3_ROLE, BaWidgetInfo.BA_TEAM_PLAYER4_ROLE, BaWidgetInfo.BA_TEAM_PLAYER5_ROLE};
    private final List<GameObject> hoppers = new ArrayList<GameObject>(2);
    private final List<GroundObject> brokenTraps = new ArrayList<GroundObject>(2);
    private final Map<CollectorEgg, Integer> cannonEggs = new HashMap<CollectorEgg, Integer>(4);
    private final Map<GroundItem.Key, GroundItem> groundEggs = new LinkedHashMap<GroundItem.Key, GroundItem>();
    private final Map<GroundItem.Key, GroundItem> groundBait = new LinkedHashMap<GroundItem.Key, GroundItem>();
    private final Map<GroundItem.Key, GroundItem> groundLogsHammer = new LinkedHashMap<GroundItem.Key, GroundItem>(3);
    private final List<DeathTimeInfoBox> deathTimesInfoBoxes = new ArrayList<DeathTimeInfoBox>();
    private final Map<String, BufferedImage> images = new HashMap<String, BufferedImage>(8);
    private final Map<Role, Integer> rolePoints = new EnumMap<Role, Integer>(Role.class);
    private final Map<Role, RolePointsInfoBox> rolePointsInfoBoxes = new EnumMap<Role, RolePointsInfoBox>(Role.class);
    private final Role[] playerRoles = new Role[5];
    @Inject
    private Client client;
    @Inject
    private ClientThread clientThread;
    @Inject
    private BaMinigameConfig config;
    @Inject
    private ChatMessageManager chatMessageManager;
    @Inject
    private OverlayManager overlayManager;
    @Inject
    private ItemManager itemManager;
    @Inject
    private InfoBoxManager infoBoxManager;
    @Inject
    private ConfigManager configManager;
    @Inject
    private KeyManager keyManager;
    @Inject
    private MenuEntrySwapper menuEntrySwapper;
    @Inject
    private WaveInfoOverlay waveInfoOverlay;
    @Inject
    private InventoryOverlay inventoryOverlay;
    @Inject
    private GroundItemsOverlay groundItemsOverlay;
    @Inject
    private HoppersOverlay hoppersOverlay;
    @Inject
    private RunnerTickTimerOverlay runnerTickTimerOverlay;
    @Inject
    private TeamHealthBarOverlay teamHealthBarOverlay;
    @Inject
    private BaMinigameInputListener inputListener;
    @Inject
    private RolePointsOverlay rolePointsOverlay;
    @Inject
    private BrokenTrapsOverlay brokenTrapsOverlay;
    private RunnerTickTimer runnerTickTimer;
    private int inGameBit;
    private Timer timer;
    private Session session;
    private Round round;
    private Wave wave;
    private int currentWave;
    private String lastListen;
    private int lastListenItemId;
    private Integer attackStyleTextColor;
    private boolean teammatesHealthHotkeyPressed;
    private boolean teammatesHealthShifted;
    private WorldPoint worldPoint;
    private long lastWaveCompletedTimestamp;
    private int correctedCallCount;
    private boolean containsRoleHorn;
    private boolean loadingPlayerRoles;

    @Provides
    BaMinigameConfig provideConfig(ConfigManager configManager) {
        return (BaMinigameConfig)configManager.getConfig(BaMinigameConfig.class);
    }

    protected void startUp() throws Exception {
        this.images.put("fighters", ImageUtil.loadImageResource(((Object)((Object)this)).getClass(), (String)"/penance_fighter.png"));
        this.images.put("rangers", ImageUtil.loadImageResource(((Object)((Object)this)).getClass(), (String)"/penance_ranger.png"));
        this.images.put("healers", ImageUtil.loadImageResource(((Object)((Object)this)).getClass(), (String)"/penance_healer.png"));
        this.images.put("runners", ImageUtil.loadImageResource(((Object)((Object)this)).getClass(), (String)"/penance_runner.png"));
        this.images.put("attacker", ImageUtil.loadImageResource(((Object)((Object)this)).getClass(), (String)"/attacker.png"));
        this.images.put("defender", ImageUtil.loadImageResource(((Object)((Object)this)).getClass(), (String)"/defender.png"));
        this.images.put("collector", ImageUtil.loadImageResource(((Object)((Object)this)).getClass(), (String)"/collector.png"));
        this.images.put("healer", ImageUtil.loadImageResource(((Object)((Object)this)).getClass(), (String)"/healer.png"));
        this.overlayManager.add((Overlay)this.waveInfoOverlay);
        this.overlayManager.add((Overlay)this.inventoryOverlay);
        this.overlayManager.add((Overlay)this.groundItemsOverlay);
        this.overlayManager.add((Overlay)this.hoppersOverlay);
        this.overlayManager.add((Overlay)this.runnerTickTimerOverlay);
        this.overlayManager.add((Overlay)this.teamHealthBarOverlay);
        this.overlayManager.add((Overlay)this.rolePointsOverlay);
        this.overlayManager.add((Overlay)this.brokenTrapsOverlay);
        this.menuEntrySwapper.enableSwaps();
        this.clientThread.invokeLater(() -> this.updateAttackStyleText(this.lastListen));
        this.keyManager.registerKeyListener((KeyListener)this.inputListener);
        if (this.config.showGroundItemHighlights()) {
            this.setGroundItemsPluginLists();
        }
        this.disableBarbarianAssaultPluginFeatures();
    }

    protected void shutDown() throws Exception {
        this.overlayManager.remove((Overlay)this.waveInfoOverlay);
        this.overlayManager.remove((Overlay)this.inventoryOverlay);
        this.overlayManager.remove((Overlay)this.groundItemsOverlay);
        this.overlayManager.remove((Overlay)this.hoppersOverlay);
        this.overlayManager.remove((Overlay)this.runnerTickTimerOverlay);
        this.overlayManager.remove((Overlay)this.teamHealthBarOverlay);
        this.overlayManager.remove((Overlay)this.rolePointsOverlay);
        this.overlayManager.remove((Overlay)this.brokenTrapsOverlay);
        this.menuEntrySwapper.disableSwaps();
        this.keyManager.unregisterKeyListener((KeyListener)this.inputListener);
        this.hoppers.clear();
        this.brokenTraps.clear();
        this.cannonEggs.clear();
        this.groundEggs.clear();
        this.groundBait.clear();
        this.groundLogsHammer.clear();
        this.images.clear();
        this.rolePoints.clear();
        this.disableRunnerTickTimer(true);
        this.removeDeathTimesInfoBoxes();
        this.removeRolePointsInfoBoxes();
        this.clientThread.invokeLater(this::restoreHealerTeammatesHealth);
        this.clientThread.invokeLater(this::restoreAttackStyleText);
        if (this.wave != null) {
            this.clientThread.invokeLater(() -> {
                this.restoreWaveWidget(this.wave, true);
                this.setCallFlashColor(this.wave, DEFAULT_FLASH_COLOR);
                this.removeWaveWidgets(this.wave);
                this.wave = null;
            });
        }
        this.timer = null;
        this.round = null;
        this.session = null;
        this.currentWave = 0;
        this.lastListen = null;
        this.lastListenItemId = 0;
        this.restoreGroundItemsPluginLists();
        this.restoreBarbarianAssaultPluginFeatures();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Subscribe
    public void onConfigChanged(ConfigChanged event) {
        block74: {
            String group = event.getGroup();
            String key = event.getKey();
            String oldValue = event.getOldValue();
            String newValue = event.getNewValue();
            block4 : switch (group) {
                case "barbarianAssault": {
                    this.config.setBarbarianAssaultConfigs("");
                    return;
                }
                case "baMinigame": {
                    switch (key) {
                        case "callChangeFlashColor": {
                            if (this.inGameBit != 1) return;
                            this.setCallFlashColor(this.wave, this.config.callChangeFlashColor());
                            break block74;
                        }
                        case "showCallChangeTimer": 
                        case "hideTeammateRole": {
                            if (this.wave == null) return;
                            this.clientThread.invokeLater(() -> {
                                this.removeWaveWidgets(this.wave);
                                this.setWaveWidgets(this.wave);
                            });
                            break block74;
                        }
                        case "showWaveTimer": {
                            if (this.config.showWaveTimer()) return;
                            this.clientThread.invokeLater(() -> this.restoreWaveWidget(this.wave, false));
                            break block74;
                        }
                        case "showHpCountOverlay": {
                            if (this.wave == null || this.getRole() != Role.HEALER) return;
                            this.clientThread.invokeLater(() -> {
                                this.removeWaveWidgets(this.wave);
                                this.setWaveWidgets(this.wave);
                            });
                            break block74;
                        }
                        case "showEggCountOverlay": {
                            if (this.wave == null || this.getRole() != Role.COLLECTOR) return;
                            this.clientThread.invokeLater(() -> {
                                this.removeWaveWidgets(this.wave);
                                this.setWaveWidgets(this.wave);
                            });
                            break block74;
                        }
                        case "showRunnerTickTimerAttacker": {
                            boolean display = this.config.showRunnerTickTimerAttacker() && this.inGameBit == 1 && this.getRole() == Role.ATTACKER;
                            this.enableRunnerTickTimer(display);
                            break block4;
                        }
                        case "showRunnerTickTimerDefender": {
                            boolean display = this.config.showRunnerTickTimerDefender() && this.inGameBit == 1 && this.getRole() == Role.DEFENDER;
                            this.enableRunnerTickTimer(display);
                            break block4;
                        }
                        case "showRunnerTickTimerCollector": {
                            boolean display = this.config.showRunnerTickTimerCollector() && this.inGameBit == 1 && this.getRole() == Role.COLLECTOR;
                            this.enableRunnerTickTimer(display);
                            break block4;
                        }
                        case "showRunnerTickTimerHealer": {
                            boolean display = this.config.showRunnerTickTimerHealer() && this.inGameBit == 1 && this.getRole() == Role.HEALER;
                            this.enableRunnerTickTimer(display);
                            break block4;
                        }
                        case "deathTimesMode": {
                            DeathTimesMode deathTimesMode = this.config.deathTimesMode();
                            if (deathTimesMode == DeathTimesMode.INFO_BOX || deathTimesMode == DeathTimesMode.INFOBOX_CHAT) {
                                this.showDeathTimes();
                                break block4;
                            }
                            this.hideDeathTimesInfoBoxes();
                            break block4;
                        }
                        case "displayPointsMode": {
                            DisplayPointsMode pointsMode = this.config.displayPointsMode();
                            if (pointsMode == DisplayPointsMode.INFO_BOX) {
                                this.clientThread.invokeLater(() -> this.updateRolePoints(false));
                                break block4;
                            }
                            this.hideRolePointsInfoBoxes();
                            break block4;
                        }
                        case "displayPointsLocationMode": {
                            if (!this.shouldDisplayRolePoints()) {
                                this.hideRolePointsInfoBoxes();
                                break block4;
                            }
                            this.clientThread.invokeLater(() -> this.updateRolePoints(true));
                            break block4;
                        }
                        case "highlightAttackStyle": 
                        case "highlightAttackStyleColor": {
                            this.clientThread.invokeLater(() -> this.updateAttackStyleText(this.lastListen));
                            break block4;
                        }
                        case "showGroundItemHighlights": {
                            if (this.config.showGroundItemHighlights()) {
                                this.setGroundItemsPluginLists();
                                break block4;
                            }
                            this.restoreGroundItemsPluginLists();
                            break block4;
                        }
                        case "groundItemsPluginHighlightedList": {
                            if (oldValue.isEmpty() || !newValue.isEmpty()) return;
                            this.config.setGroundItemsPluginHighlightedList(oldValue);
                            break block74;
                        }
                        case "groundItemsPluginHiddenList": {
                            if (oldValue.isEmpty() || !newValue.isEmpty()) return;
                            this.config.setGroundItemsPluginHiddenList(oldValue);
                            break block74;
                        }
                        case "barbarianAssaultConfigs": {
                            if (oldValue.isEmpty() || !newValue.isEmpty()) return;
                            this.config.setBarbarianAssaultConfigs(oldValue);
                            break block74;
                        }
                        case "hideHealerTeammatesHealth": {
                            if (this.wave == null || this.wave.getRole() != Role.HEALER) return;
                            this.setHealerTeammatesHealthDisplay();
                            break block74;
                        }
                        case "showWaveCompleted": {
                            if (this.config.showWaveCompleted()) return;
                            this.restoreWaveIcon(this.wave);
                            break block74;
                        }
                        case "pointsCounterMode": 
                        case "rolePointsTrackingMode": {
                            this.clientThread.invokeLater(() -> this.updateRolePoints(false));
                            break block4;
                        }
                        case "resetPoints": {
                            this.resetRolePoints();
                            break block4;
                        }
                        case "kandarinHardDiaryPointsBoost": {
                            PointsCounterMode pointsCounterMode = this.config.pointsCounterMode();
                            if (pointsCounterMode == PointsCounterMode.CURRENT_POINTS) return;
                            this.clientThread.invokeLater(() -> this.updateRolePoints(false));
                        }
                    }
                }
            }
        }
    }

    @Subscribe
    public void onWidgetLoaded(WidgetLoaded event) {
        switch (event.getGroupId()) {
            case 497: {
                Widget rewardWidget = this.client.getWidget(BaWidgetInfo.BA_REWARD_TEXT.getGroupId(), BaWidgetInfo.BA_REWARD_TEXT.getChildId());
                if (rewardWidget == null) break;
                if (!rewardWidget.getText().contains(END_ROUND_REWARD_NEEDLE_TEXT)) {
                    this.onWaveEnded(false);
                    break;
                }
                if (this.round == null) break;
                this.announceRoundInfo();
                break;
            }
            case 485: {
                this.startWave(Role.ATTACKER, this.config.showRunnerTickTimerAttacker());
                break;
            }
            case 487: {
                this.startWave(Role.DEFENDER, this.config.showRunnerTickTimerDefender());
                break;
            }
            case 486: {
                this.startWave(Role.COLLECTOR, this.config.showRunnerTickTimerCollector());
                break;
            }
            case 488: {
                this.startWave(Role.HEALER, this.config.showRunnerTickTimerHealer());
                break;
            }
            case 256: {
                this.loadingPlayerRoles = true;
                break;
            }
            case 491: {
                if (!this.config.scrollConnadRewards()) break;
                this.scrollConnadRewards();
            }
        }
    }

    private void scrollConnadRewards() {
        Widget parent = this.client.getWidget(BaWidgetInfo.CONNAD_REWARDS_CONTENT.getGroupId(), BaWidgetInfo.CONNAD_REWARDS_CONTENT.getChildId());
        if (parent == null) {
            return;
        }
        this.client.runScript(new Object[]{72, BaWidgetInfo.CONNAD_REWARDS_SCROLLBAR.getId(), BaWidgetInfo.CONNAD_REWARDS_CONTENT.getId(), parent.getScrollHeight()});
    }

    @Subscribe
    public void onWidgetClosed(WidgetClosed event) {
        if (event.getGroupId() == 256) {
            this.loadingPlayerRoles = false;
        }
    }

    @Subscribe
    public void onItemContainerChanged(ItemContainerChanged event) {
        ItemContainer container = event.getItemContainer();
        if (container == this.client.getItemContainer(InventoryID.INVENTORY)) {
            Item[] inventory = event.getItemContainer().getItems();
            boolean containsRoleHorn = Arrays.stream(inventory).map(Item::getId).anyMatch(id -> id == 10516 || id == 10517 || id == 10518 || id == 10519 || id == 10520 || id == 10538 || id == 10560 || id == 10526 || id == 10527 || id == 10528 || id == 10529 || id == 10530);
            if (containsRoleHorn && !this.containsRoleHorn) {
                this.startWave(null, false);
            }
            this.containsRoleHorn = containsRoleHorn;
        }
    }

    @Subscribe
    public void onChatMessage(ChatMessage chatMessage) {
        ChatMessageType type = chatMessage.getType();
        if (type != ChatMessageType.GAMEMESSAGE && type != ChatMessageType.WELCOME) {
            return;
        }
        String message = chatMessage.getMessage();
        if (message.startsWith("---- Wave:")) {
            this.currentWave = Integer.parseInt(message.split(" ")[2]);
            if (this.round == null || this.currentWave == 1) {
                this.timer = new Timer();
                this.round = new Round(this.currentWave, this.timer);
            }
            this.wave = null;
        } else if (this.wave != null && message.contains("exploded")) {
            this.wave.setWrongEggsCount(this.wave.getWrongEggsCount() + 1);
            this.wave.setEggsCount(this.wave.getEggsCount() - 1);
        } else if (this.wave != null && this.wave.getNumber() != 10 && message.contains("You healed ")) {
            int health = Integer.parseInt(message.split(" ")[2]);
            this.wave.setHpHealed(this.wave.getHpHealed() + health);
        } else if (this.config.highlightNotification() && message.contains("the wrong type of poisoned food to use")) {
            MessageNode messageNode = chatMessage.getMessageNode();
            String nodeValue = Text.removeTags((String)messageNode.getValue());
            messageNode.setValue(ColorUtil.wrapWithColorTag((String)nodeValue, (Color)this.config.highlightNotificationColor()));
        } else if (this.wave != null && message.startsWith("All of the Penance ")) {
            MessageNode node = chatMessage.getMessageNode();
            String nodeValue = Text.removeTags((String)node.getValue());
            Color deathColor = FIGHTER_DEATH_COLOR;
            String npc = nodeValue.split(" ")[4];
            Role role = this.wave.getRole();
            switch (npc) {
                case "Fighters": {
                    this.wave.setFightersKilled(true);
                    break;
                }
                case "Rangers": {
                    this.wave.setRangersKilled(true);
                    break;
                }
                case "Healers": {
                    this.wave.setHealersKilled(true);
                    deathColor = HEALER_DEATH_COLOR;
                    break;
                }
                case "Runners": {
                    this.wave.setRunnersKilled(true);
                    deathColor = RUNNER_DEATH_COLOR;
                }
            }
            if (this.config.deathMessageColor() != null) {
                deathColor = this.config.deathMessageColor();
                if (role == Role.ATTACKER && (npc.equals("Fighters") || npc.equals("Rangers")) || role == Role.HEALER && npc.equals("Healers") || role == Role.DEFENDER && npc.equals("Runners")) {
                    nodeValue = ColorUtil.wrapWithColorTag((String)nodeValue, (Color)this.config.deathMessageColor());
                    node.setValue(nodeValue);
                }
            } else {
                nodeValue = node.getValue();
                node.setValue(nodeValue);
            }
            if (this.wave.getTimer() != null) {
                TimeUnits units = this.config.timeUnits();
                String timeFormat = units.getFormatString();
                float time = this.wave.getTimeElapsed(false, units);
                this.addDeathTimesInfoBoxes(npc, time, timeFormat);
                DeathTimesMode deathTimesMode = this.config.deathTimesMode();
                if (deathTimesMode == DeathTimesMode.CHAT || deathTimesMode == DeathTimesMode.INFOBOX_CHAT) {
                    Object timeElapsed = String.format(timeFormat, Float.valueOf(time)) + "s";
                    if (this.config.enableGameChatColors()) {
                        timeElapsed = ColorUtil.wrapWithColorTag((String)timeElapsed, (Color)deathColor);
                    }
                    node.setValue(nodeValue + " " + (String)timeElapsed);
                }
            }
        }
    }

    @Subscribe
    public void onVarbitChanged(VarbitChanged event) {
        int currentInGame = this.client.getVarbitValue(3923);
        if (this.inGameBit != currentInGame) {
            int previousInGameBit = this.inGameBit;
            this.inGameBit = currentInGame;
            if (previousInGameBit == 1) {
                DurationMode durationMode = this.config.showDurationMode();
                if ((durationMode == DurationMode.WAVE || durationMode == DurationMode.WAVE_ROUND) && this.wave != null && this.client.isInInstancedRegion()) {
                    this.announceWaveTime();
                    if (this.currentWave == 10) {
                        this.onRoundEnded();
                    }
                }
                this.stopWave();
            } else {
                this.startWave(null, false);
            }
        }
        if (this.inGameBit == 1) {
            this.updateEggsCount();
        }
        this.updateRolePoints(false);
    }

    private void updateRolePoints(boolean forceDisplay) {
        boolean shouldDisplayRolePoints = forceDisplay || this.shouldDisplayRolePoints();
        PointsCounterMode pointsCounterMode = this.config.pointsCounterMode();
        boolean diaryBonus = this.includeKandarinBonus();
        for (Role role : Role.values()) {
            int points = 0;
            if (pointsCounterMode == PointsCounterMode.CURRENT_POINTS) {
                points = role.getPoints(this.client);
            } else if (this.round != null && pointsCounterMode == PointsCounterMode.ROUND_POINTS) {
                points = this.round.getRolePoints(role);
                if (diaryBonus) {
                    points = (int)((double)points * 1.1);
                }
            } else if (this.session != null && pointsCounterMode == PointsCounterMode.SESSION_POINTS) {
                points = this.session.getRolePoints(role);
                if (diaryBonus) {
                    points = (int)((double)points * 1.1);
                }
            }
            this.rolePoints.put(role, points);
            if (!shouldDisplayRolePoints) continue;
            this.addOrUpdateRolePointsInfoBoxes(role, points);
        }
    }

    private boolean includeKandarinBonus() {
        return this.config.kandarinHardDiaryPointsBonus() == KandarinDiaryBonusMode.YES || this.config.kandarinHardDiaryPointsBonus() == KandarinDiaryBonusMode.IF_COMPLETED && this.client.getVarbitValue(4477) == 1;
    }

    @Subscribe
    public void onScriptPostFired(ScriptPostFired scriptPostFired) {
        if (scriptPostFired.getScriptId() == 420) {
            this.clientThread.invokeLater(() -> this.updateAttackStyleText(this.lastListen));
        }
    }

    @Subscribe
    public void onGameTick(GameTick event) {
        WorldPoint worldPoint;
        Player player;
        DisplayPointsLocationMode pointsLocationMode = this.config.displayPointsLocationMode();
        if ((pointsLocationMode == DisplayPointsLocationMode.OUTPOST || pointsLocationMode == DisplayPointsLocationMode.OUTPOST_INGAME) && (player = this.client.getLocalPlayer()) != null && (worldPoint = player.getWorldLocation()) != this.worldPoint) {
            this.worldPoint = worldPoint;
            if (!this.shouldDisplayRolePoints()) {
                this.hideRolePointsInfoBoxes();
            }
        }
        if (this.timer != null) {
            this.timer.onGameTick();
        }
        if (this.inGameBit == 1) {
            Role role;
            if (this.wave != null && (role = this.wave.getRole()) != null) {
                String currentListen = role.getListenText(this.client);
                if (currentListen != null && !currentListen.equals(this.lastListen)) {
                    this.clientThread.invokeLater(() -> this.updateAttackStyleText(currentListen));
                    if (this.config.announceCallCorrection()) {
                        this.checkCallCorrection(currentListen);
                    }
                }
                this.lastListen = currentListen;
                this.lastListenItemId = role.getListenItemId(this.client);
            }
            if (this.runnerTickTimer != null) {
                this.runnerTickTimer.incrementCount();
            }
        } else if (this.loadingPlayerRoles) {
            for (int i = 0; i < TEAM_PLAYERS_ROLES_WIDGETS.length; ++i) {
                Widget playerRole = this.client.getWidget(TEAM_PLAYERS_ROLES_WIDGETS[i].getGroupId(), TEAM_PLAYERS_ROLES_WIDGETS[i].getChildId());
                this.playerRoles[i] = playerRole != null ? this.getRoleForModelId(playerRole.getModelId()) : null;
            }
        }
        if (this.session != null && System.currentTimeMillis() >= this.lastWaveCompletedTimestamp + TimeUnit.MINUTES.toMillis(this.config.sessionResetTime())) {
            this.session.reset();
            this.updateRolePoints(false);
        }
    }

    private Role getRoleForModelId(int modelId) {
        for (Role role : Role.values()) {
            if (role.getRoleModelId() != modelId) continue;
            return role;
        }
        return null;
    }

    @Subscribe
    public void onGameObjectSpawned(GameObjectSpawned gameObjectSpawned) {
        GameObject gameObject = gameObjectSpawned.getGameObject();
        if (this.isHopperGameObject(gameObject.getId())) {
            this.hoppers.add(gameObject);
        }
    }

    @Subscribe
    public void onGroundObjectSpawned(GroundObjectSpawned groundObjectSpawned) {
        GroundObject groundObject = groundObjectSpawned.getGroundObject();
        if (groundObject.getId() == 20231) {
            this.brokenTraps.add(groundObject);
        }
    }

    @Subscribe
    public void onGameObjectDespawned(GameObjectDespawned gameObjectDespawned) {
        GameObject gameObject = gameObjectDespawned.getGameObject();
        if (this.isHopperGameObject(gameObject.getId())) {
            this.hoppers.remove(gameObject);
        }
    }

    @Subscribe
    public void onGroundObjectDespawned(GroundObjectDespawned groundObjectDespawned) {
        GroundObject groundObject = groundObjectDespawned.getGroundObject();
        if (groundObject.getId() == 20231) {
            this.brokenTraps.remove(groundObject);
        }
    }

    @Subscribe
    public void onItemSpawned(ItemSpawned itemSpawned) {
        Role role = this.getRole();
        if (role == null) {
            return;
        }
        TileItem item = itemSpawned.getItem();
        Tile tile = itemSpawned.getTile();
        this.addItemSpawn(item, tile, role);
    }

    @Subscribe
    public void onItemDespawned(ItemDespawned itemDespawned) {
        Role role = this.getRole();
        if (role == null) {
            return;
        }
        TileItem item = itemDespawned.getItem();
        Tile tile = itemDespawned.getTile();
        this.removeItemSpawn(item, tile, role);
    }

    @Subscribe
    public void onClientTick(ClientTick clientTick) {
        this.menuEntrySwapper.performSwaps();
    }

    public Role getRole() {
        return this.wave == null ? null : this.wave.getRole();
    }

    private void updateAttackStyleText(String listen) {
        this.restoreAttackStyleText();
        if (!this.config.highlightAttackStyle() || listen == null || this.getRole() != Role.ATTACKER) {
            return;
        }
        int var = this.client.getVarbitValue(357);
        AttackStyle[] styles = WeaponType.getWeaponType(var).getAttackStyles();
        for (int i = 0; i < styles.length; ++i) {
            AttackStyle style = styles[i];
            if (style == null || !listen.startsWith(style.getName())) continue;
            int color = Integer.decode(ColorUtil.toHexColor((Color)this.config.highlightAttackStyleColor()));
            AttackStyleWidget attackStyleWidget = AttackStyleWidget.getAttackStyles()[i];
            BaWidgetInfo attackStyleTextBaWidgetInfo = attackStyleWidget.getTextWidget();
            Widget attackStyleTextWidget = this.client.getWidget(attackStyleTextBaWidgetInfo.getGroupId(), attackStyleTextBaWidgetInfo.getChildId());
            if (attackStyleTextWidget == null) continue;
            if (this.attackStyleTextColor == null) {
                this.attackStyleTextColor = attackStyleTextWidget.getTextColor();
            }
            attackStyleTextWidget.setTextColor(color);
        }
    }

    @Subscribe
    public void onMenuEntryAdded(MenuEntryAdded event) {
        Color color;
        Role role = this.getRole();
        if (role == null) {
            return;
        }
        String listen = this.lastListen != null ? this.lastListen : "";
        MenuEntry[] menuEntries = this.client.getMenuEntries();
        MenuEntry entry = menuEntries[menuEntries.length - 1];
        String entryOption = Text.removeTags((String)entry.getOption());
        String entryTarget = Text.removeTags((String)entry.getTarget());
        MenuHighlightMode mode = this.config.menuHighlightMode();
        if (mode != MenuHighlightMode.DISABLED && role == Role.COLLECTOR && entryOption.equals("Take") && event.getType() == MENU_THIRD_OPTION && listen.startsWith(entryTarget) && (color = this.getEggColorFromName(entryTarget.split(" ")[0])) != null) {
            if (mode == MenuHighlightMode.OPTION_NAME || mode == MenuHighlightMode.OPTION) {
                entryOption = ColorUtil.prependColorTag((String)"Take", (Color)color);
                entry.setOption(entryOption);
            }
            if (mode == MenuHighlightMode.OPTION_NAME || mode == MenuHighlightMode.NAME) {
                entryTarget = ColorUtil.prependColorTag((String)entryTarget.substring(entryTarget.indexOf(62) + 1), (Color)color);
                entry.setTarget(entryTarget);
            }
        }
        this.client.setMenuEntries(menuEntries);
    }

    public Color getColorForInventoryItemId(int itemId) {
        switch (itemId) {
            case 22227: 
            case 22228: 
            case 22229: 
            case 22230: {
                return this.config.highlightArrowColor();
            }
            case 10539: 
            case 10540: 
            case 10541: {
                return this.config.highlightPoisonColor();
            }
            case 10513: 
            case 10514: 
            case 10515: {
                return this.config.highlightBaitColor();
            }
        }
        return null;
    }

    public Color getColorForGroundItemId(int itemId) {
        switch (itemId) {
            case 10531: {
                return Color.GREEN;
            }
            case 10532: {
                return LIGHT_RED;
            }
            case 10533: {
                return LIGHT_BLUE;
            }
            case 10534: {
                return Color.YELLOW;
            }
            case 10513: 
            case 10514: 
            case 10515: {
                return this.config.highlightGroundBaitColor();
            }
            case 1511: 
            case 2347: {
                return this.config.highlightGroundLogsHammerColor();
            }
        }
        return null;
    }

    private void restoreAttackStyleText() {
        if (this.client.getGameState() != GameState.LOGGED_IN) {
            return;
        }
        int color = this.attackStyleTextColor != null ? this.attackStyleTextColor : 16750623;
        int var = this.client.getVarbitValue(357);
        AttackStyle[] styles = WeaponType.getWeaponType(var).getAttackStyles();
        for (int i = 0; i < styles.length; ++i) {
            AttackStyleWidget attackStyleWidget;
            BaWidgetInfo attackStyleTextBaWidgetInfo;
            Widget attackStyleTextWidget;
            AttackStyle style = styles[i];
            if (style == AttackStyle.CASTING || style == AttackStyle.DEFENSIVE_CASTING || (attackStyleTextWidget = this.client.getWidget((attackStyleTextBaWidgetInfo = (attackStyleWidget = AttackStyleWidget.getAttackStyles()[i]).getTextWidget()).getGroupId(), attackStyleTextBaWidgetInfo.getChildId())) == null) continue;
            attackStyleTextWidget.setTextColor(color);
        }
        this.attackStyleTextColor = null;
    }

    private void onWaveEnded(boolean roundEnded) {
        Wave wave = this.wave;
        if (wave == null) {
            wave = new Wave(this.client, this.currentWave);
        }
        wave.setPoints(roundEnded);
        if (!roundEnded) {
            wave.setAmounts();
            BaWidgetInfo pointsBaWidgetInfo = BaWidgetInfo.BA_REWARD_TEXT;
            Widget pointsWidget = this.client.getWidget(pointsBaWidgetInfo.getGroupId(), pointsBaWidgetInfo.getChildId());
            if (pointsWidget != null) {
                RewardsBreakdownMode rewardsBreakdownMode;
                boolean colorful = this.config.enableGameChatColors();
                PointsMode pointsMode = this.config.showRewardPointsMode();
                if (pointsMode == PointsMode.WAVE || pointsMode == PointsMode.WAVE_ROUND) {
                    ChatMessageBuilder wavePoints = wave.getWavePoints(colorful, this.includeKandarinBonus());
                    this.announce(wavePoints);
                }
                if ((rewardsBreakdownMode = this.config.showRewardsBreakdownMode()) == RewardsBreakdownMode.WAVE || rewardsBreakdownMode == RewardsBreakdownMode.WAVE_ROUND) {
                    ChatMessageBuilder waveSummary = wave.getWaveSummary(colorful);
                    this.announce(waveSummary);
                }
            }
        }
        if (this.round != null) {
            this.round.addWave(wave, this.config.rolePointsTrackingMode());
        }
        if (this.session == null) {
            this.session = new Session();
        }
        this.session.addWave(wave, this.config.rolePointsTrackingMode());
        PointsCounterMode pointsCounterMode = this.config.pointsCounterMode();
        if (pointsCounterMode == PointsCounterMode.ROUND_POINTS || pointsCounterMode == PointsCounterMode.SESSION_POINTS) {
            this.updateRolePoints(false);
        }
        this.wave = null;
        this.currentWave = 0;
        this.lastWaveCompletedTimestamp = System.currentTimeMillis();
    }

    private void onRoundEnded() {
        if (this.round == null) {
            return;
        }
        this.onWaveEnded(true);
        if (this.timer != null) {
            this.timer.setRoundEnded();
        }
    }

    private void startWave(Role role, boolean displayTickTimer) {
        if (this.wave != null) {
            if (this.wave.getRole() == null && role != null) {
                this.wave.setRole(role);
                this.setCallFlashColor(this.wave, this.config.callChangeFlashColor());
                if (role == Role.HEALER) {
                    this.setHealerTeammatesHealthDisplay();
                }
                this.runnerTickTimer.setDisplaying(displayTickTimer);
                this.clientThread.invokeLater(() -> this.setWaveWidgets(this.wave));
            }
            return;
        }
        if (this.timer == null) {
            this.timer = new Timer();
        }
        log.debug("Starting wave {} with roles 1={} 2={} 3={} 4={} 5={} at {}", new Object[]{this.currentWave, this.playerRoles[0], this.playerRoles[1], this.playerRoles[2], this.playerRoles[3], this.playerRoles[4], this.timer.getRoundTimeFormatted(this.config.timeUnits())});
        this.timer.setWaveStartTime();
        this.wave = new Wave(this.client, this.currentWave, this.playerRoles, this.timer);
        this.wave.setRole(role);
        this.runnerTickTimer = new RunnerTickTimer();
        this.runnerTickTimer.setDisplaying(displayTickTimer);
        this.correctedCallCount = 0;
        if (role != null) {
            this.setCallFlashColor(this.wave, this.config.callChangeFlashColor());
            if (role == Role.HEALER) {
                this.setHealerTeammatesHealthDisplay();
            }
            this.clientThread.invokeLater(() -> this.setWaveWidgets(this.wave));
        }
    }

    private void setWaveWidgets(Wave wave) {
        Widget roleSprite;
        Widget roleText;
        boolean showingCounter;
        if (wave == null) {
            return;
        }
        Role role = wave.getRole();
        if (role == null) {
            return;
        }
        Widget waveInfoWidget = this.client.getWidget(role.getWaveInfo().getGroupId(), role.getWaveInfo().getChildId());
        if (waveInfoWidget == null) {
            return;
        }
        Widget waveTextWidget = this.client.getWidget(role.getWaveText().getGroupId(), role.getWaveText().getChildId());
        if (waveTextWidget == null) {
            return;
        }
        waveInfoWidget.setOriginalHeight(130);
        waveInfoWidget.revalidate();
        boolean bl = showingCounter = role == Role.HEALER && this.config.showHpCountOverlay() || role == Role.COLLECTOR && this.config.showEggCountOverlay();
        if (showingCounter) {
            Widget roleCounterIcon;
            Widget roleCounter = waveInfoWidget.createChild(0, 4);
            roleCounter.setFontId(waveTextWidget.getFontId());
            roleCounter.setTextColor(waveTextWidget.getTextColor());
            roleCounter.setTextShadowed(true);
            roleCounter.setOriginalX(24);
            roleCounter.setOriginalY(this.config.hideTeammateRole() ? 57 : 78);
            roleCounter.setOriginalHeight(32);
            roleCounter.setOriginalWidth(75);
            roleCounter.setXTextAlignment(2);
            roleCounter.setXPositionMode(2);
            roleCounter.setYPositionMode(0);
            roleCounter.setClickMask(112640);
            roleCounter.setNoClickThrough(false);
            roleCounter.revalidate();
            if (role == Role.HEALER) {
                roleCounterIcon = waveInfoWidget.createChild(1, 5);
                roleCounterIcon.setSpriteId(562);
                roleCounterIcon.setOriginalHeight(17);
                roleCounterIcon.setOriginalWidth(17);
            } else {
                roleCounterIcon = waveInfoWidget.createChild(1, 6);
                roleCounterIcon.setModelId(20563);
                roleCounterIcon.setModelType(1);
                roleCounterIcon.setModelZoom(4112);
                roleCounterIcon.setRotationX(510);
                roleCounterIcon.setRotationZ(2014);
                roleCounterIcon.setOriginalHeight(16);
                roleCounterIcon.setOriginalWidth(16);
            }
            roleCounterIcon.setOriginalX(380);
            roleCounterIcon.setOriginalY(this.config.hideTeammateRole() ? 64 : 87);
            roleCounterIcon.setClickMask(112640);
            roleCounterIcon.setNoClickThrough(false);
            roleCounterIcon.revalidate();
        }
        if (this.config.showCallChangeTimer()) {
            if (showingCounter) {
                this.setCallTimerWidget(waveInfoWidget, waveTextWidget, this.config.hideTeammateRole() ? 80 : 100, this.config.hideTeammateRole() ? 89 : 109);
            } else if (role == Role.ATTACKER) {
                this.setCallTimerWidget(waveInfoWidget, waveTextWidget, this.config.hideTeammateRole() ? 67 : 87, this.config.hideTeammateRole() ? 76 : 96);
            } else {
                this.setCallTimerWidget(waveInfoWidget, waveTextWidget, this.config.hideTeammateRole() ? 58 : 78, this.config.hideTeammateRole() ? 67 : 87);
            }
        }
        if ((roleText = this.client.getWidget(role.getRoleText().getGroupId(), role.getRoleText().getChildId())) != null) {
            roleText.setHidden(this.config.hideTeammateRole());
        }
        if ((roleSprite = this.client.getWidget(role.getRoleSprite().getGroupId(), role.getRoleSprite().getChildId())) != null) {
            roleSprite.setHidden(this.config.hideTeammateRole());
        }
    }

    private void setCallTimerWidget(Widget waveInfoWidget, Widget waveTextWidget, int textOriginalY, int iconOriginalY) {
        Widget callTimer = waveInfoWidget.createChild(2, 4);
        callTimer.setFontId(waveTextWidget.getFontId());
        callTimer.setTextColor(waveTextWidget.getTextColor());
        callTimer.setTextShadowed(true);
        callTimer.setOriginalX(24);
        callTimer.setOriginalY(textOriginalY);
        callTimer.setOriginalHeight(32);
        callTimer.setOriginalWidth(75);
        callTimer.setXTextAlignment(2);
        callTimer.setXPositionMode(2);
        callTimer.setYPositionMode(0);
        callTimer.setText("- - -");
        callTimer.setClickMask(112640);
        callTimer.setNoClickThrough(false);
        callTimer.revalidate();
        Widget callTimerIcon = waveInfoWidget.createChild(3, 5);
        callTimerIcon.setSpriteId(this.getRole().getHornSpriteId());
        callTimerIcon.setOriginalX(380);
        callTimerIcon.setOriginalY(iconOriginalY);
        callTimerIcon.setOriginalHeight(13);
        callTimerIcon.setOriginalWidth(17);
        callTimerIcon.setClickMask(112640);
        callTimerIcon.setNoClickThrough(false);
        callTimerIcon.revalidate();
    }

    private void removeWaveWidgets(Wave wave) {
        if (wave == null) {
            return;
        }
        Role role = wave.getRole();
        if (role == null) {
            return;
        }
        Widget waveInfoWidget = this.client.getWidget(role.getWaveInfo().getGroupId(), role.getWaveInfo().getChildId());
        if (waveInfoWidget == null) {
            return;
        }
        Widget[] children = waveInfoWidget.getChildren();
        if (children == null) {
            return;
        }
        if (children.length > 0 && children[0] != null) {
            children[0].setHidden(true);
            children[0] = null;
        }
        if (children.length > 1 && children[1] != null) {
            children[1].setHidden(true);
            children[1] = null;
        }
        if (children.length > 2 && children[2] != null) {
            children[2].setHidden(true);
            children[2] = null;
        }
        if (children.length > 3 && children[3] != null) {
            children[3].setHidden(true);
            children[3] = null;
        }
    }

    private void setCallFlashColor(Wave wave, Color flashColor) {
        if (wave == null) {
            return;
        }
        Role role = wave.getRole();
        if (role == null) {
            return;
        }
        Widget callFlashWidget = this.client.getWidget(role.getCallFlash().getGroupId(), role.getCallFlash().getChildId());
        if (callFlashWidget != null) {
            int color = Integer.decode(ColorUtil.toHexColor((Color)new Color(flashColor.getRed(), flashColor.getGreen(), flashColor.getBlue())));
            callFlashWidget.setTextColor(color);
            callFlashWidget.setOpacity(255 - flashColor.getAlpha());
        }
    }

    private void removeCallChangeTimer(Wave wave) {
        if (wave == null) {
            return;
        }
        Role role = wave.getRole();
        if (role == null) {
            return;
        }
        Widget waveInfoWidget = this.client.getWidget(role.getWaveInfo().getGroupId(), role.getWaveInfo().getChildId());
        if (waveInfoWidget == null) {
            return;
        }
        Widget[] children = waveInfoWidget.getChildren();
        if (children != null && children.length >= 4) {
            if (children[2] != null) {
                children[2].setHidden(true);
                children[2] = null;
            }
            if (children[3] != null) {
                children[3].setHidden(true);
                children[3] = null;
            }
        }
    }

    private void restoreWaveWidget(Wave wave, boolean restoreIcon) {
        if (wave == null) {
            return;
        }
        Role role = wave.getRole();
        if (role == null) {
            return;
        }
        BaWidgetInfo waveInfo = role.getWaveText();
        Widget waveText = this.client.getWidget(waveInfo.getGroupId(), waveInfo.getChildId());
        if (waveText != null) {
            waveText.setText("Wave " + wave.getNumber());
        }
        if (restoreIcon) {
            this.restoreWaveIcon(wave);
        }
    }

    private void restoreWaveIcon(Wave wave) {
        if (wave == null) {
            return;
        }
        Role role = wave.getRole();
        if (role == null) {
            return;
        }
        Widget waveSprite = this.client.getWidget(role.getWaveSprite().getGroupId(), role.getWaveSprite().getChildId());
        if (waveSprite != null) {
            waveSprite.setSpriteId(765);
            waveSprite.setOriginalWidth(17);
            waveSprite.setOriginalX(3);
        }
    }

    private void stopWave() {
        this.hoppers.clear();
        this.brokenTraps.clear();
        this.cannonEggs.clear();
        this.groundEggs.clear();
        this.groundBait.clear();
        this.groundLogsHammer.clear();
        this.disableRunnerTickTimer(true);
        this.removeDeathTimesInfoBoxes();
        this.lastListen = null;
        this.lastListenItemId = 0;
        this.clientThread.invokeLater(this::restoreAttackStyleText);
    }

    private void announceWaveTime() {
        if (this.wave == null || this.wave.getTimer() == null) {
            return;
        }
        String time = this.wave.getTimer().getWaveTimeFormatted(this.config.timeUnits());
        int number = this.wave.getNumber();
        StringBuilder message = new StringBuilder();
        message.append("Wave ");
        if (number > 0) {
            message.append(number).append(" ");
        }
        message.append("duration: ");
        this.announceTime(message.toString(), time);
    }

    private void announceRoundInfo() {
        if (this.round == null) {
            return;
        }
        DurationMode durationMode = this.config.showDurationMode();
        if (durationMode == DurationMode.ROUND || durationMode == DurationMode.WAVE_ROUND) {
            this.announceRoundTime();
        }
        if (this.round.isComplete()) {
            RewardsBreakdownMode rewardsBreakdownMode;
            boolean colorful = this.config.enableGameChatColors();
            PointsMode pointsMode = this.config.showRewardPointsMode();
            if (pointsMode == PointsMode.ROUND || pointsMode == PointsMode.WAVE_ROUND) {
                ChatMessageBuilder roundPoints = this.round.getRoundPointsMessage(colorful, this.includeKandarinBonus());
                this.announce(roundPoints);
            }
            if ((rewardsBreakdownMode = this.config.showRewardsBreakdownMode()) == RewardsBreakdownMode.ROUND || rewardsBreakdownMode == RewardsBreakdownMode.WAVE_ROUND) {
                ChatMessageBuilder roundSummary = this.round.getRoundSummaryMessage(colorful);
                this.announce(roundSummary);
            }
        }
        this.timer = null;
    }

    private void announceRoundTime() {
        if (this.round == null || this.round.getTimer() == null) {
            return;
        }
        String time = this.round.getTimer().getRoundTimeFormatted(this.config.timeUnits());
        int fromWave = this.round.getStartingWave();
        StringBuilder message = new StringBuilder();
        if (fromWave == 1) {
            message.append("Round duration: ");
        } else {
            message.append("Round duration from wave ").append(fromWave).append(": ");
        }
        this.announceTime(message.toString(), time);
    }

    private void announceTime(String preText, String time) {
        ChatMessageBuilder chatMessageBuilder = new ChatMessageBuilder().append(ChatColorType.NORMAL).append(preText);
        if (this.config.enableGameChatColors()) {
            chatMessageBuilder.append(ChatColorType.HIGHLIGHT);
        }
        chatMessageBuilder = chatMessageBuilder.append(time);
        this.announce(chatMessageBuilder);
    }

    private void announce(ChatMessageBuilder chatMessage) {
        this.chatMessageManager.queue(QueuedMessage.builder().type(ChatMessageType.CONSOLE).runeLiteFormattedMessage(chatMessage.build()).build());
    }

    private Color getEggColorFromName(String eggName) {
        switch (eggName.toLowerCase()) {
            case "green": {
                return Color.GREEN;
            }
            case "red": {
                return LIGHT_RED;
            }
            case "blue": {
                return LIGHT_BLUE;
            }
        }
        return null;
    }

    private void updateEggsCount() {
        for (CollectorEgg collectorEgg : CollectorEgg.values()) {
            int eggsCount = this.client.getVarbitValue(collectorEgg.getVarbits().getId());
            if (eggsCount < 1) {
                this.cannonEggs.remove((Object)collectorEgg);
                continue;
            }
            this.cannonEggs.put(collectorEgg, eggsCount);
        }
    }

    private void addItemSpawn(TileItem item, Tile tile, Role role) {
        GroundItem.Key Key2 = new GroundItem.Key(item.getId(), tile.getWorldLocation());
        GroundItem groundItem = this.buildGroundItem(tile, item);
        switch (role) {
            case COLLECTOR: {
                if (!this.isEggItem(item.getId())) break;
                this.addEggSpawn(Key2, groundItem);
                break;
            }
            case DEFENDER: {
                if (this.isBaitItem(item.getId())) {
                    this.addDefenderBaitSpawn(Key2, groundItem);
                    break;
                }
                if (!this.isLogsOrHammerItem(item.getId())) break;
                this.addLogsHammerSpawn(Key2, groundItem);
            }
        }
    }

    private void removeItemSpawn(TileItem item, Tile tile, Role role) {
        switch (role) {
            case COLLECTOR: {
                if (!this.isEggItem(item.getId())) break;
                this.removeEggSpawn(item, tile);
                break;
            }
            case DEFENDER: {
                if (this.isBaitItem(item.getId())) {
                    this.removeBaitSpawn(item, tile);
                    break;
                }
                if (!this.isLogsOrHammerItem(item.getId())) break;
                this.removeLogsHammerSpawn(item, tile);
            }
        }
    }

    private void addEggSpawn(GroundItem.Key Key2, GroundItem groundItem) {
        this.addItemSpawn(Key2, groundItem, this.groundEggs);
    }

    private void addDefenderBaitSpawn(GroundItem.Key Key2, GroundItem groundItem) {
        this.addItemSpawn(Key2, groundItem, this.groundBait);
    }

    private void addLogsHammerSpawn(GroundItem.Key Key2, GroundItem groundItem) {
        this.addItemSpawn(Key2, groundItem, this.groundLogsHammer);
    }

    private void addItemSpawn(GroundItem.Key Key2, GroundItem groundItem, Map<GroundItem.Key, GroundItem> spawnItems) {
        GroundItem existing = spawnItems.putIfAbsent(Key2, groundItem);
        if (existing != null) {
            existing.setQuantity(existing.getQuantity() + groundItem.getQuantity());
        }
    }

    private GroundItem buildGroundItem(Tile tile, TileItem item) {
        int itemId = item.getId();
        ItemComposition itemComposition = this.itemManager.getItemComposition(itemId);
        int realItemId = itemComposition.getNote() != -1 ? itemComposition.getLinkedNoteId() : itemId;
        return GroundItem.builder().id(itemId).location(tile.getWorldLocation()).itemId(realItemId).quantity(item.getQuantity()).name(itemComposition.getName()).height(tile.getItemLayer().getHeight()).spawnTime(Instant.now()).build();
    }

    private void removeEggSpawn(TileItem item, Tile tile) {
        GroundItem.Key Key2 = new GroundItem.Key(item.getId(), tile.getWorldLocation());
        GroundItem groundItem = this.removeItemSpawn(item, Key2, this.groundEggs);
        if (groundItem == null) {
            return;
        }
        Player player = this.client.getLocalPlayer();
        if (player == null) {
            return;
        }
        Instant spawnTime = groundItem.getSpawnTime();
        Instant now = Instant.now();
        if (this.wave != null && this.wave.getNumber() != 10 && (spawnTime == null || now.isBefore(spawnTime.plus(Duration.ofMinutes(2L)))) && groundItem.getLocation().equals((Object)player.getWorldLocation())) {
            this.wave.setEggsCount(this.wave.getEggsCount() + 1);
        }
    }

    private void removeBaitSpawn(TileItem item, Tile tile) {
        GroundItem.Key Key2 = new GroundItem.Key(item.getId(), tile.getWorldLocation());
        this.removeItemSpawn(item, Key2, this.groundBait);
    }

    private void removeLogsHammerSpawn(TileItem item, Tile tile) {
        GroundItem.Key Key2 = new GroundItem.Key(item.getId(), tile.getWorldLocation());
        this.removeItemSpawn(item, Key2, this.groundLogsHammer);
    }

    private GroundItem removeItemSpawn(TileItem item, GroundItem.Key Key2, Map<GroundItem.Key, GroundItem> spawnItems) {
        GroundItem groundItem = spawnItems.get(Key2);
        if (groundItem == null) {
            return null;
        }
        if (groundItem.getQuantity() <= item.getQuantity()) {
            spawnItems.remove(Key2);
        } else {
            groundItem.setQuantity(groundItem.getQuantity() - item.getQuantity());
            groundItem.setSpawnTime(null);
        }
        return groundItem;
    }

    private boolean isEggItem(int itemId) {
        return itemId == 10532 || itemId == 10531 || itemId == 10533 || itemId == 10534;
    }

    private boolean isBaitItem(int itemId) {
        return itemId == 10514 || itemId == 10515 || itemId == 10513;
    }

    private boolean isLogsOrHammerItem(int itemId) {
        return itemId == 1511 || itemId == 2347;
    }

    private boolean isHopperGameObject(int gameObjectId) {
        return gameObjectId == 20264 || gameObjectId == 20265 || gameObjectId == 20266 || gameObjectId == 20267;
    }

    private void enableRunnerTickTimer(boolean display) {
        if (this.runnerTickTimer == null) {
            this.runnerTickTimer = new RunnerTickTimer();
        }
        this.runnerTickTimer.setDisplaying(display);
    }

    private void disableRunnerTickTimer(boolean remove) {
        if (this.runnerTickTimer != null) {
            this.runnerTickTimer.setDisplaying(false);
        }
        if (remove) {
            this.runnerTickTimer = null;
        }
    }

    private void showDeathTimes() {
        List infoBoxes = this.infoBoxManager.getInfoBoxes();
        for (InfoBox infoBox : this.deathTimesInfoBoxes) {
            if (infoBoxes.contains(infoBox)) continue;
            this.infoBoxManager.addInfoBox(infoBox);
        }
    }

    private void showRolePoints() {
        List infoBoxes = this.infoBoxManager.getInfoBoxes();
        for (InfoBox infoBox : this.rolePointsInfoBoxes.values()) {
            if (infoBoxes.contains(infoBox)) continue;
            this.infoBoxManager.addInfoBox(infoBox);
        }
    }

    private void hideDeathTimesInfoBoxes() {
        for (InfoBox infoBox : this.deathTimesInfoBoxes) {
            this.infoBoxManager.removeInfoBox(infoBox);
        }
    }

    private void hideRolePointsInfoBoxes() {
        for (InfoBox infoBox : this.rolePointsInfoBoxes.values()) {
            this.infoBoxManager.removeInfoBox(infoBox);
        }
    }

    private void hideRolePointsInfoBox(Role role) {
        this.infoBoxManager.removeInfoBox((InfoBox)this.rolePointsInfoBoxes.get((Object)role));
    }

    private void addDeathTimesInfoBoxes(String npc, float time, String format) {
        BufferedImage image = this.images.get(npc.toLowerCase());
        DeathTimeInfoBox infoBox = new DeathTimeInfoBox(image, this, time, format);
        this.deathTimesInfoBoxes.add(infoBox);
        DeathTimesMode deathTimesMode = this.config.deathTimesMode();
        if (deathTimesMode == DeathTimesMode.INFO_BOX || deathTimesMode == DeathTimesMode.INFOBOX_CHAT) {
            this.infoBoxManager.addInfoBox((InfoBox)infoBox);
        }
    }

    private void addOrUpdateRolePointsInfoBoxes(Role role, int points) {
        DisplayPointsMode displayPointsMode = this.config.displayPointsMode();
        RolePointsTrackingMode rolePointsTrackingMode = this.config.rolePointsTrackingMode();
        if (displayPointsMode != DisplayPointsMode.INFO_BOX || rolePointsTrackingMode == RolePointsTrackingMode.ATTACKER && role != Role.ATTACKER || rolePointsTrackingMode == RolePointsTrackingMode.DEFENDER && role != Role.DEFENDER || rolePointsTrackingMode == RolePointsTrackingMode.HEALER && role != Role.HEALER || rolePointsTrackingMode == RolePointsTrackingMode.COLLECTOR && role != Role.COLLECTOR) {
            this.hideRolePointsInfoBox(role);
        } else {
            RolePointsInfoBox previousInfoBox = this.rolePointsInfoBoxes.get((Object)role);
            if (previousInfoBox != null) {
                previousInfoBox.setPoints(points);
                if (!this.infoBoxManager.getInfoBoxes().contains((Object)previousInfoBox)) {
                    this.infoBoxManager.addInfoBox((InfoBox)previousInfoBox);
                }
            } else {
                RolePointsInfoBox infoBox = new RolePointsInfoBox(this.images.get(role.getName().toLowerCase(Locale.ROOT)), this, points);
                this.rolePointsInfoBoxes.put(role, infoBox);
                this.infoBoxManager.addInfoBox((InfoBox)infoBox);
            }
        }
    }

    private void removeDeathTimesInfoBoxes() {
        this.hideDeathTimesInfoBoxes();
        this.deathTimesInfoBoxes.clear();
    }

    private void removeRolePointsInfoBoxes() {
        this.hideRolePointsInfoBoxes();
        this.rolePointsInfoBoxes.clear();
    }

    private void setGroundItemsPluginLists() {
        String highlightedItems = Optional.ofNullable(this.configManager.getConfiguration(GROUND_ITEMS_CONFIG_GROUP, GROUND_ITEMS_CONFIG_HIGHLIGHTED_ITENS)).orElse("");
        List highlightedItemsList = Arrays.stream(highlightedItems.split(",")).map(i -> i.trim().toLowerCase()).collect(Collectors.toList());
        String hiddenItems = Optional.ofNullable(this.configManager.getConfiguration(GROUND_ITEMS_CONFIG_GROUP, GROUND_ITEMS_CONFIG_HIDDEN_ITENS)).orElse("");
        List hiddenItemsList = Arrays.stream(hiddenItems.split(",")).map(i -> i.trim().toLowerCase()).collect(Collectors.toList());
        StringBuilder highlightedItemsListBuilder = new StringBuilder();
        StringBuilder hiddenItemsListBuilder = new StringBuilder();
        for (String item : GROUND_ITEMS_HIDDEN_LIST) {
            if (highlightedItemsList.contains(item.toLowerCase())) {
                if (highlightedItemsListBuilder.length() > 0) {
                    highlightedItemsListBuilder.append(",");
                }
                highlightedItemsListBuilder.append(item);
                highlightedItems = highlightedItems.replaceAll("\\s*,*\\s*(?i)" + Pattern.quote(item) + "\\s*,*\\s*", ",");
                if (highlightedItems.startsWith(",")) {
                    highlightedItems = highlightedItems.substring(1);
                }
                if (highlightedItems.endsWith(",")) {
                    highlightedItems = highlightedItems.substring(0, highlightedItems.length() - 1);
                }
            }
            if (hiddenItemsList.contains(item.toLowerCase())) continue;
            if (hiddenItemsListBuilder.length() > 0) {
                hiddenItemsListBuilder.append(",");
            }
            hiddenItemsListBuilder.append(item);
        }
        StringBuilder hiddenItemsBuilder = new StringBuilder(hiddenItems);
        if (hiddenItemsListBuilder.length() > 0 && !hiddenItems.endsWith(",")) {
            hiddenItemsBuilder.append(",");
        }
        hiddenItemsBuilder.append((CharSequence)hiddenItemsListBuilder);
        this.config.setGroundItemsPluginHighlightedList(highlightedItemsListBuilder.toString());
        this.config.setGroundItemsPluginHiddenList(hiddenItemsListBuilder.toString());
        this.configManager.setConfiguration(GROUND_ITEMS_CONFIG_GROUP, GROUND_ITEMS_CONFIG_HIGHLIGHTED_ITENS, highlightedItems);
        this.configManager.setConfiguration(GROUND_ITEMS_CONFIG_GROUP, GROUND_ITEMS_CONFIG_HIDDEN_ITENS, hiddenItemsBuilder.toString());
    }

    private void restoreGroundItemsPluginLists() {
        String[] list;
        String highlightedItems = Optional.ofNullable(this.configManager.getConfiguration(GROUND_ITEMS_CONFIG_GROUP, GROUND_ITEMS_CONFIG_HIGHLIGHTED_ITENS)).orElse("");
        StringBuilder highlightedItemsBuilder = new StringBuilder(highlightedItems);
        String[] highlightedItemsArray = this.config.getGroundItemsPluginHighlightedList().split(",");
        List highlightedItemsList = Arrays.stream(highlightedItems.split(",")).map(i -> i.trim().toLowerCase()).collect(Collectors.toList());
        for (String s : highlightedItemsArray) {
            String item = s.trim();
            if (highlightedItemsList.contains(item.toLowerCase())) continue;
            if (!highlightedItems.isEmpty() && !highlightedItems.endsWith(",")) {
                highlightedItemsBuilder.append(",");
            }
            highlightedItemsBuilder.append(item);
        }
        this.configManager.setConfiguration(GROUND_ITEMS_CONFIG_GROUP, GROUND_ITEMS_CONFIG_HIGHLIGHTED_ITENS, highlightedItemsBuilder.toString());
        this.config.setGroundItemsPluginHighlightedList("");
        String hiddenItems = this.configManager.getConfiguration(GROUND_ITEMS_CONFIG_GROUP, GROUND_ITEMS_CONFIG_HIDDEN_ITENS);
        for (String item : list = this.config.getGroundItemsPluginHiddenList().split(",")) {
            if ((item = item.trim()).length() <= 0 || !StringUtils.containsIgnoreCase((CharSequence)hiddenItems, (CharSequence)item)) continue;
            if ((hiddenItems = hiddenItems.replaceAll("\\s*,*\\s*(?i)" + Pattern.quote(item) + "\\s*,*\\s*", ",")).startsWith(",")) {
                hiddenItems = hiddenItems.substring(1);
            }
            if (!hiddenItems.endsWith(",")) continue;
            hiddenItems = hiddenItems.substring(0, hiddenItems.length() - 1);
        }
        this.configManager.setConfiguration(GROUND_ITEMS_CONFIG_GROUP, GROUND_ITEMS_CONFIG_HIDDEN_ITENS, hiddenItems);
        this.config.setGroundItemsPluginHiddenList("");
    }

    private void disableBarbarianAssaultPluginFeatures() {
        StringBuilder configsBuilder = new StringBuilder();
        for (String config : BARBARIAN_ASSAULT_CONFIGS) {
            String value = this.configManager.getConfiguration(BARBARIAN_ASSAULT_CONFIG_GROUP, config);
            if (configsBuilder.length() > 0) {
                configsBuilder.append(",");
            }
            configsBuilder.append(config).append("=").append(value);
            this.configManager.setConfiguration(BARBARIAN_ASSAULT_CONFIG_GROUP, config, (Object)false);
        }
        if (this.config.getBarbarianAssaultConfigs().length() == 0) {
            this.config.setBarbarianAssaultConfigs(configsBuilder.toString());
        }
    }

    private void restoreBarbarianAssaultPluginFeatures() {
        String[] configs;
        for (String config : configs = this.config.getBarbarianAssaultConfigs().split(",")) {
            String[] keyValue = config.split("=");
            if (keyValue.length != 2) continue;
            String key = keyValue[0];
            String value = keyValue[1];
            this.configManager.setConfiguration(BARBARIAN_ASSAULT_CONFIG_GROUP, key, value);
        }
        this.config.setBarbarianAssaultConfigs("");
    }

    public boolean isDisplayingHealerTeammatesHealth() {
        return !this.config.hideHealerTeammatesHealth() || this.teammatesHealthHotkeyPressed;
    }

    private void setHealerTeammatesHealthDisplay() {
        Widget teammatesHealth = this.client.getWidget(BaWidgetInfo.BA_HEAL_TEAMMATES.getGroupId(), BaWidgetInfo.BA_HEAL_TEAMMATES.getChildId());
        if (teammatesHealth == null) {
            return;
        }
        if (this.config.hideHealerTeammatesHealth()) {
            teammatesHealth.setHidden(!this.teammatesHealthHotkeyPressed);
        } else {
            teammatesHealth.setHidden(false);
        }
    }

    private void restoreHealerTeammatesHealth() {
        Widget teammatesHealth = this.client.getWidget(BaWidgetInfo.BA_HEAL_TEAMMATES.getGroupId(), BaWidgetInfo.BA_HEAL_TEAMMATES.getChildId());
        if (teammatesHealth != null) {
            teammatesHealth.setHidden(false);
        }
    }

    void onTeammatesHealthHotkeyChanged(boolean pressed) {
        this.teammatesHealthHotkeyPressed = pressed;
        if (this.wave != null && this.wave.getRole() == Role.HEALER) {
            this.setHealerTeammatesHealthDisplay();
        }
    }

    public boolean shouldDisplayRolePoints() {
        DisplayPointsLocationMode locationMode = this.config.displayPointsLocationMode();
        if (locationMode == DisplayPointsLocationMode.ALWAYS) {
            return true;
        }
        if (locationMode == DisplayPointsLocationMode.NEVER) {
            return false;
        }
        if (locationMode == DisplayPointsLocationMode.OUTPOST || locationMode == DisplayPointsLocationMode.OUTPOST_INGAME) {
            if (locationMode == DisplayPointsLocationMode.OUTPOST_INGAME && this.inGameBit == 1) {
                return true;
            }
            if (this.worldPoint == null) {
                return false;
            }
            int regionId = this.worldPoint.getRegionID();
            int x = this.worldPoint.getX();
            int y = this.worldPoint.getY();
            return regionId == 10322 || x >= 2522 && x <= 2538 && y >= 3560 && y <= 3579;
        }
        return false;
    }

    private void checkCallCorrection(String currentListen) {
        int maxCorrections = 3;
        if (this.lastListen == null || currentListen == null) {
            return;
        }
        if (currentListen.startsWith("-")) {
            this.correctedCallCount = 0;
        } else if (!this.lastListen.startsWith("-") && !currentListen.startsWith("-")) {
            if (++this.correctedCallCount > 3) {
                return;
            }
            if (this.lastListen.equalsIgnoreCase("Poison Worms") && currentListen.equalsIgnoreCase("Pois. Worms") || this.lastListen.equalsIgnoreCase("Pois. Worms") && currentListen.equalsIgnoreCase("Poison Worms") || this.lastListen.equalsIgnoreCase("Poison Tofu") && currentListen.equalsIgnoreCase("Pois. Tofu") || this.lastListen.equalsIgnoreCase("Pois. Tofu") && currentListen.equalsIgnoreCase("Poison Tofu") || this.lastListen.equalsIgnoreCase("Poison Meat") && currentListen.equalsIgnoreCase("Pois. Meat") || this.lastListen.equalsIgnoreCase("Pois. Meat") && currentListen.equalsIgnoreCase("Poison Meat")) {
                return;
            }
            ChatMessageBuilder message = new ChatMessageBuilder().append("Call correction: ");
            if (this.config.enableGameChatColors()) {
                message = message.append(ChatColorType.HIGHLIGHT);
            }
            message.append(currentListen);
            this.announce(message);
        }
    }

    private void resetRolePoints() {
        PointsCounterMode pointsCounterMode;
        if (this.round != null) {
            this.round.resetRolePoints();
        }
        if (this.session != null) {
            this.session.resetRolePoints();
        }
        if ((pointsCounterMode = this.config.pointsCounterMode()) != PointsCounterMode.CURRENT_POINTS) {
            this.clientThread.invokeLater(() -> this.updateRolePoints(false));
        }
    }

    public List<GameObject> getHoppers() {
        return this.hoppers;
    }

    public List<GroundObject> getBrokenTraps() {
        return this.brokenTraps;
    }

    public Map<CollectorEgg, Integer> getCannonEggs() {
        return this.cannonEggs;
    }

    public Map<GroundItem.Key, GroundItem> getGroundEggs() {
        return this.groundEggs;
    }

    public Map<GroundItem.Key, GroundItem> getGroundBait() {
        return this.groundBait;
    }

    public Map<GroundItem.Key, GroundItem> getGroundLogsHammer() {
        return this.groundLogsHammer;
    }

    public Map<Role, Integer> getRolePoints() {
        return this.rolePoints;
    }

    public RunnerTickTimer getRunnerTickTimer() {
        return this.runnerTickTimer;
    }

    public int getInGameBit() {
        return this.inGameBit;
    }

    Timer getTimer() {
        return this.timer;
    }

    public Session getSession() {
        return this.session;
    }

    public Round getRound() {
        return this.round;
    }

    public Wave getWave() {
        return this.wave;
    }

    int getCurrentWave() {
        return this.currentWave;
    }

    public String getLastListen() {
        return this.lastListen;
    }

    public int getLastListenItemId() {
        return this.lastListenItemId;
    }

    public boolean isTeammatesHealthHotkeyPressed() {
        return this.teammatesHealthHotkeyPressed;
    }

    public void setTeammatesHealthShifted(boolean teammatesHealthShifted) {
        this.teammatesHealthShifted = teammatesHealthShifted;
    }

    public boolean isTeammatesHealthShifted() {
        return this.teammatesHealthShifted;
    }
}

