/*
 * Decompiled with CFR 0.152.
 */
package com.corpffa;

import com.corpffa.CorpFfaConfig;
import com.corpffa.CorpFfaOverlay;
import com.corpffa.PlayerState;
import com.google.common.collect.ImmutableSet;
import com.google.inject.Provides;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import java.util.concurrent.ScheduledExecutorService;
import java.util.function.Consumer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.inject.Inject;
import net.runelite.api.ChatMessageType;
import net.runelite.api.Client;
import net.runelite.api.GameState;
import net.runelite.api.NPC;
import net.runelite.api.Player;
import net.runelite.api.PlayerComposition;
import net.runelite.api.events.AnimationChanged;
import net.runelite.api.events.ChatMessage;
import net.runelite.api.events.GameStateChanged;
import net.runelite.api.events.NpcSpawned;
import net.runelite.api.events.PlayerDespawned;
import net.runelite.api.events.PlayerSpawned;
import net.runelite.api.kit.KitType;
import net.runelite.client.config.ConfigManager;
import net.runelite.client.eventbus.Subscribe;
import net.runelite.client.plugins.Plugin;
import net.runelite.client.plugins.PluginDescriptor;
import net.runelite.client.ui.DrawManager;
import net.runelite.client.ui.overlay.Overlay;
import net.runelite.client.ui.overlay.OverlayManager;
import net.runelite.client.util.ImageCapture;
import net.runelite.client.util.ImageUploadStyle;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@PluginDescriptor(name="Corp FFA")
public class CorpFfaPlugin
extends Plugin {
    private static final Logger log = LoggerFactory.getLogger(CorpFfaPlugin.class);
    @Inject
    private Client client;
    @Inject
    private CorpFfaConfig config;
    @Inject
    private CorpFfaOverlay overlay;
    @Inject
    private OverlayManager overlayManager;
    @Inject
    private ImageCapture imageCapture;
    @Inject
    private ScheduledExecutorService executor;
    @Inject
    DrawManager drawManager;
    public HashMap<String, PlayerState> PlayersInCave;
    private boolean IsActive;
    private List<String> TaggedPlayers;
    private final Set<Integer> BannedItems = ImmutableSet.of((Object)3204, (Object)23987, (Object)24125, (Object)13652, (Object)20784, (Object)22978, (Object[])new Integer[]{11889, 27690, 11832, 21301, 10551, 24175, 24420, 26384, 26378, 11834, 23646, 21304, 24421, 23246, 26386, 26380, 20997, 12926, 22804, 22812, 22814, 22806, 22808, 22810});
    private final Set<Integer> RangedWeapons = ImmutableSet.of((Object)9185, (Object)23601, (Object)21902, (Object)21012, (Object)11785, (Object)23611, (Object[])new Integer[]{11235, 12765, 12766, 12767, 12768, 20408, 26374, 9183});
    private final Set<Integer> GoodSpecWeapons = ImmutableSet.of((Object)13576, (Object)20785, (Object)11804, (Object)20782, (Object)21060, (Object)20370, (Object[])new Integer[0]);
    private final Set<Integer> ArclightSpecWeapons = ImmutableSet.of((Object)19675, (Object)6746);
    private final Set<Integer> IgnoredAnimations = ImmutableSet.of((Object)-1, (Object)829, (Object)836);
    private final Pattern receivedADropPattern = Pattern.compile("<col=[\\d\\w]+>([\\s\\w\\xa0\\-]+) received a drop: .+</col>");

    @Provides
    CorpFfaConfig provideConfig(ConfigManager configManager) {
        return (CorpFfaConfig)configManager.getConfig(CorpFfaConfig.class);
    }

    protected void startUp() throws Exception {
        this.PlayersInCave = new HashMap();
        this.RefreshTaggedPlayers();
    }

    protected void shutDown() throws Exception {
        this.overlayManager.remove((Overlay)this.overlay);
        this.PlayersInCave.clear();
        this.IsActive = false;
    }

    @Subscribe
    public void onGameStateChanged(GameStateChanged gameStateChanged) {
        if (gameStateChanged.getGameState() == GameState.LOGGED_IN) {
            Player currentPlayer = this.client.getLocalPlayer();
            int location = currentPlayer.getWorldLocation().getRegionID();
            this.PlayersInCave.clear();
            boolean bl = this.IsActive = location == 11844;
            if (this.IsActive) {
                this.overlayManager.add((Overlay)this.overlay);
                this.RefreshTaggedPlayers();
            }
        }
    }

    @Subscribe
    public void onPlayerDespawned(PlayerDespawned playerDespawned) {
        String playerName = playerDespawned.getPlayer().getName();
        if (this.PlayersInCave.containsKey(playerName)) {
            PlayerState playerState = this.PlayersInCave.get(playerName);
            playerState.HasLeft = true;
        }
    }

    @Subscribe
    public void onPlayerSpawned(PlayerSpawned playerSpawned) {
        if (!this.IsActive) {
            return;
        }
        Player player = playerSpawned.getPlayer();
        PlayerComposition playerComposition = player.getPlayerComposition();
        if (playerComposition == null) {
            return;
        }
        String playerName = player.getName();
        PlayerState playerState = this.GetOrAddPlayerState(player, playerName);
        playerState.HasLeft = false;
        boolean isTagged = this.DoTaggedCheck(playerState, playerName);
        boolean hadBannedGear = this.DoBannedGearCheck(playerState, playerComposition);
        if (!hadBannedGear && !isTagged) {
            playerState.HideFromList = true;
        }
    }

    @Subscribe
    public void onNpcSpawned(NpcSpawned npcSpawned) {
        NPC npc = npcSpawned.getNpc();
        if (npc.getCombatLevel() != 785) {
            return;
        }
        this.IsActive = true;
        this.PlayersInCave.clear();
        this.RefreshTaggedPlayers();
    }

    @Subscribe
    public void onChatMessage(ChatMessage chatMessage) {
        boolean playerHasSpecced;
        boolean isGameMessage;
        if (!this.IsActive) {
            return;
        }
        boolean bl = isGameMessage = chatMessage.getType() == ChatMessageType.GAMEMESSAGE;
        if (!isGameMessage) {
            return;
        }
        Matcher matcher = this.receivedADropPattern.matcher(chatMessage.getMessage());
        boolean isLootMessage = matcher.find();
        if (!isLootMessage) {
            return;
        }
        String userName = matcher.group(1);
        if (!this.PlayersInCave.containsKey(userName)) {
            return;
        }
        PlayerState playerState = this.PlayersInCave.get(userName);
        boolean bl2 = playerHasSpecced = playerState.SpecCount >= 2;
        if (playerHasSpecced) {
            return;
        }
        String message = "<col=FF0000>" + userName + " got the kill with " + playerState.SpecCount + " specs!</col>";
        this.client.addChatMessage(ChatMessageType.GAMEMESSAGE, "", message, null);
    }

    @Subscribe
    public void onAnimationChanged(AnimationChanged e) {
        if (!this.IsActive) {
            return;
        }
        if (!(e.getActor() instanceof Player)) {
            return;
        }
        Player player = (Player)e.getActor();
        int animationId = player.getAnimation();
        if (this.IgnoredAnimations.contains(animationId)) {
            return;
        }
        PlayerComposition playerComposition = player.getPlayerComposition();
        if (playerComposition == null) {
            return;
        }
        String playerName = player.getName();
        PlayerState playerState = this.GetOrAddPlayerState(player, playerName);
        playerState.HideFromList = false;
        playerState.HasLeft = false;
        Integer equippedWeapon = playerComposition.getEquipmentId(KitType.WEAPON);
        boolean isHoldingGoodSpecWeapon = this.GoodSpecWeapons.contains(equippedWeapon);
        playerState.Weapon = !(isHoldingGoodSpecWeapon |= this.config.allowArclight() && this.ArclightSpecWeapons.contains(equippedWeapon)) ? equippedWeapon : Integer.valueOf(-1);
        this.DoTaggedCheck(playerState, playerName);
        this.DoRangerCheck(playerState, playerComposition);
        this.DoSpecCheck(playerState, player);
        boolean hasBannedGear = this.DoBannedGearCheck(playerState, playerComposition);
        if (hasBannedGear && !playerState.HasBeenScreenshotted && this.config.captureOnCrash()) {
            playerState.HasBeenScreenshotted = true;
            this.takeScreenshot("crash--" + playerName + "--");
        }
    }

    private boolean DoBannedGearCheck(PlayerState playerState, PlayerComposition playerComposition) {
        boolean hasBannedGear;
        List<Object> bannedGear = new ArrayList();
        if (this.config.bannedItemCountToShow() > 0) {
            bannedGear = this.GetBannedItems(playerComposition);
        }
        boolean bl = hasBannedGear = bannedGear.size() > 0;
        if (hasBannedGear) {
            playerState.BannedGear = Stream.concat(playerState.BannedGear.stream(), bannedGear.stream()).distinct().collect(Collectors.toList());
        }
        return hasBannedGear;
    }

    private boolean DoRangerCheck(PlayerState playerState, PlayerComposition playerComposition) {
        boolean isRanger;
        playerState.IsRanger = isRanger = this.IsRanger(playerComposition);
        return isRanger;
    }

    private boolean DoSpecCheck(PlayerState playerState, Player player) {
        boolean isSpeccing = this.IsSpeccing(player);
        if (isSpeccing) {
            ++playerState.SpecCount;
        }
        return isSpeccing;
    }

    private boolean DoTaggedCheck(PlayerState playerState, String playerName) {
        boolean isTaggedPlayer;
        if (playerName == null) {
            playerName = "";
        }
        playerState.IsTagged = isTaggedPlayer = this.TaggedPlayers.contains(playerName.toLowerCase());
        return isTaggedPlayer;
    }

    private PlayerState GetOrAddPlayerState(Player player, String playerName) {
        return this.PlayersInCave.computeIfAbsent(playerName, k -> new PlayerState(player));
    }

    private boolean IsRanger(PlayerComposition playerComposition) {
        return this.RangedWeapons.contains(playerComposition.getEquipmentId(KitType.WEAPON));
    }

    private boolean IsSpeccing(Player player) {
        if (player == null) {
            return false;
        }
        int animId = player.getAnimation();
        switch (animId) {
            case 1378: 
            case 7642: 
            case 7643: {
                return true;
            }
        }
        return animId == 2890 && this.config.allowArclight();
    }

    private List<Integer> GetBannedItems(PlayerComposition playerComposition) {
        ArrayList<Integer> illegalItems = new ArrayList<Integer>();
        if (playerComposition == null) {
            return illegalItems;
        }
        List<Integer> equippedItems = Arrays.asList(playerComposition.getEquipmentId(KitType.TORSO), playerComposition.getEquipmentId(KitType.LEGS), playerComposition.getEquipmentId(KitType.WEAPON));
        for (Integer equippedItem : equippedItems) {
            if (!this.BannedItems.contains(equippedItem)) continue;
            illegalItems.add(equippedItem);
        }
        return illegalItems;
    }

    public void RefreshTaggedPlayers() {
        this.TaggedPlayers = Arrays.stream(this.config.taggedPlayers().split(",")).map(a -> a.trim().toLowerCase()).collect(Collectors.toList());
    }

    private void takeScreenshot(String fileName) {
        boolean shouldNotify = this.config.nofifyOnCapture();
        boolean shouldCopyToClipboard = this.config.saveToClipboard();
        Consumer<Image> imageCallback = img -> this.executor.submit(() -> this.imageCapture.takeScreenshot((BufferedImage)img, fileName, "corp-ffa", shouldNotify, shouldCopyToClipboard ? ImageUploadStyle.CLIPBOARD : ImageUploadStyle.NEITHER));
        this.drawManager.requestNextFrameListener(imageCallback);
    }
}

