/*
 * Decompiled with CFR 0.152.
 */
package com.corpffa;

import com.corpffa.CorpFfaConfig;
import com.corpffa.CorpFfaPlugin;
import com.corpffa.PlayerState;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.inject.Inject;
import net.runelite.api.Actor;
import net.runelite.api.Client;
import net.runelite.api.Player;
import net.runelite.api.Point;
import net.runelite.client.plugins.Plugin;
import net.runelite.client.ui.overlay.OverlayPanel;
import net.runelite.client.ui.overlay.OverlayPosition;
import net.runelite.client.ui.overlay.OverlayUtil;
import net.runelite.client.ui.overlay.components.LayoutableRenderableEntity;
import net.runelite.client.ui.overlay.components.LineComponent;
import net.runelite.client.ui.overlay.components.TitleComponent;

public class CorpFfaOverlay
extends OverlayPanel {
    private final CorpFfaPlugin plugin;
    private final CorpFfaConfig config;
    private final Client client;

    @Inject
    public CorpFfaOverlay(CorpFfaPlugin plugin, Client client, CorpFfaConfig config) {
        super((Plugin)plugin);
        this.setPosition(OverlayPosition.DYNAMIC);
        this.setPosition(OverlayPosition.DETACHED);
        this.setPosition(OverlayPosition.TOP_LEFT);
        this.setPreferredSize(new Dimension(100, 600));
        this.plugin = plugin;
        this.client = client;
        this.config = config;
    }

    public Dimension render(Graphics2D graphics2D) {
        List renderableEntities = this.panelComponent.getChildren();
        renderableEntities.clear();
        Rectangle overlayPosition = super.getBounds();
        ArrayList<Map.Entry<String, PlayerState>> playerStates = new ArrayList<Map.Entry<String, PlayerState>>(this.plugin.PlayersInCave.entrySet());
        if (playerStates.size() <= 1) {
            return super.render(graphics2D);
        }
        long numberOfSpeccedPlayers = playerStates.stream().filter(playerEntry -> ((PlayerState)playerEntry.getValue()).SpecCount >= 2).count();
        boolean shouldHaveSpecced = numberOfSpeccedPlayers > 3L;
        playerStates.sort((player1, player2) -> {
            String playerName1 = (String)player1.getKey();
            String playerName2 = (String)player2.getKey();
            return playerName1.compareToIgnoreCase(playerName2);
        });
        if (!this.config.hideBanner()) {
            renderableEntities.add(TitleComponent.builder().text("Corp FFA").color(this.config.defaultColor()).build());
        }
        this.drawPlayerList(graphics2D, renderableEntities, overlayPosition, playerStates, shouldHaveSpecced);
        if (!this.config.hidePlayerCount()) {
            this.drawPlayerCount(renderableEntities, shouldHaveSpecced);
        }
        return super.render(graphics2D);
    }

    private void drawPlayerList(Graphics2D graphics2D, List<LayoutableRenderableEntity> renderableEntities, Rectangle overlayPosition, List<Map.Entry<String, PlayerState>> playerStates, boolean shouldHaveSpecced) {
        for (Map.Entry<String, PlayerState> entry : playerStates) {
            PlayerState playerState = entry.getValue();
            Player player = playerState.Player;
            String nonFriendsChatIndicator = this.config.nonFriendChatLabel();
            if (playerState.HideFromList) continue;
            boolean hasBannedGear = playerState.BannedGear.size() > 0;
            boolean hasSpecced = playerState.SpecCount >= 2;
            boolean allGood = !hasBannedGear && hasSpecced;
            boolean isNonSpeccer = !hasSpecced && shouldHaveSpecced;
            String rightLabel = "" + playerState.SpecCount;
            Color rightColor = this.config.defaultColor();
            String leftLabel = player.getName() + (String)(player.isClanMember() || player.isFriend() || player.isFriendsChatMember() ? "" : " " + nonFriendsChatIndicator);
            Color leftColor = this.config.defaultColor();
            Color highlightColor = null;
            String highlightText = null;
            boolean shouldRender = true;
            if (playerState.HasLeft) {
                Color goneColor;
                leftColor = goneColor = this.config.gonePlayerColor();
                rightColor = goneColor;
                if (this.config.hideTeledPlayers()) {
                    shouldRender = false;
                }
            } else if (hasBannedGear && this.config.bannedItemCountToShow() > 0) {
                Color cheaterColor;
                List itemNames = playerState.BannedGear.stream().limit(this.config.bannedItemCountToShow()).map(gearId -> this.client.getItemDefinition(gearId.intValue()).getName()).collect(Collectors.toList());
                rightLabel = playerState.SpecCount + " - " + String.join((CharSequence)", ", itemNames);
                this.highlightPlayer(graphics2D, (Actor)player, rightLabel, this.config.cheaterColor(), overlayPosition.x, overlayPosition.y);
                leftColor = cheaterColor = this.config.cheaterColor();
                rightColor = cheaterColor;
            } else if (isNonSpeccer) {
                Color cheaterColor;
                leftColor = cheaterColor = this.config.cheaterColor();
                rightColor = cheaterColor;
                highlightColor = cheaterColor;
                highlightText = playerState.SpecCount + " spec";
                if (playerState.Weapon != -1) {
                    String weaponName = this.client.getItemDefinition(playerState.Weapon.intValue()).getName();
                    String acronym = Arrays.stream(weaponName.split(" ")).map(str -> str.substring(0, 1)).collect(Collectors.joining(""));
                    highlightText = highlightText + "( " + acronym + ")";
                }
            } else if (allGood) {
                Color goodColor;
                leftColor = goodColor = this.config.goodColor();
                rightColor = goodColor;
                if (this.config.hideGoodPlayers()) {
                    shouldRender = false;
                }
            }
            if (playerState.IsTagged) {
                Color taggedPlayerColor;
                highlightColor = taggedPlayerColor = this.config.taggedPlayerColor();
                highlightText = leftLabel;
                leftColor = taggedPlayerColor;
                leftLabel = leftLabel + "*";
                shouldRender = true;
            }
            if (!shouldRender) continue;
            renderableEntities.add((LayoutableRenderableEntity)LineComponent.builder().leftColor(leftColor).left(leftLabel).rightColor(rightColor).right(rightLabel).build());
            if (highlightText == null || highlightColor == null || playerState.HasLeft) continue;
            this.highlightPlayer(graphics2D, (Actor)player, highlightText, highlightColor, overlayPosition.x, overlayPosition.y);
        }
    }

    private void drawPlayerCount(List<LayoutableRenderableEntity> renderableEntities, boolean showCount) {
        List playersInCave = this.plugin.PlayersInCave.values().stream().filter(o -> !o.HasLeft).collect(Collectors.toList());
        int playerCount = playersInCave.size();
        Object playerCountText = "-";
        if (showCount) {
            playerCountText = "" + playerCount;
        }
        renderableEntities.add((LayoutableRenderableEntity)LineComponent.builder().leftColor(this.config.playerCountColor()).left("Players").rightColor(this.config.playerCountColor()).right((String)playerCountText).build());
    }

    private void highlightPlayer(Graphics2D graphics, Actor actor, String text, Color color, int xTextOffSet, int yTextOffSet) {
        Point poly = actor.getCanvasTextLocation(graphics, text, 20);
        if (poly == null) {
            return;
        }
        Point offsetPoint = new Point(poly.getX() - xTextOffSet, poly.getY() - yTextOffSet);
        OverlayUtil.renderTextLocation((Graphics2D)graphics, (Point)offsetPoint, (String)text, (Color)color);
    }
}

