/*
 * Decompiled with CFR 0.152.
 */
package com.sololegends.runelite.panel;

import com.google.inject.Inject;
import com.sololegends.runelite.FriendMapPoint;
import com.sololegends.runelite.FriendsOnMapPlugin;
import com.sololegends.runelite.panel.FriendPanel;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import javax.swing.BoxLayout;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.border.EmptyBorder;
import net.runelite.api.Skill;
import net.runelite.client.game.SkillIconManager;
import net.runelite.client.ui.ColorScheme;
import net.runelite.client.ui.PluginPanel;
import net.runelite.client.ui.components.DragAndDropReorderPane;

public class FriendsPanel
extends PluginPanel {
    private final FriendsOnMapPlugin plugin;
    private final JComponent friends = new DragAndDropReorderPane();
    private final Map<String, Component> friend_components = new ConcurrentHashMap<String, Component>();
    private final ImageIcon health_icon;
    private final ImageIcon prayer_icon;

    @Inject
    FriendsPanel(FriendsOnMapPlugin plugin, SkillIconManager icon_manager) {
        this.plugin = plugin;
        this.health_icon = new ImageIcon(icon_manager.getSkillImage(Skill.HITPOINTS, true));
        this.prayer_icon = new ImageIcon(icon_manager.getSkillImage(Skill.PRAYER, true));
        this.setBorder(new EmptyBorder(10, 10, 10, 10));
        this.setBackground(ColorScheme.DARK_GRAY_COLOR);
        this.setLayout(new BorderLayout());
        JPanel layout = new JPanel();
        BoxLayout boxLayout = new BoxLayout(layout, 1);
        layout.setLayout(boxLayout);
        this.add(layout, "North");
        JPanel info_panel = new JPanel();
        info_panel.setBorder(new EmptyBorder(0, 0, 4, 0));
        info_panel.add(new JLabel("Friends Info"));
        layout.add(info_panel);
        layout.add(this.friends);
    }

    public void clear() {
        this.friends.removeAll();
        this.friends.revalidate();
    }

    public void prune() {
        HashSet<String> panels = new HashSet<String>(this.friend_components.keySet());
        for (String s : panels) {
            FriendPanel panel = (FriendPanel)this.friend_components.get(s);
            if (!panel.expired()) continue;
            this.friends.remove(this.friend_components.remove(s));
        }
    }

    public void update() {
        Set<FriendMapPoint> friend_points = this.plugin.currentPoints();
        for (final FriendMapPoint friend : friend_points) {
            FriendPanel panel;
            if (this.friend_components.containsKey(friend.friend)) {
                panel = (FriendPanel)this.friend_components.get(friend.friend);
                panel.update(friend, friend.getLocation());
                continue;
            }
            panel = new FriendPanel(this, friend, this.health_icon, this.prayer_icon);
            panel.addMouseListener(new MouseListener(){

                @Override
                public void mouseClicked(MouseEvent e) {
                    FriendsPanel.this.plugin.focusOn(friend);
                }

                @Override
                public void mousePressed(MouseEvent e) {
                }

                @Override
                public void mouseReleased(MouseEvent e) {
                }

                @Override
                public void mouseEntered(MouseEvent e) {
                }

                @Override
                public void mouseExited(MouseEvent e) {
                }
            });
            this.friend_components.put(friend.friend, this.friends.add(panel));
        }
        this.prune();
        this.friends.revalidate();
    }
}

