/*
 * Decompiled with CFR 0.152.
 */
package com.sololegends.runelite.panel;

import com.sololegends.runelite.FriendMapPoint;
import com.sololegends.runelite.helpers.WorldLocations;
import com.sololegends.runelite.panel.FriendsPanel;
import com.sololegends.runelite.skills.Health;
import com.sololegends.runelite.skills.PlayerSkill;
import com.sololegends.runelite.skills.Prayer;
import java.awt.Color;
import java.awt.Component;
import javax.swing.BorderFactory;
import javax.swing.GroupLayout;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.border.TitledBorder;
import net.runelite.api.Skill;
import net.runelite.client.ui.components.ProgressBar;

public class FriendPanel
extends JPanel {
    private static final long EXPIRE_THRESHOLD = 70000L;
    private static final Color HEALTH_FG = new Color(0, 146, 54, 230);
    private static final Color HEALTH_BG = new Color(102, 15, 16, 230);
    private static final Color PRAYER_FG = new Color(0, 149, 151);
    private static final Color PRAYER_BG = Color.black;
    ProgressBar health = this.buildStatBar(new Health(0, 0));
    ProgressBar prayer = this.buildStatBar(new Prayer(0, 0));
    TitledBorder border = new TitledBorder("");
    final FriendsPanel parent;
    final String name;
    long updated = System.currentTimeMillis();

    public FriendPanel(FriendsPanel parent, FriendMapPoint friend, ImageIcon h_icon, ImageIcon p_icon) {
        this.border = new TitledBorder(BorderFactory.createEtchedBorder(0), friend.friend);
        this.name = friend.friend;
        this.setBorder(this.border);
        this.parent = parent;
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setAutoCreateGaps(true);
        layout.setAutoCreateContainerGaps(true);
        this.health = this.buildStatBar(friend.getHealth());
        this.prayer = this.buildStatBar(friend.getPrayer());
        JLabel health_icon = new JLabel(h_icon);
        JLabel prayer_icon = new JLabel(p_icon);
        GroupLayout.SequentialGroup h_group = layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.CENTER).addGroup(layout.createSequentialGroup().addComponent(health_icon, -2, -2, 25).addComponent((Component)this.health, -2, -2, Short.MAX_VALUE)).addGroup(layout.createSequentialGroup().addComponent(prayer_icon, -2, -2, 25).addComponent((Component)this.prayer, -2, -2, Short.MAX_VALUE)));
        GroupLayout.SequentialGroup v_group = layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(health_icon).addComponent((Component)this.health)).addGroup(layout.createParallelGroup(GroupLayout.Alignment.CENTER).addComponent(prayer_icon).addComponent((Component)this.prayer));
        layout.setHorizontalGroup(h_group);
        layout.setVerticalGroup(v_group);
    }

    public void update(FriendMapPoint friend, WorldLocations.WorldSurface surface) {
        this.updated = System.currentTimeMillis();
        Health h_skill = friend.getHealth();
        Prayer p_skill = friend.getPrayer();
        this.health.setValue(h_skill.current());
        this.health.setMaximumValue(h_skill.max());
        this.health.setCenterLabel(h_skill.current() + " / " + h_skill.max());
        this.prayer.setValue(p_skill.current());
        this.prayer.setMaximumValue(p_skill.max());
        this.prayer.setCenterLabel(p_skill.current() + " / " + p_skill.max());
        if (surface != null) {
            this.border.setTitle(friend.friend + ": " + surface.name);
        }
    }

    public boolean expired() {
        return System.currentTimeMillis() - this.updated > 70000L;
    }

    private ProgressBar buildStatBar(PlayerSkill skill) {
        ProgressBar bar = new ProgressBar();
        bar.setValue(skill.current());
        bar.setMaximumValue(skill.max());
        bar.setCenterLabel(skill.current() + " / " + skill.max());
        if (skill.type() == Skill.HITPOINTS) {
            bar.setForeground(HEALTH_FG);
            bar.setBackground(HEALTH_BG);
        } else if (skill.type() == Skill.PRAYER) {
            bar.setForeground(PRAYER_FG);
            bar.setBackground(PRAYER_BG);
        }
        return bar;
    }

    public int hashCode() {
        return -1;
    }

    public boolean equals(Object o) {
        return o instanceof FriendPanel && ((FriendPanel)o).name.equals(this.name);
    }
}

