/*
 * Decompiled with CFR 0.152.
 */
package com.sololegends.runelite.overlay;

import com.sololegends.runelite.FriendsOnMapConfig;
import com.sololegends.runelite.FriendsOnMapPlugin;
import com.sololegends.runelite.helpers.WorldLocations;
import java.awt.Dimension;
import java.awt.Graphics2D;
import javax.inject.Inject;
import net.runelite.api.Client;
import net.runelite.api.coords.LocalPoint;
import net.runelite.api.coords.WorldPoint;
import net.runelite.client.plugins.Plugin;
import net.runelite.client.ui.overlay.OverlayPanel;
import net.runelite.client.ui.overlay.OverlayPosition;
import net.runelite.client.ui.overlay.OverlayPriority;
import net.runelite.client.ui.overlay.components.LineComponent;

public class PlayerLocationOverlayPanel
extends OverlayPanel {
    private FriendsOnMapConfig config;
    private Client client;

    @Inject
    private PlayerLocationOverlayPanel(FriendsOnMapPlugin plugin, FriendsOnMapConfig config, Client client) {
        super((Plugin)plugin);
        this.setPosition(OverlayPosition.TOP_LEFT);
        this.setPriority(OverlayPriority.LOW);
        this.config = config;
        this.client = client;
    }

    public Dimension render(Graphics2D graphics) {
        if (this.config.yourLocation()) {
            WorldPoint player = this.client.getLocalPlayer().getWorldLocation();
            LocalPoint local = this.client.getLocalPlayer().getLocalLocation();
            int region_id = player.getRegionID();
            if (this.client.isInInstancedRegion()) {
                region_id = WorldPoint.fromLocalInstance((Client)this.client, (LocalPoint)local).getRegionID();
            }
            WorldLocations.WorldSurface s = WorldLocations.getWorldSurface(region_id);
            if (s.name.equals("Unknown")) {
                s = WorldLocations.getWorldSurface(player);
            }
            this.panelComponent.getChildren().add(LineComponent.builder().left(s.name).right("" + region_id).build());
        }
        return super.render(graphics);
    }
}

