/*
 * Decompiled with CFR 0.152.
 */
package com.sololegends.runelite.overlay;

import com.google.inject.Inject;
import com.sololegends.runelite.FriendMapPoint;
import com.sololegends.runelite.FriendsOnMapConfig;
import com.sololegends.runelite.FriendsOnMapPlugin;
import com.sololegends.runelite.helpers.WorldLocations;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.StringSelection;
import java.awt.geom.Area;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Set;
import net.runelite.api.Client;
import net.runelite.api.Point;
import net.runelite.api.coords.WorldArea;
import net.runelite.api.coords.WorldPoint;
import net.runelite.api.widgets.Widget;
import net.runelite.api.widgets.WidgetInfo;
import net.runelite.api.worldmap.WorldMap;
import net.runelite.client.plugins.Plugin;
import net.runelite.client.ui.FontManager;
import net.runelite.client.ui.JagexColors;
import net.runelite.client.ui.overlay.Overlay;
import net.runelite.client.ui.overlay.OverlayLayer;
import net.runelite.client.ui.overlay.OverlayPosition;
import net.runelite.client.ui.overlay.OverlayPriority;
import net.runelite.client.ui.overlay.worldmap.WorldMapOverlay;

public class OtherSurfacePlayersOverlay
extends Overlay {
    private static final Font FONT = FontManager.getRunescapeFont().deriveFont(1, 16.0f);
    private final Client client;
    private final FriendsOnMapPlugin plugin;
    private final FriendsOnMapConfig config;
    @Inject
    private WorldMapOverlay map_overlay;

    @Inject
    private OtherSurfacePlayersOverlay(Client client, FriendsOnMapPlugin plugin, FriendsOnMapConfig config) {
        super((Plugin)plugin);
        this.client = client;
        this.plugin = plugin;
        this.config = config;
        this.setPosition(OverlayPosition.DYNAMIC);
        this.setPriority(OverlayPriority.HIGHEST);
        this.setLayer(OverlayLayer.MANUAL);
        this.drawAfterLayer(WidgetInfo.WORLD_MAP_VIEW);
    }

    public Dimension render(Graphics2D g) {
        Widget parent = this.client.getWidget(WidgetInfo.WORLD_MAP_VIEW);
        if (parent == null || parent.isHidden()) {
            return null;
        }
        Point mouse = this.client.getMouseCanvasPosition();
        Rectangle bounds = parent.getBounds();
        Shape clip = this.getWorldMapClipArea(bounds);
        g.setClip(clip);
        int y_offset = 10;
        int x = 0;
        int y = 0;
        WorldMap worldMap = this.client.getWorldMap();
        String draw_tip = null;
        ArrayList<FriendMapPoint> points = new ArrayList<FriendMapPoint>(this.plugin.currentPoints());
        points.sort(new Comparator<FriendMapPoint>(){

            @Override
            public int compare(FriendMapPoint o1, FriendMapPoint o2) {
                return o1.friend.compareTo(o2.friend);
            }
        });
        for (FriendMapPoint f : points) {
            if (worldMap.getWorldMapData().surfaceContainsPosition(f.getWorldPoint().getX(), f.getWorldPoint().getY())) continue;
            x = bounds.x + 10;
            y = bounds.y + y_offset;
            Dimension dim = this.drawLocationGraphic(g, f, x, y);
            if (mouse.getX() > x && mouse.getX() < x + dim.width && mouse.getY() > y && mouse.getY() < y + dim.height) {
                WorldLocations.WorldSurface loc = f.getLocation();
                draw_tip = loc.name;
            }
            y_offset = (int)((double)y_offset + (dim.getHeight() + 5.0));
        }
        if (this.config.mapDrawAreas()) {
            this.drawAreas(g, worldMap);
        }
        if (draw_tip != null) {
            this.drawToolTip(g, draw_tip, mouse.getX(), 20 + mouse.getY());
        }
        return null;
    }

    private void drawAreas(Graphics2D g, WorldMap map) {
        Set<WorldLocations.WorldSurface> surfaces = WorldLocations.getSurfaces();
        Widget map_w = this.client.getWidget(WidgetInfo.WORLD_MAP_VIEW);
        if (map_w == null) {
            return;
        }
        g.setFont(FontManager.getRunescapeFont().deriveFont(0, 13.0f));
        FontMetrics fm = g.getFontMetrics();
        for (WorldLocations.WorldSurface s : surfaces) {
            for (WorldArea a : s.areas) {
                WorldPoint start = new WorldPoint(a.getX(), a.getY(), 0);
                WorldPoint end = new WorldPoint(a.getX() + a.getWidth(), a.getY() + a.getHeight(), 0);
                Point draw_start = this.map_overlay.mapWorldPointToGraphicsPoint(start);
                Point draw_end = this.map_overlay.mapWorldPointToGraphicsPoint(end);
                if (draw_start == null || draw_end == null) continue;
                g.setColor(Color.RED);
                g.drawRect(draw_start.getX(), draw_end.getY(), draw_end.getX() - draw_start.getX(), draw_start.getY() - draw_end.getY());
                Rectangle2D bounds = fm.getStringBounds(s.name, g);
                g.setColor(Color.BLACK);
                g.drawString(s.name, draw_start.getX() + 4, draw_end.getY() + 2 + (int)bounds.getHeight());
                g.setColor(Color.WHITE);
                g.drawString(s.name, draw_start.getX() + 3, draw_end.getY() + 3 + (int)bounds.getHeight());
            }
        }
    }

    private Dimension drawLocationGraphic(Graphics2D g, FriendMapPoint f, int x_offset, int y_offset) {
        g.setFont(FONT);
        FontMetrics fm = g.getFontMetrics();
        Rectangle2D bounds = fm.getStringBounds(f.getName(), g);
        Dimension dim = this.plugin.drawIcon(f.world != this.client.getWorld(), true, g, x_offset, y_offset);
        g.setColor(Color.BLACK);
        g.drawString(f.getName(), x_offset + 6 + dim.width, 1 + y_offset + (int)bounds.getHeight());
        g.setColor(Color.WHITE);
        g.drawString(f.getName(), x_offset + 5 + dim.width, y_offset + (int)bounds.getHeight());
        return new Dimension(dim.width + (int)bounds.getWidth() + 5, (int)bounds.getHeight());
    }

    public void drawToolTip(Graphics2D g, String text, int x, int y) {
        g.setFont(FontManager.getRunescapeFont());
        FontMetrics fm = g.getFontMetrics();
        Rectangle2D bounds = fm.getStringBounds(text, g);
        Rectangle padded = new Rectangle(x, y, (int)bounds.getWidth() + 6, (int)bounds.getHeight() + 4);
        g.setColor(JagexColors.TOOLTIP_BACKGROUND);
        g.fill(padded);
        g.setStroke(new BasicStroke(1.0f));
        g.setColor(JagexColors.TOOLTIP_BORDER);
        g.draw(padded);
        g.setColor(JagexColors.TOOLTIP_TEXT);
        g.drawString(text, x + 3, y + 1 + (int)bounds.getHeight());
    }

    private Shape getWorldMapClipArea(Rectangle baseRectangle) {
        Widget overview = this.client.getWidget(WidgetInfo.WORLD_MAP_OVERVIEW_MAP);
        Widget surfaceSelector = this.client.getWidget(WidgetInfo.WORLD_MAP_SURFACE_SELECTOR);
        Area clipArea = new Area(baseRectangle);
        boolean subtracted = false;
        if (overview != null && !overview.isHidden()) {
            clipArea.subtract(new Area(overview.getBounds()));
            subtracted = true;
        }
        if (surfaceSelector != null && !surfaceSelector.isHidden()) {
            clipArea.subtract(new Area(surfaceSelector.getBounds()));
            subtracted = true;
        }
        return subtracted ? clipArea : baseRectangle;
    }

    private void drawCrosshair(Graphics2D g, Point mouse, Rectangle bounds) {
        g.setColor(Color.RED);
        g.setStroke(new BasicStroke(1.0f));
        g.drawLine(mouse.getX(), bounds.y, mouse.getX(), bounds.y + bounds.height);
        g.drawLine(bounds.x, mouse.getY(), bounds.x + bounds.width, mouse.getY());
    }

    private void drawMapGrid(Graphics2D graphics, int grid_size, Color grid_color) {
        int gridTruncate = ~(grid_size - 1);
        Widget map = this.client.getWidget(WidgetInfo.WORLD_MAP_VIEW);
        if (map == null) {
            return;
        }
        graphics.setStroke(new BasicStroke(1.0f));
        WorldMap ro = this.client.getWorldMap();
        Float pixelsPerTile = Float.valueOf(ro.getWorldMapZoom());
        Rectangle worldMapRect = map.getBounds();
        graphics.setClip(worldMapRect);
        int widthInTiles = (int)Math.ceil(worldMapRect.getWidth() / (double)pixelsPerTile.floatValue());
        int heightInTiles = (int)Math.ceil(worldMapRect.getHeight() / (double)pixelsPerTile.floatValue());
        Point worldMapPosition = ro.getWorldMapPosition();
        int yTileMin = worldMapPosition.getY() - heightInTiles / 2;
        int xRegionMin = worldMapPosition.getX() - widthInTiles / 2 & gridTruncate;
        int xRegionMax = (worldMapPosition.getX() + widthInTiles / 2 & gridTruncate) + grid_size;
        int yRegionMin = yTileMin & gridTruncate;
        int yRegionMax = (worldMapPosition.getY() + heightInTiles / 2 & gridTruncate) + grid_size;
        int regionPixelSize = (int)Math.ceil((float)grid_size * pixelsPerTile.floatValue());
        Point mouse = this.client.getMouseCanvasPosition();
        String draw_tip = null;
        Object copy = "";
        int tip_x = 0;
        int tip_y = 0;
        graphics.setColor(grid_color);
        boolean render_lines = (float)grid_size * pixelsPerTile.floatValue() >= 3.0f;
        for (int x = xRegionMin; x < xRegionMax; x += grid_size) {
            for (int y = yRegionMin; y < yRegionMax; y += grid_size) {
                int yTileOffset = -(yTileMin - y);
                int xTileOffset = x + widthInTiles / 2 - worldMapPosition.getX();
                int xPos = (int)((float)xTileOffset * pixelsPerTile.floatValue()) + (int)worldMapRect.getX();
                int yPos = worldMapRect.height - (int)((float)yTileOffset * pixelsPerTile.floatValue()) + (int)worldMapRect.getY();
                yPos -= regionPixelSize;
                if (render_lines) {
                    graphics.drawRect(xPos, yPos, regionPixelSize, regionPixelSize);
                }
                if (!new Rectangle(xPos, yPos, regionPixelSize, regionPixelSize).contains(mouse.getX(), mouse.getY())) continue;
                draw_tip = "x: " + xPos + ", y: " + yPos + ", rX: " + x + " , rY: " + y;
                tip_x = xPos;
                tip_y = yPos;
                copy = x + ", " + y;
            }
        }
        if (draw_tip != null) {
            if (this.client.getMouseCurrentButton() == 1 || this.client.getMouseCurrentButton() == 2) {
                Clipboard clipboard = Toolkit.getDefaultToolkit().getSystemClipboard();
                clipboard.setContents(new StringSelection((String)copy), null);
            }
            this.drawToolTip(graphics, draw_tip, tip_x, tip_y + 20);
        }
    }
}

