/*
 * Decompiled with CFR 0.152.
 */
package com.sololegends.runelite.helpers;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonParser;
import com.google.gson.JsonSyntaxException;
import com.sololegends.runelite.data.WorldRegions;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import net.runelite.api.coords.WorldArea;
import net.runelite.api.coords.WorldPoint;

public class WorldLocations {
    private static final Set<WorldSurface> WORLD_AREAS = ConcurrentHashMap.newKeySet();

    public static WorldArea fromBounds(int x, int y2, int x2, int y) {
        return new WorldArea(x, y, x2 - x, y2 - y, 0);
    }

    public static WorldSurface surface(String name, int eX, int eY, WorldArea ... areas) {
        return new WorldSurface(name, new WorldPoint(eX, eY, 0), areas);
    }

    public static Set<WorldSurface> getSurfaces() {
        return new HashSet<WorldSurface>(WORLD_AREAS);
    }

    public static WorldSurface getWorldSurface(WorldPoint point) {
        WorldSurface s = WorldLocations.getWorldSurface(point.getRegionID());
        if (!s.name.equals("Unknown")) {
            return s;
        }
        for (WorldSurface surface : WORLD_AREAS) {
            if (!surface.contains(point)) continue;
            return surface;
        }
        return new WorldSurface("Unknown", new WorldPoint(0, 0, 0), new WorldArea(0, 0, 0, 0, 0));
    }

    public static WorldSurface getWorldSurface(int region) {
        WorldSurface s;
        if (region != -1 && (s = WorldRegions.fromRegion(region)) != null) {
            return s;
        }
        return new WorldSurface("Unknown", new WorldPoint(0, 0, 0), new WorldArea(0, 0, 0, 0, 0));
    }

    public static final void main(String[] args) {
        try {
            InputStream wis = WorldLocations.class.getResourceAsStream("/map_data.json");
            JsonElement ele = new JsonParser().parse(new String(wis.readAllBytes(), StandardCharsets.UTF_8));
            Iterator arr = ele.getAsJsonArray().iterator();
            StringBuilder sb = new StringBuilder("static {");
            while (arr.hasNext()) {
                JsonElement e = (JsonElement)arr.next();
                JsonArray bounds = e.getAsJsonObject().get("bounds").getAsJsonArray();
                JsonArray b1 = bounds.get(0).getAsJsonArray();
                JsonArray b2 = bounds.get(1).getAsJsonArray();
                sb.append("\r\n  WORLD_AREAS.put(\"" + e.getAsJsonObject().get("name").getAsString() + "\", fromBounds(" + b1.get(0).getAsInt() + ", " + b1.get(1).getAsInt() + ", " + b2.get(0).getAsInt() + ", " + b2.get(1).getAsInt() + "));");
            }
            sb.append("\r\n}");
            System.out.println(sb.toString());
        }
        catch (JsonSyntaxException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    static {
        WORLD_AREAS.add(WorldLocations.surface("RuneScape Surface", 0, 0, WorldLocations.fromBounds(1052, 4132, 3940, 2396)));
        WORLD_AREAS.add(WorldLocations.surface("Ancient Cavern", 2511, 3508, WorldLocations.fromBounds(1733, 5436, 1854, 5318)));
        WorldSurface ardougne_ug = WorldLocations.surface("Ardougne Underground", 2631, 3294, WorldLocations.fromBounds(2513, 9854, 2748, 9599));
        WORLD_AREAS.add(WorldLocations.surface("Clock Tower Dungeon", 2568, 3229, WorldLocations.fromBounds(2560, 9663, 2623, 9600)).setParent(ardougne_ug));
        WORLD_AREAS.add(WorldLocations.surface("Ardougne Rat Pits", 2560, 3320, WorldLocations.fromBounds(2640, 9675, 2673, 9617)).setParent(ardougne_ug));
        WORLD_AREAS.add(WorldLocations.surface("Ardougne Sewers North", 2641, 9674, WorldLocations.fromBounds(2628, 9727, 2684, 9675)).setParent(ardougne_ug));
        WORLD_AREAS.add(WorldLocations.surface("Ardougne Sewers South", 2586, 3235, WorldLocations.fromBounds(2536, 9727, 2623, 9664), WorldLocations.fromBounds(2513, 9664, 2557, 9638)).setParent(ardougne_ug));
        WORLD_AREAS.add(WorldLocations.surface("Chaos Druid Tower Dungeon", 2561, 3356, WorldLocations.fromBounds(2560, 9758, 2593, 9729)).setParent(ardougne_ug));
        WORLD_AREAS.add(WorldLocations.surface("Goblin Cave", 2262, 3393, WorldLocations.fromBounds(2561, 9854, 2622, 9793)).setParent(ardougne_ug));
        WORLD_AREAS.add(WorldLocations.surface("Legend's Guild Dungeon", 2723, 3375, WorldLocations.fromBounds(2690, 9785, 2739, 9729)).setParent(ardougne_ug));
        WORLD_AREAS.add(WorldLocations.surface("Wicthaven Dungeon", 2695, 3283, WorldLocations.fromBounds(2692, 9719, 2748, 9665)).setParent(ardougne_ug));
        WorldSurface asgarnia_ice_cave = WorldLocations.surface("Asgarnia Ice Cave", 0, 0, WorldLocations.fromBounds(2920, 9660, 3149, 9535));
        WORLD_AREAS.add(WorldLocations.surface("Melzar's Maze Basement", 2923, 3250, WorldLocations.fromBounds(2920, 9660, 2942, 9638)).setParent(asgarnia_ice_cave));
        WORLD_AREAS.add(WorldLocations.surface("Port Sarim Rat Pits", 3017, 3232, WorldLocations.fromBounds(3016, 9658, 3063, 9623)).setParent(asgarnia_ice_cave));
        WORLD_AREAS.add(WorldLocations.surface("Asgarnia Ice Dungeon", 3005, 3150, WorldLocations.fromBounds(2984, 9601, 3145, 9538)).setParent(asgarnia_ice_cave));
        WORLD_AREAS.add(WorldLocations.surface("Braindeath Island", 3680, 3537, WorldLocations.fromBounds(2113, 5182, 2174, 5057)));
        WORLD_AREAS.add(WorldLocations.surface("Dorgesh-Kaan", 3208, 3618, WorldLocations.fromBounds(2689, 5502, 2878, 5252)));
        WorldSurface dwarven_mines = WorldLocations.surface("Dwarven Mines", 0, 0, WorldLocations.fromBounds(2962, 9852, 3223, 9664));
        WORLD_AREAS.add(WorldLocations.surface("Dwarven Mine North", 3017, 3450, WorldLocations.fromBounds(2962, 9852, 3060, 9794)).setParent(dwarven_mines));
        WORLD_AREAS.add(WorldLocations.surface("Dwarven Mine South", 3058, 3376, WorldLocations.fromBounds(3031, 9794, 3062, 9756)).setParent(dwarven_mines));
        WORLD_AREAS.add(WorldLocations.surface("Mining Guild Basement", 3018, 3339, WorldLocations.fromBounds(3002, 9756, 3056, 9699)).setParent(dwarven_mines));
        WORLD_AREAS.add(WorldLocations.surface("Motherload Mine", 3058, 3376, WorldLocations.fromBounds(3074, 9725, 3223, 9666)).setParent(dwarven_mines));
        WorldSurface fh_under = WorldLocations.surface("Feldip Hills Underground", 0, 0, WorldLocations.fromBounds(1669, 9199, 2071, 8860));
        WORLD_AREAS.add(WorldLocations.surface("Crumbling Tower Basement", 2130, 2994, WorldLocations.fromBounds(1671, 9198, 1687, 9189)).setParent(fh_under));
        WORLD_AREAS.add(WorldLocations.surface("Isle of Souls Dungeon", 3208, 2919, WorldLocations.fromBounds(1793, 9149, 1853, 9093)).setParent(fh_under));
        WORLD_AREAS.add(WorldLocations.surface("Red Chinchompa Hunting Ground", 2525, 2894, WorldLocations.fromBounds(2015, 9092, 2038, 9071)).setParent(fh_under));
        WORLD_AREAS.add(WorldLocations.surface("Myths' Guild Dungeon", 2456, 2847, WorldLocations.fromBounds(1883, 9023, 1953, 8963)).setParent(fh_under));
        WORLD_AREAS.add(WorldLocations.surface("Corsair Cove Dungeon", 2525, 2894, WorldLocations.fromBounds(1953, 9085, 1987, 8970), WorldLocations.fromBounds(1987, 9012, 2072, 8962)).setParent(fh_under));
        WorldSurface fi_under = WorldLocations.surface("Fossil Island Underground", 0, 0, WorldLocations.fromBounds(3585, 10302, 3918, 10113));
        WORLD_AREAS.add(WorldLocations.surface("Wyvern Cave (Task)", 3677, 3854, WorldLocations.fromBounds(3585, 10302, 3645, 10242)).setParent(fi_under));
        WORLD_AREAS.add(WorldLocations.surface("Wyvern Cave", 3745, 3779, WorldLocations.fromBounds(3585, 10237, 3647, 10241)).setParent(fi_under));
        WORLD_AREAS.add(WorldLocations.surface("Underwater", 3765, 3898, WorldLocations.fromBounds(3716, 10301, 3837, 10241)).setParent(fi_under));
        WORLD_AREAS.add(WorldLocations.surface("Volcanic Mine", 3815, 3808, WorldLocations.fromBounds(3779, 10229, 3836, 10114), WorldLocations.fromBounds(3890, 10239, 3917, 10190)).setParent(fi_under));
        WORLD_AREAS.add(WorldLocations.surface("Fremennik Slayer Cave", 2796, 3615, WorldLocations.fromBounds(2691, 10044, 2811, 9920)));
        WORLD_AREAS.add(WorldLocations.surface("God Wars Dungeon", 2917, 3746, WorldLocations.fromBounds(2820, 5373, 2962, 5157)));
        WorldSurface karamja_ug = WorldLocations.surface("Karamja Underground", 0, 0, WorldLocations.fromBounds(2560, 9662, 2940, 9375));
        WORLD_AREAS.add(WorldLocations.surface("Crandor Dungeon", 2833, 3256, WorldLocations.fromBounds(2827, 9661, 2866, 9546)).setParent(karamja_ug));
        WORLD_AREAS.add(WorldLocations.surface("Jogre Dungeon", 2824, 3118, WorldLocations.fromBounds(2822, 9532, 2939, 9414)).setParent(karamja_ug));
        WORLD_AREAS.add(WorldLocations.surface("Shilo Village Mine", 2824, 2942, WorldLocations.fromBounds(2826, 9399, 2858, 9377)).setParent(karamja_ug));
        WORLD_AREAS.add(WorldLocations.surface("Brimhaven Agility Arena", 2808, 3194, WorldLocations.fromBounds(2757, 9594, 2809, 9542)).setParent(karamja_ug));
        WORLD_AREAS.add(WorldLocations.surface("Brimhaven Dungeon North", 2743, 3154, WorldLocations.fromBounds(2561, 9598, 2618, 9473), WorldLocations.fromBounds(2629, 9598, 2734, 9498)).setParent(karamja_ug));
        WORLD_AREAS.add(WorldLocations.surface("Brimhaven Dungeon South", 2759, 3062, WorldLocations.fromBounds(2627, 9498, 2749, 9412), WorldLocations.fromBounds(2730, 9510, 2746, 9496)).setParent(karamja_ug));
        WorldSurface kebos_ug = WorldLocations.surface("Kebos Underground", 0, 0, WorldLocations.fromBounds(1115, 10287, 1380, 9925));
        WORLD_AREAS.add(WorldLocations.surface("Karuulm Slayer Dungeon", 1308, 3807, WorldLocations.fromBounds(1117, 10285, 1379, 10129)).setParent(kebos_ug));
        WORLD_AREAS.add(WorldLocations.surface("Hespori Patch", 1232, 3729, WorldLocations.fromBounds(1175, 10079, 1191, 10063)).setParent(kebos_ug));
        WORLD_AREAS.add(WorldLocations.surface("Lizardman Temple", 1311, 3685, WorldLocations.fromBounds(1281, 10063, 1343, 9999)).setParent(kebos_ug));
        WORLD_AREAS.add(WorldLocations.surface("Lizardman Caves", 1306, 3574, WorldLocations.fromBounds(1284, 9958, 1335, 9927)).setParent(kebos_ug));
        WORLD_AREAS.add(WorldLocations.surface("Keldagrim", 2730, 3713, WorldLocations.fromBounds(2816, 10239, 2943, 10079)));
        WorldSurface kharidian_ug = WorldLocations.surface("Kharidian Desert Underground", 0, 0, WorldLocations.fromBounds(1244, 10212, 1956, 9692));
        WORLD_AREAS.add(WorldLocations.surface("Kalphite Cave", 3319, 3122, WorldLocations.fromBounds(3330, 9542, 3404, 9474)).setParent(kharidian_ug));
        WORLD_AREAS.add(WorldLocations.surface("Kalphite Lair", 3226, 3108, WorldLocations.fromBounds(3171, 9530, 3230, 9408)).setParent(kharidian_ug));
        WORLD_AREAS.add(WorldLocations.surface("Giant's Foundry", 3360, 3150, WorldLocations.fromBounds(3432, 9606, 3477, 9578)).setParent(kharidian_ug));
        WorldSurface kourend_ug = WorldLocations.surface("Kourend Underground", 0, 0, WorldLocations.fromBounds(1347, 10173, 1877, 9793));
        WORLD_AREAS.add(WorldLocations.surface("Kourend Underground", 1470, 3653, WorldLocations.fromBounds(1600, 10111, 1729, 9979)).setParent(kourend_ug));
        WORLD_AREAS.add(WorldLocations.surface("Chasm of Fire", 1433, 3670, WorldLocations.fromBounds(1346, 10107, 1404, 9859)).setParent(kourend_ug));
        WORLD_AREAS.add(WorldLocations.surface("Shayzien Crypts", 1482, 3549, WorldLocations.fromBounds(1446, 10107, 1497, 9865)).setParent(kourend_ug));
        WORLD_AREAS.add(WorldLocations.surface("Giant's Den", 1420, 3588, WorldLocations.fromBounds(1413, 9850, 1467, 9795)).setParent(kourend_ug));
        WORLD_AREAS.add(WorldLocations.surface("Woodcutting Guild Dungeon", 1603, 3508, WorldLocations.fromBounds(1544, 9914, 1598, 9862)).setParent(kourend_ug));
        WORLD_AREAS.add(WorldLocations.surface("Crabclaw Caves", 1643, 3449, WorldLocations.fromBounds(1644, 9849, 1723, 9792)).setParent(kourend_ug));
        WORLD_AREAS.add(WorldLocations.surface("Forthos dungeon", 1701, 3574, WorldLocations.fromBounds(1794, 9979, 1854, 9882)).setParent(kourend_ug));
        WORLD_AREAS.add(WorldLocations.surface("The Warrens", 1812, 3745, WorldLocations.fromBounds(1793, 10174, 1876, 10114)).setParent(kourend_ug));
        WORLD_AREAS.add(WorldLocations.surface("Lair of Tarn Razorlor", 0, 0, WorldLocations.fromBounds(3138, 4637, 3390, 4545)));
        WORLD_AREAS.add(WorldLocations.surface("LMS Desert Island", 3138, 3635, WorldLocations.fromBounds(3392, 5887, 3519, 5760)));
        WORLD_AREAS.add(WorldLocations.surface("LMS Wild Varrock", 3138, 3635, WorldLocations.fromBounds(3456, 6206, 3646, 6016)));
        WorldSurface misc_ug = WorldLocations.surface("Miscellania Underground", 0, 0, WorldLocations.fromBounds(2012, 10468, 2916, 10076));
        WORLD_AREAS.add(WorldLocations.surface("Miscellania / Etcetera Dungeon", 2619, 3865, WorldLocations.fromBounds(2500, 10301, 2621, 10243)).setParent(misc_ug));
        WORLD_AREAS.add(WorldLocations.surface("Ice Troll Cave", 2401, 3889, WorldLocations.fromBounds(2375, 10302, 2426, 10241)).setParent(misc_ug));
        WORLD_AREAS.add(WorldLocations.surface("Jormungand's Prison", 2464, 4012, WorldLocations.fromBounds(2398, 10467, 2492, 10371)).setParent(misc_ug));
        WORLD_AREAS.add(WorldLocations.surface("Salt Mine", 2866, 3941, WorldLocations.fromBounds(2829, 10354, 2858, 10326)).setParent(misc_ug));
        WorldSurface mist_ug = WorldLocations.surface("Misthalin Underground", 0, 0, WorldLocations.fromBounds(2972, 10084, 3364, 9372));
        WORLD_AREAS.add(WorldLocations.surface("Edgeville Dungeon", 3115, 3452, WorldLocations.fromBounds(3073, 9999, 3152, 9793)).setParent(mist_ug));
        WORLD_AREAS.add(WorldLocations.surface("Varrock Sewers", 3241, 3428, WorldLocations.fromBounds(3153, 9918, 3287, 9858)).setParent(mist_ug));
        WORLD_AREAS.add(WorldLocations.surface("Draynor Manor Basement", 3114, 3357, WorldLocations.fromBounds(3075, 9778, 3118, 9744)).setParent(mist_ug));
        WORLD_AREAS.add(WorldLocations.surface("Champions' Challenge", 3189, 3355, WorldLocations.fromBounds(3150, 9772, 3188, 9743)).setParent(mist_ug));
        WORLD_AREAS.add(WorldLocations.surface("VTAM Corporation", 3244, 3384, WorldLocations.fromBounds(3230, 9806, 3254, 9761), WorldLocations.fromBounds(3187, 9834, 3196, 9818)).setParent(mist_ug));
        WORLD_AREAS.add(WorldLocations.surface("Draynor Sewers", 3083, 3272, WorldLocations.fromBounds(3081, 9697, 3126, 9643)).setParent(mist_ug));
        WORLD_AREAS.add(WorldLocations.surface("Sourhog Cave", 3150, 3347, WorldLocations.fromBounds(3153, 9719, 3182, 9670)).setParent(mist_ug));
        WORLD_AREAS.add(WorldLocations.surface("Watermill Cellar", 2866, 3941, WorldLocations.fromBounds(3206, 9705, 3246, 9662)).setParent(mist_ug));
        WORLD_AREAS.add(WorldLocations.surface("H.A.M. Cult", 2866, 3941, WorldLocations.fromBounds(3140, 9658, 3188, 9606)).setParent(mist_ug));
        WORLD_AREAS.add(WorldLocations.surface("Lumbridge Castle Cellar", 3209, 3218, WorldLocations.fromBounds(3208, 9625, 3219, 9615)).setParent(mist_ug));
        WORLD_AREAS.add(WorldLocations.surface("Goblin Mine", 3209, 3218, WorldLocations.fromBounds(3309, 9654, 3326, 9600)).setParent(mist_ug));
        WORLD_AREAS.add(WorldLocations.surface("Goblin Maze", 3209, 3218, WorldLocations.fromBounds(3221, 9658, 3308, 9603)).setParent(mist_ug));
        WORLD_AREAS.add(WorldLocations.surface("Lumbridge Swamp Caves", 3168, 3172, WorldLocations.fromBounds(3144, 9601, 3261, 9487)).setParent(mist_ug));
        WORLD_AREAS.add(WorldLocations.surface("Wizard's Tower Basement", 3103, 3162, WorldLocations.fromBounds(3096, 9577, 3121, 9555)).setParent(mist_ug));
        WORLD_AREAS.add(WorldLocations.surface("Mole Hole", 2985, 3387, WorldLocations.fromBounds(1732, 5244, 1787, 5132)));
        WORLD_AREAS.add(WorldLocations.surface("Morytania Underground", 0, 0, WorldLocations.fromBounds(3386, 9975, 3903, 9581)));
        WORLD_AREAS.add(WorldLocations.surface("Mos Le'Harmless Cave", 3747, 2973, WorldLocations.fromBounds(3716, 9469, 3837, 9348)));
        WORLD_AREAS.add(WorldLocations.surface("Ourania Altar", 2450, 3231, WorldLocations.fromBounds(3009, 5630, 3070, 5569)));
        WORLD_AREAS.add(WorldLocations.surface("Stronghold of Security", 3080, 3421, WorldLocations.fromBounds(1856, 5247, 1915, 5184), WorldLocations.fromBounds(1984, 5247, 2042, 5184), WorldLocations.fromBounds(2113, 5247, 2176, 5184), WorldLocations.fromBounds(2304, 5247, 2367, 5184)));
        WorldSurface strong_ug = WorldLocations.surface("Stronghold Underground", 0, 0, WorldLocations.fromBounds(2140, 10084, 2596, 9628));
        WORLD_AREAS.add(WorldLocations.surface("Kraken Cave", 2277, 3611, WorldLocations.fromBounds(2242, 10044, 2301, 9987)).setParent(strong_ug));
        WORLD_AREAS.add(WorldLocations.surface("Grand Tree Tunnels", 2462, 3496, WorldLocations.fromBounds(2433, 9918, 2494, 9858)).setParent(strong_ug));
        WORLD_AREAS.add(WorldLocations.surface("Brimstail Cave", 2401, 3419, WorldLocations.fromBounds(2379, 9830, 2396, 9805), WorldLocations.fromBounds(2397, 9832, 2414, 9811)).setParent(strong_ug));
        WORLD_AREAS.add(WorldLocations.surface("Stronghold Slayer Dungeon", 2427, 3424, WorldLocations.fromBounds(2415, 9838, 2495, 9768), WorldLocations.fromBounds(2392, 9806, 2414, 9768), WorldLocations.fromBounds(2388, 9787, 2392, 9777)).setParent(strong_ug));
        WORLD_AREAS.add(WorldLocations.surface("Taverley Underground", 0, 0, WorldLocations.fromBounds(2656, 10006, 2994, 9602)));
        WORLD_AREAS.add(WorldLocations.surface("The Abyss", 3082, 3487, WorldLocations.fromBounds(2950, 4924, 3131, 4737)));
        WORLD_AREAS.add(WorldLocations.surface("Tolna's Rift", 3308, 3449, WorldLocations.fromBounds(3266, 9855, 3326, 9793)));
        WORLD_AREAS.add(WorldLocations.surface("Troll Stronghold", 2738, 3543, WorldLocations.fromBounds(2822, 10174, 2990, 10049)));
        WORLD_AREAS.add(WorldLocations.surface("Tutorial Island", 3127, 3037, WorldLocations.fromBounds(1640, 6141, 1760, 6057)));
        WORLD_AREAS.add(WorldLocations.surface("Wilderness Dungeons", 0, 0, WorldLocations.fromBounds(2935, 10369, 3451, 10047)));
        WorldSurface yanille_ug = WorldLocations.surface("Yanille Underground", 0, 0, WorldLocations.fromBounds(2204, 9572, 2724, 9308));
        WORLD_AREAS.add(WorldLocations.surface("Smoke Devils Dungeon", 2412, 3061, WorldLocations.fromBounds(2347, 9468, 2426, 9415)).setParent(yanille_ug));
        WORLD_AREAS.add(WorldLocations.surface("Wizard's Guild Basement", 2593, 3085, WorldLocations.fromBounds(2582, 9493, 2594, 9484)).setParent(yanille_ug));
        WORLD_AREAS.add(WorldLocations.surface("Yanille Agility Dungeon", 2603, 3078, WorldLocations.fromBounds(2595, 9525, 2639, 9474), WorldLocations.fromBounds(2561, 9533, 2595, 9496)).setParent(yanille_ug));
        WORLD_AREAS.add(WorldLocations.surface("Zanaris", 3203, 3169, WorldLocations.fromBounds(2370, 4478, 2493, 4355)));
        WORLD_AREAS.add(WorldLocations.surface("Temporos", 3136, 2841, WorldLocations.fromBounds(12649, 26554478, 12699, 2605)));
    }

    public static final class WorldSurface {
        public final String name;
        public final WorldArea[] areas;
        public final WorldPoint entry;
        public WorldSurface parent;

        public WorldSurface(String name, WorldPoint entry, WorldArea ... areas) {
            this.name = name;
            this.areas = areas;
            this.entry = entry;
        }

        public WorldSurface setParent(WorldSurface parent) {
            this.parent = parent;
            return this;
        }

        public boolean contains(WorldPoint point) {
            for (WorldArea area : this.areas) {
                if (area.getX() > point.getX() || point.getX() > area.getX() + area.getWidth() || area.getY() > point.getY() || point.getY() > area.getY() + area.getHeight()) continue;
                return true;
            }
            return false;
        }
    }
}

