/*
 * Decompiled with CFR 0.152.
 */
package com.sololegends.runelite.helpers;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.sololegends.runelite.FriendMapPoint;
import com.sololegends.runelite.FriendsOnMapConfig;
import com.sololegends.runelite.FriendsOnMapPlugin;
import com.sololegends.runelite.skills.Health;
import com.sololegends.runelite.skills.Prayer;
import java.io.IOException;
import java.net.MalformedURLException;
import javax.inject.Inject;
import net.runelite.api.Point;
import net.runelite.api.coords.WorldPoint;
import okhttp3.Call;
import okhttp3.Callback;
import okhttp3.MediaType;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;

public class RemoteDataManager {
    private volatile boolean in_progress = false;
    @Inject
    private FriendsOnMapPlugin plugin;
    @Inject
    private FriendsOnMapConfig config;
    @Inject
    private OkHttpClient http_client;

    public void sendRequest(JsonObject data) {
        if (this.in_progress) {
            return;
        }
        this.in_progress = true;
        Request.Builder req_builder = new Request.Builder().url(this.config.friendsAPI()).post(RequestBody.create((MediaType)MediaType.get((String)"application/json"), (String)data.toString()));
        this.http_client.newCall(req_builder.build()).enqueue(new Callback(){

            public void onFailure(Call call, IOException e) {
                RemoteDataManager.this.in_progress = false;
                if (e instanceof MalformedURLException) {
                    RemoteDataManager.this.plugin.message("Failed to retrieve friends from friends api: Invalid API URL");
                    return;
                }
                RemoteDataManager.this.plugin.message("Failed to retrieve friends from friends api: API Call Failed");
            }

            public void onResponse(Call call, Response resp) throws IOException {
                JsonArray my_friends;
                if (resp.code() != 200) {
                    RemoteDataManager.this.plugin.message("Failed to retrieve friends from friends api [RC2]");
                    RemoteDataManager.this.plugin.updated(System.currentTimeMillis() + (long)(RemoteDataManager.this.config.updateInterval().interval() * 9));
                    RemoteDataManager.this.in_progress = false;
                    return;
                }
                JsonElement arr = new JsonParser().parse(resp.body().string());
                if (arr.isJsonArray() && (my_friends = arr.getAsJsonArray()) != null && my_friends.size() > 0) {
                    for (JsonElement e : my_friends) {
                        JsonObject f;
                        if (!e.isJsonObject() || !(f = e.getAsJsonObject()).has("x") || !f.has("y") || !f.has("z") || !f.has("name") || !f.has("w")) continue;
                        String tool_tip = f.get("name").getAsString() + " -- World: " + f.get("w").getAsString();
                        FriendMapPoint wmp = new FriendMapPoint(new WorldPoint(f.get("x").getAsInt(), f.get("y").getAsInt(), f.get("z").getAsInt()), RemoteDataManager.this.plugin.getIcon(!RemoteDataManager.this.plugin.isCurrentWorld(f.get("w").getAsInt()), false, tool_tip, false), f.get("name").getAsString(), f.get("w").getAsInt()){

                            @Override
                            public void onEdgeSnap() {
                                super.onEdgeSnap();
                                RemoteDataManager.this.plugin.updateFriendPointIcon(this, true);
                            }

                            @Override
                            public void onEdgeUnsnap() {
                                super.onEdgeUnsnap();
                                RemoteDataManager.this.plugin.updateFriendPointIcon(this, true);
                            }
                        };
                        int ds = RemoteDataManager.this.config.dotSize();
                        wmp.setImagePoint(new Point(ds / 2, ds / 2));
                        wmp.setName(f.get("name").getAsString());
                        wmp.setTooltip(tool_tip);
                        wmp.setSnapToEdge(true);
                        if (f.has("r")) {
                            wmp.setRegion(f.get("r").getAsInt());
                        }
                        if (f.has("hm") && f.get("hm").getAsInt() != -1 && f.has("hM") && f.get("hM").getAsInt() != -1) {
                            wmp.setHealth(new Health(f.get("hm").getAsInt(), f.get("hM").getAsInt()));
                        }
                        if (f.has("pm") && f.get("pm").getAsInt() != -1 && f.has("pM") && f.get("pM").getAsInt() != -1) {
                            wmp.setPrayer(new Prayer(f.get("pm").getAsInt(), f.get("pM").getAsInt()));
                        }
                        RemoteDataManager.this.plugin.addPoint(wmp);
                    }
                }
                RemoteDataManager.this.plugin.updatePanel();
                RemoteDataManager.this.plugin.updated(System.currentTimeMillis());
                RemoteDataManager.this.in_progress = false;
            }
        });
    }
}

