/*
 * Decompiled with CFR 0.152.
 */
package com.sololegends.runelite.data;

import com.sololegends.runelite.helpers.WorldLocations;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import net.runelite.api.coords.WorldArea;
import net.runelite.api.coords.WorldPoint;

public class WorldRegions {
    private static final Map<Integer, WorldLocations.WorldSurface> REGIONS = new ConcurrentHashMap<Integer, WorldLocations.WorldSurface>();

    public static WorldArea fromBounds(int x, int y2, int x2, int y) {
        return new WorldArea(x, y, x2 - x, y2 - y, 0);
    }

    public static WorldLocations.WorldSurface surface(String name, int eX, int eY, WorldArea ... areas) {
        return new WorldLocations.WorldSurface(name, new WorldPoint(eX, eY, 0), areas);
    }

    private static void addRegion(WorldLocations.WorldSurface surface, int ... region_ids) {
        for (int i : region_ids) {
            if (REGIONS.containsKey(i)) {
                System.out.println("FFP => WARNING: Duplicate Region ID registered [" + surface.name + ":" + i + "]");
            }
            REGIONS.put(i, surface);
        }
    }

    public static WorldLocations.WorldSurface fromRegion(int region) {
        return REGIONS.get(region);
    }

    static {
        WorldRegions.addRegion(WorldRegions.surface("Abyssal Sire", 0, 0, WorldRegions.fromBounds(0, 0, 0, 0)), 11851, 11850, 12363, 12362);
        WorldRegions.addRegion(WorldRegions.surface("Cerberus", 0, 0, WorldRegions.fromBounds(0, 0, 0, 0)), 4883, 5140, 5395);
        WorldRegions.addRegion(WorldRegions.surface("Commander Zilyana", 0, 0, WorldRegions.fromBounds(0, 0, 0, 0)), 11602);
        WorldRegions.addRegion(WorldRegions.surface("Corporeal Beast", 0, 0, WorldRegions.fromBounds(0, 0, 0, 0)), 11842, 11844);
        WorldRegions.addRegion(WorldRegions.surface("Dagannoth Kings", 0, 0, WorldRegions.fromBounds(0, 0, 0, 0)), 11588, 11589);
        WorldRegions.addRegion(WorldRegions.surface("General Graardor", 0, 0, WorldRegions.fromBounds(0, 0, 0, 0)), 11347);
        WorldRegions.addRegion(WorldRegions.surface("Giant Mole", 0, 0, WorldRegions.fromBounds(0, 0, 0, 0)), 6993, 6992);
        WorldRegions.addRegion(WorldRegions.surface("Grotesque Guardians", 0, 0, WorldRegions.fromBounds(0, 0, 0, 0)), 6727);
        WorldRegions.addRegion(WorldRegions.surface("Hespori", 0, 0, WorldRegions.fromBounds(0, 0, 0, 0)), 5021);
        WorldRegions.addRegion(WorldRegions.surface("Alchemical Hydra", 0, 0, WorldRegions.fromBounds(0, 0, 0, 0)), 5536);
        WorldRegions.addRegion(WorldRegions.surface("Kalphite Queen", 0, 0, WorldRegions.fromBounds(0, 0, 0, 0)), 13972);
        WorldRegions.addRegion(WorldRegions.surface("Kraken", 0, 0, WorldRegions.fromBounds(0, 0, 0, 0)), 9116);
        WorldRegions.addRegion(WorldRegions.surface("Kree'arra", 0, 0, WorldRegions.fromBounds(0, 0, 0, 0)), 11346);
        WorldRegions.addRegion(WorldRegions.surface("K'ril Tsutsaroth", 0, 0, WorldRegions.fromBounds(0, 0, 0, 0)), 11603);
        WorldRegions.addRegion(WorldRegions.surface("Nex", 0, 0, WorldRegions.fromBounds(0, 0, 0, 0)), 11601);
        WorldRegions.addRegion(WorldRegions.surface("Nightmare of Ashihama", 0, 0, WorldRegions.fromBounds(0, 0, 0, 0)), 15515);
        WorldRegions.addRegion(WorldRegions.surface("Sarachnis", 0, 0, WorldRegions.fromBounds(0, 0, 0, 0)), 7322);
        WorldRegions.addRegion(WorldRegions.surface("Skotizo", 0, 0, WorldRegions.fromBounds(0, 0, 0, 0)), 6810);
        WorldRegions.addRegion(WorldRegions.surface("Thermonuclear smoke devil", 0, 0, WorldRegions.fromBounds(0, 0, 0, 0)), 9363, 9619);
        WorldRegions.addRegion(WorldRegions.surface("Tempoross", 0, 0, WorldRegions.fromBounds(0, 0, 0, 0)), 12078);
        WorldRegions.addRegion(WorldRegions.surface("Vorkath", 0, 0, WorldRegions.fromBounds(0, 0, 0, 0)), 9023);
        WorldRegions.addRegion(WorldRegions.surface("Wintertodt", 0, 0, WorldRegions.fromBounds(0, 0, 0, 0)), 6462);
        WorldRegions.addRegion(WorldRegions.surface("Zalcano", 0, 0, WorldRegions.fromBounds(0, 0, 0, 0)), 12126);
        WorldRegions.addRegion(WorldRegions.surface("Zulrah", 0, 0, WorldRegions.fromBounds(0, 0, 0, 0)), 9007);
        WorldRegions.addRegion(WorldRegions.surface("Abandoned Mine", 0, 0, WorldRegions.fromBounds(0, 0, 0, 0)), 13618, 13718, 11079, 11078, 11077, 10823, 10822, 10821);
        WorldRegions.addRegion(WorldRegions.surface("Ah Za Rhoon", 0, 0, WorldRegions.fromBounds(0, 0, 0, 0)), 11666);
        WorldRegions.addRegion(WorldRegions.surface("Ancient Cavern", 0, 0, WorldRegions.fromBounds(0, 0, 0, 0)), 6483, 6995);
        WorldRegions.addRegion(WorldRegions.surface("Ape Atoll Dungeon", 0, 0, WorldRegions.fromBounds(0, 0, 0, 0)), 11150, 10894);
        WorldRegions.addRegion(WorldRegions.surface("Ape Atoll Banana Plantation", 0, 0, WorldRegions.fromBounds(0, 0, 0, 0)), 10895);
        WorldRegions.addRegion(WorldRegions.surface("West Ardougne Basement", 0, 0, WorldRegions.fromBounds(0, 0, 0, 0)), 10135);
        WorldRegions.addRegion(WorldRegions.surface("Ardougne Sewers", 0, 0, WorldRegions.fromBounds(0, 0, 0, 0)), 10134, 10136, 10391, 10647);
        WorldRegions.addRegion(WorldRegions.surface("Asgarnian Ice Caves", 0, 0, WorldRegions.fromBounds(0, 0, 0, 0)), 11925, 12181);
        WorldRegions.addRegion(WorldRegions.surface("Tomb of Bervirius", 0, 0, WorldRegions.fromBounds(0, 0, 0, 0)), 11154);
        WorldRegions.addRegion(WorldRegions.surface("Brimhaven Dungeon", 0, 0, WorldRegions.fromBounds(0, 0, 0, 0)), 10901, 10900, 10899, 10645, 10644, 10643);
        WorldRegions.addRegion(WorldRegions.surface("Brine Rat Cavern", 0, 0, WorldRegions.fromBounds(0, 0, 0, 0)), 10910);
        WorldRegions.addRegion(WorldRegions.surface("Catacombs of Kourend", 0, 0, WorldRegions.fromBounds(0, 0, 0, 0)), 6557, 6556, 6813, 6812);
        WorldRegions.addRegion(WorldRegions.surface("Champions' Challenge", 0, 0, WorldRegions.fromBounds(0, 0, 0, 0)), 12696);
        WorldRegions.addRegion(WorldRegions.surface("Chaos Druid Tower", 0, 0, WorldRegions.fromBounds(0, 0, 0, 0)), 10392);
        WorldRegions.addRegion(WorldRegions.surface("Chasm of Fire", 0, 0, WorldRegions.fromBounds(0, 0, 0, 0)), 5789);
        WorldRegions.addRegion(WorldRegions.surface("Chasm of Tears", 0, 0, WorldRegions.fromBounds(0, 0, 0, 0)), 12948);
        WorldRegions.addRegion(WorldRegions.surface("Chinchompa Hunting Ground", 0, 0, WorldRegions.fromBounds(0, 0, 0, 0)), 10129);
        WorldRegions.addRegion(WorldRegions.surface("Clock Tower Basement", 0, 0, WorldRegions.fromBounds(0, 0, 0, 0)), 10390);
        WorldRegions.addRegion(WorldRegions.surface("Corsair Cove Dungeon", 0, 0, WorldRegions.fromBounds(0, 0, 0, 0)), 8076, 8332);
        WorldRegions.addRegion(WorldRegions.surface("Crabclaw Caves", 0, 0, WorldRegions.fromBounds(0, 0, 0, 0)), 6553, 6809);
        WorldRegions.addRegion(WorldRegions.surface("Crandor Dungeon", 0, 0, WorldRegions.fromBounds(0, 0, 0, 0)), 11414);
        WorldRegions.addRegion(WorldRegions.surface("Crash Site Cavern", 0, 0, WorldRegions.fromBounds(0, 0, 0, 0)), 8280, 8536);
        WorldRegions.addRegion(WorldRegions.surface("Crumbling Tower", 0, 0, WorldRegions.fromBounds(0, 0, 0, 0)), 7827);
        WorldRegions.addRegion(WorldRegions.surface("Daeyalt Essence Mine", 0, 0, WorldRegions.fromBounds(0, 0, 0, 0)), 14744);
        WorldRegions.addRegion(WorldRegions.surface("Digsite Dungeon", 0, 0, WorldRegions.fromBounds(0, 0, 0, 0)), 13464, 13465);
        WorldRegions.addRegion(WorldRegions.surface("Dorgesh-Kaan South Dungeon", 0, 0, WorldRegions.fromBounds(0, 0, 0, 0)), 10833);
        WorldRegions.addRegion(WorldRegions.surface("Dorgeshuun Mines", 0, 0, WorldRegions.fromBounds(0, 0, 0, 0)), 12950, 13206);
        WorldRegions.addRegion(WorldRegions.surface("Draynor Sewers", 0, 0, WorldRegions.fromBounds(0, 0, 0, 0)), 12439, 12438);
        WorldRegions.addRegion(WorldRegions.surface("Dwarven Mines", 0, 0, WorldRegions.fromBounds(0, 0, 0, 0)), 12185, 12184, 12183);
        WorldRegions.addRegion(WorldRegions.surface("Eagles' Peak Dungeon", 0, 0, WorldRegions.fromBounds(0, 0, 0, 0)), 8013);
        WorldRegions.addRegion(WorldRegions.surface("Ectofuntus", 0, 0, WorldRegions.fromBounds(0, 0, 0, 0)), 14746);
        WorldRegions.addRegion(WorldRegions.surface("Edgeville Dungeon", 0, 0, WorldRegions.fromBounds(0, 0, 0, 0)), 12441, 12442, 12443, 12698);
        WorldRegions.addRegion(WorldRegions.surface("Elemental Workshop", 0, 0, WorldRegions.fromBounds(0, 0, 0, 0)), 10906, 7760);
        WorldRegions.addRegion(WorldRegions.surface("Elven rabbit cave", 0, 0, WorldRegions.fromBounds(0, 0, 0, 0)), 13252);
        WorldRegions.addRegion(WorldRegions.surface("Enakhra's Temple", 0, 0, WorldRegions.fromBounds(0, 0, 0, 0)), 12423);
        WorldRegions.addRegion(WorldRegions.surface("Evil Chicken's Lair", 0, 0, WorldRegions.fromBounds(0, 0, 0, 0)), 9796);
        WorldRegions.addRegion(WorldRegions.surface("Experiment Cave", 0, 0, WorldRegions.fromBounds(0, 0, 0, 0)), 14235, 13979);
        WorldRegions.addRegion(WorldRegions.surface("Ferox Enclave Dungeon", 0, 0, WorldRegions.fromBounds(0, 0, 0, 0)), 12700);
        WorldRegions.addRegion(WorldRegions.surface("Forthos Dungeon", 0, 0, WorldRegions.fromBounds(0, 0, 0, 0)), 7323);
        WorldRegions.addRegion(WorldRegions.surface("Fremennik Slayer Dungeon", 0, 0, WorldRegions.fromBounds(0, 0, 0, 0)), 10907, 10908, 11164);
        WorldRegions.addRegion(WorldRegions.surface("Glarial's Tomb", 0, 0, WorldRegions.fromBounds(0, 0, 0, 0)), 10137);
        WorldRegions.addRegion(WorldRegions.surface("Goblin Cave", 0, 0, WorldRegions.fromBounds(0, 0, 0, 0)), 10393);
        WorldRegions.addRegion(WorldRegions.surface("Grand Tree Tunnels", 0, 0, WorldRegions.fromBounds(0, 0, 0, 0)), 9882);
        WorldRegions.addRegion(WorldRegions.surface("H.A.M. Hideout", 0, 0, WorldRegions.fromBounds(0, 0, 0, 0)), 12694);
        WorldRegions.addRegion(WorldRegions.surface("H.A.M. Store room", 0, 0, WorldRegions.fromBounds(0, 0, 0, 0)), 10321);
        WorldRegions.addRegion(WorldRegions.surface("Heroes' Guild Mine", 0, 0, WorldRegions.fromBounds(0, 0, 0, 0)), 11674);
        WorldRegions.addRegion(WorldRegions.surface("Iorwerth Dungeon", 0, 0, WorldRegions.fromBounds(0, 0, 0, 0)), 12737, 12738, 12993, 12994);
        WorldRegions.addRegion(WorldRegions.surface("Isle of Souls Dungeon", 0, 0, WorldRegions.fromBounds(0, 0, 0, 0)), 8593);
        WorldRegions.addRegion(WorldRegions.surface("Jatizso Mines", 0, 0, WorldRegions.fromBounds(0, 0, 0, 0)), 9631);
        WorldRegions.addRegion(WorldRegions.surface("Jiggig Burial Tomb", 0, 0, WorldRegions.fromBounds(0, 0, 0, 0)), 9875, 9874);
        WorldRegions.addRegion(WorldRegions.surface("Jogre Dungeon", 0, 0, WorldRegions.fromBounds(0, 0, 0, 0)), 11412);
        WorldRegions.addRegion(WorldRegions.surface("Karamja Dungeon", 0, 0, WorldRegions.fromBounds(0, 0, 0, 0)), 11413);
        WorldRegions.addRegion(WorldRegions.surface("Karuulm Slayer Dungeon", 0, 0, WorldRegions.fromBounds(0, 0, 0, 0)), 5280, 5279, 5023, 5535, 5022, 4766, 4510, 4511, 4767, 4768, 4512);
        WorldRegions.addRegion(WorldRegions.surface("KGP Headquarters", 0, 0, WorldRegions.fromBounds(0, 0, 0, 0)), 10658);
        WorldRegions.addRegion(WorldRegions.surface("Kruk's Dungeon", 0, 0, WorldRegions.fromBounds(0, 0, 0, 0)), 9358, 9359, 9360, 9615, 9616, 9871, 10125, 10126, 10127, 10128, 10381, 10382, 10383, 10384, 10637, 10638, 10639, 10640);
        WorldRegions.addRegion(WorldRegions.surface("Legends' Guild Dungeon", 0, 0, WorldRegions.fromBounds(0, 0, 0, 0)), 10904);
        WorldRegions.addRegion(WorldRegions.surface("Lighthouse", 0, 0, WorldRegions.fromBounds(0, 0, 0, 0)), 10140);
        WorldRegions.addRegion(WorldRegions.surface("Lizardman Caves", 0, 0, WorldRegions.fromBounds(0, 0, 0, 0)), 5275);
        WorldRegions.addRegion(WorldRegions.surface("Lizardman Temple", 0, 0, WorldRegions.fromBounds(0, 0, 0, 0)), 5277);
        WorldRegions.addRegion(WorldRegions.surface("Lumbridge Swamp Caves", 0, 0, WorldRegions.fromBounds(0, 0, 0, 0)), 12693, 12949);
        WorldRegions.addRegion(WorldRegions.surface("Lunar Isle Mine", 0, 0, WorldRegions.fromBounds(0, 0, 0, 0)), 9377);
        WorldRegions.addRegion(WorldRegions.surface("Maniacal Monkey Hunter Area", 0, 0, WorldRegions.fromBounds(0, 0, 0, 0)), 11662);
        WorldRegions.addRegion(WorldRegions.surface("Meiyerditch Mine", 0, 0, WorldRegions.fromBounds(0, 0, 0, 0)), 9544);
        WorldRegions.addRegion(WorldRegions.surface("Miscellania Dungeon", 0, 0, WorldRegions.fromBounds(0, 0, 0, 0)), 10144, 10400);
        WorldRegions.addRegion(WorldRegions.surface("Mogre Camp", 0, 0, WorldRegions.fromBounds(0, 0, 0, 0)), 11924);
        WorldRegions.addRegion(WorldRegions.surface("Mos Le'Harmless Caves", 0, 0, WorldRegions.fromBounds(0, 0, 0, 0)), 14994, 14995, 15251);
        WorldRegions.addRegion(WorldRegions.surface("Motherlode Mine", 0, 0, WorldRegions.fromBounds(0, 0, 0, 0)), 14679, 14680, 14681, 14935, 14936, 14937, 15191, 15192, 15193);
        WorldRegions.addRegion(WorldRegions.surface("Mourner Tunnels", 0, 0, WorldRegions.fromBounds(0, 0, 0, 0)), 7752, 8008);
        WorldRegions.addRegion(WorldRegions.surface("Mouse Hole", 0, 0, WorldRegions.fromBounds(0, 0, 0, 0)), 9046);
        WorldRegions.addRegion(WorldRegions.surface("Myreditch Laboratories", 0, 0, WorldRegions.fromBounds(0, 0, 0, 0)), 14232, 14233, 14487, 14488);
        WorldRegions.addRegion(WorldRegions.surface("Myreque Hideout", 0, 0, WorldRegions.fromBounds(0, 0, 0, 0)), 13721, 13974, 13977, 13978);
        WorldRegions.addRegion(WorldRegions.surface("Myths' Guild Dungeon", 0, 0, WorldRegions.fromBounds(0, 0, 0, 0)), 7564, 7820, 7821);
        WorldRegions.addRegion(WorldRegions.surface("Observatory Dungeon", 0, 0, WorldRegions.fromBounds(0, 0, 0, 0)), 9362);
        WorldRegions.addRegion(WorldRegions.surface("Ogre Enclave", 0, 0, WorldRegions.fromBounds(0, 0, 0, 0)), 10387);
        WorldRegions.addRegion(WorldRegions.surface("Ourania Cave", 0, 0, WorldRegions.fromBounds(0, 0, 0, 0)), 12119);
        WorldRegions.addRegion(WorldRegions.surface("Quidamortem Cave", 0, 0, WorldRegions.fromBounds(0, 0, 0, 0)), 4763);
        WorldRegions.addRegion(WorldRegions.surface("Rashiliyta's Tomb", 0, 0, WorldRegions.fromBounds(0, 0, 0, 0)), 11668);
        WorldRegions.addRegion(WorldRegions.surface("Ruins of Camdozaal", 0, 0, WorldRegions.fromBounds(0, 0, 0, 0)), 11609, 11610, 11611, 11865, 11866, 11867, 12121, 12122, 12123);
        WorldRegions.addRegion(WorldRegions.surface("Salt Mine", 0, 0, WorldRegions.fromBounds(0, 0, 0, 0)), 11425);
        WorldRegions.addRegion(WorldRegions.surface("Saradomin Shrine (Paterdomus))", 0, 0, WorldRegions.fromBounds(0, 0, 0, 0)), 13722);
        WorldRegions.addRegion(WorldRegions.surface("Shade Catacombs", 0, 0, WorldRegions.fromBounds(0, 0, 0, 0)), 13975);
        WorldRegions.addRegion(WorldRegions.surface("Shadow Dungeon", 0, 0, WorldRegions.fromBounds(0, 0, 0, 0)), 10575, 10831);
        WorldRegions.addRegion(WorldRegions.surface("Shayzien Crypts", 0, 0, WorldRegions.fromBounds(0, 0, 0, 0)), 6043);
        WorldRegions.addRegion(WorldRegions.surface("Sisterhood Sanctuary", 0, 0, WorldRegions.fromBounds(0, 0, 0, 0)), 14999, 15000, 15001, 15255, 15256, 15257, 15511, 15512, 15513);
        WorldRegions.addRegion(WorldRegions.surface("Smoke Dungeon", 0, 0, WorldRegions.fromBounds(0, 0, 0, 0)), 12946, 13202, 12690);
        WorldRegions.addRegion(WorldRegions.surface("Sophanem Dungeon", 0, 0, WorldRegions.fromBounds(0, 0, 0, 0)), 13200);
        WorldRegions.addRegion(WorldRegions.surface("Sourhog Cave", 0, 0, WorldRegions.fromBounds(0, 0, 0, 0)), 12695);
        WorldRegions.addRegion(WorldRegions.surface("Stronghold of Security", 0, 0, WorldRegions.fromBounds(0, 0, 0, 0)), 7505, 8017, 8530, 9297);
        WorldRegions.addRegion(WorldRegions.surface("Stronghold Slayer Cave", 0, 0, WorldRegions.fromBounds(0, 0, 0, 0)), 9624, 9625, 9880, 9881);
        WorldRegions.addRegion(WorldRegions.surface("Tarn's Lair", 0, 0, WorldRegions.fromBounds(0, 0, 0, 0)), 12616, 12615);
        WorldRegions.addRegion(WorldRegions.surface("Taverley Dungeon", 0, 0, WorldRegions.fromBounds(0, 0, 0, 0)), 11416, 11417, 11671, 11672, 11673, 11928, 11929);
        WorldRegions.addRegion(WorldRegions.surface("Temple of Ikov", 0, 0, WorldRegions.fromBounds(0, 0, 0, 0)), 10649, 10905, 10650);
        WorldRegions.addRegion(WorldRegions.surface("Temple of Light", 0, 0, WorldRegions.fromBounds(0, 0, 0, 0)), 7496);
        WorldRegions.addRegion(WorldRegions.surface("Temple of Marimbo", 0, 0, WorldRegions.fromBounds(0, 0, 0, 0)), 11151);
        WorldRegions.addRegion(WorldRegions.surface("The Warrens", 0, 0, WorldRegions.fromBounds(0, 0, 0, 0)), 7070, 7326);
        WorldRegions.addRegion(WorldRegions.surface("Dungeon of Tolna", 0, 0, WorldRegions.fromBounds(0, 0, 0, 0)), 13209);
        WorldRegions.addRegion(WorldRegions.surface("Tower of Life Basement", 0, 0, WorldRegions.fromBounds(0, 0, 0, 0)), 12100);
        WorldRegions.addRegion(WorldRegions.surface("Trahaearn Mine", 0, 0, WorldRegions.fromBounds(0, 0, 0, 0)), 13250);
        WorldRegions.addRegion(WorldRegions.surface("Tunnel of Chaos", 0, 0, WorldRegions.fromBounds(0, 0, 0, 0)), 12625);
        WorldRegions.addRegion(WorldRegions.surface("Underground Pass", 0, 0, WorldRegions.fromBounds(0, 0, 0, 0)), 9369, 9370);
        WorldRegions.addRegion(WorldRegions.surface("Varrock Sewers", 0, 0, WorldRegions.fromBounds(0, 0, 0, 0)), 12954, 13210);
        WorldRegions.addRegion(WorldRegions.surface("Viyeldi Caves", 0, 0, WorldRegions.fromBounds(0, 0, 0, 0)), 9545, 11153);
        WorldRegions.addRegion(WorldRegions.surface("Warriors' Guild Basement", 0, 0, WorldRegions.fromBounds(0, 0, 0, 0)), 11675);
        WorldRegions.addRegion(WorldRegions.surface("Water Ravine", 0, 0, WorldRegions.fromBounds(0, 0, 0, 0)), 13461);
        WorldRegions.addRegion(WorldRegions.surface("Waterbirth Dungeon", 0, 0, WorldRegions.fromBounds(0, 0, 0, 0)), 9886, 10142, 7492, 7748);
        WorldRegions.addRegion(WorldRegions.surface("Waterfall Dungeon", 0, 0, WorldRegions.fromBounds(0, 0, 0, 0)), 10394);
        WorldRegions.addRegion(WorldRegions.surface("Werewolf Agility Course", 0, 0, WorldRegions.fromBounds(0, 0, 0, 0)), 14234);
        WorldRegions.addRegion(WorldRegions.surface("White Wolf Mountain Caves", 0, 0, WorldRegions.fromBounds(0, 0, 0, 0)), 11418, 11419);
        WorldRegions.addRegion(WorldRegions.surface("Witchhaven Shrine Dungeon", 0, 0, WorldRegions.fromBounds(0, 0, 0, 0)), 10903);
        WorldRegions.addRegion(WorldRegions.surface("Wizards' Tower Basement", 0, 0, WorldRegions.fromBounds(0, 0, 0, 0)), 12437);
        WorldRegions.addRegion(WorldRegions.surface("Woodcutting Guild Dungeon", 0, 0, WorldRegions.fromBounds(0, 0, 0, 0)), 6298);
        WorldRegions.addRegion(WorldRegions.surface("Wyvern Cave", 0, 0, WorldRegions.fromBounds(0, 0, 0, 0)), 14495, 14496);
        WorldRegions.addRegion(WorldRegions.surface("Yanille Agility Dungeon", 0, 0, WorldRegions.fromBounds(0, 0, 0, 0)), 10388);
        WorldRegions.addRegion(WorldRegions.surface("Ardougne Rat Pits", 0, 0, WorldRegions.fromBounds(0, 0, 0, 0)), 10646);
        WorldRegions.addRegion(WorldRegions.surface("Barbarian Assault", 0, 0, WorldRegions.fromBounds(0, 0, 0, 0)), 7508, 7509, 10322);
        WorldRegions.addRegion(WorldRegions.surface("Barrows", 0, 0, WorldRegions.fromBounds(0, 0, 0, 0)), 14131, 14231);
        WorldRegions.addRegion(WorldRegions.surface("Blast Furnace", 0, 0, WorldRegions.fromBounds(0, 0, 0, 0)), 7757);
        WorldRegions.addRegion(WorldRegions.surface("Brimhaven Agility Arena", 0, 0, WorldRegions.fromBounds(0, 0, 0, 0)), 11157);
        WorldRegions.addRegion(WorldRegions.surface("Burthorpe Games Room", 0, 0, WorldRegions.fromBounds(0, 0, 0, 0)), 8781);
        WorldRegions.addRegion(WorldRegions.surface("Castle Wars", 0, 0, WorldRegions.fromBounds(0, 0, 0, 0)), 9520, 9620);
        WorldRegions.addRegion(WorldRegions.surface("Clan Wars", 0, 0, WorldRegions.fromBounds(0, 0, 0, 0)), 12621, 12622, 12623, 13130, 13131, 13133, 13134, 13135, 13386, 13387, 13390, 13641, 13642, 13643, 13644, 13645, 13646, 13647, 13899, 13900, 14155, 14156);
        WorldRegions.addRegion(WorldRegions.surface("PvP Arena", 0, 0, WorldRegions.fromBounds(0, 0, 0, 0)), 13362, 13363);
        WorldRegions.addRegion(WorldRegions.surface("Fishing Trawler", 0, 0, WorldRegions.fromBounds(0, 0, 0, 0)), 7499, 8011);
        WorldRegions.addRegion(WorldRegions.surface("The Gauntlet", 0, 0, WorldRegions.fromBounds(0, 0, 0, 0)), 12127, 7512);
        WorldRegions.addRegion(WorldRegions.surface("Corrupted Gauntlet", 0, 0, WorldRegions.fromBounds(0, 0, 0, 0)), 7768);
        WorldRegions.addRegion(WorldRegions.surface("Hallowed Sepulchre", 0, 0, WorldRegions.fromBounds(0, 0, 0, 0)), 8797, 9051, 9052, 9053, 9054, 9309, 9563, 9565, 9821, 10074, 10075, 10077);
        WorldRegions.addRegion(WorldRegions.surface("The Inferno", 0, 0, WorldRegions.fromBounds(0, 0, 0, 0)), 9043);
        WorldRegions.addRegion(WorldRegions.surface("Keldagrim Rat Pits", 0, 0, WorldRegions.fromBounds(0, 0, 0, 0)), 7753);
        WorldRegions.addRegion(WorldRegions.surface("LMS - Deserted Island", 0, 0, WorldRegions.fromBounds(0, 0, 0, 0)), 13658, 13659, 13660, 13914, 13915, 13916);
        WorldRegions.addRegion(WorldRegions.surface("LMS - Wild Varrock", 0, 0, WorldRegions.fromBounds(0, 0, 0, 0)), 13918, 13919, 13920, 14174, 14175, 14176, 14430, 14431, 14432);
        WorldRegions.addRegion(WorldRegions.surface("Mage Training Arena", 0, 0, WorldRegions.fromBounds(0, 0, 0, 0)), 13462, 13463);
        WorldRegions.addRegion(WorldRegions.surface("Nightmare Zone", 0, 0, WorldRegions.fromBounds(0, 0, 0, 0)), 9033);
        WorldRegions.addRegion(WorldRegions.surface("Pest Control", 0, 0, WorldRegions.fromBounds(0, 0, 0, 0)), 10536);
        WorldRegions.addRegion(WorldRegions.surface("Port Sarim Rat Pits", 0, 0, WorldRegions.fromBounds(0, 0, 0, 0)), 11926);
        WorldRegions.addRegion(WorldRegions.surface("Pyramid Plunder", 0, 0, WorldRegions.fromBounds(0, 0, 0, 0)), 7749);
        WorldRegions.addRegion(WorldRegions.surface("Rogues' Den", 0, 0, WorldRegions.fromBounds(0, 0, 0, 0)), 11854, 11855, 12109, 12110, 12111);
        WorldRegions.addRegion(WorldRegions.surface("Sorceress's Garden", 0, 0, WorldRegions.fromBounds(0, 0, 0, 0)), 11605);
        WorldRegions.addRegion(WorldRegions.surface("Soul Wars", 0, 0, WorldRegions.fromBounds(0, 0, 0, 0)), 8493, 8748, 8749, 9005);
        WorldRegions.addRegion(WorldRegions.surface("Temple Trekking", 0, 0, WorldRegions.fromBounds(0, 0, 0, 0)), 8014, 8270, 8256, 8782, 9038, 9294, 9550, 9806);
        WorldRegions.addRegion(WorldRegions.surface("Tithe Farm", 0, 0, WorldRegions.fromBounds(0, 0, 0, 0)), 7222);
        WorldRegions.addRegion(WorldRegions.surface("Trouble Brewing", 0, 0, WorldRegions.fromBounds(0, 0, 0, 0)), 15150);
        WorldRegions.addRegion(WorldRegions.surface("Tzhaar Fight Caves", 0, 0, WorldRegions.fromBounds(0, 0, 0, 0)), 9551);
        WorldRegions.addRegion(WorldRegions.surface("Tzhaar Fight Pits", 0, 0, WorldRegions.fromBounds(0, 0, 0, 0)), 9552);
        WorldRegions.addRegion(WorldRegions.surface("Varrock Rat Pits", 0, 0, WorldRegions.fromBounds(0, 0, 0, 0)), 11599);
        WorldRegions.addRegion(WorldRegions.surface("Volcanic Mine", 0, 0, WorldRegions.fromBounds(0, 0, 0, 0)), 15263, 15262);
        WorldRegions.addRegion(WorldRegions.surface("Guardians of the Rift", 0, 0, WorldRegions.fromBounds(0, 0, 0, 0)), 14484);
        WorldRegions.addRegion(WorldRegions.surface("Chambers of Xeric", 0, 0, WorldRegions.fromBounds(0, 0, 0, 0)), 12889, 13136, 13137, 13138, 13139, 13140, 13141, 13145, 13393, 13394, 13395, 13396, 13397, 13401);
        WorldRegions.addRegion(WorldRegions.surface("Theatre of Blood", 0, 0, WorldRegions.fromBounds(0, 0, 0, 0)), 12611, 12612, 12613, 12867, 12869, 13122, 13123, 13125, 13379);
        WorldRegions.addRegion(WorldRegions.surface("Home, Sweet Home", 0, 0, WorldRegions.fromBounds(0, 0, 0, 0)), 7513);
        WorldRegions.addRegion(WorldRegions.surface("Old Man's Maze", 0, 0, WorldRegions.fromBounds(0, 0, 0, 0)), 11591);
        WorldRegions.addRegion(WorldRegions.surface("Osmumten's Tomb", 0, 0, WorldRegions.fromBounds(0, 0, 0, 0)), 13712, 13456);
        WorldRegions.addRegion(WorldRegions.surface("Cosmic Entity's Plane", 0, 0, WorldRegions.fromBounds(0, 0, 0, 0)), 8267);
        WorldRegions.addRegion(WorldRegions.surface("Icyene Graveyard", 0, 0, WorldRegions.fromBounds(0, 0, 0, 0)), 14641);
        WorldRegions.addRegion(WorldRegions.surface("Baba Yaga's House", 0, 0, WorldRegions.fromBounds(0, 0, 0, 0)), 9800);
        WorldRegions.addRegion(WorldRegions.surface("Killerwatt Rift", 0, 0, WorldRegions.fromBounds(0, 0, 0, 0)), 10577);
        WorldRegions.addRegion(WorldRegions.surface("Air Alter", 0, 0, WorldRegions.fromBounds(0, 0, 0, 0)), 11339);
        WorldRegions.addRegion(WorldRegions.surface("Earth Alter", 0, 0, WorldRegions.fromBounds(0, 0, 0, 0)), 10571);
        WorldRegions.addRegion(WorldRegions.surface("Water Alter", 0, 0, WorldRegions.fromBounds(0, 0, 0, 0)), 10827);
        WorldRegions.addRegion(WorldRegions.surface("Fire Alter", 0, 0, WorldRegions.fromBounds(0, 0, 0, 0)), 10315);
        WorldRegions.addRegion(WorldRegions.surface("Mind Alter", 0, 0, WorldRegions.fromBounds(0, 0, 0, 0)), 11083);
        WorldRegions.addRegion(WorldRegions.surface("Body Alter", 0, 0, WorldRegions.fromBounds(0, 0, 0, 0)), 10059);
        WorldRegions.addRegion(WorldRegions.surface("Chaos Alter", 0, 0, WorldRegions.fromBounds(0, 0, 0, 0)), 9035);
        WorldRegions.addRegion(WorldRegions.surface("Death Alter", 0, 0, WorldRegions.fromBounds(0, 0, 0, 0)), 8779);
        WorldRegions.addRegion(WorldRegions.surface("Law Alter", 0, 0, WorldRegions.fromBounds(0, 0, 0, 0)), 9803);
        WorldRegions.addRegion(WorldRegions.surface("Nature Alter", 0, 0, WorldRegions.fromBounds(0, 0, 0, 0)), 9547);
        WorldRegions.addRegion(WorldRegions.surface("Cosmic Alter", 0, 0, WorldRegions.fromBounds(0, 0, 0, 0)), 8523);
        WorldRegions.addRegion(WorldRegions.surface("Zanaris", 0, 0, WorldRegions.fromBounds(0, 0, 0, 0)), 9541, 9797, 9540);
        WorldRegions.addRegion(WorldRegions.surface("Kalphite Caves", 0, 0, WorldRegions.fromBounds(0, 0, 0, 0)), 13461, 13460, 13716);
        WorldRegions.addRegion(WorldRegions.surface("Mage Arena Basement", 0, 0, WorldRegions.fromBounds(0, 0, 0, 0)), 10057);
        WorldRegions.addRegion(WorldRegions.surface("Mage Arena Basement", 0, 0, WorldRegions.fromBounds(0, 0, 0, 0)), 10057);
        WorldRegions.addRegion(WorldRegions.surface("Mor-Ul-Rek", 0, 0, WorldRegions.fromBounds(0, 0, 0, 0)), 9808, 10064, 9807, 10069);
    }
}

