/*
 * Decompiled with CFR 0.152.
 */
package com.sololegends.runelite;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.inject.Provides;
import com.sololegends.runelite.FriendClickListener;
import com.sololegends.runelite.FriendMapPoint;
import com.sololegends.runelite.FriendsOnMapConfig;
import com.sololegends.runelite.helpers.RemoteDataManager;
import com.sololegends.runelite.overlay.OtherSurfacePlayersOverlay;
import com.sololegends.runelite.overlay.PlayerLocationOverlayPanel;
import com.sololegends.runelite.panel.FriendsPanel;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.image.BufferedImage;
import java.util.EnumSet;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.LinkedBlockingQueue;
import javax.inject.Inject;
import javax.swing.SwingUtilities;
import net.runelite.api.ChatMessageType;
import net.runelite.api.Client;
import net.runelite.api.Friend;
import net.runelite.api.Player;
import net.runelite.api.Point;
import net.runelite.api.Skill;
import net.runelite.api.World;
import net.runelite.api.coords.LocalPoint;
import net.runelite.api.coords.WorldPoint;
import net.runelite.api.events.ClientTick;
import net.runelite.api.events.GameTick;
import net.runelite.api.events.StatChanged;
import net.runelite.api.widgets.Widget;
import net.runelite.api.widgets.WidgetInfo;
import net.runelite.api.worldmap.WorldMap;
import net.runelite.client.callback.ClientThread;
import net.runelite.client.chat.ChatColorType;
import net.runelite.client.chat.ChatMessageBuilder;
import net.runelite.client.config.ConfigManager;
import net.runelite.client.eventbus.Subscribe;
import net.runelite.client.events.ConfigChanged;
import net.runelite.client.game.WorldService;
import net.runelite.client.input.MouseListener;
import net.runelite.client.input.MouseManager;
import net.runelite.client.plugins.Plugin;
import net.runelite.client.plugins.PluginDescriptor;
import net.runelite.client.ui.ClientToolbar;
import net.runelite.client.ui.FontManager;
import net.runelite.client.ui.NavigationButton;
import net.runelite.client.ui.PluginPanel;
import net.runelite.client.ui.overlay.Overlay;
import net.runelite.client.ui.overlay.OverlayManager;
import net.runelite.client.ui.overlay.worldmap.WorldMapOverlay;
import net.runelite.client.ui.overlay.worldmap.WorldMapPoint;
import net.runelite.client.ui.overlay.worldmap.WorldMapPointManager;
import net.runelite.client.util.ImageUtil;
import net.runelite.client.util.WorldUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@PluginDescriptor(name="Friend Finder")
public class FriendsOnMapPlugin
extends Plugin {
    private static final Logger log = LoggerFactory.getLogger(FriendsOnMapPlugin.class);
    public static final int VARBIT_PRIVATE_CHAT = 13674;
    public static final int VARBIT_PRIVATE_CHAT_ON = 0;
    public static final int VARBIT_PRIVATE_CHAT_FRIENDS = 1;
    public static final int VARBIT_PRIVATE_CHAT_OFF = 2;
    private Set<FriendMapPoint> current_points = ConcurrentHashMap.newKeySet();
    private LinkedBlockingQueue<String> message_queue = new LinkedBlockingQueue();
    private long last_update = 0L;
    private World hop_world = null;
    private int hop_world_attempts = 0;
    private int hop_world_attempts_max = 10;
    private long hop_world_last = 0L;
    private int hop_world_interval = 1000;
    private volatile FriendMapPoint focus_on = null;
    private volatile boolean info_updated = false;
    private int health_last;
    private int prayer_last;
    private FriendsPanel panel;
    private NavigationButton side_panel_btn;
    @Inject
    private Client client;
    @Inject
    private ClientThread clientThread;
    @Inject
    private ClientToolbar clientToolbar;
    @Inject
    private FriendsOnMapConfig config;
    @Inject
    private WorldMapPointManager map_point_manager;
    @Inject
    private WorldMapOverlay map_overlay;
    @Inject
    private MouseManager mouse;
    @Inject
    private FriendClickListener mouse_listener;
    @Inject
    private WorldService worldService;
    @Inject
    private RemoteDataManager remote;
    @Inject
    private OtherSurfacePlayersOverlay other_surface_overlay;
    @Inject
    private PlayerLocationOverlayPanel player_location_overlay;
    @Inject
    private OverlayManager overlay_manager;

    protected void startUp() throws Exception {
        log.info("Starting Friend finder");
        this.mouse.registerMouseListener((MouseListener)this.mouse_listener);
        this.overlay_manager.add((Overlay)this.other_surface_overlay);
        this.overlay_manager.add((Overlay)this.player_location_overlay);
        this.panel = (FriendsPanel)((Object)this.injector.getInstance(FriendsPanel.class));
        BufferedImage icon = ImageUtil.loadImageResource(FriendsOnMapPlugin.class, (String)"panel_icon_sm.png");
        this.side_panel_btn = NavigationButton.builder().tooltip("Friends On Map").icon(icon).priority(9).panel((PluginPanel)this.panel).build();
        this.clientToolbar.addNavigation(this.side_panel_btn);
    }

    protected void shutDown() throws Exception {
        log.info("Stopping Friend finder!");
        this.clientToolbar.removeNavigation(this.side_panel_btn);
        this.mouse.unregisterMouseListener((MouseListener)this.mouse_listener);
        this.overlay_manager.remove((Overlay)this.other_surface_overlay);
        this.overlay_manager.remove((Overlay)this.player_location_overlay);
    }

    public void message(String msg) {
        this.message_queue.add(msg);
    }

    public void updated(long time) {
        this.last_update = time;
    }

    @Deprecated
    public void clearPoints() {
        for (WorldMapPoint worldMapPoint : this.current_points) {
            this.map_point_manager.remove(worldMapPoint);
        }
        this.current_points.clear();
    }

    public boolean alignLeft(int x) {
        return this.client.getWorldMap().getWorldMapPosition().getX() < x;
    }

    public void removePoint(FriendMapPoint fmp) {
        this.map_point_manager.remove((WorldMapPoint)fmp);
        this.current_points.remove((Object)fmp);
    }

    public void addPoint(FriendMapPoint fmp) {
        if (this.current_points.contains((Object)fmp)) {
            for (FriendMapPoint fp : this.current_points) {
                if (!fp.equals((Object)fmp)) continue;
                fp.world = fmp.world;
                fp.setHealth(fmp.getHealth());
                fp.setPrayer(fmp.getPrayer());
                fp.setWorldPoint(fmp.getWorldPoint());
                fp.setRegion(fmp.getRegion());
                fp.updated();
                this.updateFriendPointIcon(fp, true);
                return;
            }
            return;
        }
        System.out.println("Adding: " + fmp);
        this.map_point_manager.add((WorldMapPoint)fmp);
        this.current_points.add(fmp);
    }

    public void updatePanel() {
        SwingUtilities.invokeLater(() -> this.panel.update());
    }

    public boolean isCurrentWorld(int world) {
        return this.client.getWorld() == world;
    }

    public Set<FriendMapPoint> currentPoints() {
        return this.current_points;
    }

    public void focusFriendClick() {
        if (this.isMouseInWorldMap()) {
            Point mouse_pos = this.client.getMouseCanvasPosition();
            for (FriendMapPoint point : this.current_points) {
                if (this.isWithin(mouse_pos, point.getWorldPoint()) && !point.isCurrentlyEdgeSnapped()) continue;
            }
        }
    }

    public void worldSwitchClick() {
        if (this.isMouseInWorldMap()) {
            Point mouse_pos = this.client.getMouseCanvasPosition();
            for (FriendMapPoint point : this.current_points) {
                if (!this.isWithin(mouse_pos, point.getWorldPoint())) continue;
                this.message_queue.add(new ChatMessageBuilder().append("Attempting to switch to ").append(ChatColorType.HIGHLIGHT).append(point.friend).append(ChatColorType.NORMAL).append("'s world ").append(ChatColorType.HIGHLIGHT).append(Integer.toString(point.world)).append(ChatColorType.NORMAL).build());
                this.hopToWorld(point.world);
            }
        }
    }

    private boolean isWithin(Point mouse_pos, WorldPoint point) {
        float zoom;
        WorldMap map = this.client.getWorldMap();
        WorldPoint map_click = this.calculateMapPoint(map, mouse_pos, zoom = map.getWorldMapZoom());
        return point.distanceTo2D(map_click) < this.config.dotSize();
    }

    private WorldPoint calculateMapPoint(WorldMap map, Point mousePos, float zoom) {
        WorldPoint map_point = new WorldPoint(map.getWorldMapPosition().getX(), map.getWorldMapPosition().getY(), 0);
        Point middle = this.map_overlay.mapWorldPointToGraphicsPoint(map_point);
        int dx = (int)((float)(mousePos.getX() - middle.getX()) / zoom);
        int dy = (int)((float)(-(mousePos.getY() - middle.getY())) / zoom);
        return map_point.dx(dx).dy(dy);
    }

    private boolean isMouseInWorldMap() {
        Point mousePos = this.client.getMouseCanvasPosition();
        Widget view = this.client.getWidget(WidgetInfo.WORLD_MAP_VIEW);
        if (view == null) {
            return false;
        }
        Rectangle worldMapBounds = view.getBounds();
        return worldMapBounds.contains(mousePos.getX(), mousePos.getY());
    }

    public void hopToWorld(int world_id) {
        net.runelite.http.api.worlds.World world = this.worldService.getWorlds().findWorld(world_id);
        if (world == null || this.client.getWorld() == world_id) {
            this.message_queue.add(new ChatMessageBuilder().append("Failed to load world ").append(ChatColorType.HIGHLIGHT).append(Integer.toString(world_id)).append(ChatColorType.NORMAL).build());
            return;
        }
        this.clientThread.invoke(() -> this.hop(world));
    }

    public void hop(net.runelite.http.api.worlds.World world) {
        assert (this.client.isClientThread());
        World rsWorld = this.client.createWorld();
        rsWorld.setActivity(world.getActivity());
        rsWorld.setAddress(world.getAddress());
        rsWorld.setId(world.getId());
        rsWorld.setPlayerCount(world.getPlayers());
        rsWorld.setLocation(world.getLocation());
        rsWorld.setTypes(WorldUtil.toWorldTypes((EnumSet)world.getTypes()));
        this.hop_world = rsWorld;
        this.hop_world_attempts = 0;
    }

    public BufferedImage getIcon(boolean off_world, boolean translated, String label, boolean left) {
        int d_size = this.config.dotSize();
        BufferedImage icon = new BufferedImage(d_size + 2, d_size + 2, 2);
        Graphics2D g = (Graphics2D)icon.getGraphics();
        if (!this.config.alwaysShowName()) {
            this.drawIcon(off_world, translated, g, 1, 1);
            return icon;
        }
        Color owc = translated ? this.config.otherWorldColorLink() : this.config.otherWorldColor();
        Color wc = translated ? this.config.dotColorLink() : this.config.dotColor();
        Font font = FontManager.getRunescapeFont().deriveFont(1, 13.0f);
        g.setFont(font);
        FontMetrics fm = g.getFontMetrics();
        int n_width = fm.stringWidth(label);
        icon = new BufferedImage(icon.getWidth() + n_width + 10, icon.getHeight(), 2);
        g = (Graphics2D)icon.getGraphics();
        g.setFont(font);
        g.setColor(new Color(0.0f, 0.0f, 0.0f, 0.15f));
        g.fillRect(0, 0, icon.getWidth(), icon.getHeight());
        int x_off = d_size + 2 + 5;
        if (left) {
            this.drawIcon(off_world, translated, g, icon.getWidth() - d_size - 1, 1);
            x_off = 0;
        } else {
            this.drawIcon(off_world, translated, g, 1, 1);
        }
        int s_y = icon.getHeight() / 2 + fm.getAscent() / 2;
        int s_x = x_off;
        g.setColor(owc);
        g.drawString(label, s_x + 1, s_y + 1);
        g.setColor(off_world && !this.config.offWorldAsOutline() ? owc : wc);
        g.drawString(label, s_x, s_y);
        return icon;
    }

    public Dimension drawIcon(boolean off_world, boolean translated, Graphics2D g, int x, int y) {
        int d_size = this.config.dotSize();
        Color oc = g.getColor();
        Color owc = translated ? this.config.otherWorldColorLink() : this.config.otherWorldColor();
        Color wc = translated ? this.config.dotColorLink() : this.config.dotColor();
        g.setColor(off_world && !this.config.offWorldAsOutline() ? owc : wc);
        g.fillOval(x, y, d_size, d_size);
        if (off_world && this.config.offWorldAsOutline()) {
            g.setColor(owc);
            g.setStroke(new BasicStroke(Math.max(2, this.config.outlineSize())));
            g.drawOval(x, y, d_size, d_size);
        }
        g.setColor(oc);
        return new Dimension(d_size, d_size);
    }

    public boolean privateMode() {
        return this.client.getVarbitValue(13674) == 2;
    }

    @Subscribe
    public void onGameTick(GameTick event) {
        if (this.focus_on != null) {
            WorldMap map = this.client.getWorldMap();
            if (map != null && map.getWorldMapRenderer().isLoaded()) {
                map.setWorldMapPositionTarget(this.focus_on.getWorldPoint());
                this.client.playSoundEffect(2266);
            }
            this.focus_on = null;
        }
        String msg = null;
        while ((msg = this.message_queue.poll()) != null) {
            this.client.addChatMessage(ChatMessageType.GAMEMESSAGE, "friend-finder", msg, "Friend Finder Plugin", true);
        }
        if (this.hop_world != null && this.hop_world_attempts < this.hop_world_attempts_max && System.currentTimeMillis() - this.hop_world_last > (long)this.hop_world_interval) {
            this.hop_world_last = System.currentTimeMillis();
            ++this.hop_world_attempts;
            if (this.client.getWorld() != this.hop_world.getId()) {
                this.client.hopToWorld(this.hop_world);
            } else {
                this.hop_world = null;
            }
        } else if (this.hop_world != null) {
            this.hop_world = null;
        }
        if (System.currentTimeMillis() - this.last_update > (long)this.config.updateInterval().interval() || this.info_updated) {
            if (this.privateMode()) {
                return;
            }
            this.info_updated = false;
            Player player = this.client.getLocalPlayer();
            if (player == null) {
                this.last_update = System.currentTimeMillis();
            }
            WorldPoint player_location = player.getWorldLocation();
            Friend[] friends = (Friend[])this.client.getFriendContainer().getMembers();
            JsonObject payload = new JsonObject();
            payload.addProperty("name", player.getName());
            payload.addProperty("id", (Number)player.getId());
            payload.addProperty("x", (Number)player_location.getX());
            payload.addProperty("hm", (Number)this.client.getBoostedSkillLevel(Skill.HITPOINTS));
            payload.addProperty("hM", (Number)this.client.getRealSkillLevel(Skill.HITPOINTS));
            payload.addProperty("pm", (Number)this.client.getBoostedSkillLevel(Skill.PRAYER));
            payload.addProperty("pM", (Number)this.client.getRealSkillLevel(Skill.PRAYER));
            payload.addProperty("y", (Number)player_location.getY());
            payload.addProperty("z", (Number)player_location.getPlane());
            payload.addProperty("w", (Number)this.client.getWorld());
            LocalPoint local = player.getLocalLocation();
            int region_id = player_location.getRegionID();
            if (this.client.isInInstancedRegion()) {
                region_id = WorldPoint.fromLocalInstance((Client)this.client, (LocalPoint)local).getRegionID();
            }
            payload.addProperty("r", (Number)region_id);
            JsonArray friends_json = new JsonArray();
            if (player_location != null) {
                for (Friend f : friends) {
                    friends_json.add(f.getName());
                }
            }
            payload.add("friends", (JsonElement)friends_json);
            this.remote.sendRequest(payload);
        }
    }

    @Subscribe
    public void onClientTick(ClientTick clientTick) {
        for (FriendMapPoint mp : this.current_points) {
            if (mp.expired()) {
                this.removePoint(mp);
                continue;
            }
            this.updateFriendPointIcon(mp);
        }
    }

    public void focusOn(FriendMapPoint mp) {
        this.focus_on = mp;
    }

    public void updateFriendPointIcon(FriendMapPoint mp) {
        this.updateFriendPointIcon(mp, false);
    }

    public void updateFriendPointIcon(FriendMapPoint mp, boolean force) {
        boolean align_left = mp.isCurrentlyEdgeSnapped() && this.alignLeft(mp.getWorldPoint().getX());
        int ds = this.config.dotSize();
        mp.setImagePoint(new Point(ds / 2, ds / 2));
        if (mp.isCurrentlyEdgeSnapped()) {
            mp.setImagePoint(null);
        }
        if (mp.left_align == align_left && !force) {
            return;
        }
        mp.left_align = align_left;
        mp.setImage(this.getIcon(!this.isCurrentWorld(mp.world), false, mp.friend + " -- World: " + mp.world, mp.left_align));
    }

    @Subscribe
    public void onConfigChanged(ConfigChanged event) {
        if (event.getKey().equals("always_show_name")) {
            for (FriendMapPoint mp : this.current_points) {
                this.updateFriendPointIcon(mp, true);
            }
        }
    }

    @Subscribe
    public void onStatChanged(StatChanged statChanged) {
        Skill skill = statChanged.getSkill();
        int current_value = this.client.getBoostedSkillLevel(skill);
        switch (skill) {
            case AGILITY: 
            case ATTACK: 
            case CONSTRUCTION: 
            case COOKING: 
            case CRAFTING: 
            case DEFENCE: 
            case FARMING: 
            case FIREMAKING: 
            case FISHING: 
            case FLETCHING: 
            case HERBLORE: 
            case HUNTER: 
            case MAGIC: 
            case MINING: 
            case RANGED: 
            case RUNECRAFT: 
            case SLAYER: 
            case SMITHING: 
            case STRENGTH: 
            case THIEVING: 
            case WOODCUTTING: {
                break;
            }
            case HITPOINTS: {
                if (this.health_last == current_value) break;
                this.info_updated = true;
                this.health_last = current_value;
                break;
            }
            case PRAYER: {
                if (this.prayer_last == current_value) break;
                this.info_updated = true;
                this.prayer_last = current_value;
                break;
            }
        }
    }

    @Provides
    FriendsOnMapConfig provideConfig(ConfigManager configManager) {
        return (FriendsOnMapConfig)configManager.getConfig(FriendsOnMapConfig.class);
    }
}

