/*
 * Decompiled with CFR 0.152.
 */
package com.sololegends.runelite;

import com.sololegends.runelite.helpers.WorldLocations;
import com.sololegends.runelite.skills.Health;
import com.sololegends.runelite.skills.Prayer;
import java.awt.image.BufferedImage;
import net.runelite.api.coords.WorldPoint;
import net.runelite.client.ui.overlay.worldmap.WorldMapPoint;

public class FriendMapPoint
extends WorldMapPoint {
    public static final int LIFETIME = 70000;
    public final String friend;
    public int world;
    public int region = -1;
    public boolean left_align = false;
    private Health health = new Health(0, 0);
    private Prayer prayer = new Prayer(0, 0);
    private long updated = System.currentTimeMillis();

    public FriendMapPoint(WorldPoint worldPoint, BufferedImage image, String friend, int world) {
        super(worldPoint, image);
        this.friend = friend;
        this.world = world;
    }

    public void updated() {
        this.updated = System.currentTimeMillis();
    }

    public boolean expired() {
        return System.currentTimeMillis() - this.updated > 70000L;
    }

    public void setPrayer(Prayer prayer) {
        this.prayer = prayer;
    }

    public void setHealth(Health health) {
        this.health = health;
    }

    public Prayer getPrayer() {
        return this.prayer;
    }

    public Health getHealth() {
        return this.health;
    }

    public void setRegion(int region) {
        this.region = region;
    }

    public int getRegion() {
        return this.region;
    }

    public void onEdgeSnap() {
        super.onEdgeSnap();
        this.setJumpOnClick(true);
    }

    public void onEdgeUnsnap() {
        super.onEdgeUnsnap();
        this.setJumpOnClick(false);
    }

    public FriendMapPoint asOverworld() {
        return new FriendMapPoint(WorldPoint.getMirrorPoint((WorldPoint)this.getWorldPoint(), (boolean)true), this.getImage(), this.friend, this.world);
    }

    public boolean matches(FriendMapPoint fmp) {
        WorldPoint wp = this.getWorldPoint();
        WorldPoint fwp = fmp.getWorldPoint();
        return wp.getX() == fwp.getX() && wp.getY() == fwp.getY();
    }

    public WorldLocations.WorldSurface getLocation() {
        if (this.getRegion() != -1) {
            return WorldLocations.getWorldSurface(this.getRegion());
        }
        return WorldLocations.getWorldSurface(this.getWorldPoint());
    }

    public int hashCode() {
        return -1;
    }

    public boolean equals(Object o) {
        return o instanceof FriendMapPoint && ((FriendMapPoint)((Object)o)).friend.equalsIgnoreCase(this.friend);
    }
}

