/*
 * Decompiled with CFR 0.152.
 */
package com.zulrahhelper.options;

import java.awt.Graphics;
import java.awt.image.BufferedImage;
import net.runelite.client.util.ImageUtil;

public enum OverheadProtection {
    NONE,
    PROTECT_FROM_MAGIC("/options/protect-from-magic.png"),
    PROTECT_FROM_MISSILES("/options/protect-from-missiles.png");

    private static final int SIZE = 75;
    private static final int PADDING = 5;
    private final BufferedImage image;

    private OverheadProtection(String imgPath) {
        this.image = ImageUtil.loadImageResource(((Object)((Object)this)).getClass(), (String)imgPath);
    }

    private OverheadProtection() {
        this.image = null;
    }

    public BufferedImage applyToPhase(BufferedImage phaseImg, boolean left) {
        if (this == NONE) {
            return phaseImg;
        }
        Graphics g = phaseImg.getGraphics();
        g.drawImage(this.image, OverheadProtection.getX(phaseImg.getWidth(), left), OverheadProtection.getY(phaseImg.getHeight(), left), 75, 75, null);
        return phaseImg;
    }

    private static int getX(int phaseWidth, boolean left) {
        if (left) {
            return 5;
        }
        return phaseWidth - 75 - 5;
    }

    private static int getY(int phaseHeight, boolean left) {
        return 5;
    }
}

