/*
 * Decompiled with CFR 0.152.
 */
package com.zulrahhelper;

import com.google.inject.Provides;
import com.zulrahhelper.Phase;
import com.zulrahhelper.State;
import com.zulrahhelper.ZulrahHelperConfig;
import com.zulrahhelper.ui.ZulrahHelperPanel;
import java.util.Arrays;
import java.util.List;
import javax.inject.Inject;
import javax.swing.SwingUtilities;
import net.runelite.api.Client;
import net.runelite.api.Player;
import net.runelite.api.coords.LocalPoint;
import net.runelite.api.coords.WorldPoint;
import net.runelite.api.events.GameTick;
import net.runelite.client.config.ConfigManager;
import net.runelite.client.eventbus.Subscribe;
import net.runelite.client.events.ConfigChanged;
import net.runelite.client.input.KeyListener;
import net.runelite.client.input.KeyManager;
import net.runelite.client.plugins.Plugin;
import net.runelite.client.plugins.PluginDescriptor;
import net.runelite.client.ui.ClientToolbar;
import net.runelite.client.ui.NavigationButton;
import net.runelite.client.ui.PluginPanel;
import net.runelite.client.util.HotkeyListener;
import net.runelite.client.util.ImageUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@PluginDescriptor(name="Zulrah Helper", description="Panel to show Zulrah rotations", tags={"zulrah", "pvm"})
public class ZulrahHelperPlugin
extends Plugin {
    private static final Logger log = LoggerFactory.getLogger(ZulrahHelperPlugin.class);
    static final String CONFIG_GROUP = "zulrahhelper";
    static final String SECTION_IMAGE_OPTIONS = "Image Options";
    static final String SECTION_HOTKEYS = "Hotkeys";
    static final String SECTION_MISC = "Miscellaneous";
    static final String DARK_MODE_KEY = "darkMode";
    static final String DISPLAY_PRAYER_KEY = "displayPrayer";
    static final String DISPLAY_ATTACK_KEY = "displayAttack";
    static final String IMAGE_ORIENTATION_KEY = "imageOrientation";
    static final String AUTO_HIDE_KEY = "autoHide";
    private static final int ZULANDRA_REGION_ID = 8751;
    private static final int ZULRAH_SPAWN_REGION_ID = 9007;
    private static final int ZULRAH_REGION_ID = 9008;
    private static final List<Integer> REGION_IDS = Arrays.asList(8751, 9007, 9008);
    private static final List<Integer> INSTANCE_IDS = Arrays.asList(9007, 9008);
    private static final List<String> OPTION_KEYS = Arrays.asList("darkMode", "displayPrayer", "displayAttack", "imageOrientation");
    @Inject
    private KeyManager keyManager;
    @Inject
    private ClientToolbar clientToolbar;
    @Inject
    private Client client;
    @Inject
    private ZulrahHelperConfig config;
    private ZulrahHelperPanel panel;
    private NavigationButton navButton;
    private State state;
    private HotkeyListener[] hotkeys = new HotkeyListener[5];
    private int lastRegionId = -1;
    private boolean hotkeysEnabled = false;
    private boolean panelEnabled = false;

    protected void startUp() throws Exception {
        this.panel = new ZulrahHelperPanel(this);
        this.state = new State();
        this.navButton = NavigationButton.builder().tooltip("Zulrah Helper").icon(ImageUtil.getResourceStreamFromClass(((Object)((Object)this)).getClass(), (String)"/icon.png")).priority(70).panel((PluginPanel)this.panel).build();
        this.initHotkeys();
        this.togglePanel(!this.config.autoHide(), false);
        this.panel.update(this.state);
    }

    protected void shutDown() throws Exception {
        this.clientToolbar.removeNavigation(this.navButton);
        if (this.hotkeysEnabled) {
            this.toggleHotkeys();
        }
    }

    @Subscribe
    public void onConfigChanged(ConfigChanged event) {
        if (!event.getGroup().equals(CONFIG_GROUP)) {
            return;
        }
        if (OPTION_KEYS.contains(event.getKey())) {
            this.panel.update(this.state);
        }
        if (event.getKey().equals(AUTO_HIDE_KEY)) {
            boolean atZul = REGION_IDS.contains(this.getRegionId());
            this.togglePanel(atZul || !this.config.autoHide(), false);
        }
    }

    @Provides
    ZulrahHelperConfig provideConfig(ConfigManager configManager) {
        return (ZulrahHelperConfig)configManager.getConfig(ZulrahHelperConfig.class);
    }

    @Subscribe
    public void onGameTick(GameTick tick) {
        this.checkRegion();
    }

    private void checkRegion() {
        int regionId = this.getRegionId();
        if (this.hotkeysEnabled && !INSTANCE_IDS.contains(regionId)) {
            this.toggleHotkeys();
        }
        if (!REGION_IDS.contains(regionId)) {
            if (this.config.autoHide()) {
                this.togglePanel(false, false);
            }
            this.lastRegionId = regionId;
            return;
        }
        if (!REGION_IDS.contains(this.lastRegionId) && !this.panelEnabled && this.config.autoHide()) {
            this.togglePanel(true, true);
        }
        if (INSTANCE_IDS.contains(regionId) && !this.hotkeysEnabled) {
            this.toggleHotkeys();
        }
        this.lastRegionId = regionId;
    }

    private int getRegionId() {
        Player player = this.client.getLocalPlayer();
        if (player == null) {
            return -1;
        }
        return WorldPoint.fromLocalInstance((Client)this.client, (LocalPoint)player.getLocalLocation()).getRegionID();
    }

    public void reset() {
        this.setState(State.START_PHASE);
    }

    private void selectOption(int choice) {
        List<List<Phase>> tree = this.state.buildTree();
        if (tree == null || tree.size() <= 0) {
            log.error("no state tree found");
            return;
        }
        List<Phase> choices = tree.get(tree.size() - 1);
        if (choice >= choices.size()) {
            log.error("trying to select nonexistent phase: {} {}", (Object)choice, (Object)choices.size());
            return;
        }
        this.setState(choices.get(choice));
    }

    public void setState(Phase phase) {
        this.state.setPhase(phase);
        log.debug("setting state: " + this.state.toString());
        this.panel.update(this.state);
    }

    private void initHotkeys() {
        this.hotkeys[0] = new HotkeyListener(() -> this.config.phaseSelection1Hotkey()){

            public void hotkeyPressed() {
                ZulrahHelperPlugin.this.selectOption(0);
            }
        };
        this.hotkeys[1] = new HotkeyListener(() -> this.config.phaseSelection2Hotkey()){

            public void hotkeyPressed() {
                ZulrahHelperPlugin.this.selectOption(1);
            }
        };
        this.hotkeys[2] = new HotkeyListener(() -> this.config.phaseSelection3Hotkey()){

            public void hotkeyPressed() {
                ZulrahHelperPlugin.this.selectOption(2);
            }
        };
        this.hotkeys[3] = new HotkeyListener(() -> this.config.nextPhaseHotkey()){

            public void hotkeyPressed() {
                ZulrahHelperPlugin.this.setState(ZulrahHelperPlugin.this.state.getRotationTree().get(ZulrahHelperPlugin.this.state.getNumber()).get(0));
            }
        };
        this.hotkeys[4] = new HotkeyListener(() -> this.config.resetPhasesHotkey()){

            public void hotkeyPressed() {
                ZulrahHelperPlugin.this.reset();
            }
        };
    }

    private void toggleHotkeys() {
        for (HotkeyListener hotkey : this.hotkeys) {
            if (this.hotkeysEnabled) {
                this.keyManager.unregisterKeyListener((KeyListener)hotkey);
                continue;
            }
            this.keyManager.registerKeyListener((KeyListener)hotkey);
        }
        this.hotkeysEnabled = !this.hotkeysEnabled;
    }

    private void togglePanel(boolean enable, boolean show) {
        this.panelEnabled = enable;
        if (enable) {
            this.clientToolbar.addNavigation(this.navButton);
            if (show) {
                SwingUtilities.invokeLater(() -> {
                    if (!this.navButton.isSelected()) {
                        this.navButton.getOnSelect().run();
                    }
                });
            }
        } else {
            this.clientToolbar.removeNavigation(this.navButton);
            this.navButton.setSelected(false);
        }
    }

    public ZulrahHelperConfig getConfig() {
        return this.config;
    }
}

