/*
 * Decompiled with CFR 0.152.
 */
package com.zulrahhelper;

import com.zulrahhelper.ImageOptions;
import com.zulrahhelper.PhaseBuilder;
import com.zulrahhelper.State;
import com.zulrahhelper.ZulrahHelperConfig;
import com.zulrahhelper.options.Attack;
import com.zulrahhelper.options.OverheadProtection;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.image.BufferedImage;
import net.runelite.client.util.ImageUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Phase {
    private static final Logger log = LoggerFactory.getLogger(Phase.class);
    public static final String IMG_PATH = "/phases/%s-%s.png";
    private final Rotation rotation;
    private final int number;
    private final OverheadProtection[] prayers;
    private final Attack[] attacks;
    private BufferedImage image;
    private boolean current = false;
    private boolean selectable = false;
    private boolean completed = false;
    private ImageOptions lastImageOpts;

    public static PhaseBuilder builder(Rotation rotation, int number) {
        return new PhaseBuilder().setRotation(rotation).setNumber(number);
    }

    public Phase(Rotation rotation, int number, OverheadProtection[] prayers, Attack[] attacks) {
        this.rotation = rotation;
        this.number = number;
        this.prayers = prayers;
        this.attacks = attacks;
        this.image = this.getImage(new ImageOptions());
    }

    public Phase copy() {
        return new Phase(this.rotation, this.number, this.prayers, this.attacks);
    }

    private String getImgPath(Rotation rotation, int number) {
        return String.format(IMG_PATH, rotation.name().toLowerCase(), number);
    }

    public Rotation getRotation() {
        return this.rotation;
    }

    public int getNumber() {
        return this.number;
    }

    public boolean isSelectable() {
        return this.selectable;
    }

    public boolean isCurrent() {
        return this.current;
    }

    public boolean isCompleted() {
        return this.completed;
    }

    public void setCompleted(State state) {
        this.completed = this.number < state.getNumber();
    }

    public void setCurrent(State state) {
        this.current = state.getNumber() == this.number && state.getRotation() == this.rotation;
    }

    public void setSelectable(State state) {
        this.selectable = true;
    }

    public void setStates(State state) {
        this.setCurrent(state);
        this.setSelectable(state);
        this.setCompleted(state);
    }

    public BufferedImage getImage(ZulrahHelperConfig config) {
        return this.getImage(new ImageOptions(config));
    }

    public BufferedImage getImage(ImageOptions imgOpts) {
        if (this.image != null && imgOpts.equals(this.lastImageOpts)) {
            return this.image;
        }
        String imgPath = this.getImgPath(this.rotation, this.number);
        this.lastImageOpts = imgOpts;
        this.image = ImageUtil.loadImageResource(this.getClass(), (String)imgPath);
        this.image = this.applyImageOptions(this.image, this.lastImageOpts);
        return this.image;
    }

    private BufferedImage applyImageOptions(BufferedImage image, ImageOptions imageOpts) {
        double theta = imageOpts.getOrientation().getRotation();
        if (theta != 0.0) {
            image = ImageUtil.rotateImage((BufferedImage)image, (double)theta);
        }
        if (imageOpts.isAttackIcons()) {
            for (Attack attack : this.attacks) {
                image = attack.applyToPhase(image, imageOpts.isDarkMode());
            }
        }
        if (imageOpts.isPrayerIcons()) {
            for (int i = 0; i < this.prayers.length; ++i) {
                image = this.prayers[i].applyToPhase(image, i == 0);
            }
        }
        if (!imageOpts.isDarkMode() && image != null && image.getType() != 1) {
            BufferedImage out = new BufferedImage(image.getWidth(null), image.getHeight(null), 1);
            Graphics2D g2d = out.createGraphics();
            g2d.drawImage(image, 0, 0, Color.WHITE, null);
            g2d.dispose();
            image = out;
        }
        if (image != null) {
            image.flush();
        }
        return image;
    }

    public static enum Rotation {
        START,
        NORMAL,
        MAGMA,
        MAGMA_A,
        MAGMA_B,
        TANZ;

    }
}

