/*
 * Decompiled with CFR 0.152.
 */
package com.snip;

import com.google.inject.Provides;
import com.snip.SnipConfig;
import com.snip.SnipPanel;
import java.awt.image.BufferedImage;
import javax.inject.Inject;
import net.runelite.api.Client;
import net.runelite.client.config.ConfigManager;
import net.runelite.client.eventbus.Subscribe;
import net.runelite.client.events.ConfigChanged;
import net.runelite.client.plugins.Plugin;
import net.runelite.client.plugins.PluginDescriptor;
import net.runelite.client.ui.ClientToolbar;
import net.runelite.client.ui.NavigationButton;
import net.runelite.client.ui.PluginPanel;
import net.runelite.client.util.ImageUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@PluginDescriptor(name="Chat Transcripts")
public class SnipPlugin
extends Plugin {
    private static final Logger log = LoggerFactory.getLogger(SnipPlugin.class);
    @Inject
    private Client client;
    @Inject
    private ClientToolbar clientToolbar;
    @Inject
    private SnipConfig config;
    private SnipPanel panel;
    private NavigationButton button;
    final BufferedImage icon = ImageUtil.getResourceStreamFromClass(((Object)((Object)this)).getClass(), (String)"/227-0.png");

    protected void startUp() throws Exception {
        this.panel = new SnipPanel(this.config, this.client);
        this.button = NavigationButton.builder().tooltip("Chat Transcripts").icon(this.icon).priority(this.config.location()).panel((PluginPanel)this.panel).build();
        this.clientToolbar.addNavigation(this.button);
    }

    protected void shutDown() throws Exception {
        this.clientToolbar.removeNavigation(this.button);
    }

    @Provides
    SnipConfig provideConfig(ConfigManager configManager) {
        return (SnipConfig)configManager.getConfig(SnipConfig.class);
    }

    @Subscribe
    public void onConfigChanged(ConfigChanged event) {
        if (event.getGroup().equals("Chat Transcripts")) {
            this.clientToolbar.removeNavigation(this.button);
            this.button = NavigationButton.builder().tooltip("Chat Transcripts").icon(this.icon).priority(this.config.location()).panel((PluginPanel)this.panel).build();
            this.clientToolbar.addNavigation(this.button);
        }
    }
}

