/*
 * Decompiled with CFR 0.152.
 */
package com.snip;

import com.snip.SnipConfig;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Desktop;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.GridBagConstraints;
import java.awt.Image;
import java.awt.Insets;
import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.IOException;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import javax.imageio.ImageIO;
import javax.inject.Inject;
import javax.swing.CellRendererPane;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextArea;
import javax.swing.SwingUtilities;
import net.runelite.api.Client;
import net.runelite.api.widgets.Widget;
import net.runelite.api.widgets.WidgetInfo;
import net.runelite.client.RuneLite;
import net.runelite.client.ui.ColorScheme;
import net.runelite.client.ui.PluginPanel;
import net.runelite.client.util.Text;

public class SnipPanel
extends PluginPanel {
    private static final DateFormat TIME_FORMAT = new SimpleDateFormat("yyyy-MM-dd_HH-mm-ss");
    JButton imageButton = new JButton("Generate Image");
    @Inject
    private Client client;
    private String First = "Line of starting message.";
    private String Second = "Line of ending message.";
    private String Error = "Please check that both lines match messages in chat box. Ranks/ Irons/ Mod status/ Emojis are not detected.";
    private String Output = "\nWaiting to generate transcript.\n\nFor best results paste the messages from right click copy to clipboard as the start and end messages. \n\nQuick Commands: \n\nTo generate a transcript of the entire chat use ^all and all$ as the starting and ending messages. \n\nIf you have the starting line you can use +# (ex \"+3\") as the end line to make a transcript of that many extra lines. this will error if you try to use too many lines.\n";
    private Boolean Ready = false;
    private String Transcript;
    private JTextArea firstBar;
    private JTextArea secondBar;
    private JTextArea OutputField = new JTextArea(this.Output);
    @Inject
    private SnipConfig config;

    public SnipPanel(SnipConfig config, Client client) {
        this.client = client;
        this.config = config;
        GridBagConstraints c = new GridBagConstraints();
        c.fill = 2;
        c.gridx = 0;
        c.gridy = 0;
        c.weightx = 1.0;
        c.weighty = 0.0;
        c.insets = new Insets(0, 0, 10, 0);
        this.firstBar = new JTextArea(this.First);
        this.firstBar.setForeground(ColorScheme.MEDIUM_GRAY_COLOR);
        this.firstBar.setBackground(ColorScheme.DARKER_GRAY_COLOR);
        this.firstBar.setLineWrap(true);
        this.firstBar.setWrapStyleWord(true);
        this.firstBar.setMinimumSize(new Dimension(205, 30));
        this.firstBar.addFocusListener(new FocusListener(){

            @Override
            public void focusGained(FocusEvent e) {
                if (SnipPanel.this.firstBar.getText().equals(SnipPanel.this.First)) {
                    SnipPanel.this.firstBar.setText("");
                    SnipPanel.this.firstBar.setForeground(ColorScheme.LIGHT_GRAY_COLOR);
                }
            }

            @Override
            public void focusLost(FocusEvent e) {
                if (SnipPanel.this.firstBar.getText().isEmpty()) {
                    SnipPanel.this.firstBar.setForeground(ColorScheme.MEDIUM_GRAY_COLOR);
                    SnipPanel.this.firstBar.setText(SnipPanel.this.First);
                }
            }
        });
        this.add(this.firstBar, c);
        ++c.gridy;
        this.secondBar = new JTextArea(this.Second);
        this.secondBar.setForeground(ColorScheme.MEDIUM_GRAY_COLOR);
        this.secondBar.setBackground(ColorScheme.DARKER_GRAY_COLOR);
        this.secondBar.setLineWrap(true);
        this.secondBar.setWrapStyleWord(true);
        this.secondBar.setMinimumSize(new Dimension(205, 30));
        this.secondBar.addFocusListener(new FocusListener(){

            @Override
            public void focusGained(FocusEvent e) {
                if (SnipPanel.this.secondBar.getText().equals(SnipPanel.this.Second)) {
                    SnipPanel.this.secondBar.setText("");
                    SnipPanel.this.secondBar.setForeground(ColorScheme.LIGHT_GRAY_COLOR);
                }
            }

            @Override
            public void focusLost(FocusEvent e) {
                if (SnipPanel.this.secondBar.getText().isEmpty()) {
                    SnipPanel.this.secondBar.setForeground(ColorScheme.MEDIUM_GRAY_COLOR);
                    SnipPanel.this.secondBar.setText(SnipPanel.this.Second);
                }
            }
        });
        this.add(this.secondBar, c);
        ++c.gridy;
        JPanel refreshPanel = new JPanel();
        refreshPanel.setLayout(new BorderLayout());
        JButton refreshButton = new JButton("Generate Transcript");
        refreshButton.setFocusPainted(false);
        refreshButton.setForeground(ColorScheme.LIGHT_GRAY_COLOR);
        refreshButton.addActionListener(event -> {
            String startPoint = this.firstBar.getText();
            String endPoint = this.secondBar.getText();
            if (startPoint.equals(this.First) || endPoint.equals(this.Second)) {
                this.Output = this.Error;
                this.OutputField.setText(this.Output);
                return;
            }
            if (!this.scrubChat(startPoint, endPoint).booleanValue()) {
                this.Output = this.Error;
                this.OutputField.setText(this.Output);
                return;
            }
        });
        refreshPanel.add((Component)refreshButton, "Center");
        this.add(refreshPanel, c);
        ++c.gridy;
        this.OutputField.setBackground(ColorScheme.DARKER_GRAY_COLOR);
        this.OutputField.setLineWrap(true);
        this.OutputField.setWrapStyleWord(true);
        this.OutputField.setMinimumSize(new Dimension(205, 30));
        this.add(this.OutputField, c);
        ++c.gridy;
        JPanel imagePanel = new JPanel();
        imagePanel.setLayout(new BorderLayout());
        this.imageButton.setForeground(ColorScheme.LIGHT_GRAY_COLOR);
        this.imageButton.setFocusPainted(false);
        this.imageButton.addActionListener(event -> {
            if (this.Ready.booleanValue()) {
                try {
                    this.makeImage(this.Transcript);
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        });
        imagePanel.add((Component)this.imageButton, "Center");
        this.add(imagePanel, c);
        ++c.gridy;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static String format(Date date) {
        DateFormat dateFormat = TIME_FORMAT;
        synchronized (dateFormat) {
            return TIME_FORMAT.format(date);
        }
    }

    private Boolean scrubChat(String start, String end) {
        this.Ready = false;
        if (this.client.getWidget(162, 59) != null) {
            Widget[] Testing = this.client.getWidget(WidgetInfo.CHATBOX_MESSAGE_LINES).getDynamicChildren();
            if (Testing.length == 0) {
                return false;
            }
            Object check = "";
            Object temp = "";
            Object tempSplit = "";
            Object finalSplit = "";
            Object out = "";
            Boolean first = false;
            Boolean last = false;
            this.Transcript = "";
            int stopAt = -1;
            int counter = 0;
            Boolean clanMessage = false;
            if (start.equals("^all") && end.equals("all$")) {
                first = true;
                last = true;
            } else if (end.matches("^\\+\\d+$")) {
                stopAt = Integer.parseInt(end.replace("+", ""));
            }
            for (int x = Testing.length - 4; x >= 0; x -= 4) {
                if (Testing[x].getText().isEmpty() || Testing[x + 1].getText().isEmpty() || Testing[x].isSelfHidden()) continue;
                check = Testing[x].getText() + " " + Testing[x + 1].getText();
                if (!Testing[x + 2].getText().isEmpty()) {
                    check = Testing[x + 2].getText() + Testing[x].getText() + " " + Testing[x + 1].getText();
                    clanMessage = true;
                }
                if (((String)check).split("<col=.{6}>").length > 0) {
                    temp = "";
                    tempSplit = "";
                    finalSplit = "";
                    for (String hold : ((String)check).split("<col=.{6}>")) {
                        temp = (String)temp + hold;
                    }
                    for (String hold : ((String)temp).split("</col>")) {
                        tempSplit = (String)tempSplit + hold;
                    }
                    for (String hold : ((String)tempSplit).split("<img=\\d{1,3}>")) {
                        finalSplit = (String)finalSplit + hold;
                    }
                    finalSplit = ((String)finalSplit).replaceAll("<lt>", "<").replaceAll("<gt>", ">");
                }
                if (((String)finalSplit).trim().toLowerCase().endsWith(start.trim().toLowerCase()) || Text.removeTags((String)((String)check).trim().toLowerCase()).endsWith(start.toLowerCase())) {
                    first = true;
                }
                if (first.booleanValue() && (((String)finalSplit).trim().toLowerCase().endsWith(end.trim().toLowerCase()) || Text.removeTags((String)((String)check).trim().toLowerCase()).endsWith(end.toLowerCase()) || counter == stopAt)) {
                    out = (String)out + (String)finalSplit;
                    this.Transcript = clanMessage != false ? this.Transcript + Testing[x + 2].getText() + Testing[x].getText() + " " + Testing[x + 1].getText() : this.Transcript + Testing[x].getText() + " " + Testing[x + 1].getText();
                    last = true;
                    break;
                }
                if (((String)finalSplit).isEmpty() || !first.booleanValue()) continue;
                this.Transcript = clanMessage != false ? this.Transcript + Testing[x + 2].getText() + Testing[x].getText() + " " + Testing[x + 1].getText() + "\n" : this.Transcript + Testing[x].getText() + " " + Testing[x + 1].getText() + "\n";
                out = (String)out + (String)finalSplit + "\n";
                if (stopAt == -1) continue;
                ++counter;
            }
            if (!((String)out).isEmpty() && last.booleanValue()) {
                if (start.equals("^all") && end.equals("all$")) {
                    out = ((String)out).substring(0, ((String)out).lastIndexOf("\n"));
                }
                this.Output = out;
                this.OutputField.setText(this.Output);
                this.Ready = true;
                return true;
            }
        }
        return false;
    }

    private void makeImage(String chat) throws IOException {
        String newTranscript = this.Transcript.replaceAll("<col=", "<font color=#").replaceAll("</col>", "</font color>").replaceAll("\n", "<br>").replaceAll("<lt>", "\\&lt;").replaceAll("<gt>", "\\>").replaceAll("<img=\\d*>", "");
        Object newerTranscript = "";
        String[] newSplit = newTranscript.split("<br>");
        for (int x = 0; x < newSplit.length; ++x) {
            if (newSplit[x].split("<font color=#.{6}>").length != newSplit[x].split("</font color>").length) {
                for (int y = 0; y < newSplit[x].split("<font color=#.{6}>").length - newSplit[x].split("</font color>").length; ++y) {
                    int n = x;
                    newSplit[n] = newSplit[n] + "</font color>";
                }
            }
            if (x != newSplit.length - 1) {
                int n = x;
                newSplit[n] = newSplit[n] + "<br>";
            }
            newerTranscript = (String)newerTranscript + newSplit[x];
        }
        JLabel label = new JLabel("<html>" + ((String)newerTranscript).replaceAll(" ", "&nbsp;") + "</html>");
        label.setBackground(this.config.BgColor());
        label.setForeground(Color.BLACK);
        label.setOpaque(true);
        int width = label.getPreferredSize().width;
        int height = label.getPreferredSize().height;
        BufferedImage bufferedImage = new BufferedImage(width + 1, height + 3, 2);
        Graphics2D g2d = bufferedImage.createGraphics();
        SwingUtilities.paintComponent(g2d, label, new CellRendererPane(), 1, 0, width, height);
        g2d.dispose();
        File parentFolder = new File(RuneLite.SCREENSHOT_DIR, "Transcripts");
        parentFolder.mkdirs();
        File file = new File(parentFolder, this.client.getLocalPlayer().getName() + SnipPanel.format(new Date()) + ".png");
        try {
            if (this.config.clipboard()) {
                TransferableImage trans = new TransferableImage(bufferedImage);
                Clipboard c = Toolkit.getDefaultToolkit().getSystemClipboard();
                c.setContents(trans, null);
                this.OutputField.setText("Transcript saved to clipboard.");
            }
            if (this.config.saveImage()) {
                ImageIO.write((RenderedImage)bufferedImage, "png", file);
                this.OutputField.setText("Transcript saved to Screenshots folder.");
                if (this.config.postOpen()) {
                    Desktop.getDesktop().open(file);
                }
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private class TransferableImage
    implements Transferable {
        Image i;

        public TransferableImage(Image i) {
            this.i = i;
        }

        @Override
        public Object getTransferData(DataFlavor flavor) throws UnsupportedFlavorException, IOException {
            if (flavor.equals(DataFlavor.imageFlavor) && this.i != null) {
                return this.i;
            }
            throw new UnsupportedFlavorException(flavor);
        }

        @Override
        public DataFlavor[] getTransferDataFlavors() {
            DataFlavor[] flavors = new DataFlavor[]{DataFlavor.imageFlavor};
            return flavors;
        }

        @Override
        public boolean isDataFlavorSupported(DataFlavor flavor) {
            DataFlavor[] flavors = this.getTransferDataFlavors();
            for (int i = 0; i < flavors.length; ++i) {
                if (!flavor.equals(flavors[i])) continue;
                return true;
            }
            return false;
        }
    }
}

