/*
 * Decompiled with CFR 0.152.
 */
package net.bram91.modeldumper.types;

import com.google.gson.Gson;
import com.google.gson.reflect.TypeToken;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.io.Reader;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.Set;
import net.bram91.modeldumper.types.AnimationGroup;
import net.bram91.modeldumper.types.NPCData;
import net.runelite.client.RuneLite;
import net.runelite.http.api.RuneLiteAPI;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DataFetcher {
    private static final Logger log = LoggerFactory.getLogger(DataFetcher.class);
    private static final Gson gson = RuneLiteAPI.GSON.newBuilder().create();

    private String getRemoteJson(String path) throws IOException {
        String url = "https://bram91.github.io/" + path;
        if (System.getProperty("devmode") != null) {
            url = "http://localhost/" + path;
        }
        try (InputStream inputStream = new URL(url).openStream();){
            BufferedReader reader = new BufferedReader(new InputStreamReader(inputStream, StandardCharsets.UTF_8));
            String string = DataFetcher.readAll(reader);
            return string;
        }
    }

    private static String readAll(Reader rd) throws IOException {
        int cp;
        StringBuilder sb = new StringBuilder();
        while ((cp = rd.read()) != -1) {
            sb.append((char)cp);
        }
        return sb.toString();
    }

    public Set<NPCData> getNPCData() throws IOException {
        String data = this.getRemoteJson("data.json");
        return (Set)gson.fromJson(data, new TypeToken<Set<NPCData>>(){}.getType());
    }

    public Set<NPCData> getAnimationGroups() throws IOException {
        String data = this.getRemoteJson("animationgroups.json");
        return (Set)gson.fromJson(data, new TypeToken<Set<AnimationGroup>>(){}.getType());
    }

    public HashMap<Integer, String> getAnimationNames() {
        HashMap<Integer, String> animationNames = new HashMap<Integer, String>();
        File MODEL_DIR = new File(RuneLite.RUNELITE_DIR, "models/animationNames.txt");
        try {
            BufferedReader reader = new BufferedReader(new FileReader(MODEL_DIR));
            String line = reader.readLine();
            while (line != null) {
                String[] lineData = line.split("=");
                animationNames.put(Integer.valueOf(lineData[0]), lineData[1]);
                line = reader.readLine();
            }
            reader.close();
        }
        catch (IOException line) {
        }
        catch (ArrayIndexOutOfBoundsException e) {
            log.warn("Invalid line in models/animationNames.txt");
        }
        return animationNames;
    }

    public void saveAnimationNames(Object[] animationNames) throws FileNotFoundException {
        PrintWriter animationName = new PrintWriter(new File(RuneLite.RUNELITE_DIR, "models/animationNames.txt"));
        for (Object name : animationNames) {
            AnimationGroup animationGroup = (AnimationGroup)name;
            animationGroup.getAnimationGroup().forEach(a -> {
                if (a.getName() != null && !a.getName().equals("null")) {
                    animationName.println(a.getId() + "=" + a.getName());
                }
            });
        }
        animationName.flush();
        animationName.close();
    }
}

