/*
 * Decompiled with CFR 0.152.
 */
package net.bram91.modeldumper;

import java.io.ByteArrayOutputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintWriter;
import net.runelite.api.Model;

public class STLExporter {
    public static void export(Model m, String name) throws IOException {
        FileOutputStream os = new FileOutputStream(name + ".stl");
        PrintWriter stlHeader = new PrintWriter(os);
        stlHeader.print("UNITS=mm STL Exported from RuneLite Model-Dumper Plugin, using non-color binary!");
        stlHeader.flush();
        ByteArrayOutputStream w = new ByteArrayOutputStream();
        w.write(STLExporter.le(m.getFaceCount()));
        for (int fi = 0; fi < m.getFaceCount(); ++fi) {
            int vi1 = m.getFaceIndices1()[fi];
            int vi2 = m.getFaceIndices2()[fi];
            int vi3 = m.getFaceIndices3()[fi];
            w.write(STLExporter.le(0.0f));
            w.write(STLExporter.le(0.0f));
            w.write(STLExporter.le(0.0f));
            w.write(STLExporter.le((float)m.getVerticesX()[vi1]));
            w.write(STLExporter.le((float)m.getVerticesZ()[vi1]));
            w.write(STLExporter.le((float)(-m.getVerticesY()[vi1])));
            w.write(STLExporter.le((float)m.getVerticesX()[vi2]));
            w.write(STLExporter.le((float)m.getVerticesZ()[vi2]));
            w.write(STLExporter.le((float)(-m.getVerticesY()[vi2])));
            w.write(STLExporter.le((float)m.getVerticesX()[vi3]));
            w.write(STLExporter.le((float)m.getVerticesZ()[vi3]));
            w.write(STLExporter.le((float)(-m.getVerticesY()[vi3])));
            w.write(0);
            w.write(0);
        }
        w.flush();
        ((OutputStream)os).write(w.toByteArray());
        os.flush();
        ((OutputStream)os).close();
    }

    private static byte[] le(int n) {
        byte[] b = new byte[]{(byte)n, (byte)(n >> 8), (byte)(n >> 16), (byte)(n >> 24)};
        return b;
    }

    private static byte[] le(float f) {
        byte[] b = new byte[4];
        int n = Float.floatToIntBits(f);
        b[0] = (byte)n;
        b[1] = (byte)(n >> 8);
        b[2] = (byte)(n >> 16);
        b[3] = (byte)(n >> 24);
        return b;
    }
}

