/*
 * Decompiled with CFR 0.152.
 */
package net.bram91.modeldumper;

import java.awt.Color;
import java.io.ByteArrayOutputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Objects;
import net.bram91.modeldumper.JagexColor;
import net.bram91.modeldumper.TextureColor;
import net.runelite.api.Model;

public class PLYExporter {
    public static void export(Model m, String name) throws IOException {
        ArrayList<Vertex> vertices = new ArrayList<Vertex>();
        for (int fi = 0; fi < m.getFaceCount(); ++fi) {
            Object vc3;
            Color vc2;
            Color vc1;
            int textureId = -1;
            if (m.getFaceTextures() != null) {
                textureId = m.getFaceTextures()[fi];
            }
            if (textureId != -1) {
                vc2 = vc1 = TextureColor.getColor(textureId);
                vc3 = vc1;
            } else {
                vc1 = new Color(JagexColor.HSLtoRGB((short)m.getFaceColors1()[fi], 0.9));
                vc2 = new Color(JagexColor.HSLtoRGB((short)m.getFaceColors2()[fi], 0.9));
                vc3 = new Color(JagexColor.HSLtoRGB((short)m.getFaceColors3()[fi], 0.9));
            }
            int vi1 = m.getFaceIndices1()[fi];
            int vi2 = m.getFaceIndices2()[fi];
            int vi3 = m.getFaceIndices3()[fi];
            int vx1 = m.getVerticesX()[vi1];
            int vx2 = m.getVerticesX()[vi2];
            int vx3 = m.getVerticesX()[vi3];
            int vy1 = -m.getVerticesY()[vi1];
            int vy2 = -m.getVerticesY()[vi2];
            int vy3 = -m.getVerticesY()[vi3];
            int vz1 = m.getVerticesZ()[vi1];
            int vz2 = m.getVerticesZ()[vi2];
            int vz3 = m.getVerticesZ()[vi3];
            vertices.add(new Vertex(vx1, vy1, vz1, vc1.getRed(), vc1.getGreen(), vc1.getBlue()));
            vertices.add(new Vertex(vx2, vy2, vz2, vc2.getRed(), vc2.getGreen(), vc2.getBlue()));
            vertices.add(new Vertex(vx3, vy3, vz3, ((Color)vc3).getRed(), ((Color)vc3).getGreen(), ((Color)vc3).getBlue()));
        }
        FileOutputStream ply = new FileOutputStream(name + ".ply");
        PrintWriter plyHeader = new PrintWriter(ply);
        plyHeader.println("ply");
        plyHeader.println("format binary_little_endian 1.0");
        plyHeader.println("element vertex " + vertices.size());
        plyHeader.println("property int16 x");
        plyHeader.println("property int16 y");
        plyHeader.println("property int16 z");
        plyHeader.println("property uint8 red");
        plyHeader.println("property uint8 green");
        plyHeader.println("property uint8 blue");
        plyHeader.println("element face " + m.getFaceCount());
        plyHeader.println("property list uint8 int16 vertex_indices");
        plyHeader.println("end_header");
        plyHeader.flush();
        ByteArrayOutputStream w = new ByteArrayOutputStream();
        for (Vertex v : vertices) {
            w.write(PLYExporter.le(v.x));
            w.write(PLYExporter.le(v.z));
            w.write(PLYExporter.le(v.y));
            w.write((byte)v.r);
            w.write((byte)v.g);
            w.write((byte)v.b);
        }
        for (int i = 0; i < m.getFaceCount(); ++i) {
            int vi = i * 3;
            w.write(3);
            w.write(PLYExporter.le(vi));
            w.write(PLYExporter.le(vi + 1));
            w.write(PLYExporter.le(vi + 2));
        }
        w.flush();
        ((OutputStream)ply).write(w.toByteArray());
        ply.flush();
        ((OutputStream)ply).close();
    }

    private static byte[] le(int n) {
        byte[] b = new byte[]{(byte)n, (byte)(n >> 8)};
        return b;
    }

    private static class Vertex {
        public int x;
        public int y;
        public int z;
        public int r;
        public int g;
        public int b;

        public Vertex(int x, int y, int z, int r, int g, int b) {
            this.x = x;
            this.y = y;
            this.z = z;
            this.r = r;
            this.g = g;
            this.b = b;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Vertex vertex = (Vertex)o;
            return this.x == vertex.x && this.y == vertex.y && this.z == vertex.z && this.r == vertex.r && this.g == vertex.g && this.b == vertex.b;
        }

        public int hashCode() {
            return Objects.hash(this.x, this.y, this.z, this.r, this.g, this.b);
        }
    }
}

