/*
 * Decompiled with CFR 0.152.
 */
package net.bram91.modeldumper;

import java.awt.Color;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.PrintWriter;
import java.util.ArrayList;
import net.bram91.modeldumper.JagexColor;
import net.bram91.modeldumper.ModelDumperPlugin;
import net.bram91.modeldumper.TextureColor;
import net.runelite.api.Model;
import net.runelite.api.Renderable;
import net.runelite.client.RuneLite;

public class OBJExporter {
    private static final String PATH = RuneLite.RUNELITE_DIR + "//models//";

    public static void export(Renderable r, String name) {
        Model m = r instanceof Model ? (Model)r : r.getModel();
        OBJExporter.export((Renderable)m, name);
    }

    public static void export(Model m, String path, String name, boolean seq) {
        try {
            File folder = new File(PATH);
            if (!folder.exists()) {
                folder.mkdir();
            }
            OBJExporter.exportModel(m, path, name, seq);
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
    }

    private static void exportModel(Model m, String path, String name, boolean seq) throws FileNotFoundException {
        if (m == null) {
            return;
        }
        Object mtlName = name;
        boolean shouldWriteMaterials = ModelDumperPlugin.getConfig().material();
        if (seq) {
            mtlName = name.split("-")[0] + "-" + name.split("-")[1];
            if (!name.split("-")[2].equals("0") && seq && !ModelDumperPlugin.getConfig().writeMaterialData()) {
                shouldWriteMaterials = false;
            }
        }
        PrintWriter obj = new PrintWriter(path + name + ".obj");
        PrintWriter mtl = null;
        obj.println("# Made by RuneLite Model-Dumper Plugin");
        if (shouldWriteMaterials) {
            mtl = new PrintWriter(path + (String)mtlName + ".mtl");
            obj.println("mtllib " + (String)mtlName + ".mtl");
        }
        obj.println("o " + name);
        for (int vi = 0; vi < m.getVerticesCount(); ++vi) {
            int vx = m.getVerticesX()[vi];
            int vy = -m.getVerticesY()[vi];
            int vz = -m.getVerticesZ()[vi];
            obj.println("v " + vx + " " + vy + " " + vz);
        }
        ArrayList<Color> knownColors = new ArrayList<Color>();
        int prevMtlIndex = -1;
        for (int fi = 0; fi < m.getFaceCount(); ++fi) {
            Color c;
            int textureId = -1;
            if (m.getFaceTextures() != null) {
                textureId = m.getFaceTextures()[fi];
            }
            if (textureId != -1) {
                c = TextureColor.getColor(textureId);
            } else {
                int c1 = m.getFaceColors1()[fi];
                int c2 = m.getFaceColors2()[fi];
                int c3 = m.getFaceColors3()[fi];
                c = JagexColor.HSLtoRGBAvg(c1, c2, c3);
            }
            int ci = knownColors.indexOf(c);
            if (shouldWriteMaterials) {
                for (int i = 0; i < knownColors.size(); ++i) {
                    Color color = (Color)knownColors.get(i);
                    ModelDumperPlugin.getInstance();
                    if (!OBJExporter.similarTo(c, color, ModelDumperPlugin.getConfig().getMaxDistance())) continue;
                    ci = i;
                    break;
                }
            }
            if (ci == -1 && shouldWriteMaterials) {
                ci = knownColors.size();
                knownColors.add(c);
                double r = (double)c.getRed() / 255.0;
                double g = (double)c.getGreen() / 255.0;
                double b = (double)c.getBlue() / 255.0;
                mtl.println("newmtl c" + ci);
                mtl.printf("Kd %.4f %.4f %.4f\n", r, g, b);
            }
            if (shouldWriteMaterials && prevMtlIndex != ci) {
                obj.println("usemtl c" + ci);
            }
            int vi1 = m.getFaceIndices1()[fi] + 1;
            int vi2 = m.getFaceIndices2()[fi] + 1;
            int vi3 = m.getFaceIndices3()[fi] + 1;
            obj.println("f " + vi1 + " " + vi2 + " " + vi3);
            prevMtlIndex = ci;
        }
        obj.flush();
        obj.close();
        if (shouldWriteMaterials) {
            mtl.flush();
            mtl.close();
        }
    }

    private static boolean similarTo(Color c1, Color c2, double maxDistance) {
        double distance = Math.sqrt((c1.getRed() - c2.getRed()) * (c1.getRed() - c2.getRed()) + (c1.getGreen() - c2.getGreen()) * (c1.getGreen() - c2.getGreen()) + (c1.getBlue() - c2.getBlue()) * (c1.getBlue() - c2.getBlue()));
        double percentage = distance / Math.sqrt(195075.0) * 100.0;
        return percentage < maxDistance;
    }
}

