/*
 * Decompiled with CFR 0.152.
 */
package net.bram91.modeldumper;

import com.google.inject.Inject;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.File;
import java.io.FileNotFoundException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.regex.PatternSyntaxException;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.RowFilter;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.TableModel;
import javax.swing.table.TableRowSorter;
import net.bram91.modeldumper.ModelDumperPlugin;
import net.bram91.modeldumper.ModelDumperPluginConfig;
import net.bram91.modeldumper.types.Animation;
import net.bram91.modeldumper.types.AnimationGroup;
import net.bram91.modeldumper.types.AnimationTableModel;
import net.bram91.modeldumper.types.DataFetcher;
import net.bram91.modeldumper.types.ModelExporterData;
import net.bram91.modeldumper.types.NPCData;
import net.runelite.api.ChatMessageType;
import net.runelite.api.Client;
import net.runelite.api.GameState;
import net.runelite.api.Player;
import net.runelite.client.RuneLite;
import net.runelite.client.callback.ClientThread;
import net.runelite.client.ui.PluginPanel;
import net.runelite.client.util.LinkBrowser;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ModelPanel
extends PluginPanel {
    private static final Logger log = LoggerFactory.getLogger(ModelPanel.class);
    @Inject
    Client client;
    @Inject
    ClientThread clientThread;
    @Inject
    ModelDumperPluginConfig config;
    private JTable npcList;
    private JTable animationList;
    private final String npcFilterHint = "Search for npcs...";
    private final String animationFilterHint = "Search for animations...";
    private JTextField npcFilter = new JTextField("Search for npcs...");
    private JTextField animationFilter = new JTextField("Search for animations...");
    public static final File MODEL_DIR = new File(RuneLite.RUNELITE_DIR, "models");

    public void init(ModelExporterData modelExporterData) {
        if (modelExporterData.getNpcData() == null || modelExporterData.getAnimationGroup() == null) {
            JTextArea errorDescription = new JTextArea("There was a problem loading npc information. You can still transmog in the plugin config, but searching through npc names/animations is not available.");
            errorDescription.setLineWrap(true);
            errorDescription.setWrapStyleWord(true);
            this.add(errorDescription);
            this.add(new JButton("Open Folder"){
                {
                    this.addActionListener(e -> LinkBrowser.open((String)MODEL_DIR.toString()));
                }
            });
            return;
        }
        Object[] animationGroups = modelExporterData.getAnimationGroup().toArray();
        JPanel settingsPanel = new JPanel();
        JCheckBox freePick = new JCheckBox("Free animation pick");
        freePick.setToolTipText("This will allow you to apply any animation to any npc.");
        freePick.addActionListener(e -> this.setSelection(animationGroups, freePick, modelExporterData));
        settingsPanel.add(freePick);
        JPanel container = new JPanel();
        container.setLayout(new GridLayout(0, 1, 3, 3));
        for (Object animationGroup : animationGroups) {
            AnimationGroup animGroup = (AnimationGroup)animationGroup;
            animGroup.getAnimationGroup().forEach(anim -> {
                String name = modelExporterData.getAnimationNames().get(anim.getId());
                anim.setName(name);
            });
        }
        modelExporterData.getNpcData().add(new NPCData(" Player", -1, 808, 637));
        Object[] npcData = Arrays.stream(modelExporterData.getNpcData().toArray()).sorted().toArray();
        npcData = Arrays.stream(npcData).filter(x -> !StringUtils.isBlank((CharSequence)x.toString()) && !x.toString().equals("null")).toArray();
        AnimationTableModel model = new AnimationTableModel(npcData, "Name", modelExporterData.getAnimationNames());
        this.npcList = new JTable(model);
        container.add(this.npcFilter);
        this.npcFilter.addFocusListener(new FocusAdapter(){

            @Override
            public void focusGained(FocusEvent e) {
                if (ModelPanel.this.npcFilter.getText().equals("Search for npcs...")) {
                    ModelPanel.this.npcFilter.setText("");
                }
            }
        });
        this.animationFilter.addFocusListener(new FocusAdapter(){

            @Override
            public void focusGained(FocusEvent e) {
                if (ModelPanel.this.animationFilter.getText().equals("Search for animations...")) {
                    ModelPanel.this.animationFilter.setText("");
                }
            }
        });
        this.addSearchBox(this.npcList, this.npcFilter);
        KeyListener keyListener = new KeyListener(){

            @Override
            public void keyTyped(KeyEvent e) {
            }

            @Override
            public void keyPressed(KeyEvent e) {
            }

            @Override
            public void keyReleased(KeyEvent e) {
                NPCData npcData = null;
                Animation animation = null;
                if (ModelPanel.this.npcList.getSelectedRow() != -1) {
                    npcData = (NPCData)ModelPanel.this.npcList.getValueAt(ModelPanel.this.npcList.getSelectedRow(), 0);
                }
                if (ModelPanel.this.animationList.getSelectedRow() != -1 && ModelPanel.this.animationList.getValueAt(ModelPanel.this.animationList.getSelectedRow(), 0) instanceof Animation) {
                    animation = (Animation)ModelPanel.this.animationList.getValueAt(ModelPanel.this.animationList.getSelectedRow(), 0);
                }
                if (npcData != null) {
                    if (animation != null) {
                        ModelPanel.this.applyAnimation(npcData.getId(), animation.getId());
                    } else {
                        ModelPanel.this.applyAnimation(npcData.getId(), npcData.getStandingAnimation());
                    }
                }
            }
        };
        ListSelectionListener npcListListener = e -> {
            if (this.npcList.getSelectedRow() == -1) {
                return;
            }
            this.setSelection(animationGroups, freePick, modelExporterData);
        };
        MouseAdapter animationListListener = new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                int rowAtPoint = ModelPanel.this.animationList.rowAtPoint(e.getPoint());
                ModelPanel.this.animationList.setRowSelectionInterval(rowAtPoint, rowAtPoint);
                if (!(ModelPanel.this.animationList.getValueAt(ModelPanel.this.animationList.getSelectedRow(), 0) instanceof Animation)) {
                    return;
                }
                Animation animation = (Animation)ModelPanel.this.animationList.getValueAt(ModelPanel.this.animationList.getSelectedRow(), 0);
                if (e.getButton() == 3) {
                    String m = JOptionPane.showInputDialog("Animation name for " + animation.getId(), (Object)animation.getName());
                    if (m != null) {
                        if (m.equals("")) {
                            ((Animation)ModelPanel.this.animationList.getValueAt(ModelPanel.this.animationList.getSelectedRow(), 0)).setName(null);
                        } else {
                            ((Animation)ModelPanel.this.animationList.getValueAt(ModelPanel.this.animationList.getSelectedRow(), 0)).setName(m);
                        }
                    }
                } else {
                    int npcId = ((NPCData)ModelPanel.this.npcList.getValueAt(ModelPanel.this.npcList.getSelectedRow(), 0)).getId();
                    ModelPanel.this.applyAnimation(npcId, animation.getId());
                }
            }
        };
        container.add(freePick);
        JPanel animationPanel = new JPanel();
        animationPanel.setLayout(new GridLayout(0, 1, 3, 3));
        this.animationList = new JTable();
        animationPanel.add(new JScrollPane(this.animationList));
        JPanel exportPanel = new JPanel();
        exportPanel.setLayout(new GridLayout(2, 2, 3, 3));
        JButton configButton = new JButton("Set Config");
        configButton.addActionListener(e -> this.setConfig());
        JButton exportButton = new JButton("Export Sequence");
        exportButton.addActionListener(e -> this.exportSequence());
        JButton resetButton = new JButton("Reset");
        resetButton.addActionListener(e -> this.applyAnimation(-1, -1));
        JButton openButton = new JButton("Open Folder");
        JButton saveButton = new JButton("Save Animation Names");
        saveButton.addActionListener(e -> {
            try {
                new DataFetcher().saveAnimationNames(animationGroups);
            }
            catch (FileNotFoundException ex) {
                log.warn("Failed to write animation names to file.");
            }
        });
        openButton.addActionListener(e -> LinkBrowser.open((String)MODEL_DIR.toString()));
        exportPanel.add(configButton);
        exportPanel.add(exportButton);
        exportPanel.add(resetButton);
        exportPanel.add(openButton);
        this.npcList.getSelectionModel().addListSelectionListener(npcListListener);
        this.npcList.addKeyListener(keyListener);
        this.animationList.addMouseListener(animationListListener);
        this.animationList.addKeyListener(keyListener);
        JScrollPane jScrollPane = new JScrollPane(this.npcList);
        Dimension d = this.npcList.getPreferredSize();
        d.height = 200;
        jScrollPane.setPreferredSize(d);
        this.add(new JLabel("NPC selection:"));
        this.add(jScrollPane, "Center");
        this.add(container);
        d = animationPanel.getPreferredSize();
        d.height = 200;
        animationPanel.setPreferredSize(d);
        this.add(animationPanel);
        this.add(this.animationFilter);
        this.add(saveButton);
        this.add(exportPanel);
    }

    private void setSelection(Object[] animationGroups, JCheckBox freePick, ModelExporterData modelExporterData) {
        if (this.npcList.getSelectedRow() == -1) {
            return;
        }
        NPCData data = (NPCData)this.npcList.getValueAt(this.npcList.getSelectedRow(), 0);
        ArrayList<Animation> matchingAnimations = new ArrayList<Animation>();
        matchingAnimations.add(new Animation(-1));
        for (Object animationGroup : animationGroups) {
            AnimationGroup anim = (AnimationGroup)animationGroup;
            if (freePick.isSelected()) {
                matchingAnimations.addAll(((AnimationGroup)animationGroup).getAnimationGroup());
                continue;
            }
            if (!anim.getAnimationGroup().contains(new Animation(data.getStandingAnimation())) && !anim.getAnimationGroup().contains(new Animation(data.getWalkingAnimation()))) continue;
            matchingAnimations.addAll(anim.getAnimationGroup());
            if (data.getId() != -1) break;
        }
        this.animationList.setModel(new AnimationTableModel(matchingAnimations.stream().sorted().toArray(), "Animations", modelExporterData.getAnimationNames()));
        this.addSearchBox(this.animationList, this.animationFilter);
        this.applyAnimation(data.getId(), data.getStandingAnimation());
    }

    private boolean setConfig() {
        if (this.npcList.getSelectedRow() == -1) {
            return false;
        }
        int npcId = ((NPCData)this.npcList.getValueAt(this.npcList.getSelectedRow(), 0)).getId();
        this.config.setFrame(0);
        this.config.setNpcId(npcId);
        this.config.setAnimationId(this.getAnimationID());
        return true;
    }

    public int getAnimationID() {
        int animation = this.animationList.getSelectedRow() != -1 ? ((Animation)this.animationList.getValueAt(this.animationList.getSelectedRow(), 0)).getId() : ((NPCData)this.npcList.getValueAt(this.npcList.getSelectedRow(), 0)).getStandingAnimation();
        return animation;
    }

    private void applyAnimation(int id, int animation) {
        this.clientThread.invoke(() -> {
            if (this.client.getGameState() == GameState.LOGGED_IN && this.client.getLocalPlayer() != null) {
                Player player = this.client.getLocalPlayer();
                player.getPlayerComposition().setTransformedNpcId(id);
                player.setIdlePoseAnimation(animation);
            }
        });
    }

    private void exportSequence() {
        if (!this.setConfig()) {
            return;
        }
        int animation = this.getAnimationID();
        this.clientThread.invoke(() -> {
            if (this.client.getGameState() == GameState.LOGGED_IN && this.client.getLocalPlayer() != null) {
                if (animation == -1) {
                    this.client.addChatMessage(ChatMessageType.GAMEMESSAGE, "", "Exported a normal model since no animation was selected.", "");
                    ModelDumperPlugin.getInstance().exportLocalPlayerModel(null);
                } else {
                    this.client.addChatMessage(ChatMessageType.GAMEMESSAGE, "", "Exported animation sequence", "");
                    ModelDumperPlugin.getInstance().exportLocalPlayerSequence(null);
                }
            }
        });
    }

    public void addSearchBox(JTable jTable, final JTextField filter) {
        final TableRowSorter<TableModel> rowSorter = new TableRowSorter<TableModel>(jTable.getModel());
        jTable.setRowSorter(rowSorter);
        filter.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void insertUpdate(DocumentEvent e) {
                String text = filter.getText();
                if (text.trim().isEmpty()) {
                    rowSorter.setRowFilter(null);
                } else {
                    try {
                        rowSorter.setRowFilter(RowFilter.regexFilter("(?i)" + text, new int[0]));
                    }
                    catch (PatternSyntaxException ex) {
                        rowSorter.setRowFilter(null);
                    }
                }
            }

            @Override
            public void removeUpdate(DocumentEvent e) {
                String text = filter.getText();
                if (text.trim().isEmpty()) {
                    rowSorter.setRowFilter(null);
                } else {
                    try {
                        rowSorter.setRowFilter(RowFilter.regexFilter("(?i)" + text, new int[0]));
                    }
                    catch (PatternSyntaxException ex) {
                        rowSorter.setRowFilter(null);
                    }
                }
            }

            @Override
            public void changedUpdate(DocumentEvent e) {
            }
        });
    }
}

