/*
 * Decompiled with CFR 0.152.
 */
package net.bram91.modeldumper;

import com.google.common.collect.HashBasedTable;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Table;
import com.google.inject.Provides;
import java.awt.Shape;
import java.awt.image.BufferedImage;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import javax.inject.Inject;
import net.bram91.modeldumper.Exporter;
import net.bram91.modeldumper.GroundItem;
import net.bram91.modeldumper.ModelDumperPluginConfig;
import net.bram91.modeldumper.ModelPanel;
import net.bram91.modeldumper.types.ModelExporterData;
import net.runelite.api.Animation;
import net.runelite.api.Client;
import net.runelite.api.DecorativeObject;
import net.runelite.api.GameObject;
import net.runelite.api.GameState;
import net.runelite.api.MenuAction;
import net.runelite.api.MenuEntry;
import net.runelite.api.NPC;
import net.runelite.api.Player;
import net.runelite.api.Point;
import net.runelite.api.Scene;
import net.runelite.api.Tile;
import net.runelite.api.TileItem;
import net.runelite.api.WallObject;
import net.runelite.api.coords.WorldPoint;
import net.runelite.api.events.BeforeRender;
import net.runelite.api.events.ClientTick;
import net.runelite.api.events.GameStateChanged;
import net.runelite.api.events.ItemDespawned;
import net.runelite.api.events.ItemQuantityChanged;
import net.runelite.api.events.ItemSpawned;
import net.runelite.api.events.MenuOpened;
import net.runelite.api.events.NpcDespawned;
import net.runelite.api.events.NpcSpawned;
import net.runelite.api.widgets.WidgetInfo;
import net.runelite.client.callback.ClientThread;
import net.runelite.client.config.ConfigManager;
import net.runelite.client.eventbus.Subscribe;
import net.runelite.client.events.ConfigChanged;
import net.runelite.client.menus.MenuManager;
import net.runelite.client.menus.WidgetMenuOption;
import net.runelite.client.plugins.Plugin;
import net.runelite.client.plugins.PluginDescriptor;
import net.runelite.client.ui.ClientToolbar;
import net.runelite.client.ui.NavigationButton;
import net.runelite.client.ui.PluginPanel;
import net.runelite.client.util.ImageUtil;
import net.runelite.client.util.Text;

@PluginDescriptor(name="Model Exporter", description="Allows exporting models by right clicking them.", tags={"Model", "Dumper", "Exporter", "3d", "obj"})
public class ModelDumperPlugin
extends Plugin {
    private static ModelDumperPlugin instance;
    private static final String EXPORT_MODEL = "Export Model";
    private static final String EXPORT_SEQUENCE = "Export Animation Sequence";
    private static final String MENU_TARGET = "Player";
    private static final WidgetMenuOption FIXED_EQUIPMENT_TAB_EXPORT;
    private static final WidgetMenuOption RESIZABLE_EQUIPMENT_TAB_EXPORT;
    private static final WidgetMenuOption RESIZABLE_VIEWPORT_BOTTOM_LINE_INVENTORY_TAB_EXPORT;
    private static final WidgetMenuOption FIXED_EQUIPMENT_TAB_EXPORT_SEQ;
    private static final WidgetMenuOption RESIZABLE_EQUIPMENT_TAB_EXPORT_SEQ;
    private static final WidgetMenuOption RESIZABLE_VIEWPORT_BOTTOM_LINE_INVENTORY_TAB_EXPORT_SEQ;
    private final ImmutableList<String> set = ImmutableList.of((Object)"Trade with", (Object)"Attack", (Object)"Talk-to", (Object)"Examine");
    private ModelExporterData modelData;
    @Inject
    private ClientToolbar clientToolbar;
    private NavigationButton navButton;
    @Inject
    private Client client;
    @Inject
    private ClientThread clientThread;
    @Inject
    private MenuManager menuManager;
    @Inject
    private ModelDumperPluginConfig config;
    private final Table<WorldPoint, Integer, GroundItem> groundItems = HashBasedTable.create();
    private final List<NPC> pets = new ArrayList<NPC>();

    @Provides
    ModelDumperPluginConfig getConfig(ConfigManager configManager) {
        return (ModelDumperPluginConfig)configManager.getConfig(ModelDumperPluginConfig.class);
    }

    protected void startUp() throws Exception {
        if (this.config.transmogEnabled()) {
            this.config.setTransmog(false);
        }
        this.menuManager.addManagedCustomMenu(FIXED_EQUIPMENT_TAB_EXPORT, this::exportLocalPlayerModel);
        this.menuManager.addManagedCustomMenu(RESIZABLE_EQUIPMENT_TAB_EXPORT, this::exportLocalPlayerModel);
        this.menuManager.addManagedCustomMenu(RESIZABLE_VIEWPORT_BOTTOM_LINE_INVENTORY_TAB_EXPORT, this::exportLocalPlayerModel);
        this.menuManager.addManagedCustomMenu(FIXED_EQUIPMENT_TAB_EXPORT_SEQ, this::exportLocalPlayerSequence);
        this.menuManager.addManagedCustomMenu(RESIZABLE_EQUIPMENT_TAB_EXPORT_SEQ, this::exportLocalPlayerSequence);
        this.menuManager.addManagedCustomMenu(RESIZABLE_VIEWPORT_BOTTOM_LINE_INVENTORY_TAB_EXPORT_SEQ, this::exportLocalPlayerSequence);
        instance = this;
        this.modelData = new ModelExporterData();
        if (this.config.sidepanelEnabled()) {
            this.addSidepanel();
        }
    }

    public void addSidepanel() {
        ModelPanel panel = (ModelPanel)((Object)this.injector.getInstance(ModelPanel.class));
        panel.init(this.modelData);
        BufferedImage icon = ImageUtil.loadImageResource(((Object)((Object)this)).getClass(), (String)"icon.png");
        this.navButton = NavigationButton.builder().tooltip("Model Exporter").icon(icon).priority(10).panel((PluginPanel)panel).build();
        this.clientToolbar.addNavigation(this.navButton);
    }

    public void removeSidepanel() {
        this.clientToolbar.removeNavigation(this.navButton);
    }

    protected void shutDown() {
        this.menuManager.removeManagedCustomMenu(FIXED_EQUIPMENT_TAB_EXPORT);
        this.menuManager.removeManagedCustomMenu(RESIZABLE_EQUIPMENT_TAB_EXPORT);
        this.menuManager.removeManagedCustomMenu(RESIZABLE_VIEWPORT_BOTTOM_LINE_INVENTORY_TAB_EXPORT);
        this.menuManager.removeManagedCustomMenu(FIXED_EQUIPMENT_TAB_EXPORT_SEQ);
        this.menuManager.removeManagedCustomMenu(RESIZABLE_EQUIPMENT_TAB_EXPORT_SEQ);
        this.menuManager.removeManagedCustomMenu(RESIZABLE_VIEWPORT_BOTTOM_LINE_INVENTORY_TAB_EXPORT_SEQ);
        if (this.config.sidepanelEnabled()) {
            this.removeSidepanel();
        }
        this.groundItems.clear();
    }

    @Subscribe
    public void onMenuOpened(MenuOpened event) {
        MenuEntry[] menuEntries = event.getMenuEntries();
        for (int i = 0; i < this.set.size(); ++i) {
            boolean addMenuEntry = false;
            MenuEntry target = null;
            for (MenuEntry menuEntry : menuEntries) {
                if (menuEntry.getOption().toLowerCase().equals("drop") || menuEntry.getOption().toLowerCase().equals("destroy")) {
                    return;
                }
                if (!menuEntry.getOption().equals(this.set.get(i))) continue;
                addMenuEntry = true;
                target = menuEntry;
            }
            if (!this.client.isKeyPressed(81) || !addMenuEntry) continue;
            String entityName = target.getTarget();
            if (target.getPlayer() != null) {
                this.client.createMenuEntry(0).setOption(EXPORT_MODEL).setTarget(entityName).setIdentifier(target.getIdentifier()).onClick(this::exportPlayerModel);
                break;
            }
            if (target.getType().equals((Object)MenuAction.EXAMINE_ITEM_GROUND) || target.getType().equals((Object)MenuAction.EXAMINE_OBJECT)) {
                this.client.createMenuEntry(0).setOption(EXPORT_MODEL).setTarget(entityName).setIdentifier(target.getIdentifier()).onClick(this::exportObjectModel);
                break;
            }
            if (target.getNpc() == null || target.getNpc().getComposition().isFollower()) break;
            this.client.createMenuEntry(0).setOption(EXPORT_MODEL).setTarget(entityName).setIdentifier(target.getIdentifier()).onClick(this::exportNpcModel);
            break;
        }
    }

    @Subscribe
    public void onBeforeRender(BeforeRender beforeRender) {
        if (this.config.transmogEnabled() && this.config.frame() != 0) {
            Player player = this.client.getLocalPlayer();
            Animation animation = this.client.loadAnimation(this.config.animationId());
            if (player != null && animation != null) {
                if (this.config.frame() < animation.getNumFrames()) {
                    player.setAnimationFrame(this.config.frame());
                    player.setPoseAnimationFrame(this.config.frame());
                } else {
                    player.setAnimationFrame(animation.getNumFrames() - 1);
                    player.setPoseAnimationFrame(animation.getNumFrames() - 1);
                }
            }
        }
    }

    @Subscribe
    public void onConfigChanged(ConfigChanged configChanged) {
        if (!configChanged.getGroup().equals("modeldumper")) {
            return;
        }
        if (configChanged.getKey().equals("sidepanelEnabled")) {
            if (Boolean.parseBoolean(configChanged.getNewValue())) {
                this.addSidepanel();
            } else {
                this.removeSidepanel();
            }
            return;
        }
        Player player = this.client.getLocalPlayer();
        if (player != null) {
            switch (configChanged.getKey()) {
                case "npcId": {
                    if (!this.config.transmogEnabled()) break;
                    player.getPlayerComposition().setTransformedNpcId(Integer.parseInt(configChanged.getNewValue()));
                    break;
                }
                case "animationId": {
                    if (!this.config.transmogEnabled()) break;
                    int newValue = Integer.parseInt(configChanged.getNewValue());
                    if (newValue == 0) {
                        player.setIdlePoseAnimation(-1);
                        break;
                    }
                    player.setIdlePoseAnimation(newValue);
                    break;
                }
                case "transmogEnabled": {
                    if (Boolean.parseBoolean(configChanged.getNewValue())) {
                        player.getPlayerComposition().setTransformedNpcId(this.config.npcId());
                        player.setIdlePoseAnimation(this.config.animationId());
                        break;
                    }
                    player.getPlayerComposition().setTransformedNpcId(-1);
                    player.setIdlePoseAnimation(-1);
                    player.setPoseAnimation(-1);
                }
            }
        }
    }

    public void exportLocalPlayerModel(MenuEntry entry) {
        Player localPlayer = this.client.getLocalPlayer();
        if (this.config.forceRestPose()) {
            localPlayer.setAnimation(2566);
            localPlayer.setAnimationFrame(0);
        }
        Exporter.export(localPlayer.getModel(), "Player " + this.client.getLocalPlayer().getName(), false);
    }

    public void exportLocalPlayerSequence(MenuEntry entry) {
        Player localPlayer = this.client.getLocalPlayer();
        Date dateTime = new Date();
        Animation animation = this.client.loadAnimation(this.config.animationId());
        if (animation != null) {
            for (int i = 0; i < animation.getNumFrames(); ++i) {
                if (this.client.loadAnimation(this.config.animationId()) == null) continue;
                localPlayer.setAnimation(this.config.animationId());
                localPlayer.setAnimationFrame(i);
                Exporter.exportSequence(localPlayer.getModel(), this.config.npcId(), this.config.animationId(), i, dateTime);
            }
        }
        localPlayer.setAnimationFrame(0);
    }

    private void exportObjectModel(MenuEntry entry) {
        int id = entry.getIdentifier();
        String menuTarget = entry.getTarget();
        Scene scene = this.client.getScene();
        Tile[][][] tiles = scene.getTiles();
        int z = this.client.getPlane();
        for (int x = 0; x < 104; ++x) {
            for (int y = 0; y < 104; ++y) {
                Tile tile = tiles[z][x][y];
                if (tile == null) continue;
                GameObject[] gameObjects = tile.getGameObjects();
                WallObject wallObject = tile.getWallObject();
                Collection groundItemsOnTile = this.groundItems.row((Object)tile.getWorldLocation()).values();
                DecorativeObject decoration = tile.getDecorativeObject();
                if (wallObject != null && wallObject.getId() == id) {
                    Exporter.export(wallObject.getRenderable1(), "Object " + Text.removeFormattingTags((String)menuTarget));
                    return;
                }
                if (decoration != null && decoration.getId() == id) {
                    Exporter.export(decoration.getRenderable(), "Object " + Text.removeFormattingTags((String)menuTarget));
                    return;
                }
                for (GameObject gameObject : gameObjects) {
                    if (gameObject == null || gameObject.getId() != id || gameObject.getRenderable() == null) continue;
                    Exporter.export(gameObject.getRenderable(), "Object " + Text.removeFormattingTags((String)menuTarget));
                    return;
                }
                for (GroundItem groundItem : groundItemsOnTile) {
                    if (groundItem.getId() != id) continue;
                    Exporter.export(groundItem.getModel(), "Item " + Text.removeFormattingTags((String)menuTarget), false);
                    return;
                }
            }
        }
    }

    private void exportNpcModel(MenuEntry entry) {
        String menuTarget = entry.getTarget();
        int identifier = entry.getIdentifier();
        NPC npc = this.client.getCachedNPCs()[identifier];
        Exporter.export(npc.getModel(), "NPC " + Text.removeFormattingTags((String)menuTarget), false);
    }

    private void exportPetModel(MenuEntry entry) {
        String menuTarget = entry.getTarget();
        int identifier = entry.getIdentifier();
        NPC npc = null;
        for (NPC npC : this.client.getNpcs()) {
            if (npC.getId() != identifier) continue;
            npc = npC;
        }
        if (npc != null) {
            Exporter.export(npc.getModel(), "Pet " + Text.removeFormattingTags((String)menuTarget), false);
        }
    }

    private void exportPlayerModel(MenuEntry entry) {
        String menuTarget = entry.getTarget();
        Pattern REMOVE_TAGS_SECONDARY = Pattern.compile("\\(.+?\\)");
        Matcher m = REMOVE_TAGS_SECONDARY.matcher(menuTarget);
        String trgt = m.replaceAll("");
        trgt = Text.sanitize((String)Text.removeFormattingTags((String)trgt.trim()));
        for (int i = 0; i < this.client.getPlayers().size(); ++i) {
            if (!((Player)this.client.getPlayers().get(i)).getName().equals(trgt)) continue;
            Exporter.export(((Player)this.client.getPlayers().get(i)).getModel(), "Player " + trgt, false);
        }
    }

    @Subscribe
    public void onGameStateChanged(GameStateChanged event) {
        if (event.getGameState() == GameState.LOADING) {
            this.groundItems.clear();
        }
    }

    @Subscribe
    public void onItemSpawned(ItemSpawned itemSpawned) {
        TileItem item = itemSpawned.getItem();
        Tile tile = itemSpawned.getTile();
        GroundItem groundItem = GroundItem.builder().id(item.getId()).item(item).location(tile.getWorldLocation()).quantity(item.getQuantity()).build();
        GroundItem existing = (GroundItem)this.groundItems.get((Object)tile.getWorldLocation(), (Object)item.getId());
        if (existing != null) {
            existing.setQuantity(existing.getQuantity() + groundItem.getQuantity());
        } else {
            this.groundItems.put((Object)tile.getWorldLocation(), (Object)item.getId(), (Object)groundItem);
        }
    }

    @Subscribe
    public void onItemDespawned(ItemDespawned itemDespawned) {
        TileItem item = itemDespawned.getItem();
        Tile tile = itemDespawned.getTile();
        GroundItem groundItem = (GroundItem)this.groundItems.get((Object)tile.getWorldLocation(), (Object)item.getId());
        if (groundItem == null) {
            return;
        }
        if (groundItem.getQuantity() <= item.getQuantity()) {
            this.groundItems.remove((Object)tile.getWorldLocation(), (Object)item.getId());
        } else {
            groundItem.setQuantity(groundItem.getQuantity() - item.getQuantity());
        }
    }

    @Subscribe
    public void onItemQuantityChanged(ItemQuantityChanged itemQuantityChanged) {
        TileItem item = itemQuantityChanged.getItem();
        Tile tile = itemQuantityChanged.getTile();
        int oldQuantity = itemQuantityChanged.getOldQuantity();
        int newQuantity = itemQuantityChanged.getNewQuantity();
        int diff = newQuantity - oldQuantity;
        GroundItem groundItem = (GroundItem)this.groundItems.get((Object)tile.getWorldLocation(), (Object)item.getId());
        if (groundItem != null) {
            groundItem.setQuantity(groundItem.getQuantity() + diff);
        }
    }

    @Subscribe
    public void onClientTick(ClientTick clientTick) {
        if (this.client.getGameState() == GameState.LOGGED_IN && !this.client.isMenuOpen() && this.client.isKeyPressed(81) && this.pets.size() < 20) {
            this.addMenus();
        }
    }

    private void addMenus() {
        Point mouseCanvasPosition = this.client.getMouseCanvasPosition();
        List petsUnderCursor = this.pets.stream().filter(p -> this.isClickable((NPC)p, mouseCanvasPosition)).collect(Collectors.toList());
        if (!petsUnderCursor.isEmpty()) {
            for (NPC pet : petsUnderCursor) {
                this.client.createMenuEntry(0).setOption(EXPORT_MODEL).setTarget(pet.getName()).setIdentifier(pet.getId()).onClick(this::exportPetModel);
            }
        }
    }

    private boolean isClickable(NPC npc, Point mouseCanvasPosition) {
        Shape npcHull = npc.getConvexHull();
        if (npcHull != null) {
            return npcHull.contains(mouseCanvasPosition.getX(), mouseCanvasPosition.getY());
        }
        return false;
    }

    @Subscribe
    public void onNpcSpawned(NpcSpawned npcSpawned) {
        NPC npc = npcSpawned.getNpc();
        if (npc.getComposition().isFollower()) {
            this.pets.add(npc);
        }
    }

    @Subscribe
    public void onNpcDespawned(NpcDespawned npcDespawned) {
        NPC npc = npcDespawned.getNpc();
        if (npc.getComposition().isFollower()) {
            this.pets.remove(npc);
        }
    }

    protected static Client getClient() {
        return ModelDumperPlugin.instance.client;
    }

    protected static ModelDumperPluginConfig getConfig() {
        return ModelDumperPlugin.instance.config;
    }

    public static ModelDumperPlugin getInstance() {
        return instance;
    }

    static {
        FIXED_EQUIPMENT_TAB_EXPORT = new WidgetMenuOption(EXPORT_MODEL, MENU_TARGET, WidgetInfo.FIXED_VIEWPORT_EQUIPMENT_TAB);
        RESIZABLE_EQUIPMENT_TAB_EXPORT = new WidgetMenuOption(EXPORT_MODEL, MENU_TARGET, WidgetInfo.RESIZABLE_VIEWPORT_EQUIPMENT_TAB);
        RESIZABLE_VIEWPORT_BOTTOM_LINE_INVENTORY_TAB_EXPORT = new WidgetMenuOption(EXPORT_MODEL, MENU_TARGET, WidgetInfo.RESIZABLE_VIEWPORT_BOTTOM_LINE_INVENTORY_TAB);
        FIXED_EQUIPMENT_TAB_EXPORT_SEQ = new WidgetMenuOption(EXPORT_SEQUENCE, MENU_TARGET, WidgetInfo.FIXED_VIEWPORT_EQUIPMENT_TAB);
        RESIZABLE_EQUIPMENT_TAB_EXPORT_SEQ = new WidgetMenuOption(EXPORT_SEQUENCE, MENU_TARGET, WidgetInfo.RESIZABLE_VIEWPORT_EQUIPMENT_TAB);
        RESIZABLE_VIEWPORT_BOTTOM_LINE_INVENTORY_TAB_EXPORT_SEQ = new WidgetMenuOption(EXPORT_SEQUENCE, MENU_TARGET, WidgetInfo.RESIZABLE_VIEWPORT_BOTTOM_LINE_INVENTORY_TAB);
    }
}

