/*
 * Decompiled with CFR 0.152.
 */
package net.bram91.modeldumper;

import java.io.File;
import java.io.IOException;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import net.bram91.modeldumper.ModelDumperPlugin;
import net.bram91.modeldumper.OBJExporter;
import net.bram91.modeldumper.PLYExporter;
import net.bram91.modeldumper.STLExporter;
import net.runelite.api.Model;
import net.runelite.api.Renderable;
import net.runelite.client.RuneLite;

public class Exporter {
    private static final String PATH = RuneLite.RUNELITE_DIR + "//models//";
    private static final DateFormat TIME_FORMAT = new SimpleDateFormat("yyyy-MM-dd_HH-mm-ss");

    public static void export(Renderable r, String name) {
        Model m = r instanceof Model ? (Model)r : r.getModel();
        Exporter.export(m, name, false);
    }

    public static void export(Model m, String name, boolean seq) {
        Exporter.export(m, null, name, seq);
    }

    public static void export(Model m, String path, String name, boolean seq) {
        if (!seq) {
            name = (String)name + " " + TIME_FORMAT.format(new Date());
        }
        switch (ModelDumperPlugin.getConfig().exportFormat()) {
            case OBJ: {
                OBJExporter.export(m, seq ? path : PATH, (String)name, seq);
                break;
            }
            case PLY: {
                try {
                    PLYExporter.export(m, (seq ? path : PATH) + (String)name);
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
                break;
            }
            case STL: {
                try {
                    STLExporter.export(m, (seq ? path : PATH) + (String)name);
                    break;
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
    }

    public static void exportSequence(Model model, int npcId, int animationId, int frame, Date dateTime) {
        String path = PATH + "sequences//" + TIME_FORMAT.format(dateTime) + "//";
        File folder = new File(path);
        if (!folder.exists()) {
            folder.mkdirs();
        }
        if (npcId < 0) {
            Exporter.export(model, path, "player-" + animationId + "-" + frame, true);
        } else {
            Exporter.export(model, path, npcId + "-" + animationId + "-" + frame, true);
        }
    }
}

