/*
 * Decompiled with CFR 0.152.
 */
package com.catvrat;

import com.catvrat.CatCounter;
import com.catvrat.CatOverlay;
import com.catvrat.KarambwanjiCounter;
import java.awt.Color;
import java.awt.image.BufferedImage;
import javax.inject.Inject;
import net.runelite.api.Actor;
import net.runelite.api.ChatMessageType;
import net.runelite.api.Client;
import net.runelite.api.InventoryID;
import net.runelite.api.Item;
import net.runelite.api.ItemComposition;
import net.runelite.api.ItemContainer;
import net.runelite.api.NPC;
import net.runelite.api.events.AnimationChanged;
import net.runelite.api.events.ItemContainerChanged;
import net.runelite.client.Notifier;
import net.runelite.client.callback.ClientThread;
import net.runelite.client.chat.ChatMessageBuilder;
import net.runelite.client.chat.ChatMessageManager;
import net.runelite.client.chat.QueuedMessage;
import net.runelite.client.eventbus.Subscribe;
import net.runelite.client.game.ItemManager;
import net.runelite.client.plugins.Plugin;
import net.runelite.client.plugins.PluginDescriptor;
import net.runelite.client.ui.overlay.Overlay;
import net.runelite.client.ui.overlay.OverlayManager;
import net.runelite.client.ui.overlay.infobox.InfoBox;
import net.runelite.client.ui.overlay.infobox.InfoBoxManager;
import net.runelite.client.util.AsyncBufferedImage;

@PluginDescriptor(name="Cat V Rat", description="Help remind yourself to feed your cat while it is fighting Hell-Rat Behemoths for spices!", tags={"cat", "rat", "health", "notifications", "spicy", "stew"})
public class CatVRatPlugin
extends Plugin {
    @Inject
    private Client client;
    @Inject
    private ClientThread clientThread;
    @Inject
    private OverlayManager overlayManager;
    @Inject
    private CatOverlay catOverlay;
    @Inject
    private ChatMessageManager chatMessageManager;
    @Inject
    private InfoBoxManager infoBoxManager;
    @Inject
    private ItemManager itemManager;
    @Inject
    private Notifier notifier;
    private KarambwanjiCounter KarambwanjiCounterBox;
    private CatCounter catCounterBox;
    public static String catState = "null";

    protected void startUp() throws Exception {
        this.clientThread.invokeLater(() -> {
            this.overlayManager.add((Overlay)this.catOverlay);
            ItemContainer container = this.client.getItemContainer(InventoryID.INVENTORY);
            if (container != null) {
                this.checkInventory(container);
            }
        });
    }

    protected void shutDown() throws Exception {
        this.overlayManager.remove((Overlay)this.catOverlay);
        this.infoBoxManager.removeInfoBox((InfoBox)this.KarambwanjiCounterBox);
        this.infoBoxManager.removeInfoBox((InfoBox)this.catCounterBox);
        this.KarambwanjiCounterBox = null;
        this.catCounterBox = null;
    }

    @Subscribe
    public void onItemContainerChanged(ItemContainerChanged event) {
        if (event.getItemContainer() != this.client.getItemContainer(InventoryID.INVENTORY)) {
            return;
        }
        this.checkInventory(event.getItemContainer());
    }

    @Subscribe
    public void onAnimationChanged(AnimationChanged event) {
        Actor actor = event.getActor();
        if (actor.getName() == null) {
            return;
        }
        if (!(actor instanceof NPC)) {
            return;
        }
        if (!actor.getName().equalsIgnoreCase("Hell-Rat Behemoth")) {
            return;
        }
        if (actor.getAnimation() == 2705) {
            this.checkCatState(Color.orange);
        } else if (actor.getAnimation() == 2706) {
            this.checkCatState(Color.yellow);
        } else if (actor.getAnimation() == 2707) {
            this.sendChatMessage(Color.green, "Hell-Rat Behemoth has been defeated!");
            catState = "null";
        }
    }

    private void checkCatState(Color warning_color) {
        NPC follower = this.client.getFollower();
        int max_follower_health = follower.getHealthScale();
        int curr_follower_health = follower.getHealthRatio();
        if (max_follower_health == -1) {
            return;
        }
        double warning_threshold = 0.6;
        double curr_health_ratio = (double)curr_follower_health / (double)max_follower_health;
        double dangerous_threshold = 0.3;
        if (curr_health_ratio <= dangerous_threshold) {
            if (!catState.equalsIgnoreCase("dangerous")) {
                this.sendChatMessage(Color.red, "Cat is at dangerous health!");
                this.client.setHintArrow(follower);
                this.notifier.notify("DANGER: HEAL YOUR CAT RIGHT NOW!");
                catState = "dangerous";
            }
        } else if (curr_health_ratio <= warning_threshold) {
            if (!catState.equalsIgnoreCase("warning")) {
                this.sendChatMessage(warning_color, "Cat is low health!");
                this.client.setHintArrow(follower);
                this.notifier.notify("WARNING: HEAL YOUR CAT RIGHT NOW!");
                catState = "warning";
            }
        } else if (!catState.equalsIgnoreCase("good")) {
            this.sendChatMessage(Color.CYAN, "Cat is at good health!");
            this.client.clearHintArrow();
            catState = "good";
        }
    }

    private void checkInventory(ItemContainer inventory) {
        Item[] items = inventory.getItems();
        int karambwanji_idx = -1;
        if (inventory.contains(3150)) {
            int idx = 0;
            for (Item item : inventory.getItems()) {
                if (item.getId() == 3150) {
                    karambwanji_idx = idx;
                    break;
                }
                ++idx;
            }
        }
        if (karambwanji_idx == -1) {
            System.out.println("No raw Karambwanji was found in inventory");
            this.removeInfobox();
            return;
        }
        System.out.println("Found " + items[karambwanji_idx].getQuantity() + " raw Karambwanji at inventory idx: " + karambwanji_idx);
        NPC follower = this.client.getFollower();
        if (follower != null) {
            int cat_item_id = -1;
            cat_item_id = follower.getName().equalsIgnoreCase("WILY HELLCAT") ? 7585 : (follower.getName().equalsIgnoreCase("LAZY HELLCAT") ? 7584 : (follower.getName().equalsIgnoreCase("OVERGROWN HELLCAT") ? 7581 : (follower.getName().equalsIgnoreCase("HELLCAT") ? 7582 : (follower.getName().equalsIgnoreCase("WILY CAT") ? 6555 : (follower.getName().equalsIgnoreCase("LAZY CAT") ? 6549 : 1561)))));
            this.infoBoxManager.removeInfoBox((InfoBox)this.catCounterBox);
            this.catCounterBox = null;
            AsyncBufferedImage image = this.itemManager.getImage(cat_item_id, 1, false);
            this.catCounterBox = new CatCounter(this, cat_item_id, 1, follower.getName(), (BufferedImage)image);
            this.infoBoxManager.addInfoBox((InfoBox)this.catCounterBox);
        } else {
            this.infoBoxManager.removeInfoBox((InfoBox)this.catCounterBox);
            this.catCounterBox = null;
        }
        Item karambwanji = items[karambwanji_idx];
        ItemComposition comp = this.itemManager.getItemComposition(karambwanji.getId());
        this.updateInfobox(karambwanji, comp);
    }

    private void updateInfobox(Item item, ItemComposition comp) {
        if (this.KarambwanjiCounterBox != null && this.KarambwanjiCounterBox.getItemID() == item.getId()) {
            this.KarambwanjiCounterBox.setCount(item.getQuantity());
            return;
        }
        this.removeInfobox();
        AsyncBufferedImage image = this.itemManager.getImage(item.getId(), 1, false);
        this.KarambwanjiCounterBox = new KarambwanjiCounter(this, item.getId(), item.getQuantity(), comp.getName(), (BufferedImage)image);
        this.infoBoxManager.addInfoBox((InfoBox)this.KarambwanjiCounterBox);
    }

    private void removeInfobox() {
        this.infoBoxManager.removeInfoBox((InfoBox)this.KarambwanjiCounterBox);
        this.KarambwanjiCounterBox = null;
    }

    private void sendChatMessage(Color color, String chatMessage) {
        String message = new ChatMessageBuilder().append(color, chatMessage).build();
        this.chatMessageManager.queue(QueuedMessage.builder().type(ChatMessageType.CONSOLE).runeLiteFormattedMessage(message).build());
    }
}

