/*
 * Decompiled with CFR 0.152.
 */
package com.catvrat;

import com.catvrat.CatVRatPlugin;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.image.BufferedImage;
import javax.inject.Inject;
import net.runelite.api.Actor;
import net.runelite.api.Client;
import net.runelite.api.coords.LocalPoint;
import net.runelite.client.game.ItemManager;
import net.runelite.client.ui.overlay.Overlay;
import net.runelite.client.ui.overlay.OverlayLayer;
import net.runelite.client.ui.overlay.OverlayPosition;
import net.runelite.client.ui.overlay.OverlayUtil;

class CatOverlay
extends Overlay {
    private final CatVRatPlugin plugin;
    private final Client client;
    @Inject
    private ItemManager itemManager;

    @Inject
    private CatOverlay(Client client, CatVRatPlugin plugin) {
        this.setPosition(OverlayPosition.DYNAMIC);
        this.setLayer(OverlayLayer.ABOVE_SCENE);
        this.client = client;
        this.plugin = plugin;
    }

    public Dimension render(Graphics2D graphics) {
        if (CatVRatPlugin.catState.equalsIgnoreCase("warning")) {
            this.makeFeedingOverlayHint(graphics, Color.ORANGE);
        } else if (CatVRatPlugin.catState.equalsIgnoreCase("dangerous")) {
            this.makeFeedingOverlayHint(graphics, Color.RED);
        }
        return null;
    }

    public void makeFeedingOverlayHint(Graphics2D graphics, Color color) {
        LocalPoint localLocation = this.client.getFollower().getLocalLocation();
        if (localLocation != null) {
            OverlayUtil.renderActorOverlayImage((Graphics2D)graphics, (Actor)this.client.getFollower(), (BufferedImage)this.itemManager.getImage(3150, 1, false), (Color)color, (int)0);
        }
    }
}

