/*
 * Decompiled with CFR 0.152.
 */
package com.ClassesOfGielinor;

import com.ClassesOfGielinor.ClassesOfGielinorConfig;
import com.google.inject.Provides;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import javax.inject.Inject;
import net.runelite.api.ChatMessageType;
import net.runelite.api.Client;
import net.runelite.api.GameState;
import net.runelite.api.ItemComposition;
import net.runelite.api.coords.WorldPoint;
import net.runelite.api.events.GameStateChanged;
import net.runelite.api.events.MenuOptionClicked;
import net.runelite.client.chat.ChatColorType;
import net.runelite.client.chat.ChatMessageBuilder;
import net.runelite.client.chat.ChatMessageManager;
import net.runelite.client.chat.QueuedMessage;
import net.runelite.client.config.ConfigManager;
import net.runelite.client.eventbus.Subscribe;
import net.runelite.client.events.ConfigChanged;
import net.runelite.client.game.ItemManager;
import net.runelite.client.plugins.Plugin;
import net.runelite.client.plugins.PluginDescriptor;
import net.runelite.client.util.Text;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@PluginDescriptor(name="Classes of Gielinor", description="Adds character classes to Old School Runescape!")
public class ClassesOfGielinorPlugin
extends Plugin {
    private static final Logger log = LoggerFactory.getLogger(ClassesOfGielinorPlugin.class);
    public boolean spellCaster = false;
    public boolean disableNonClassItems = false;
    public boolean prayerAllowed = false;
    public String classDeity = "";
    public int PrevClass = 0;
    public String PrevAlign = "";
    String msgStr = "";
    public String[][] validClassItems = new String[21][21];
    public String[][] permClassItems = new String[21][21];
    public String[][] questItems = new String[128][2];
    public String[][] classDialogue = new String[21][21];
    public String[][] worldAltars = new String[56][3];
    public String[] playerDeities = new String[14];
    @Inject
    private Client client;
    @Inject
    private ItemManager itemManager;
    @Inject
    private ClassesOfGielinorConfig config;
    @Inject
    private ChatMessageManager chatMessageManager;

    protected void startUp() throws Exception {
        log.info("Classes of Gielinor plugin started");
    }

    protected void shutDown() throws Exception {
        log.info("Classes of Gielinor plugin stopped");
    }

    @Subscribe
    public void onGameStateChanged(GameStateChanged gameStateChanged) {
        if (gameStateChanged.getGameState() == GameState.LOGGED_IN) {
            this.getClassRestrictions(this.config.playerClass().toString());
            this.setAllowedItems(this.config.playerClass().toString());
            String deitylist = this.setReligion(this.config.playerAlignment().toString());
            this.setGods(deitylist);
            this.setAltars();
            this.setClassPermanentItems(this.config.playerClass().toString());
            this.setQuestItems();
            return;
        }
    }

    @Subscribe
    private void onConfigChanged(ConfigChanged event) {
        String currentClass = this.config.playerClass().toString();
        String currentAlignment = this.config.playerAlignment().toString();
        String deitylist = this.setReligion(currentAlignment.toString());
        this.setGods(deitylist);
        this.getClassRestrictions(currentClass);
        this.setReligion(currentAlignment);
        this.setAllowedItems(currentClass);
        this.setClassPermanentItems(currentClass);
        this.setClassDialogue(currentClass);
        this.msgStr = "";
        if (this.PrevClass != this.getClassID(currentClass)) {
            if (currentClass == "None") {
                this.msgStr = "You do not have a class set.";
            } else {
                this.msgStr = "Your class has been set to " + currentClass + ".";
                this.PrevClass = this.getClassID(this.config.playerClass().toString());
            }
            this.sendChatMessage(this.msgStr);
            this.msgStr = this.spellCaster || this.config.classIsSpellcaster() ? "You feel magical energies empower you." : "";
            if (this.msgStr != "") {
                this.sendChatMessage(this.msgStr);
            }
        }
        if (this.PrevAlign != this.config.playerAlignment().toString()) {
            if (this.playerDeities.length > 0) {
                this.commitToFaith();
                this.PrevAlign = currentAlignment;
            } else {
                this.msgStr = "Your lack of faith prevents you from obtaining blessings.";
                this.sendChatMessage(this.msgStr);
            }
        }
    }

    private void setQuestItems() {
        this.questItems[0][0] = "Ogre bellows";
        this.questItems[1][0] = "Spiked boots";
        this.questItems[2][0] = "Trowel";
        this.questItems[3][0] = "Battered book";
        this.questItems[4][0] = "Battered key";
        this.questItems[5][0] = "Fake beard";
        this.questItems[6][0] = "Red hot sauce";
        this.questItems[7][0] = "Red vine worm";
        this.questItems[8][0] = "Dramen branch";
        this.questItems[9][0] = "Redberry pie";
        this.questItems[10][0] = "Black mushroom";
        this.questItems[11][0] = "Strange implement";
        this.questItems[12][0] = "Black mushroom ink";
        this.questItems[13][0] = "Dramen branch";
        this.questItems[14][0] = "Karamjan rum";
        this.questItems[15][0] = "Hangover cure";
        this.questItems[16][0] = "Ghostspeak amulet";
        this.questItems[17][0] = "Broken glass";
        this.questItems[18][0] = "Rogue's purse";
        this.questItems[19][0] = "Glarial's pebble";
        this.questItems[20][0] = "A key";
        this.questItems[21][0] = "Glarial's amulet";
        this.questItems[22][0] = "Door key";
        this.questItems[23][0] = "H.A.M. robes";
        this.questItems[24][0] = "Fuse";
        this.questItems[25][0] = "Commorb";
        this.questItems[26][0] = "Goutweed";
        this.questItems[27][0] = "Storeroom key";
        this.questItems[28][0] = "Seal of passage";
        this.questItems[29][0] = "Nettle tea";
        this.questItems[30][0] = "Ice gloves";
        this.questItems[31][0] = "Airtight pot";
        this.questItems[32][0] = "Animate rock scroll";
        this.questItems[33][0] = "M'speak amulet";
        this.questItems[34][0] = "Monkey greegree";
        this.questItems[35][0] = "Barrel of naphtha";
        this.questItems[36][0] = "Barrel of coal-tar";
        this.questItems[37][0] = "Barrel";
        this.questItems[38][0] = "Ogre bow";
        this.questItems[39][0] = "Silverlight";
        this.questItems[40][0] = "Catspeak amulet";
        this.questItems[41][0] = "Silver sickle (b)";
        this.questItems[42][0] = "Mourner gear";
        this.questItems[43][0] = "Excalibur";
        this.questItems[44][0] = "Dramen staff";
        this.questItems[45][0] = "Snake charm";
        this.questItems[46][0] = "Ugthanki dung";
        this.questItems[47][0] = "Enchanted lyre";
        this.questItems[48][0] = "Snake charm";
        this.questItems[49][0] = "Ring of visibility";
        this.questItems[50][0] = "Gnome amulet";
        this.questItems[51][0] = "Crystal-mine key";
        this.questItems[52][0] = "Blurite ore";
        this.questItems[53][0] = "Beaten book";
        this.questItems[54][0] = "Dwarven helmet";
        this.questItems[55][0] = "Klank's gauntlets";
        this.questItems[56][0] = "Crystal bow/shield";
        this.questItems[57][0] = "Brooch";
        this.questItems[58][0] = "Ring of charos (a)";
        this.questItems[59][0] = "Lunar staff";
        this.questItems[60][0] = "Kitten";
        this.questItems[61][0] = "Eagle cape";
        this.questItems[62][0] = "Fake beak";
        this.questItems[63][0] = "Camel mask";
        this.questItems[64][0] = "Bomber jacket";
        this.questItems[65][0] = "Bomber cap";
        this.questItems[66][0] = "Origami balloon";
        this.questItems[67][0] = "'perfect' ring";
        this.questItems[68][0] = "'perfect' necklace";
        this.questItems[69][0] = "Shoes";
        this.questItems[70][0] = "Kharidian headpiece";
        this.questItems[71][0] = "Desert disguise";
        this.questItems[72][0] = "Khazard armour";
        this.questItems[73][0] = "Pet rock";
        this.questItems[74][0] = "Fremennik blade";
        this.questItems[75][0] = "Hazeel's mark";
        this.questItems[76][0] = "Carnillean armour";
        this.questItems[77][0] = "Blurite sword";
        this.questItems[78][0] = "Hazard suit";
        this.questItems[79][0] = "Slave robes";
        this.questItems[80][0] = "Builder's outfit";
        this.questItems[81][0] = "Golden helmet";
        this.questItems[82][0] = "Gadderhammer";
        this.questItems[83][0] = "Silvthrill rod";
        this.questItems[84][0] = "Rod of ivandis";
        this.questItems[85][0] = "Beads of the dead";
        this.questItems[86][0] = "Zamorak robes";
        this.questItems[87][0] = "Dark dagger";
        this.questItems[88][0] = "Crystal pendant";
        this.questItems[89][0] = "Fixed device";
        this.questItems[90][0] = "Rat pole";
        this.questItems[91][0] = "Darklight";
        this.questItems[92][0] = "Doctors/nurse hat";
        this.questItems[93][0] = "Bedsheet";
        this.questItems[94][0] = "Initiate sallet";
        this.questItems[95][0] = "Lunar armour/gear";
        this.questItems[96][0] = "Camulet";
        this.questItems[97][0] = "Crystal seed";
        this.questItems[98][0] = "Crystal trinket";
        this.questItems[99][0] = "Fishing pass";
        this.questItems[100][0] = "Blessed gold bowl";
        this.questItems[101][0] = "Mouse toy";
        this.questItems[102][0] = "Prayer book";
        this.questItems[103][0] = "Wrought iron key";
        this.questItems[104][0] = "Beacon ring";
        this.questItems[105][0] = "Dwarven rock cake";
        this.questItems[106][0] = "Barrows gloves";
        this.questItems[107][0] = "Locating crystal";
        this.questItems[108][0] = "Bervirius notes";
        this.questItems[109][0] = "Black prism";
        this.questItems[110][0] = "Ammo mould";
        this.questItems[111][0] = "Steel gauntlets";
        this.questItems[112][0] = "Blackjack";
        this.questItems[113][0] = "Magic secateurs";
        this.questItems[114][0] = "Karambwan vessel";
        this.questItems[115][0] = "Steel key ring";
        this.questItems[116][0] = "Ectophial";
        this.questItems[117][0] = "Teleport crystal";
        this.questItems[118][0] = "Book o' piracy";
        this.questItems[119][0] = "Sled";
        this.questItems[120][0] = "Armadyl pendant";
        this.questItems[121][0] = "Ancient mace";
        this.questItems[122][0] = "Bull roarer";
        this.questItems[123][0] = "Holy wrench";
        this.questItems[124][0] = "Ava's device";
        this.questItems[125][0] = "Iban's staff";
        this.questItems[126][0] = "Keris";
        this.questItems[127][0] = "Barrelchest anchor";
        this.questItems[128][0] = "Ring of charos";
        this.questItems[129][0] = "-----";
        this.questItems[0][1] = "Big Chompy Bird Hunting";
        this.questItems[1][1] = "Death Plateau";
        this.questItems[2][1] = "The Digsite";
        this.questItems[3][1] = "Elemental Workshop";
        this.questItems[4][1] = "Elemental Workshop";
        this.questItems[5][1] = "The Feud";
        this.questItems[6][1] = "The Feud";
        this.questItems[7][1] = "Fishing Contest";
        this.questItems[8][1] = "The Fremennik Trials";
        this.questItems[9][1] = "The Giant Dwarf";
        this.questItems[10][1] = "The Golem";
        this.questItems[11][1] = "The Golem";
        this.questItems[12][1] = "The Golem";
        this.questItems[13][1] = "Lost City";
        this.questItems[14][1] = "Pirate's Treasure";
        this.questItems[15][1] = "Plague City";
        this.questItems[16][1] = "The Restless Ghost";
        this.questItems[17][1] = "Sea Slug";
        this.questItems[18][1] = "Shades of Mort'ton";
        this.questItems[19][1] = "Waterfall Quest";
        this.questItems[20][1] = "Waterfall Quest";
        this.questItems[21][1] = "Waterfall Quest";
        this.questItems[22][1] = "Witch's House";
        this.questItems[23][1] = "The Lost Tribe";
        this.questItems[24][1] = "Cabin Fever";
        this.questItems[25][1] = "Wanted!";
        this.questItems[26][1] = "Eadgar's Ruse";
        this.questItems[27][1] = "Eadgar's Ruse";
        this.questItems[28][1] = "Lunar Diplomacy";
        this.questItems[29][1] = "Ghosts Ahoy";
        this.questItems[30][1] = "Heroes Quest";
        this.questItems[31][1] = "One Small Favour";
        this.questItems[32][1] = "One Small Favour";
        this.questItems[33][1] = "Monkey Madness";
        this.questItems[34][1] = "Monkey Madness";
        this.questItems[35][1] = "Regicide";
        this.questItems[36][1] = "Regicide";
        this.questItems[37][1] = "Regicide";
        this.questItems[38][1] = "Big Chompy Bird Hunting";
        this.questItems[39][1] = "Demon Slayer";
        this.questItems[40][1] = "Icthlarin's Little Helper";
        this.questItems[41][1] = "Nature Spirit";
        this.questItems[42][1] = "Mourning's End Part I";
        this.questItems[43][1] = "Merlin's Crystal";
        this.questItems[44][1] = "Lost City";
        this.questItems[45][1] = "Rat Catchers, The Feud";
        this.questItems[46][1] = "The Feud";
        this.questItems[47][1] = "The Fremennik Trials";
        this.questItems[48][1] = "The Feud";
        this.questItems[49][1] = "Desert Treasure";
        this.questItems[50][1] = "Tree Gnome Village";
        this.questItems[51][1] = "Haunted Mine";
        this.questItems[52][1] = "The Knight's Sword";
        this.questItems[53][1] = "Elemental Workshop Part II";
        this.questItems[54][1] = "Grim Tales";
        this.questItems[55][1] = "Underground Pass";
        this.questItems[56][1] = "Roving Elves";
        this.questItems[57][1] = "The Lost Tribe";
        this.questItems[58][1] = "Garden of Tranquillity";
        this.questItems[59][1] = "Lunar Diplomacy";
        this.questItems[60][1] = "Gertrude's Cat";
        this.questItems[61][1] = "Eagles' Peak";
        this.questItems[62][1] = "Eagles' Peak";
        this.questItems[63][1] = "Enakhra's Lament";
        this.questItems[64][1] = "Enlightened Journey";
        this.questItems[65][1] = "Enlightened Journey";
        this.questItems[66][1] = "Enlightened Journey";
        this.questItems[67][1] = "Family Crest";
        this.questItems[68][1] = "Family Crest";
        this.questItems[69][1] = "Spirit of the Elid";
        this.questItems[70][1] = "The Feud";
        this.questItems[71][1] = "The Feud";
        this.questItems[72][1] = "Fight Arena";
        this.questItems[73][1] = "The Fremennik Trials";
        this.questItems[74][1] = "The Fremennik Trials";
        this.questItems[75][1] = "Hazeel Cult";
        this.questItems[76][1] = "Hazeel Cult";
        this.questItems[77][1] = "The Knight's Sword";
        this.questItems[78][1] = "Sheep Herder";
        this.questItems[79][1] = "The Tourist Trap";
        this.questItems[80][1] = "Tower of Life";
        this.questItems[81][1] = "Between A Rock...";
        this.questItems[82][1] = "In Aid of the Myreque";
        this.questItems[83][1] = "In Aid of the Myreque";
        this.questItems[84][1] = "In Aid of the Myreque";
        this.questItems[85][1] = "Shilo Village";
        this.questItems[86][1] = "Underground Pass";
        this.questItems[87][1] = "Legend's Quest";
        this.questItems[88][1] = "Regicide";
        this.questItems[89][1] = "Mourning's End Part I";
        this.questItems[90][1] = "Rat Catchers";
        this.questItems[91][1] = "Shadow of the Storm";
        this.questItems[92][1] = "A Tail of Two Cats";
        this.questItems[93][1] = "Ghosts Ahoy";
        this.questItems[94][1] = "Recruitment Drive";
        this.questItems[95][1] = "Lunar Diplomacy";
        this.questItems[96][1] = "Enakhra's Lament";
        this.questItems[97][1] = "The Eyes of Glouphrie";
        this.questItems[98][1] = "Mourning's End Part II";
        this.questItems[99][1] = "Fishing Contest";
        this.questItems[100][1] = "Legend's Quest";
        this.questItems[101][1] = "A Tail of Two Cats";
        this.questItems[102][1] = "The Great Brain Robbery";
        this.questItems[103][1] = "The Tourist Trap";
        this.questItems[104][1] = "What Lies Below";
        this.questItems[105][1] = "Recipe For Disaster";
        this.questItems[106][1] = "Recipe For Disaster";
        this.questItems[107][1] = "Shilo Village";
        this.questItems[108][1] = "Shilo Village";
        this.questItems[109][1] = "Zogre Flesh Eaters";
        this.questItems[110][1] = "Dwarf Cannon";
        this.questItems[111][1] = "Family Crest";
        this.questItems[112][1] = "The Feud";
        this.questItems[113][1] = "A Fairytale Part I - Growing Pains";
        this.questItems[114][1] = "Tai Bwo Wannai Trio";
        this.questItems[115][1] = "One Small Favour";
        this.questItems[116][1] = "Ghosts Ahoy";
        this.questItems[117][1] = "Mourning's End Part I";
        this.questItems[118][1] = "Cabin Fever";
        this.questItems[119][1] = "Troll Romance";
        this.questItems[120][1] = "Temple of Ikov";
        this.questItems[121][1] = "Another Slice of H.A.M.";
        this.questItems[122][1] = "Legend's Quest";
        this.questItems[123][1] = "Rum Deal";
        this.questItems[124][1] = "Animal Magnetism";
        this.questItems[125][1] = "Underground Pass";
        this.questItems[126][1] = "Contact!";
        this.questItems[127][1] = "The Great Brain Robbery";
        this.questItems[128][1] = "Creature of Fenkenstrain";
        this.questItems[129][1] = "Dwarf Cannon";
    }

    private boolean compareToQuestItems(String currentItem) {
        int FoundFlag = 0;
        currentItem = currentItem.toUpperCase();
        for (int i = 0; i < this.questItems.length; ++i) {
            String ArrayItem = this.questItems[i][0].toUpperCase();
            if (!ArrayItem.contains(currentItem)) continue;
            FoundFlag = 1;
        }
        return FoundFlag > 0;
    }

    private boolean compareToItemArrays(String entity, String[][] setArray) {
        int classID = this.getClassID(this.config.playerClass().toString());
        int FoundFlag = 0;
        entity = entity.toUpperCase();
        while (FoundFlag <= 0) {
            for (int i = 1; i < setArray.length; ++i) {
                String ArrayItem = setArray[classID][i].toUpperCase();
                if (!entity.contains(ArrayItem) && ArrayItem != "!ALL!") continue;
                FoundFlag = 1;
            }
            if (FoundFlag == 1) continue;
            FoundFlag = 2;
        }
        return FoundFlag == 1;
    }

    private boolean checkAllowedItemsArray(String entity) {
        int classID = this.getClassID(this.config.playerClass().toString());
        int found = 0;
        entity = entity.toUpperCase();
        for (int counter = 1; counter < this.validClassItems.length; ++counter) {
            String currentArrayItem = this.validClassItems[classID][counter].toUpperCase();
            if (!entity.contains(currentArrayItem) && currentArrayItem != "!ALL!") continue;
            found = 1;
        }
        return found > 0;
    }

    private void getClassRestrictions(String PlayerClass) {
        switch (PlayerClass) {
            default: {
                this.spellCaster = true;
                this.disableNonClassItems = false;
                this.prayerAllowed = true;
                this.setAllowedItems(this.config.playerClass().toString());
                this.classDeity = "!ALL!";
                break;
            }
            case "Bard": 
            case "Cleric": 
            case "Druid": 
            case "Warlock": {
                this.spellCaster = true;
                this.disableNonClassItems = true;
                this.prayerAllowed = true;
                this.setAllowedItems(this.config.playerClass().toString());
                break;
            }
            case "Necromancer": 
            case "Wizard": {
                this.spellCaster = true;
                this.disableNonClassItems = true;
                this.prayerAllowed = false;
                this.setAllowedItems(this.config.playerClass().toString());
                break;
            }
            case "Barbarian": 
            case "Chef": 
            case "Fighter": 
            case "Artificer": 
            case "Ranger": {
                this.spellCaster = false;
                this.disableNonClassItems = true;
                this.prayerAllowed = false;
                this.setAllowedItems(this.config.playerClass().toString());
                break;
            }
            case "Monk": 
            case "Paladin": 
            case "Rogue": {
                this.spellCaster = false;
                this.disableNonClassItems = true;
                this.prayerAllowed = true;
                this.setAllowedItems(this.config.playerClass().toString());
            }
        }
    }

    private String setReligion(String PlayerAlignment) {
        String Deity = "";
        switch (PlayerAlignment) {
            case "Lawful_Good": {
                Deity = "Saradomin,Seren";
                break;
            }
            case "Neutral_Good": {
                Deity = "Ralos,Ranul";
                break;
            }
            case "Chaotic_Good": {
                Deity = "Karamjani,Marimbo";
                break;
            }
            case "Lawful_Neutral": {
                Deity = "Armadyl";
                break;
            }
            case "True_Neutral": {
                Deity = "Guthix,Elidinis";
                break;
            }
            case "Chaotic_Neutral": {
                Deity = "Bandos,Ichthlarin";
                break;
            }
            case "Lawful_Evil": {
                Deity = "Zaros";
                break;
            }
            case "Neutral_Evil": {
                Deity = "Xeric";
                break;
            }
            case "Chaotic_Evil": {
                Deity = "Zamorak";
            }
        }
        return Deity;
    }

    private void setGods(String Deities) {
        int NumOfListItems;
        String[] gods = Deities.split(",");
        List<String> detectedGods = Arrays.asList(gods);
        detectedGods.toArray(this.playerDeities);
        for (int x = NumOfListItems = detectedGods.size(); x < this.playerDeities.length; ++x) {
            this.playerDeities[x] = "";
        }
    }

    private void commitToFaith() {
        this.msgStr = "You feel the approval of ";
        for (int i = 0; i < this.playerDeities.length; ++i) {
            if (this.playerDeities[i] == "") continue;
            String NextVal = this.playerDeities[i + 1];
            String iStr = Integer.toString(i);
            if (i == 0) {
                if (NextVal == "") {
                    this.msgStr = this.msgStr + this.playerDeities[i] + ".";
                    continue;
                }
                this.msgStr = this.msgStr + this.playerDeities[i] + ",";
                continue;
            }
            this.msgStr = NextVal == "" ? this.msgStr + " and " + this.playerDeities[i] : this.msgStr + " " + this.playerDeities[i] + ",";
        }
        this.sendChatMessage(this.msgStr);
    }

    private void setAltars() {
        this.worldAltars[0][0] = "Chaos Altar";
        this.worldAltars[0][1] = "3260,3381,0";
        this.worldAltars[0][2] = "Zamorak";
        this.worldAltars[1][0] = "Chaos Altar";
        this.worldAltars[1][1] = "2415,9680,0";
        this.worldAltars[1][2] = "Zamorak";
        this.worldAltars[2][0] = "Chaos Altar";
        this.worldAltars[2][1] = "2455,3231,0";
        this.worldAltars[2][2] = "Zamorak";
        this.worldAltars[3][0] = "Chaos Altar";
        this.worldAltars[3][1] = "3240,3608,0";
        this.worldAltars[3][2] = "Zamorak";
        this.worldAltars[4][0] = "Chaos Altar";
        this.worldAltars[4][1] = "3027,3510,1";
        this.worldAltars[4][2] = "Zamorak";
        this.worldAltars[5][0] = "Chaos Altar";
        this.worldAltars[5][1] = "2933,3513,0";
        this.worldAltars[5][2] = "Zamorak";
        this.worldAltars[6][0] = "Chaos Altar";
        this.worldAltars[6][1] = "2947,3821,0";
        this.worldAltars[6][2] = "Zamorak";
        this.worldAltars[7][0] = "Chaos Altar";
        this.worldAltars[7][1] = "2571,9500,0";
        this.worldAltars[7][2] = "Zamorak";
        this.worldAltars[8][0] = "Altar";
        this.worldAltars[8][1] = "3121,3106,0";
        this.worldAltars[8][2] = "Saradomin";
        this.worldAltars[9][0] = "Altar";
        this.worldAltars[9][1] = "3243,3207,0";
        this.worldAltars[9][2] = "Saradomin";
        this.worldAltars[10][0] = "Altar";
        this.worldAltars[10][1] = "2995,3177,0";
        this.worldAltars[10][2] = "Saradomin";
        this.worldAltars[11][0] = "Altar";
        this.worldAltars[11][1] = "3377,3285,0";
        this.worldAltars[11][2] = "Saradomin";
        this.worldAltars[12][0] = "Altar";
        this.worldAltars[12][1] = "3208,3495,1";
        this.worldAltars[12][2] = "Saradomin";
        this.worldAltars[13][0] = "Altar";
        this.worldAltars[13][1] = "2694,3463,0";
        this.worldAltars[13][2] = "Saradomin";
        this.worldAltars[14][0] = "Altar";
        this.worldAltars[14][1] = "2617,3309,0";
        this.worldAltars[14][2] = "Saradomin";
        this.worldAltars[15][0] = "Altar";
        this.worldAltars[15][1] = "2530,3286,0";
        this.worldAltars[15][2] = "Saradomin";
        this.worldAltars[16][0] = "Altar";
        this.worldAltars[16][1] = "2606,3208,0";
        this.worldAltars[16][2] = "Saradomin";
        this.worldAltars[17][0] = "Altar";
        this.worldAltars[17][1] = "3416,3489,0";
        this.worldAltars[17][2] = "Saradomin";
        this.worldAltars[18][0] = "Altar";
        this.worldAltars[18][1] = "2853,3349,0";
        this.worldAltars[18][2] = "Saradomin";
        this.worldAltars[19][0] = "Altar";
        this.worldAltars[19][1] = "3051,3498,1";
        this.worldAltars[19][2] = "Saradomin";
        this.worldAltars[20][0] = "Altar";
        this.worldAltars[20][1] = "2341,9629,0";
        this.worldAltars[20][2] = "Saradomin";
        this.worldAltars[21][0] = "Altar";
        this.worldAltars[21][1] = "2356,3172,1";
        this.worldAltars[21][2] = "Seren";
        this.worldAltars[22][0] = "Altar";
        this.worldAltars[22][1] = "3263,6091,2";
        this.worldAltars[22][2] = "Seren";
        this.worldAltars[23][0] = "Altar";
        this.worldAltars[23][1] = "3246,6116,0";
        this.worldAltars[23][2] = "Seren";
        this.worldAltars[24][0] = "Altar";
        this.worldAltars[24][1] = "2284,3427,0";
        this.worldAltars[24][2] = "Seren";
        this.worldAltars[25][0] = "Altar";
        this.worldAltars[25][1] = "3254,3487,0";
        this.worldAltars[25][2] = "Saradomin";
        this.worldAltars[26][0] = "Altar";
        this.worldAltars[26][1] = "1617,3673,2";
        this.worldAltars[26][2] = "Saradomin";
        this.worldAltars[27][0] = "Altar";
        this.worldAltars[27][1] = "2728,3283,0";
        this.worldAltars[27][2] = "Saradomin";
        this.worldAltars[28][0] = "Altar";
        this.worldAltars[28][1] = "2750,3496,1";
        this.worldAltars[28][2] = "Saradomin";
        this.worldAltars[29][0] = "Altar";
        this.worldAltars[29][1] = "2889,3511,1";
        this.worldAltars[29][2] = "Saradomin";
        this.worldAltars[30][0] = "Altar";
        this.worldAltars[30][1] = "3281,2774,0";
        this.worldAltars[30][2] = "Icthlarin";
        this.worldAltars[31][0] = "Altar";
        this.worldAltars[31][1] = "1733,3572,0";
        this.worldAltars[31][2] = "Saradomin";
        this.worldAltars[32][0] = "Altar";
        this.worldAltars[32][1] = "1743,3500,0";
        this.worldAltars[32][2] = "Saradomin";
        this.worldAltars[33][0] = "Altar";
        this.worldAltars[33][1] = "1689,3794,2";
        this.worldAltars[33][2] = "None";
        this.worldAltars[34][0] = "Altar";
        this.worldAltars[34][1] = "1547,3808,0";
        this.worldAltars[34][2] = "Unknown";
        this.worldAltars[35][0] = "Altar";
        this.worldAltars[35][1] = "1282,3677,0";
        this.worldAltars[35][2] = "Xeric";
        this.worldAltars[36][0] = "Altar";
        this.worldAltars[36][1] = "1310,3619,0";
        this.worldAltars[36][2] = "Xeric";
        this.worldAltars[37][0] = "Altar";
        this.worldAltars[37][1] = "2457,2839,2";
        this.worldAltars[37][2] = "Unknown";
        this.worldAltars[38][0] = "Altar";
        this.worldAltars[38][1] = "1802,9950,0";
        this.worldAltars[38][2] = "Ranul";
        this.worldAltars[39][0] = "Altar";
        this.worldAltars[39][1] = "3126,3636,0";
        this.worldAltars[39][2] = "Zaros";
        this.worldAltars[40][0] = "Altar";
        this.worldAltars[40][1] = "3421,3180,0";
        this.worldAltars[40][2] = "Saradomin";
        this.worldAltars[41][0] = "Altar";
        this.worldAltars[41][1] = "1175,5467,0";
        this.worldAltars[41][2] = "None";
        this.worldAltars[42][0] = "Altar of Guthix";
        this.worldAltars[42][1] = "2925,3483,0";
        this.worldAltars[42][2] = "Guthix";
        this.worldAltars[43][0] = "Altar of nature";
        this.worldAltars[43][1] = "3442,9740,1";
        this.worldAltars[43][2] = "Guthix";
        this.worldAltars[44][0] = "Zamorak Altar";
        this.worldAltars[44][1] = "Find Coords";
        this.worldAltars[44][2] = "Zamorak";
        this.worldAltars[45][0] = "Saradomin Altar";
        this.worldAltars[45][1] = "Find Coords";
        this.worldAltars[45][2] = "Saradomin";
        this.worldAltars[46][0] = "Armadyl Altar";
        this.worldAltars[46][1] = "Find Coords";
        this.worldAltars[46][2] = "Armadyl";
        this.worldAltars[47][0] = "Bandos Altar";
        this.worldAltars[47][1] = "Find Coords";
        this.worldAltars[47][2] = "Bandos";
        this.worldAltars[48][0] = "Altar";
        this.worldAltars[48][1] = "Find Coords";
        this.worldAltars[48][2] = "Unknown";
        this.worldAltars[49][0] = "Altar of Zamorak";
        this.worldAltars[49][1] = "3738,3307,0";
        this.worldAltars[49][2] = "Zamorak";
        this.worldAltars[50][0] = "Broken sun altar";
        this.worldAltars[50][1] = "1795,9951,0";
        this.worldAltars[50][2] = "Ralos";
        this.worldAltars[51][0] = "Shrine";
        this.worldAltars[51][1] = "1613,3515,0";
        this.worldAltars[51][2] = "Evil Chicken";
        this.worldAltars[52][0] = "Tribal Statue";
        this.worldAltars[52][1] = "2796,3090,0";
        this.worldAltars[52][2] = "Karamjan gods";
        this.worldAltars[53][0] = "Statue";
        this.worldAltars[53][1] = "3605,3355,0";
        this.worldAltars[53][2] = "Unknown";
        this.worldAltars[54][0] = "Gorilla Statue";
        this.worldAltars[54][1] = "2798,2800,1";
        this.worldAltars[54][2] = "Marimbo";
        this.worldAltars[55][0] = "Elidinis Statuette";
        this.worldAltars[55][1] = "3427,2930,0";
        this.worldAltars[55][2] = "Elidinis";
        this.worldAltars[56][0] = "Chaos Altar";
        this.worldAltars[56][1] = "2455,3231,0";
        this.worldAltars[56][2] = "Zamorak";
        this.worldAltars[57][0] = "Altar";
        this.worldAltars[57][1] = "3177,3626,0";
        this.worldAltars[57][2] = "Zaros";
        this.worldAltars[58][0] = "Altar";
        this.worldAltars[58][1] = "1498,3562,0";
        this.worldAltars[58][2] = "Saradomin";
        this.worldAltars[59][0] = "Chaos Altar";
        this.worldAltars[59][1] = "3259,3381,0";
        this.worldAltars[59][2] = "Zamorak";
    }

    private void setAllowedItems(String PlayerClass) {
        int classID = -1;
        switch (PlayerClass) {
            case "None": {
                classID = this.getClassID(PlayerClass);
                this.validClassItems[classID][0] = PlayerClass;
                this.validClassItems[classID][1] = "!ALL!";
                this.validClassItems[classID][2] = "----";
                this.validClassItems[classID][3] = "----";
                this.validClassItems[classID][4] = "----";
                this.validClassItems[classID][5] = "----";
                this.validClassItems[classID][6] = "----";
                this.validClassItems[classID][7] = "----";
                this.validClassItems[classID][8] = "----";
                this.validClassItems[classID][9] = "----";
                this.validClassItems[classID][10] = "----";
                this.validClassItems[classID][11] = "----";
                this.validClassItems[classID][12] = "----";
                this.validClassItems[classID][13] = "----";
                this.validClassItems[classID][14] = "----";
                this.validClassItems[classID][15] = "----";
                this.validClassItems[classID][16] = "----";
                this.validClassItems[classID][17] = "----";
                this.validClassItems[classID][18] = "----";
                this.validClassItems[classID][19] = "----";
                this.validClassItems[classID][20] = "----";
                break;
            }
            case "Artificer": {
                classID = this.getClassID(PlayerClass);
                this.validClassItems[classID][0] = PlayerClass;
                this.validClassItems[classID][1] = "axe";
                this.validClassItems[classID][2] = "thrownaxe";
                this.validClassItems[classID][3] = " saw";
                this.validClassItems[classID][4] = "hammer";
                this.validClassItems[classID][5] = "knife";
                this.validClassItems[classID][6] = "knives";
                this.validClassItems[classID][7] = " axe";
                this.validClassItems[classID][8] = "Colossal blade";
                this.validClassItems[classID][9] = "Glassblowing pipe";
                this.validClassItems[classID][10] = "Pickaxe";
                this.validClassItems[classID][11] = "----";
                this.validClassItems[classID][12] = "----";
                this.validClassItems[classID][13] = "----";
                this.validClassItems[classID][14] = "----";
                this.validClassItems[classID][15] = "----";
                this.validClassItems[classID][16] = "----";
                this.validClassItems[classID][17] = "----";
                this.validClassItems[classID][18] = "----";
                this.validClassItems[classID][19] = "----";
                this.validClassItems[classID][20] = "----";
                break;
            }
            case "Chef": {
                classID = this.getClassID(PlayerClass);
                this.validClassItems[classID][0] = PlayerClass;
                this.validClassItems[classID][1] = "dagger";
                this.validClassItems[classID][2] = "knife";
                this.validClassItems[classID][3] = "spoon";
                this.validClassItems[classID][4] = "whisk";
                this.validClassItems[classID][5] = "Spork";
                this.validClassItems[classID][6] = "Spatula";
                this.validClassItems[classID][7] = "Frying pan";
                this.validClassItems[classID][8] = "Skewer";
                this.validClassItems[classID][9] = "Rolling pin";
                this.validClassItems[classID][10] = "Kitchen knife";
                this.validClassItems[classID][11] = "Meat tenderiser";
                this.validClassItems[classID][12] = "Cleaver";
                this.validClassItems[classID][13] = "Rubber chicken";
                this.validClassItems[classID][14] = "Carrot sword";
                this.validClassItems[classID][15] = "Candy cane";
                this.validClassItems[classID][16] = "scimitar";
                this.validClassItems[classID][17] = "shield";
                this.validClassItems[classID][18] = "harpoon";
                this.validClassItems[classID][19] = "----";
                this.validClassItems[classID][20] = "----";
                break;
            }
            case "Cleric": {
                classID = this.getClassID(PlayerClass);
                this.validClassItems[classID][0] = PlayerClass;
                this.validClassItems[classID][1] = "dagger";
                this.validClassItems[classID][2] = "sword";
                this.validClassItems[classID][3] = "Holy water";
                this.validClassItems[classID][4] = "mace";
                this.validClassItems[classID][5] = "flail";
                this.validClassItems[classID][6] = "sickle";
                this.validClassItems[classID][7] = "banner";
                this.validClassItems[classID][8] = "halberd";
                this.validClassItems[classID][9] = "godsword";
                this.validClassItems[classID][10] = "shield";
                this.validClassItems[classID][11] = "----";
                this.validClassItems[classID][12] = "----";
                this.validClassItems[classID][13] = "----";
                this.validClassItems[classID][14] = "----";
                this.validClassItems[classID][15] = "----";
                this.validClassItems[classID][16] = "----";
                this.validClassItems[classID][17] = "----";
                this.validClassItems[classID][18] = "----";
                this.validClassItems[classID][19] = "----";
                this.validClassItems[classID][20] = "----";
                break;
            }
            case "Necromancer": {
                classID = this.getClassID(PlayerClass);
                this.validClassItems[classID][0] = PlayerClass;
                this.validClassItems[classID][1] = "Staff";
                this.validClassItems[classID][2] = "staff";
                this.validClassItems[classID][3] = "sceptre";
                this.validClassItems[classID][4] = "crozier";
                this.validClassItems[classID][5] = "Dawnbringer";
                this.validClassItems[classID][6] = "book of";
                this.validClassItems[classID][7] = "tome";
                this.validClassItems[classID][8] = "----";
                this.validClassItems[classID][9] = "----";
                this.validClassItems[classID][10] = "----";
                this.validClassItems[classID][11] = "----";
                this.validClassItems[classID][12] = "----";
                this.validClassItems[classID][13] = "----";
                this.validClassItems[classID][14] = "----";
                this.validClassItems[classID][15] = "----";
                this.validClassItems[classID][16] = "----";
                this.validClassItems[classID][17] = "----";
                this.validClassItems[classID][18] = "----";
                this.validClassItems[classID][19] = "----";
                this.validClassItems[classID][20] = "----";
                break;
            }
            case "Ranger": {
                classID = this.getClassID(PlayerClass);
                this.validClassItems[classID][0] = PlayerClass;
                this.validClassItems[classID][1] = "bow";
                this.validClassItems[classID][2] = "sword";
                this.validClassItems[classID][3] = "dagger";
                this.validClassItems[classID][4] = "arrow";
                this.validClassItems[classID][5] = "bolt";
                this.validClassItems[classID][6] = "Chinchompa";
                this.validClassItems[classID][7] = "crossbow";
                this.validClassItems[classID][8] = "knife";
                this.validClassItems[classID][9] = "Teasing stick";
                this.validClassItems[classID][10] = "Machete";
                this.validClassItems[classID][11] = "Butterfly Net";
                this.validClassItems[classID][12] = "Harpoon";
                this.validClassItems[classID][13] = " axe";
                this.validClassItems[classID][14] = "----";
                this.validClassItems[classID][15] = "----";
                this.validClassItems[classID][16] = "----";
                this.validClassItems[classID][17] = "----";
                this.validClassItems[classID][18] = "----";
                this.validClassItems[classID][19] = "----";
                this.validClassItems[classID][20] = "----";
                break;
            }
            case "Wizard": {
                classID = this.getClassID(PlayerClass);
                this.validClassItems[classID][0] = PlayerClass;
                this.validClassItems[classID][1] = "Staff";
                this.validClassItems[classID][2] = "staff";
                this.validClassItems[classID][3] = "sceptre";
                this.validClassItems[classID][4] = "crozier";
                this.validClassItems[classID][5] = "Dawnbringer";
                this.validClassItems[classID][6] = "wand";
                this.validClassItems[classID][7] = "mage";
                this.validClassItems[classID][8] = "book of";
                this.validClassItems[classID][9] = "tome";
                this.validClassItems[classID][10] = "----";
                this.validClassItems[classID][11] = "----";
                this.validClassItems[classID][12] = "----";
                this.validClassItems[classID][13] = "----";
                this.validClassItems[classID][14] = "----";
                this.validClassItems[classID][15] = "----";
                this.validClassItems[classID][16] = "----";
                this.validClassItems[classID][17] = "----";
                this.validClassItems[classID][18] = "----";
                this.validClassItems[classID][19] = "----";
                this.validClassItems[classID][20] = "----";
                break;
            }
            case "Paladin": {
                classID = this.getClassID(PlayerClass);
                this.validClassItems[classID][0] = PlayerClass;
                this.validClassItems[classID][1] = "godsword";
                this.validClassItems[classID][2] = "bulwark";
                this.validClassItems[classID][3] = "----";
                this.validClassItems[classID][4] = "flail";
                this.validClassItems[classID][5] = "2h";
                this.validClassItems[classID][6] = "hasta";
                this.validClassItems[classID][7] = "spear";
                this.validClassItems[classID][8] = "bludgeon";
                this.validClassItems[classID][9] = "banner";
                this.validClassItems[classID][10] = "mjolnir";
                this.validClassItems[classID][11] = "blessing";
                this.validClassItems[classID][12] = " sword";
                this.validClassItems[classID][13] = " longsword";
                this.validClassItems[classID][14] = "shield";
                this.validClassItems[classID][15] = "light";
                this.validClassItems[classID][16] = "silverlight";
                this.validClassItems[classID][17] = "darklight";
                this.validClassItems[classID][18] = "arclight";
                this.validClassItems[classID][19] = "----";
                this.validClassItems[classID][20] = "----";
                break;
            }
            case "Barbarian": {
                classID = this.getClassID(PlayerClass);
                this.validClassItems[classID][0] = PlayerClass;
                this.validClassItems[classID][1] = "axe";
                this.validClassItems[classID][2] = "thrownaxe";
                this.validClassItems[classID][3] = "great";
                this.validClassItems[classID][4] = "hammer";
                this.validClassItems[classID][5] = "spear";
                this.validClassItems[classID][6] = "javelin";
                this.validClassItems[classID][7] = "club";
                this.validClassItems[classID][8] = "maul";
                this.validClassItems[classID][9] = "Machete";
                this.validClassItems[classID][10] = "Pickaxe";
                this.validClassItems[classID][11] = "----";
                this.validClassItems[classID][12] = "----";
                this.validClassItems[classID][13] = "----";
                this.validClassItems[classID][14] = "----";
                this.validClassItems[classID][15] = "----";
                this.validClassItems[classID][16] = "----";
                this.validClassItems[classID][17] = "----";
                this.validClassItems[classID][18] = "----";
                this.validClassItems[classID][19] = "----";
                this.validClassItems[classID][20] = "----";
                break;
            }
            case "Bard": {
                classID = this.getClassID(PlayerClass);
                this.validClassItems[classID][0] = PlayerClass;
                this.validClassItems[classID][1] = "rapier";
                this.validClassItems[classID][2] = "dagger";
                this.validClassItems[classID][3] = "scimitar";
                this.validClassItems[classID][4] = "lyre";
                this.validClassItems[classID][5] = "knife";
                this.validClassItems[classID][6] = "wand";
                this.validClassItems[classID][7] = "----";
                this.validClassItems[classID][8] = "----";
                this.validClassItems[classID][9] = "----";
                this.validClassItems[classID][10] = "----";
                this.validClassItems[classID][11] = "----";
                this.validClassItems[classID][12] = "----";
                this.validClassItems[classID][13] = "----";
                this.validClassItems[classID][14] = "----";
                this.validClassItems[classID][15] = "----";
                this.validClassItems[classID][16] = "----";
                this.validClassItems[classID][17] = "----";
                this.validClassItems[classID][18] = "----";
                this.validClassItems[classID][19] = "----";
                this.validClassItems[classID][20] = "----";
                break;
            }
            case "Druid": {
                classID = this.getClassID(PlayerClass);
                this.validClassItems[classID][0] = PlayerClass;
                this.validClassItems[classID][1] = "secateurs";
                this.validClassItems[classID][2] = "staff";
                this.validClassItems[classID][3] = "Guthix";
                this.validClassItems[classID][4] = "sickle";
                this.validClassItems[classID][5] = "dagger";
                this.validClassItems[classID][6] = "Butterfly Net";
                this.validClassItems[classID][7] = " axe";
                this.validClassItems[classID][8] = "----";
                this.validClassItems[classID][9] = "----";
                this.validClassItems[classID][10] = "----";
                this.validClassItems[classID][11] = "----";
                this.validClassItems[classID][12] = "----";
                this.validClassItems[classID][13] = "----";
                this.validClassItems[classID][14] = "----";
                this.validClassItems[classID][15] = "----";
                this.validClassItems[classID][16] = "----";
                this.validClassItems[classID][17] = "----";
                this.validClassItems[classID][18] = "----";
                this.validClassItems[classID][19] = "----";
                this.validClassItems[classID][20] = "----";
                break;
            }
            case "Fighter": {
                classID = this.getClassID(PlayerClass);
                this.validClassItems[classID][0] = PlayerClass;
                this.validClassItems[classID][1] = "longsword";
                this.validClassItems[classID][2] = "2h";
                this.validClassItems[classID][3] = "axe";
                this.validClassItems[classID][4] = "hammer";
                this.validClassItems[classID][5] = "scimitar";
                this.validClassItems[classID][6] = "rapier";
                this.validClassItems[classID][7] = "battle";
                this.validClassItems[classID][8] = "mace";
                this.validClassItems[classID][9] = "dagger";
                this.validClassItems[classID][10] = " sword";
                this.validClassItems[classID][11] = "shield";
                this.validClassItems[classID][12] = "defender";
                this.validClassItems[classID][13] = "silverlight";
                this.validClassItems[classID][14] = "darklight";
                this.validClassItems[classID][15] = "----";
                this.validClassItems[classID][16] = "----";
                this.validClassItems[classID][17] = "----";
                this.validClassItems[classID][18] = "----";
                this.validClassItems[classID][19] = "----";
                this.validClassItems[classID][20] = "----";
                break;
            }
            case "Monk": {
                classID = this.getClassID(PlayerClass);
                this.validClassItems[classID][0] = PlayerClass;
                this.validClassItems[classID][1] = "claws";
                this.validClassItems[classID][2] = "whip";
                this.validClassItems[classID][3] = "sickle";
                this.validClassItems[classID][4] = "Battlestaff";
                this.validClassItems[classID][5] = "holy water";
                this.validClassItems[classID][6] = "blessing";
                this.validClassItems[classID][7] = "shield";
                this.validClassItems[classID][8] = "----";
                this.validClassItems[classID][9] = "----";
                this.validClassItems[classID][10] = "----";
                this.validClassItems[classID][11] = "----";
                this.validClassItems[classID][12] = "----";
                this.validClassItems[classID][13] = "----";
                this.validClassItems[classID][14] = "----";
                this.validClassItems[classID][15] = "----";
                this.validClassItems[classID][16] = "----";
                this.validClassItems[classID][17] = "----";
                this.validClassItems[classID][18] = "----";
                this.validClassItems[classID][19] = "----";
                this.validClassItems[classID][20] = "----";
                break;
            }
            case "Rogue": {
                classID = this.getClassID(PlayerClass);
                this.validClassItems[classID][0] = PlayerClass;
                this.validClassItems[classID][1] = "dagger";
                this.validClassItems[classID][2] = "dart";
                this.validClassItems[classID][3] = "knife";
                this.validClassItems[classID][4] = "crossbow";
                this.validClassItems[classID][5] = "bolt";
                this.validClassItems[classID][6] = "blackjack";
                this.validClassItems[classID][7] = "rapier";
                this.validClassItems[classID][8] = "defender";
                this.validClassItems[classID][9] = "----";
                this.validClassItems[classID][10] = "----";
                this.validClassItems[classID][11] = "----";
                this.validClassItems[classID][12] = "----";
                this.validClassItems[classID][13] = "----";
                this.validClassItems[classID][14] = "----";
                this.validClassItems[classID][15] = "----";
                this.validClassItems[classID][16] = "----";
                this.validClassItems[classID][17] = "----";
                this.validClassItems[classID][18] = "----";
                this.validClassItems[classID][19] = "----";
                this.validClassItems[classID][20] = "----";
                break;
            }
            case "Warlock": {
                classID = this.getClassID(PlayerClass);
                this.validClassItems[classID][0] = PlayerClass;
                this.validClassItems[classID][1] = "staff";
                this.validClassItems[classID][2] = "wand";
                this.validClassItems[classID][3] = "blessing";
                this.validClassItems[classID][4] = "tome";
                this.validClassItems[classID][5] = "book of";
                this.validClassItems[classID][6] = "silverlight";
                this.validClassItems[classID][7] = "darklight";
                this.validClassItems[classID][8] = "arclight";
                this.validClassItems[classID][9] = "----";
                this.validClassItems[classID][10] = "----";
                this.validClassItems[classID][11] = "----";
                this.validClassItems[classID][12] = "----";
                this.validClassItems[classID][13] = "----";
                this.validClassItems[classID][14] = "----";
                this.validClassItems[classID][15] = "----";
                this.validClassItems[classID][16] = "----";
                this.validClassItems[classID][17] = "----";
                this.validClassItems[classID][18] = "----";
                this.validClassItems[classID][19] = "----";
                this.validClassItems[classID][20] = "----";
            }
        }
    }

    private int getClassID(String PlayerClass) {
        int classID = 0;
        switch (PlayerClass) {
            case "None": {
                classID = 0;
                break;
            }
            case "Chef": {
                classID = 1;
                break;
            }
            case "Cleric": {
                classID = 2;
                break;
            }
            case "Artificer": {
                classID = 3;
                break;
            }
            case "Necromancer": {
                classID = 4;
                break;
            }
            case "Ranger": {
                classID = 5;
                break;
            }
            case "Wizard": {
                classID = 6;
                break;
            }
            case "Paladin": {
                classID = 7;
                break;
            }
            case "Barbarian": {
                classID = 8;
                break;
            }
            case "Bard": {
                classID = 9;
                break;
            }
            case "Druid": {
                classID = 10;
                break;
            }
            case "Fighter": {
                classID = 11;
                break;
            }
            case "Monk": {
                classID = 12;
                break;
            }
            case "Rogue": {
                classID = 13;
                break;
            }
            case "Warlock": {
                classID = 14;
            }
        }
        return classID;
    }

    private void setClassDialogue(String ClassName) {
        Objects.requireNonNull(ClassName);
    }

    private void setClassPermanentItems(String ClassName) {
        switch (ClassName) {
            case "Chef": {
                int ClassID = this.getClassID(ClassName);
                this.permClassItems[ClassID][0] = ClassName;
                this.permClassItems[ClassID][1] = "Chef's hat";
                this.permClassItems[ClassID][2] = "Golden chef's hat";
                this.permClassItems[ClassID][3] = "Golden apron";
                this.permClassItems[ClassID][4] = "----";
                this.permClassItems[ClassID][5] = "----";
                this.permClassItems[ClassID][6] = "----";
                this.permClassItems[ClassID][7] = "----";
                this.permClassItems[ClassID][8] = "----";
                this.permClassItems[ClassID][9] = "----";
                this.permClassItems[ClassID][10] = "----";
                this.permClassItems[ClassID][11] = "----";
                this.permClassItems[ClassID][12] = "----";
                this.permClassItems[ClassID][13] = "----";
                this.permClassItems[ClassID][14] = "----";
                this.permClassItems[ClassID][15] = "----";
                this.permClassItems[ClassID][16] = "----";
                this.permClassItems[ClassID][17] = "----";
                this.permClassItems[ClassID][18] = "----";
                this.permClassItems[ClassID][19] = "----";
                this.permClassItems[ClassID][20] = "----";
            }
            case "Artificer": {
                int ClassID = this.getClassID(ClassName);
                this.permClassItems[ClassID][0] = ClassName;
                this.permClassItems[ClassID][1] = "Smiths tunic";
                this.permClassItems[ClassID][2] = "Smiths trousers";
                this.permClassItems[ClassID][3] = "Smiths gloves";
                this.permClassItems[ClassID][4] = "Smiths boots";
                this.permClassItems[ClassID][5] = "----";
                this.permClassItems[ClassID][6] = "----";
                this.permClassItems[ClassID][7] = "----";
                this.permClassItems[ClassID][8] = "----";
                this.permClassItems[ClassID][9] = "----";
                this.permClassItems[ClassID][10] = "----";
                this.permClassItems[ClassID][11] = "----";
                this.permClassItems[ClassID][12] = "----";
                this.permClassItems[ClassID][13] = "----";
                this.permClassItems[ClassID][14] = "----";
                this.permClassItems[ClassID][15] = "----";
                this.permClassItems[ClassID][16] = "----";
                this.permClassItems[ClassID][17] = "----";
                this.permClassItems[ClassID][18] = "----";
                this.permClassItems[ClassID][19] = "----";
                this.permClassItems[ClassID][20] = "----";
            }
            case "Ranger": {
                int ClassID = this.getClassID(ClassName);
                this.permClassItems[ClassID][0] = ClassName;
                this.permClassItems[ClassID][1] = "Ranger";
                this.permClassItems[ClassID][2] = "Robin hood hat";
                this.permClassItems[ClassID][3] = "----";
                this.permClassItems[ClassID][4] = "----";
                this.permClassItems[ClassID][5] = "----";
                this.permClassItems[ClassID][6] = "----";
                this.permClassItems[ClassID][7] = "----";
                this.permClassItems[ClassID][8] = "----";
                this.permClassItems[ClassID][9] = "----";
                this.permClassItems[ClassID][10] = "----";
                this.permClassItems[ClassID][11] = "----";
                this.permClassItems[ClassID][12] = "----";
                this.permClassItems[ClassID][13] = "----";
                this.permClassItems[ClassID][14] = "----";
                this.permClassItems[ClassID][15] = "----";
                this.permClassItems[ClassID][16] = "----";
                this.permClassItems[ClassID][17] = "----";
                this.permClassItems[ClassID][18] = "----";
                this.permClassItems[ClassID][19] = "----";
                this.permClassItems[ClassID][20] = "----";
            }
            case "Wizard": {
                int ClassID = this.getClassID(ClassName);
                this.permClassItems[ClassID][0] = ClassName;
                this.permClassItems[ClassID][1] = "Wizard hat";
                this.permClassItems[ClassID][2] = "Blue wizard hat";
                this.permClassItems[ClassID][3] = "Master wand";
                this.permClassItems[ClassID][4] = "----";
                this.permClassItems[ClassID][5] = "----";
                this.permClassItems[ClassID][6] = "----";
                this.permClassItems[ClassID][7] = "----";
                this.permClassItems[ClassID][8] = "----";
                this.permClassItems[ClassID][9] = "----";
                this.permClassItems[ClassID][10] = "----";
                this.permClassItems[ClassID][11] = "----";
                this.permClassItems[ClassID][12] = "----";
                this.permClassItems[ClassID][13] = "----";
                this.permClassItems[ClassID][14] = "----";
                this.permClassItems[ClassID][15] = "----";
                this.permClassItems[ClassID][16] = "----";
                this.permClassItems[ClassID][17] = "----";
                this.permClassItems[ClassID][18] = "----";
                this.permClassItems[ClassID][19] = "----";
                this.permClassItems[ClassID][20] = "----";
            }
        }
    }

    public String getCurrentItemName(MenuOptionClicked event) {
        ItemComposition currentItem = this.itemManager.getItemComposition(event.getItemId());
        String itemName = currentItem.getName();
        return itemName;
    }

    private boolean entryMatches(MenuOptionClicked entry, String option) {
        return entry.getMenuOption().equals(option);
    }

    private void sendChatMessage(String message) {
        String finalMsg = new ChatMessageBuilder().append(ChatColorType.HIGHLIGHT).append(message).build();
        this.chatMessageManager.queue(QueuedMessage.builder().type(ChatMessageType.CONSOLE).runeLiteFormattedMessage(finalMsg).build());
    }

    @Provides
    ClassesOfGielinorConfig provideConfig(ConfigManager configManager) {
        return (ClassesOfGielinorConfig)configManager.getConfig(ClassesOfGielinorConfig.class);
    }

    @Subscribe
    public void onMenuOptionClicked(MenuOptionClicked event) {
        String target = Text.removeTags((String)event.getMenuTarget());
        if (this.entryMatches(event, "Cast")) {
            if (this.spellCaster || this.config.classIsSpellcaster()) {
                return;
            }
            event.consume();
            this.sendChatMessage("The magical arts are a mystery to you. You cannot cast spells.");
            return;
        }
        if (this.entryMatches(event, "Wield")) {
            String itemName = this.getCurrentItemName(event);
            if (!this.checkAllowedItemsArray(itemName) && !this.config.enableNonClassItems()) {
                event.consume();
                this.msgStr = "As a " + this.config.playerClass().toString() + " you cannot wield the " + itemName + ".";
                this.sendChatMessage(this.msgStr);
            }
            return;
        }
        if (this.entryMatches(event, "Activate")) {
            String prayerName = event.getMenuTarget();
            if (!(this.prayerAllowed || this.config.forceAllowPrayer() || prayerName.contains("Protect from") && this.config.allowProtectPrayers())) {
                event.consume();
                this.msgStr = "Why would a " + this.config.playerClass().toString() + " pray to the Gods? I'll pass.";
                this.sendChatMessage(this.msgStr);
            }
        }
        if (this.entryMatches(event, "Pray-at") || this.entryMatches(event, "Pray")) {
            this.msgStr = "";
            WorldPoint currentCoords = this.client.getLocalPlayer().getWorldLocation();
            int currentX = currentCoords.getX();
            int currentY = currentCoords.getY();
            boolean altarFoundFlag = false;
            int altarMatch = 0;
            int MinXProx = currentX - 2;
            int MaxXProx = currentX + 2;
            int MinYProx = currentY - 2;
            int MaxYProx = currentY + 2;
            for (int i = 0; i < this.worldAltars.length; ++i) {
                if (altarFoundFlag) continue;
                String[] altarCoords = this.worldAltars[i][1].split(",");
                int altarX = Integer.parseInt(altarCoords[0]);
                int altarY = Integer.parseInt(altarCoords[1]);
                if (altarX > MaxXProx || altarX < MinXProx || altarY > MaxYProx || altarY < MinYProx) continue;
                altarFoundFlag = true;
                altarMatch = i;
            }
            if (altarMatch > 0) {
                String altarDiety = this.worldAltars[altarMatch][2];
                int GodFound = 0;
                for (int x = 0; x < this.playerDeities.length; ++x) {
                    if (!this.playerDeities[x].contains(altarDiety)) continue;
                    GodFound = 1;
                }
                if (GodFound > 0) {
                    this.msgStr = "You feel the embrace of " + altarDiety + " as you approach the altar.";
                    this.sendChatMessage(this.msgStr);
                } else {
                    event.consume();
                    this.msgStr = "You feel nothing. You do not have the blessing of " + altarDiety;
                    this.sendChatMessage(this.msgStr);
                }
            }
        }
    }
}

