/*
 * Decompiled with CFR 0.152.
 */
package net.runelite.client.plugins.bettertimers;

import com.google.inject.Provides;
import java.awt.image.BufferedImage;
import javax.inject.Inject;
import net.runelite.api.Client;
import net.runelite.api.events.GameTick;
import net.runelite.api.events.VarbitChanged;
import net.runelite.client.config.ConfigManager;
import net.runelite.client.eventbus.Subscribe;
import net.runelite.client.game.ItemManager;
import net.runelite.client.plugins.Plugin;
import net.runelite.client.plugins.PluginDescriptor;
import net.runelite.client.plugins.bettertimers.BetterOverloadConfig;
import net.runelite.client.plugins.bettertimers.BetterOverloadInfoBox;
import net.runelite.client.plugins.bettertimers.BetterOverloadMenaphiteRemedyInfoBox;
import net.runelite.client.plugins.bettertimers.BetterOverloadSaltInfoBox;
import net.runelite.client.ui.overlay.infobox.InfoBox;
import net.runelite.client.ui.overlay.infobox.InfoBoxManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@PluginDescriptor(name="Better Overload", description="Improved overload timer, to account for world lag.", tags={"better", "overload", "ovl", "betterovl", "better overload"})
public class BetterOverloadPlugin
extends Plugin {
    private static final Logger log = LoggerFactory.getLogger(BetterOverloadPlugin.class);
    @Inject
    private Client client;
    @Inject
    private BetterOverloadConfig config;
    @Inject
    private InfoBoxManager infoBoxManager;
    @Inject
    private ItemManager itemManager;
    boolean overloaded;
    private BetterOverloadInfoBox infoBox;
    int overloadInTicks = -1;
    int prevOvlCycles = 0;
    boolean salted;
    private BetterOverloadSaltInfoBox saltInfoBox;
    int saltInTicks = -1;
    int prevSaltCycles = 0;
    boolean menaphiteRemedied;
    private BetterOverloadMenaphiteRemedyInfoBox menaphiteRemedyInfoBox;
    int menaphiteRemedyInTicks = -1;
    int prevMenaphiteRemedyCycles = 0;
    private final int varbOvl = 5418;
    private final int varbSalt = 14344;
    private final int varbMenaphiteRemedy = 14448;

    protected void startUp() throws Exception {
    }

    protected void shutDown() throws Exception {
        this.overloaded = false;
        this.overloadInTicks = -1;
        this.prevOvlCycles = 0;
        if (this.infoBox != null) {
            this.infoBoxManager.removeInfoBox((InfoBox)this.infoBox);
            this.infoBox = null;
        }
        this.salted = false;
        this.saltInTicks = -1;
        this.prevSaltCycles = 0;
        if (this.saltInfoBox != null) {
            this.infoBoxManager.removeInfoBox((InfoBox)this.saltInfoBox);
            this.saltInfoBox = null;
        }
        this.menaphiteRemedied = false;
        this.menaphiteRemedyInTicks = -1;
        this.prevMenaphiteRemedyCycles = 0;
        if (this.menaphiteRemedyInfoBox != null) {
            this.infoBoxManager.removeInfoBox((InfoBox)this.menaphiteRemedyInfoBox);
            this.menaphiteRemedyInfoBox = null;
        }
    }

    @Subscribe
    public void onGameTick(GameTick event) {
        if (!(this.overloaded || this.salted || this.menaphiteRemedied)) {
            return;
        }
        if (this.client.getVarbitValue(5418) > 0) {
            this.ovlAdd();
        }
        if (this.client.getVarbitValue(5418) == 0) {
            this.ovlReset();
        }
        if (this.client.getVarbitValue(14344) > 0) {
            this.saltAdd();
        }
        if (this.client.getVarbitValue(14344) == 0) {
            this.saltReset();
        }
        if (this.client.getVarbitValue(14448) > 0) {
            this.menaphiteRemedyAdd();
        }
        if (this.client.getVarbitValue(14448) == 0) {
            this.menaphiteRemedyReset();
        }
        --this.overloadInTicks;
        --this.saltInTicks;
        --this.menaphiteRemedyInTicks;
    }

    @Subscribe
    public void onVarbitChanged(VarbitChanged event) {
        if (this.client.getVarbitValue(5418) > 0 && this.prevOvlCycles == 0) {
            this.prevOvlCycles = this.client.getVarbitValue(5418);
            this.overloadInTicks = this.client.getVarbitValue(5418) * 25;
            this.ovlAdd();
        }
        if (this.client.getVarbitValue(5418) < this.prevOvlCycles || this.client.getVarbitValue(5418) > this.prevOvlCycles) {
            this.overloadInTicks = this.client.getVarbitValue(5418) * 25;
            this.prevOvlCycles = this.client.getVarbitValue(5418);
            this.ovlAdd();
        }
        if (this.client.getVarbitValue(14344) > 0 && this.prevSaltCycles == 0) {
            this.prevSaltCycles = this.client.getVarbitValue(14344);
            this.saltInTicks = this.client.getVarbitValue(14344) * 25;
            this.saltAdd();
        }
        if (this.client.getVarbitValue(14344) < this.prevSaltCycles || this.client.getVarbitValue(14344) > this.prevSaltCycles) {
            this.saltInTicks = this.client.getVarbitValue(14344) * 25;
            this.prevSaltCycles = this.client.getVarbitValue(14344);
            this.saltAdd();
        }
        if (this.client.getVarbitValue(14448) > 0 && this.prevMenaphiteRemedyCycles == 0) {
            this.prevMenaphiteRemedyCycles = this.client.getVarbitValue(14448);
            this.menaphiteRemedyInTicks = this.client.getVarbitValue(14448) * 25;
            this.menaphiteRemedyAdd();
        }
        if (this.client.getVarbitValue(14448) < this.prevMenaphiteRemedyCycles || this.client.getVarbitValue(14448) > this.prevMenaphiteRemedyCycles) {
            this.menaphiteRemedyInTicks = this.client.getVarbitValue(14448) * 25;
            this.prevMenaphiteRemedyCycles = this.client.getVarbitValue(14448);
            this.menaphiteRemedyAdd();
        }
    }

    @Provides
    BetterOverloadConfig provideConfig(ConfigManager configManager) {
        return (BetterOverloadConfig)configManager.getConfig(BetterOverloadConfig.class);
    }

    public void ovlAdd() {
        this.overloaded = true;
        if (this.infoBox == null) {
            this.infoBox = new BetterOverloadInfoBox(this.client, this, this.config);
            int ovlId = 20996;
            this.infoBox.setImage((BufferedImage)this.itemManager.getImage(ovlId));
            this.infoBoxManager.addInfoBox((InfoBox)this.infoBox);
        }
    }

    public void ovlReset() {
        this.prevOvlCycles = 0;
        this.overloaded = false;
        this.infoBoxManager.removeInfoBox((InfoBox)this.infoBox);
        this.infoBox = null;
    }

    public void saltAdd() {
        this.salted = true;
        if (!this.config.enableSalt()) {
            return;
        }
        if (this.saltInfoBox == null) {
            this.saltInfoBox = new BetterOverloadSaltInfoBox(this.client, this, this.config);
            int saltId = 27343;
            this.saltInfoBox.setImage((BufferedImage)this.itemManager.getImage(saltId));
            this.infoBoxManager.addInfoBox((InfoBox)this.saltInfoBox);
        }
    }

    public void saltReset() {
        this.prevSaltCycles = 0;
        this.salted = false;
        this.infoBoxManager.removeInfoBox((InfoBox)this.saltInfoBox);
        this.saltInfoBox = null;
    }

    public void menaphiteRemedyAdd() {
        this.menaphiteRemedied = true;
        if (!this.config.enableMenaphiteRemedy()) {
            return;
        }
        if (this.menaphiteRemedyInfoBox == null) {
            this.menaphiteRemedyInfoBox = new BetterOverloadMenaphiteRemedyInfoBox(this.client, this, this.config);
            int menaphiteRemedyId = 27202;
            this.menaphiteRemedyInfoBox.setImage((BufferedImage)this.itemManager.getImage(menaphiteRemedyId));
            this.infoBoxManager.addInfoBox((InfoBox)this.menaphiteRemedyInfoBox);
        }
    }

    public void menaphiteRemedyReset() {
        this.prevMenaphiteRemedyCycles = 0;
        this.menaphiteRemedied = false;
        this.infoBoxManager.removeInfoBox((InfoBox)this.menaphiteRemedyInfoBox);
        this.menaphiteRemedyInfoBox = null;
    }

    public static String to_mmss(int ticks) {
        int m;
        int s = (ticks - (m = ticks / 100) * 100) * 6 / 10;
        return m + (s < 10 ? ":0" : ":") + s;
    }

    public static String to_mmss_precise_short(int ticks) {
        int min = ticks / 100;
        int tmp = (ticks - min * 100) * 6;
        int sec = tmp / 10;
        int sec_tenth = tmp - sec * 10;
        return min + (sec < 10 ? ":0" : ":") + sec + "." + sec_tenth;
    }
}

