/*
 * Decompiled with CFR 0.152.
 */
package com.clantracker.api;

import com.clantracker.ClanTrackerConfig;
import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.inject.Provides;
import java.io.IOException;
import java.util.List;
import java.util.concurrent.TimeUnit;
import javax.inject.Inject;
import net.runelite.client.config.ConfigManager;
import okhttp3.Call;
import okhttp3.Callback;
import okhttp3.MediaType;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class APIClient {
    private static final Logger log = LoggerFactory.getLogger(APIClient.class);
    @Inject
    private ClanTrackerConfig config;
    @Inject
    private Gson gson;
    private static final MediaType JSON = MediaType.parse((String)"application/json");
    private static final String ANALYZE = "analyze";
    private static final String ONLINE_COUNT = "onlinecount";
    private static final String GET_SEQUENCE = "getsequence";
    private static OkHttpClient okHttpClient;

    @Provides
    ClanTrackerConfig provideConfig(ConfigManager configManager) {
        return (ClanTrackerConfig)configManager.getConfig(ClanTrackerConfig.class);
    }

    @Inject
    public APIClient(OkHttpClient rlClient) {
        okHttpClient = rlClient.newBuilder().pingInterval(0L, TimeUnit.SECONDS).connectTimeout(30L, TimeUnit.SECONDS).readTimeout(30L, TimeUnit.SECONDS).addNetworkInterceptor(chain -> {
            Request headerRequest = chain.request().newBuilder().header("User-Agent", "ClanTracker-Plugin-1.0.0").build();
            return chain.proceed(headerRequest);
        }).build();
    }

    public void getSequence(String clanName, Callback callback) throws IOException {
        if (this.config.apiUrl() == null) {
            return;
        }
        JsonObject apiRequestBody = new JsonObject();
        apiRequestBody.addProperty("clan", clanName);
        RequestBody body = RequestBody.create((MediaType)JSON, (String)this.gson.toJson((JsonElement)apiRequestBody));
        Request request = new Request.Builder().post(body).url(this.config.apiUrl() + GET_SEQUENCE).build();
        OkHttpClient client = okHttpClient;
        Call call = client.newCall(request);
        call.enqueue(callback);
    }

    public void sendOnlineCount(List<String> onlinePlayersList, String clanName, String pluginPassword, final Callback callback) throws IOException {
        if (this.config.apiUrl() == null) {
            return;
        }
        int onlineCount = onlinePlayersList.size();
        JsonObject apiRequestBody = new JsonObject();
        apiRequestBody.addProperty("clan", clanName);
        apiRequestBody.addProperty("cpw", pluginPassword);
        apiRequestBody.addProperty("onlineCount", (Number)onlineCount);
        RequestBody body = RequestBody.create((MediaType)JSON, (String)this.gson.toJson((JsonElement)apiRequestBody));
        Request request = new Request.Builder().post(body).url(this.config.apiUrl() + ONLINE_COUNT).build();
        OkHttpClient client = okHttpClient;
        Call call = client.newCall(request);
        call.enqueue(new Callback(){

            public void onFailure(Call call, IOException e) {
                callback.onFailure(call, e);
            }

            public void onResponse(Call call, Response response) throws IOException {
                callback.onResponse(call, response);
                response.close();
            }
        });
    }

    public void message(final String clanName, final String pluginPassword, final int sequenceNumber, final int requestType, final String author, final String content, final int retryAttempt, final int maxAttempts, final Callback callback) throws IOException {
        if (this.config.apiUrl() == null) {
            return;
        }
        JsonObject apiRequestBody = new JsonObject();
        apiRequestBody.addProperty("clan", clanName);
        apiRequestBody.addProperty("cpw", pluginPassword);
        apiRequestBody.addProperty("sequence_number", (Number)sequenceNumber);
        apiRequestBody.addProperty("req_type", (Number)requestType);
        apiRequestBody.addProperty("author", author);
        apiRequestBody.addProperty("content", content);
        RequestBody body = RequestBody.create((MediaType)JSON, (String)this.gson.toJson((JsonElement)apiRequestBody));
        Request request = new Request.Builder().post(body).url(this.config.apiUrl() + ANALYZE).build();
        OkHttpClient client = okHttpClient;
        Call call = client.newCall(request);
        call.enqueue(new Callback(){

            public void onFailure(Call call, IOException e) {
                if (retryAttempt < maxAttempts) {
                    try {
                        APIClient.this.message(clanName, pluginPassword, sequenceNumber, requestType, author, content, retryAttempt + 1, maxAttempts, callback);
                    }
                    catch (IOException ex) {
                        throw new RuntimeException(ex);
                    }
                } else {
                    callback.onFailure(call, e);
                }
            }

            public void onResponse(Call call, Response response) throws IOException {
                callback.onResponse(call, response);
            }
        });
    }
}

