/*
 * Decompiled with CFR 0.152.
 */
package com.clantracker;

import com.clantracker.ClanTrackerConfig;
import com.clantracker.api.APIClient;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.google.inject.Provides;
import java.io.IOException;
import java.time.temporal.ChronoUnit;
import java.util.ArrayList;
import java.util.List;
import javax.inject.Inject;
import net.runelite.api.Client;
import net.runelite.api.GameState;
import net.runelite.api.clan.ClanChannel;
import net.runelite.api.clan.ClanChannelMember;
import net.runelite.api.events.ChatMessage;
import net.runelite.api.events.ClanChannelChanged;
import net.runelite.client.callback.ClientThread;
import net.runelite.client.config.ConfigManager;
import net.runelite.client.eventbus.Subscribe;
import net.runelite.client.plugins.Plugin;
import net.runelite.client.plugins.PluginDescriptor;
import net.runelite.client.task.Schedule;
import okhttp3.Call;
import okhttp3.Callback;
import okhttp3.Response;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@PluginDescriptor(name="Clan Tracker", description="Tracks clan information and drops")
public class ClanTrackerPlugin
extends Plugin {
    private static final Logger log = LoggerFactory.getLogger(ClanTrackerPlugin.class);
    @Inject
    private Client client;
    @Inject
    private ClientThread clientThread;
    @Inject
    private ClanTrackerConfig config;
    @Inject
    private APIClient apiClient;
    public int sequenceNumber = 0;
    public boolean validClan = false;

    @Provides
    ClanTrackerConfig provideConfig(ConfigManager configManager) {
        return (ClanTrackerConfig)configManager.getConfig(ClanTrackerConfig.class);
    }

    private Boolean loggedIn() {
        return this.client.getGameState().equals((Object)GameState.LOGGED_IN);
    }

    public void setSequenceNumber(int newSequenceNumber) {
        this.sequenceNumber = newSequenceNumber;
    }

    public int getSequenceNumber() {
        return this.sequenceNumber;
    }

    protected void startUp() {
        this.setSequenceNumber(-1);
    }

    protected void shutDown() {
    }

    private SystemMessageType getSystemMessageType(String message) {
        if (message.contains("received a drop:")) {
            return SystemMessageType.DROP;
        }
        if (message.contains("received special loot from a raid:")) {
            return SystemMessageType.RAID_DROP;
        }
        if (message.contains("has completed a quest:")) {
            return SystemMessageType.QUEST;
        }
        if (message.contains("received a new collection log item:")) {
            return SystemMessageType.COLLECTION_LOG;
        }
        if (message.contains("personal best:")) {
            return SystemMessageType.PERSONAL_BEST;
        }
        if (message.contains("To talk in your clan's channel, start each line of chat with")) {
            return SystemMessageType.LOGIN;
        }
        if (message.contains("has defeated") || message.contains("has been defeated by")) {
            return SystemMessageType.PVP;
        }
        if (message.contains("has a funny feeling like")) {
            return SystemMessageType.PET_DROP;
        }
        return SystemMessageType.NORMAL;
    }

    private Callback getMessageCallback() {
        Callback callback = new Callback(){

            public void onFailure(Call call, IOException e) {
                ClanTrackerPlugin.this.setSequenceNumber(-1);
            }

            public void onResponse(Call call, Response response) throws IOException {
                if (response.body() == null) {
                    log.debug("API Call - Response was null.");
                    response.close();
                    ClanTrackerPlugin.this.setSequenceNumber(-1);
                } else {
                    String responseString = response.body().string();
                    JsonObject jsonResponse = new JsonParser().parse(responseString).getAsJsonObject();
                    int responseSequenceNumber = jsonResponse.get("sequence_number").getAsInt();
                    response.close();
                    if (response.code() == 403) {
                        ClanTrackerPlugin.this.setSequenceNumber(responseSequenceNumber);
                    }
                }
            }
        };
        return callback;
    }

    @Subscribe
    private void onClanChannelChanged(ClanChannelChanged event) {
        if (event.getClanId() == 0) {
            ClanChannel clan = this.client.getClanChannel();
            if (clan == null) {
                return;
            }
            String clanName = this.client.getClanChannel().getName();
            if (clanName == null) {
                return;
            }
            clanName = clanName.replace('\u00a0', ' ');
            try {
                Callback callback = new Callback(){

                    public void onResponse(Call call, Response response) throws IOException {
                        if (response.body() == null) {
                            log.debug("API Call - Response was null.");
                            response.close();
                        } else if (response.code() == 200) {
                            ClanTrackerPlugin.this.validClan = true;
                            String responseString = response.body().string();
                            JsonObject jsonResponse = new JsonParser().parse(responseString).getAsJsonObject();
                            response.close();
                            ClanTrackerPlugin.this.setSequenceNumber(jsonResponse.get("sequence_number").getAsInt());
                        } else {
                            ClanTrackerPlugin.this.validClan = false;
                        }
                    }

                    public void onFailure(Call call, IOException e) {
                        ClanTrackerPlugin.this.setSequenceNumber(-1);
                    }
                };
                this.apiClient.getSequence(clanName, callback);
            }
            catch (IOException e) {
                this.setSequenceNumber(-1);
            }
        }
    }

    @Subscribe
    private void onChatMessage(ChatMessage chatMessage) {
        if (!this.validClan) {
            return;
        }
        String clanName = "";
        switch (chatMessage.getType()) {
            case CLAN_CHAT: {
                String author = chatMessage.getName().replace('\u00a0', ' ').replaceAll("<img=\\d+>", "");
                String content = this.sanitizeMessage(chatMessage.getMessage());
                clanName = this.client.getClanChannel().getName().replace('\u00a0', ' ');
                if (content.contains("</col>")) break;
                try {
                    this.apiClient.message(clanName, this.config.pluginPassword(), this.sequenceNumber, 0, author, content, 0, 3, this.getMessageCallback());
                    this.setSequenceNumber(this.sequenceNumber + 1);
                    break;
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            }
            case CLAN_MESSAGE: {
                String author = chatMessage.getName().replace('\u00a0', ' ').replaceAll("<img=\\d+>", "");
                String content = this.sanitizeMessage(chatMessage.getMessage());
                clanName = this.client.getClanChannel().getName().replace('\u00a0', ' ');
                SystemMessageType messageType = this.getSystemMessageType(content);
                if (content.contains("</col>")) break;
                try {
                    this.apiClient.message(clanName, this.config.pluginPassword(), this.sequenceNumber, messageType.code, author, content, 0, 3, this.getMessageCallback());
                    this.setSequenceNumber(this.sequenceNumber + 1);
                    break;
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            }
        }
    }

    private List<String> getOnlineClanMembers() {
        List onlineMembers = this.client.getClanChannel().getMembers();
        ArrayList<String> onlineClanMembers = new ArrayList<String>();
        for (int i = 0; i < onlineMembers.size(); ++i) {
            if (this.client.getClanSettings().titleForRank(((ClanChannelMember)onlineMembers.get(i)).getRank()).getName().equals("Guest")) continue;
            onlineClanMembers.add(((ClanChannelMember)onlineMembers.get(i)).getName());
        }
        return onlineClanMembers;
    }

    @Schedule(period=5L, unit=ChronoUnit.MINUTES, asynchronous=true)
    public void onlineCountScheduleWrapper() {
        this.clientThread.invoke(this::sendClanOnlineCount);
    }

    public Callback getOnlineCountCallback() {
        Callback callback = new Callback(){

            public void onResponse(Call call, Response response) throws IOException {
            }

            public void onFailure(Call call, IOException e) {
                log.debug("Error " + e);
            }
        };
        return callback;
    }

    public void sendClanOnlineCount() {
        if (!this.loggedIn().booleanValue()) {
            return;
        }
        ClanChannel clan = this.client.getClanChannel();
        if (clan == null) {
            return;
        }
        String clanName = this.client.getClanChannel().getName();
        if (clanName == null) {
            return;
        }
        List<String> onlineMembers = this.getOnlineClanMembers();
        try {
            this.apiClient.sendOnlineCount(onlineMembers, clanName.replace('\u00a0', ' '), this.config.pluginPassword(), this.getOnlineCountCallback());
        }
        catch (IOException e) {
            log.debug("Exception!\n" + e);
        }
    }

    private String sanitizeMessage(String message) {
        String newMessage = message;
        newMessage = newMessage.replace('\u00a0', ' ');
        newMessage = newMessage.replace("<lt>", "<");
        newMessage = newMessage.replace("<gt>", ">");
        return this.additionalCustomizations(newMessage);
    }

    private String additionalCustomizations(String message) {
        String newMessage = message;
        newMessage = newMessage.replaceAll("\\<img=\\d+\\>", "");
        return newMessage;
    }

    public static enum SystemMessageType {
        NORMAL(1),
        DROP(2),
        RAID_DROP(3),
        PET_DROP(4),
        PERSONAL_BEST(5),
        COLLECTION_LOG(6),
        QUEST(7),
        PVP(8),
        LOGIN(-1);

        public final int code;

        private SystemMessageType(int code) {
            this.code = code;
        }
    }
}

