/*
 * Decompiled with CFR 0.152.
 */
package com.toofifty.easyblastfurnace.utils;

import com.toofifty.easyblastfurnace.methods.Method;
import com.toofifty.easyblastfurnace.state.BlastFurnaceState;
import com.toofifty.easyblastfurnace.utils.BarsOres;
import com.toofifty.easyblastfurnace.utils.CoalPer;
import com.toofifty.easyblastfurnace.utils.Graceful;
import com.toofifty.easyblastfurnace.utils.MethodHandler;
import java.time.Duration;
import java.time.Instant;
import java.time.temporal.TemporalUnit;
import javax.inject.Inject;
import net.runelite.api.Client;
import net.runelite.api.Skill;
import net.runelite.client.config.ConfigManager;
import net.runelite.client.util.RSTimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StaminaHelper {
    private static final Logger log = LoggerFactory.getLogger(StaminaHelper.class);
    @Inject
    private BlastFurnaceState state;
    @Inject
    private Client client;
    @Inject
    private MethodHandler methodHandler;
    @Inject
    private ConfigManager configManager;
    private Instant staminaEndTime;
    private double lossRateMultiplier;

    public double getEnergyNeededForNextRun() {
        Method method = this.methodHandler.getMethod();
        int coalPer = CoalPer.getValueFromString(method.getName());
        boolean isCoalRunNext = this.state.getFurnace().isCoalRunNext(coalPer);
        int weight = this.client.getWeight() - this.getInventoryOresAndBarsWeight();
        int nextOreWeight = (int)Math.round(this.getWeightOfNextOresOrBarsInInventory(false, coalPer)) + weight;
        int nextBarWeight = (int)Math.round(this.getWeightOfNextOresOrBarsInInventory(true, coalPer)) + weight;
        int ticksSpentIdle = this.getTicksSpentIdle(isCoalRunNext, method.getName());
        double energyRecovered = this.getMinimumEnergyRecovered(ticksSpentIdle);
        this.calculateStaminaDuration(ticksSpentIdle);
        if (isCoalRunNext) {
            return Math.round(this.getLossRate(weight) * 9.0 + this.getLossRate(nextOreWeight) * 9.0 - energyRecovered);
        }
        return Math.round(this.getLossRate(nextOreWeight) * 9.0 + this.getLossRate(weight) * 5.0 + this.getLossRate(nextBarWeight) * 4.0 - energyRecovered);
    }

    private double getLossRate(int weight) {
        return ((double)(Math.min(Math.max(weight, 0), 64) * 67) / 64.0 + 67.0) / 100.0 * this.lossRateMultiplier;
    }

    private double getMinimumEnergyRecovered(int ticksSpentIdle) {
        double energyRecoveryPerSecond = (double)(48 + this.client.getBoostedSkillLevel(Skill.AGILITY)) / 360.0;
        int boost = 0;
        for (Graceful graceful : Graceful.values()) {
            if (!this.state.getEquipment().equipped(graceful.items)) continue;
            boost += graceful.boost;
        }
        if (boost == 20) {
            boost += 10;
        }
        return (energyRecoveryPerSecond *= 1.0 + (double)boost / 100.0) * 0.6 * (double)ticksSpentIdle;
    }

    private int getTicksSpentIdle(boolean coalRun, String methodName) {
        int ticksSpentIdle = 4;
        boolean goldBars = methodName.equals("Gold bars");
        if (!goldBars) {
            ticksSpentIdle += 2;
        }
        if (!goldBars && this.state.getCoalBag().getMaxCoal() > 27) {
            ticksSpentIdle += 2;
        }
        if (!coalRun || methodName.contains("Gold")) {
            ++ticksSpentIdle;
        }
        return ticksSpentIdle;
    }

    private double getWeightOfNextOresOrBarsInInventory(boolean getBars, int coalPer) {
        Method method = this.methodHandler.getMethod();
        String ore = method.getName().toUpperCase().replace("GOLD + ", "").replace("STEEL", "IRON").replace(" BARS", "_ORE");
        String bars = ore.replace("IRON", "STEEL").replace("_ORE", "_BAR");
        double coalRunWeight = getBars ? BarsOres.GOLD_BAR.getWeight() : BarsOres.COAL.getWeight();
        int freeSlots = this.state.getInventory().getFreeSlotsIncludingOresAndBars();
        if (this.state.getFurnace().isCoalRunNext(coalPer)) {
            freeSlots = Math.min(freeSlots, this.state.getBank().getQuantity(method.getName().contains("Gold") ? 444 : 453));
            return coalRunWeight * (double)freeSlots;
        }
        freeSlots = Math.min(freeSlots, this.state.getBank().getQuantity(BarsOres.valueOf(ore).getItemID()));
        return BarsOres.valueOf(getBars ? bars : ore).getWeight() * (double)freeSlots;
    }

    private int getInventoryOresAndBarsWeight() {
        double weight = 0.0;
        weight += (double)this.state.getInventory().getQuantity(2351, 2353, 2363, 2357) * BarsOres.GOLD_BAR.getWeight();
        weight += (double)this.state.getInventory().getQuantity(440, 453, 451, 444) * BarsOres.COAL.getWeight();
        weight += (double)this.state.getInventory().getQuantity(2361) * BarsOres.ADAMANTITE_BAR.getWeight();
        weight += (double)this.state.getInventory().getQuantity(449) * BarsOres.ADAMANTITE_ORE.getWeight();
        weight += (double)this.state.getInventory().getQuantity(2359) * BarsOres.MITHRIL_BAR.getWeight();
        return (int)Math.round(weight += (double)this.state.getInventory().getQuantity(447) * BarsOres.MITHRIL_ORE.getWeight());
    }

    private void calculateStaminaDuration(int ticksSpentIdle) {
        long lastMillis;
        Duration staminaDuration = Duration.of(10L * (long)this.client.getVarbitValue(24), (TemporalUnit)RSTimeUnit.GAME_TICKS);
        double baseDrain = this.isWearingSufficientlyChargedRingOfEndurance() ? 0.85 : 1.0;
        this.lossRateMultiplier = staminaDuration.isZero() ? baseDrain : 0.3;
        int timeForNextRun = 10800 + ticksSpentIdle * 600;
        if (this.staminaEndTime == null && !staminaDuration.isZero() && staminaDuration.toMillis() <= 18000L) {
            this.staminaEndTime = Instant.now().plus(staminaDuration);
        } else if (staminaDuration.isZero() || staminaDuration.toMillis() > 18000L) {
            this.staminaEndTime = null;
        }
        long l = lastMillis = this.staminaEndTime != null ? Duration.between(Instant.now(), this.staminaEndTime).toMillis() : 0L;
        if (this.staminaEndTime != null && lastMillis >= 0L && lastMillis <= (long)timeForNextRun) {
            this.lossRateMultiplier = baseDrain - (baseDrain - 0.3) * (double)lastMillis / (double)timeForNextRun;
        }
    }

    private boolean isWearingSufficientlyChargedRingOfEndurance() {
        Integer charges = (Integer)this.configManager.getRSProfileConfiguration("runenergy", "ringOfEnduranceCharges", Integer.class);
        return charges != null && charges >= 500 && this.state.getEquipment().equipped(24736);
    }
}

