/*
 * Decompiled with CFR 0.152.
 */
package com.toofifty.easyblastfurnace.utils;

import com.toofifty.easyblastfurnace.methods.GoldBarMethod;
import com.toofifty.easyblastfurnace.methods.GoldHybridMethod;
import com.toofifty.easyblastfurnace.methods.MetalBarMethod;
import com.toofifty.easyblastfurnace.methods.Method;
import com.toofifty.easyblastfurnace.state.BlastFurnaceState;
import com.toofifty.easyblastfurnace.utils.MethodHandler;
import com.toofifty.easyblastfurnace.utils.XpRecord;
import java.time.Duration;
import java.time.Instant;
import java.util.HashMap;
import java.util.Map;
import javax.inject.Inject;
import javax.inject.Singleton;
import net.runelite.api.Client;
import net.runelite.api.InventoryID;
import net.runelite.api.ItemContainer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
public class SessionStatistics {
    private static final Logger log = LoggerFactory.getLogger(SessionStatistics.class);
    @Inject
    private Client client;
    @Inject
    private MethodHandler methodHandler;
    @Inject
    private BlastFurnaceState state;
    private int staminaDoses = 0;
    private Instant timeStarted;
    private int barsPerHour = 0;
    private ItemContainer cachedBank;
    private final Map<Integer, Integer> outputs = new HashMap<Integer, Integer>();

    public void clear() {
        this.outputs.clear();
        this.staminaDoses = 0;
        this.timeStarted = null;
    }

    public void drinkStamina() {
        this.staminaDoses = this.state.getEquipment().equipped(24736) ? (this.staminaDoses += 2) : ++this.staminaDoses;
    }

    public int getTotalActionsDone() {
        int actions = 0;
        for (int itemId : this.outputs.keySet()) {
            actions += this.outputs.getOrDefault(itemId, 0).intValue();
        }
        this.calculateBarsPerHour(actions);
        return actions;
    }

    public double getTotalXpGained() {
        double xp = 0.0;
        for (int itemId : this.outputs.keySet()) {
            int quantity = this.outputs.getOrDefault(itemId, 0);
            xp += XpRecord.get(itemId).getXp() * (double)quantity;
        }
        return xp;
    }

    private int getActionsBanked(int itemId) {
        return this.getActionsBanked(XpRecord.get(itemId));
    }

    private ItemContainer getBank() {
        ItemContainer bank = this.client.getItemContainer(InventoryID.BANK);
        if (bank != null) {
            this.cachedBank = bank;
            return this.cachedBank;
        }
        return this.cachedBank;
    }

    private int getActionsBanked(XpRecord xpRecord) {
        ItemContainer bank = this.getBank();
        if (bank == null) {
            return 0;
        }
        int ores = bank.count(xpRecord.getOreId());
        if (xpRecord.getCoalPer() == 0) {
            return ores;
        }
        int coal = bank.count(453);
        return Math.min(ores, coal / xpRecord.getCoalPer());
    }

    private double getXpBanked(int itemId) {
        return this.getXpBanked(XpRecord.get(itemId));
    }

    private double getXpBanked(XpRecord xpRecord) {
        return (double)this.getActionsBanked(xpRecord) * xpRecord.getXp();
    }

    public int getTotalActionsBanked() {
        Method method = this.methodHandler.getMethod();
        if (method instanceof GoldHybridMethod) {
            return this.getActionsBanked(444) + this.getActionsBanked(((GoldHybridMethod)method).oreItem());
        }
        if (method instanceof MetalBarMethod) {
            return this.getActionsBanked(((MetalBarMethod)method).oreItem());
        }
        if (method instanceof GoldBarMethod) {
            return this.getActionsBanked(444);
        }
        return 0;
    }

    public double getTotalXpBanked() {
        Method method = this.methodHandler.getMethod();
        if (method instanceof GoldHybridMethod) {
            return this.getXpBanked(444) + this.getXpBanked(((GoldHybridMethod)method).oreItem());
        }
        if (method instanceof MetalBarMethod) {
            return this.getXpBanked(((MetalBarMethod)method).oreItem());
        }
        if (method instanceof GoldBarMethod) {
            return this.getXpBanked(444);
        }
        return 0.0;
    }

    public void onFurnaceUpdate() {
        int diff;
        int[] ores;
        int[] bars = new int[]{2357, 2353, 2359, 2361, 2363};
        for (int oreId : ores = new int[]{444, 440, 447, 449, 451}) {
            diff = this.state.getFurnace().getChange(oreId);
            if (diff <= 0) continue;
            this.state.getFurnace().setOresOnConveyorBelt(Math.max(this.state.getFurnace().getOresOnConveyorBelt() - diff, 0));
            if (this.state.getFurnace().getOresOnConveyorBelt() != 0) continue;
            this.state.getPlayer().hasOreOnConveyor(false);
        }
        for (int barId : bars) {
            diff = this.state.getFurnace().getChange(barId);
            if (diff <= 0) continue;
            int totalBars = this.outputs.getOrDefault(barId, 0) + diff;
            this.outputs.put(barId, totalBars);
        }
    }

    private void calculateBarsPerHour(int totalBars) {
        Instant now = Instant.now();
        if (this.timeStarted == null) {
            this.timeStarted = now;
        }
        Duration timeSinceStart = Duration.between(this.timeStarted, now);
        double hours = (double)(timeSinceStart.toMillis() / 1000L) / 3600.0;
        if (!timeSinceStart.isNegative() && hours != 0.0) {
            this.barsPerHour = (int)Math.floor((double)totalBars / hours);
        }
    }

    public int getStaminaDoses() {
        return this.staminaDoses;
    }

    public int getBarsPerHour() {
        return this.barsPerHour;
    }
}

