/*
 * Decompiled with CFR 0.152.
 */
package com.toofifty.easyblastfurnace.utils;

import com.google.inject.Inject;
import com.google.inject.Singleton;
import com.toofifty.easyblastfurnace.EasyBlastFurnaceConfig;
import com.toofifty.easyblastfurnace.methods.AdamantiteBarMethod;
import com.toofifty.easyblastfurnace.methods.AdamantiteHybridMethod;
import com.toofifty.easyblastfurnace.methods.DrinkPotionMethod;
import com.toofifty.easyblastfurnace.methods.GoldBarMethod;
import com.toofifty.easyblastfurnace.methods.GoldHybridMethod;
import com.toofifty.easyblastfurnace.methods.Method;
import com.toofifty.easyblastfurnace.methods.MithrilBarMethod;
import com.toofifty.easyblastfurnace.methods.MithrilHybridMethod;
import com.toofifty.easyblastfurnace.methods.RuniteBarMethod;
import com.toofifty.easyblastfurnace.methods.RuniteHybridMethod;
import com.toofifty.easyblastfurnace.methods.SteelBarMethod;
import com.toofifty.easyblastfurnace.overlays.ItemStepOverlay;
import com.toofifty.easyblastfurnace.state.BlastFurnaceState;
import com.toofifty.easyblastfurnace.steps.MethodStep;

@Singleton
public class MethodHandler {
    @Inject
    private EasyBlastFurnaceConfig easyBlastFurnaceConfig;
    @Inject
    private BlastFurnaceState state;
    private final DrinkPotionMethod drinkPotionMethod = new DrinkPotionMethod();
    private Method method;
    private MethodStep[] steps;

    public void next() {
        if (this.method == null) {
            return;
        }
        if (!this.state.getPlayer().isOnBlastFurnaceWorld()) {
            return;
        }
        ItemStepOverlay.currentWidgetItem = null;
        this.steps = this.drinkPotionMethod.next(this.state);
        if (this.steps == null) {
            this.steps = this.method.next(this.state);
        }
    }

    public void clear() {
        this.method = null;
        this.steps = null;
    }

    private boolean inInventory(int itemId) {
        return this.state.getInventory().has(itemId);
    }

    private Method getMethodFromInventory() {
        if (this.method instanceof GoldHybridMethod) {
            return null;
        }
        if (this.inInventory(444) || this.method instanceof GoldBarMethod) {
            if (this.inInventory(447) || this.method instanceof MithrilBarMethod) {
                return new MithrilHybridMethod();
            }
            if (this.inInventory(449) || this.method instanceof AdamantiteBarMethod) {
                return new AdamantiteHybridMethod();
            }
            if (this.inInventory(451) || this.method instanceof RuniteBarMethod) {
                return new RuniteHybridMethod();
            }
            return new GoldBarMethod();
        }
        if (this.inInventory(440)) {
            return new SteelBarMethod();
        }
        if (this.inInventory(447)) {
            return new MithrilBarMethod();
        }
        if (this.inInventory(449)) {
            return new AdamantiteBarMethod();
        }
        if (this.inInventory(451)) {
            return new RuniteBarMethod();
        }
        return null;
    }

    public void setMethodFromInventory() {
        Method method = this.getMethodFromInventory();
        if (method == null || this.method != null && this.method.getClass().isInstance(method)) {
            return;
        }
        this.clear();
        this.method = method;
    }

    public Method getMethod() {
        return this.method;
    }

    public MethodStep[] getSteps() {
        return this.steps;
    }
}

