/*
 * Decompiled with CFR 0.152.
 */
package com.toofifty.easyblastfurnace.state;

import com.toofifty.easyblastfurnace.EasyBlastFurnaceConfig;
import com.toofifty.easyblastfurnace.config.PotionOverlaySetting;
import com.toofifty.easyblastfurnace.utils.StaminaHelper;
import java.util.Arrays;
import javax.inject.Inject;
import net.runelite.api.Client;
import net.runelite.api.Player;
import net.runelite.api.coords.WorldPoint;

public class PlayerState {
    private static final WorldPoint LOAD_POSITION = new WorldPoint(1942, 4967, 0);
    private static final WorldPoint COLLECT_POSITION = new WorldPoint(1940, 4962, 0);
    private static final int[] BLAST_FURNACE_WORLDS = new int[]{352, 355, 356, 357, 358, 386, 387, 395, 424, 466, 494, 495, 496, 515, 516};
    private boolean hasOreOnConveyor = false;
    private boolean needsToDrinkEnergyPotion = false;
    @Inject
    private Client client;
    @Inject
    private EasyBlastFurnaceConfig config;
    @Inject
    private StaminaHelper staminaHelper;

    public boolean isAtConveyorBelt() {
        Player player = this.client.getLocalPlayer();
        assert (player != null);
        WorldPoint location = player.getWorldLocation();
        return location.distanceTo(LOAD_POSITION) < 2;
    }

    public boolean isAtBarDispenser() {
        Player player = this.client.getLocalPlayer();
        assert (player != null);
        WorldPoint location = player.getWorldLocation();
        return location.distanceTo(COLLECT_POSITION) < 2;
    }

    public boolean hasEnoughEnergy() {
        if (!this.config.staminaPotionEnable()) {
            return true;
        }
        if (this.config.potionOverlayMode() == PotionOverlaySetting.STAMINA) {
            return (double)this.client.getEnergy() / 100.0 - this.staminaHelper.getEnergyNeededForNextRun() > (double)this.config.requireStaminaThreshold();
        }
        if ((double)this.client.getEnergy() / 100.0 <= (double)this.config.requireStaminaThreshold() && !this.needsToDrinkEnergyPotion) {
            this.needsToDrinkEnergyPotion = true;
            return false;
        }
        if (this.config.potionOverlayMode() == PotionOverlaySetting.SUPER_ENERGY && this.needsToDrinkEnergyPotion) {
            if ((double)this.client.getEnergy() / 100.0 >= 80.0) {
                this.needsToDrinkEnergyPotion = false;
            } else {
                return false;
            }
        }
        if (this.config.potionOverlayMode() == PotionOverlaySetting.ENERGY && this.needsToDrinkEnergyPotion) {
            if ((double)this.client.getEnergy() / 100.0 >= 90.0) {
                this.needsToDrinkEnergyPotion = false;
            } else {
                return false;
            }
        }
        return true;
    }

    public boolean isOnBlastFurnaceWorld() {
        return Arrays.stream(BLAST_FURNACE_WORLDS).anyMatch(world -> world == this.client.getWorld());
    }

    public boolean hasOreOnConveyor() {
        return this.hasOreOnConveyor;
    }

    public PlayerState hasOreOnConveyor(boolean hasOreOnConveyor) {
        this.hasOreOnConveyor = hasOreOnConveyor;
        return this;
    }

    public boolean needsToDrinkEnergyPotion() {
        return this.needsToDrinkEnergyPotion;
    }

    public PlayerState needsToDrinkEnergyPotion(boolean needsToDrinkEnergyPotion) {
        this.needsToDrinkEnergyPotion = needsToDrinkEnergyPotion;
        return this;
    }
}

