/*
 * Decompiled with CFR 0.152.
 */
package com.toofifty.easyblastfurnace.state;

import java.util.Arrays;
import java.util.Optional;
import java.util.stream.IntStream;
import javax.inject.Inject;
import net.runelite.api.Client;
import net.runelite.api.InventoryID;
import net.runelite.api.Item;
import net.runelite.api.ItemContainer;

public class InventoryState {
    @Inject
    private Client client;
    private ItemContainer inventory;
    private Item[] previousInventory = new Item[0];

    private void load() {
        ItemContainer inventory = this.client.getItemContainer(InventoryID.INVENTORY);
        if (inventory != null) {
            this.inventory = inventory;
        }
    }

    private int getPreviousQuantity(int ... itemIds) {
        int total = 0;
        for (int itemId : itemIds) {
            Optional<Item> item = Arrays.stream(this.previousInventory).filter(i -> i.getId() == itemId).findFirst();
            total += item.map(Item::getQuantity).orElse(0).intValue();
        }
        return total;
    }

    public void update() {
        this.load();
        if (this.inventory != null) {
            this.previousInventory = (Item[])this.inventory.getItems().clone();
        }
    }

    public int getChange(int ... itemIds) {
        if (this.inventory == null) {
            return 0;
        }
        int totalChange = 0;
        for (int itemId : itemIds) {
            totalChange += this.getQuantity(itemId) - this.getPreviousQuantity(itemId);
        }
        return totalChange;
    }

    public boolean hasChanged(int ... itemIds) {
        return this.getChange(itemIds) != 0;
    }

    public int getQuantity(int ... itemIds) {
        this.load();
        int total = 0;
        for (int itemId : itemIds) {
            total += this.inventory.count(itemId);
        }
        return total;
    }

    public boolean has(int ... itemIds) {
        return this.getQuantity(itemIds) > 0;
    }

    public int getFreeSlots() {
        this.load();
        int freeSlots = 28;
        for (Item item : this.inventory.getItems()) {
            if (item.getQuantity() <= 0) continue;
            --freeSlots;
        }
        return freeSlots;
    }

    public int getFreeSlotsIncludingOresAndBars() {
        this.load();
        int freeSlots = 28;
        int[] barsAndOres = new int[]{2351, 2359, 2361, 2363, 2357, 2353, 440, 447, 449, 451, 444, 453};
        for (Item item : this.inventory.getItems()) {
            if (!IntStream.of(barsAndOres).noneMatch(id -> id == item.getId()) || item.getQuantity() <= 0) continue;
            --freeSlots;
        }
        return freeSlots;
    }

    public boolean hasFreeSlots() {
        return this.getFreeSlots() > 0;
    }
}

