/*
 * Decompiled with CFR 0.152.
 */
package com.toofifty.easyblastfurnace.state;

import com.toofifty.easyblastfurnace.EasyBlastFurnaceConfig;
import com.toofifty.easyblastfurnace.utils.BarsOres;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import javax.inject.Inject;
import net.runelite.api.Client;

public class FurnaceState {
    @Inject
    private Client client;
    @Inject
    private EasyBlastFurnaceConfig config;
    private final Map<Integer, Integer> previousQuantity = new HashMap<Integer, Integer>();
    public int oresOnConveyorBelt = 0;

    public void update() {
        for (BarsOres varbit : BarsOres.values()) {
            this.previousQuantity.put(varbit.getItemID(), this.getQuantity(varbit.getItemID()));
        }
    }

    public int getChange(int itemId) {
        return this.getQuantity(itemId) - this.previousQuantity.getOrDefault(itemId, 0);
    }

    public int getCoalOffset() {
        if (this.config.addCoalBuffer()) {
            return 0;
        }
        return 1;
    }

    public int getQuantity(int ... itemIds) {
        int total = 0;
        for (int itemId : itemIds) {
            Optional<BarsOres> varbit = Arrays.stream(BarsOres.values()).filter(e -> e.getItemID() == itemId).findFirst();
            assert (varbit.isPresent());
            total += this.client.getVarbitValue(varbit.get().getVarbit());
        }
        return total;
    }

    public boolean has(int ... itemIds) {
        return this.getQuantity(itemIds) > 0;
    }

    public boolean isCoalRunNext(int coalPer) {
        int coalInFurnace = this.getQuantity(453);
        return coalInFurnace < 27 * (coalPer - this.getCoalOffset());
    }

    public int getOresOnConveyorBelt() {
        return this.oresOnConveyorBelt;
    }

    public void setOresOnConveyorBelt(int oresOnConveyorBelt) {
        this.oresOnConveyorBelt = oresOnConveyorBelt;
    }
}

