/*
 * Decompiled with CFR 0.152.
 */
package com.toofifty.easyblastfurnace.state;

import javax.inject.Inject;
import net.runelite.api.Client;
import net.runelite.api.InventoryID;
import net.runelite.api.ItemContainer;

public class EquipmentState {
    @Inject
    private Client client;
    private ItemContainer equipment;

    private void load() {
        ItemContainer equipment = this.client.getItemContainer(InventoryID.EQUIPMENT);
        if (equipment != null) {
            this.equipment = equipment;
        }
    }

    public boolean equipped(int ... itemIds) {
        this.load();
        int total = 0;
        if (this.equipment == null) {
            return false;
        }
        for (int itemId : itemIds) {
            total += this.equipment.count(itemId);
        }
        return total > 0;
    }

    public boolean hasGoldsmithEffect() {
        return this.equipped(776, 9795, 9796, 13280);
    }

    public boolean hasIceGlovesEffect() {
        return this.equipped(1580, 27031);
    }
}

