/*
 * Decompiled with CFR 0.152.
 */
package com.toofifty.easyblastfurnace.state;

import com.toofifty.easyblastfurnace.state.BankState;
import com.toofifty.easyblastfurnace.state.InventoryState;
import javax.inject.Inject;

public class CoalBagState {
    private static final int MIN_COAL = 0;
    @Inject
    private InventoryState inventory;
    @Inject
    private BankState bank;
    private int coal;
    private int maxCoal = 27;
    public boolean recentlyEmptiedCoalBag = false;

    public void setMaxCoal(int quantity) {
        this.maxCoal = quantity;
    }

    public void setCoal(int quantity) {
        this.coal = Math.min(Math.max(quantity, 0), this.maxCoal);
    }

    public boolean isEmpty() {
        return this.coal == 0;
    }

    public boolean isFull() {
        return this.coal == this.maxCoal;
    }

    public void empty() {
        if (this.bank.isOpen()) {
            this.setCoal(0);
            return;
        }
        this.recentlyEmptiedCoalBag = true;
        this.setCoal(this.coal - this.inventory.getFreeSlots());
    }

    public void fill() {
        if (this.bank.isOpen()) {
            this.setCoal(this.maxCoal);
            return;
        }
        this.setCoal(this.coal + this.inventory.getQuantity(453));
    }

    public int getCoal() {
        return this.coal;
    }

    public int getMaxCoal() {
        return this.maxCoal;
    }
}

