/*
 * Decompiled with CFR 0.152.
 */
package com.toofifty.easyblastfurnace.state;

import com.toofifty.easyblastfurnace.EasyBlastFurnaceConfig;
import com.toofifty.easyblastfurnace.state.BankState;
import com.toofifty.easyblastfurnace.state.CoalBagState;
import com.toofifty.easyblastfurnace.state.EquipmentState;
import com.toofifty.easyblastfurnace.state.FurnaceState;
import com.toofifty.easyblastfurnace.state.InventoryState;
import com.toofifty.easyblastfurnace.state.PlayerState;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
public class BlastFurnaceState {
    private static final Logger log = LoggerFactory.getLogger(BlastFurnaceState.class);
    @Inject
    private CoalBagState coalBag;
    @Inject
    private InventoryState inventory;
    @Inject
    private EquipmentState equipment;
    @Inject
    private PlayerState player;
    @Inject
    private FurnaceState furnace;
    @Inject
    private BankState bank;
    @Inject
    private EasyBlastFurnaceConfig config;
    private int lastPositiveChange = 0;

    public void update() {
        int invChange = this.inventory.getChange(444, 440, 447, 449, 451);
        if (invChange > 0) {
            this.lastPositiveChange = invChange;
        }
        if (this.player.isAtConveyorBelt() && invChange == -1) {
            this.furnace.setOresOnConveyorBelt(this.lastPositiveChange);
            this.lastPositiveChange = 0;
            this.player.hasOreOnConveyor(true);
        }
        if (this.equipment.equipped(9795, 9796, 13280)) {
            this.coalBag.setMaxCoal(36);
        } else {
            this.coalBag.setMaxCoal(27);
        }
        this.inventory.update();
        this.furnace.update();
    }

    public CoalBagState getCoalBag() {
        return this.coalBag;
    }

    public InventoryState getInventory() {
        return this.inventory;
    }

    public EquipmentState getEquipment() {
        return this.equipment;
    }

    public PlayerState getPlayer() {
        return this.player;
    }

    public FurnaceState getFurnace() {
        return this.furnace;
    }

    public BankState getBank() {
        return this.bank;
    }

    public EasyBlastFurnaceConfig getConfig() {
        return this.config;
    }

    public int getLastPositiveChange() {
        return this.lastPositiveChange;
    }
}

