/*
 * Decompiled with CFR 0.152.
 */
package com.toofifty.easyblastfurnace.state;

import javax.inject.Inject;
import net.runelite.api.Client;
import net.runelite.api.InventoryID;
import net.runelite.api.ItemContainer;
import net.runelite.api.widgets.Widget;
import net.runelite.api.widgets.WidgetInfo;

public class BankState {
    @Inject
    private Client client;
    private ItemContainer bank;

    private void load() {
        ItemContainer bank = this.client.getItemContainer(InventoryID.BANK);
        if (bank != null) {
            this.bank = bank;
        }
    }

    public boolean isOpen() {
        Widget bankContainer = this.client.getWidget(WidgetInfo.BANK_ITEM_CONTAINER);
        return bankContainer != null && !bankContainer.isHidden();
    }

    public int getQuantity(int ... itemIds) {
        this.load();
        int total = 0;
        if (this.bank == null) {
            return 0;
        }
        for (int itemId : itemIds) {
            total += this.bank.count(itemId);
        }
        return total;
    }

    public boolean has(int ... itemIds) {
        return this.getQuantity(itemIds) > 0;
    }
}

