/*
 * Decompiled with CFR 0.152.
 */
package com.toofifty.easyblastfurnace.overlays;

import com.toofifty.easyblastfurnace.EasyBlastFurnaceConfig;
import com.toofifty.easyblastfurnace.config.HighlightOverlayTextSetting;
import com.toofifty.easyblastfurnace.config.ItemOverlaySetting;
import com.toofifty.easyblastfurnace.steps.MethodStep;
import com.toofifty.easyblastfurnace.steps.WidgetStep;
import com.toofifty.easyblastfurnace.utils.MethodHandler;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import javax.inject.Inject;
import javax.inject.Singleton;
import net.runelite.api.Client;
import net.runelite.api.widgets.Widget;
import net.runelite.client.ui.overlay.Overlay;
import net.runelite.client.ui.overlay.OverlayLayer;
import net.runelite.client.ui.overlay.OverlayPosition;
import net.runelite.client.ui.overlay.OverlayPriority;
import net.runelite.client.ui.overlay.components.TextComponent;

@Singleton
public class WidgetStepOverlay
extends Overlay {
    @Inject
    private Client client;
    @Inject
    private EasyBlastFurnaceConfig config;
    @Inject
    private MethodHandler methodHandler;

    WidgetStepOverlay() {
        this.setPosition(OverlayPosition.DYNAMIC);
        this.setLayer(OverlayLayer.ALWAYS_ON_TOP);
        this.setPriority(OverlayPriority.HIGHEST);
    }

    public Dimension render(Graphics2D graphics) {
        if (this.config.itemOverlayMode() == ItemOverlaySetting.NONE) {
            return null;
        }
        MethodStep[] steps = this.methodHandler.getSteps();
        if (steps == null) {
            return null;
        }
        for (MethodStep step : steps) {
            Widget widget;
            if (!(step instanceof WidgetStep) || (widget = this.client.getWidget(((WidgetStep)step).getWidgetInfo())) == null) continue;
            Color color = this.config.itemOverlayColor();
            Rectangle bounds = widget.getBounds();
            graphics.setColor(color);
            graphics.draw(bounds);
            graphics.setColor(new Color(color.getRed(), color.getBlue(), color.getGreen(), 20));
            graphics.fill(bounds);
            if (this.config.itemOverlayTextMode() == HighlightOverlayTextSetting.NONE) continue;
            TextComponent textComponent = new TextComponent();
            textComponent.setColor(this.config.itemOverlayColor());
            textComponent.setText(step.getTooltip());
            FontMetrics fontMetrics = graphics.getFontMetrics();
            int textWidth = fontMetrics.stringWidth(step.getTooltip());
            int textHeight = fontMetrics.getHeight();
            if (this.config.itemOverlayTextMode() == HighlightOverlayTextSetting.BELOW) {
                textComponent.setPosition(new Point(bounds.x + bounds.width / 2 - textWidth / 2, bounds.y + bounds.height + textHeight));
            } else {
                textComponent.setPosition(new Point(bounds.x + bounds.width / 2 - textWidth / 2, bounds.y - textHeight / 2));
            }
            textComponent.render(graphics);
        }
        return null;
    }
}

